/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationQueuesZKImpl;
import org.apache.hadoop.hbase.replication.master.ReplicationHFileCleaner;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, SmallTests.class})
public class TestReplicationHFileCleaner {
    private static final Log LOG = LogFactory.getLog(ReplicationQueuesZKImpl.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Server server;
    private static ReplicationQueues rq;
    private static ReplicationPeers rp;
    private static final String peerId = "TestReplicationHFileCleaner";
    private static Configuration conf;
    static FileSystem fs;
    Path root;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        server = new DummyServer();
        conf.setBoolean("hbase.replication.bulkload.enabled", true);
        Replication.decorateMasterConfiguration(conf);
        rp = ReplicationFactory.getReplicationPeers(server.getZooKeeper(), conf, server);
        rp.init();
        rq = ReplicationFactory.getReplicationQueues(server.getZooKeeper(), conf, server);
        rq.init(server.getServerName().toString());
        try {
            fs = FileSystem.get((Configuration)conf);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Before
    public void setup() throws ReplicationException, IOException {
        this.root = TEST_UTIL.getDataTestDirOnTestFS();
        rp.addPeer(peerId, new ReplicationPeerConfig().setClusterKey(TEST_UTIL.getClusterKey()));
        rq.addPeerToHFileRefs(peerId);
    }

    @After
    public void cleanup() throws ReplicationException {
        try {
            fs.delete(this.root, true);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to delete files recursively from path " + this.root));
        }
        rp.removePeer(peerId);
    }

    @Test
    public void testIsFileDeletable() throws IOException, ReplicationException {
        Path file = new Path(this.root, "testIsFileDeletableWithNoHFileRefs");
        fs.createNewFile(file);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(file));
        ReplicationHFileCleaner cleaner = new ReplicationHFileCleaner();
        cleaner.setConf(conf);
        Assert.assertTrue((String)"Cleaner should allow to delete this file as there is no hfile reference node for it in the queue.", (boolean)cleaner.isFileDeletable(fs.getFileStatus(file)));
        ArrayList<Pair<Path, Path>> files = new ArrayList<Pair<Path, Path>>(1);
        files.add(new Pair<Object, Path>(null, file));
        rq.addHFileRefs(peerId, files);
        Assert.assertFalse((String)"Cleaner should not allow to delete this file as there is a hfile reference node for it in the queue.", (boolean)cleaner.isFileDeletable(fs.getFileStatus(file)));
    }

    @Test
    public void testGetDeletableFiles() throws Exception {
        int i;
        Path notDeletablefile = new Path(this.root, "testGetDeletableFiles_1");
        fs.createNewFile(notDeletablefile);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(notDeletablefile));
        Path deletablefile = new Path(this.root, "testGetDeletableFiles_2");
        fs.createNewFile(deletablefile);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(deletablefile));
        ArrayList<FileStatus> files = new ArrayList<FileStatus>(2);
        FileStatus f = new FileStatus();
        f.setPath(deletablefile);
        files.add(f);
        f = new FileStatus();
        f.setPath(notDeletablefile);
        files.add(f);
        ArrayList<Pair<Path, Path>> hfiles = new ArrayList<Pair<Path, Path>>(1);
        hfiles.add(new Pair<Object, Path>(null, notDeletablefile));
        rq.addHFileRefs(peerId, hfiles);
        ReplicationHFileCleaner cleaner = new ReplicationHFileCleaner();
        cleaner.setConf(conf);
        Iterator<FileStatus> deletableFilesIterator = cleaner.getDeletableFiles(files).iterator();
        for (i = 0; deletableFilesIterator.hasNext() && i < 2; ++i) {
        }
        if (i > 2) {
            Assert.fail((String)("File " + notDeletablefile + " should not be deletable as its hfile reference node is not added."));
        }
        Assert.assertTrue((boolean)deletableFilesIterator.next().getPath().equals((Object)deletablefile));
    }

    @Test(timeout=15000L)
    public void testForDifferntHFileRefsZnodeVersion() throws Exception {
        Path file = new Path(this.root, "testForDifferntHFileRefsZnodeVersion");
        fs.createNewFile(file);
        Assert.assertTrue((String)"Test file not created!", (boolean)fs.exists(file));
        ReplicationHFileCleaner cleaner = new ReplicationHFileCleaner();
        cleaner.setConf(conf);
        ReplicationQueuesClient replicationQueuesClient = (ReplicationQueuesClient)Mockito.mock(ReplicationQueuesClient.class);
        Mockito.when((Object)replicationQueuesClient.getHFileRefsNodeChangeVersion()).thenReturn((Object)1, (Object[])new Integer[]{2});
        Class<?> cleanerClass = cleaner.getClass();
        Field rqc = cleanerClass.getDeclaredField("rqc");
        rqc.setAccessible(true);
        rqc.set(cleaner, replicationQueuesClient);
        cleaner.isFileDeletable(fs.getFileStatus(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZooKeeperAbort() throws Exception {
        ReplicationHFileCleaner cleaner = new ReplicationHFileCleaner();
        ArrayList<FileStatus> dummyFiles = Lists.newArrayList(new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("hfile1")), new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("hfile2")));
        try (FaultyZooKeeperWatcher faultyZK = new FaultyZooKeeperWatcher(conf, "testZooKeeperAbort-faulty", null);){
            faultyZK.init();
            cleaner.setConf(conf, faultyZK);
            Iterable<FileStatus> toDelete = cleaner.getDeletableFiles(dummyFiles);
            Assert.assertFalse((boolean)toDelete.iterator().hasNext());
            Assert.assertFalse((boolean)cleaner.isStopped());
        }
        cleaner = new ReplicationHFileCleaner();
        try (ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "testZooKeeperAbort-normal", null);){
            cleaner.setConf(conf, zkw);
            Iterable<FileStatus> filesToDelete = cleaner.getDeletableFiles(dummyFiles);
            Iterator<FileStatus> iter = filesToDelete.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("hfile1"), (Object)iter.next().getPath());
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("hfile2"), (Object)iter.next().getPath());
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }

    static {
        conf = TEST_UTIL.getConfiguration();
        fs = null;
    }

    static class FaultyZooKeeperWatcher
    extends ZooKeeperWatcher {
        private RecoverableZooKeeper zk;

        public FaultyZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
            super(conf, identifier, abortable);
        }

        public void init() throws Exception {
            this.zk = (RecoverableZooKeeper)Mockito.spy((Object)super.getRecoverableZooKeeper());
            ((RecoverableZooKeeper)Mockito.doThrow((Throwable)new KeeperException.ConnectionLossException()).when((Object)this.zk)).getData("/hbase/replication/hfile-refs", null, new Stat());
        }

        @Override
        public RecoverableZooKeeper getRecoverableZooKeeper() {
            return this.zk;
        }
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        @Override
        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            try {
                return new ZooKeeperWatcher(this.getConfiguration(), "dummy server", this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf("regionserver,60020,000000");
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public void stop(String why) {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }
    }
}

