/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import drill.shaded.hbase.guava.com.google.common.collect.MinMaxPriorityQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ClusterLoadState;
import org.apache.hadoop.hbase.master.balancer.RegionInfoComparator;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class SimpleLoadBalancer
extends BaseLoadBalancer {
    private static final Log LOG = LogFactory.getLog(SimpleLoadBalancer.class);
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private RegionInfoComparator riComparator = new RegionInfoComparator();
    private RegionPlan.RegionPlanComparator rpComparator = new RegionPlan.RegionPlanComparator();

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RegionPlan> balanceCluster(Map<ServerName, List<HRegionInfo>> clusterMap) {
        Map.Entry server;
        int regionCount;
        List<RegionPlan> regionsToReturn = this.balanceMasterRegions(clusterMap);
        if (regionsToReturn != null || clusterMap == null || clusterMap.size() <= 1) {
            return regionsToReturn;
        }
        if (this.masterServerName != null && clusterMap.containsKey(this.masterServerName)) {
            if (clusterMap.size() <= 2) {
                return null;
            }
            clusterMap = new HashMap<ServerName, List<HRegionInfo>>(clusterMap);
            clusterMap.remove(this.masterServerName);
        }
        long startTime = System.currentTimeMillis();
        BaseLoadBalancer.Cluster c = new BaseLoadBalancer.Cluster(clusterMap, null, this.regionFinder, this.rackManager);
        if (!this.needsBalance(c)) {
            return null;
        }
        ClusterLoadState cs = new ClusterLoadState(clusterMap);
        int numServers = cs.getNumServers();
        NavigableMap<ServerAndLoad, List<HRegionInfo>> serversByLoad = cs.getServersByLoad();
        int numRegions = cs.getNumRegions();
        float average = cs.getLoadAverage();
        int max = (int)Math.ceil(average);
        int min = (int)average;
        StringBuilder strBalanceParam = new StringBuilder();
        strBalanceParam.append("Balance parameter: numRegions=").append(numRegions).append(", numServers=").append(numServers).append(", max=").append(max).append(", min=").append(min);
        LOG.debug((Object)strBalanceParam.toString());
        MinMaxPriorityQueue<RegionPlan> regionsToMove = MinMaxPriorityQueue.orderedBy(this.rpComparator).create();
        regionsToReturn = new ArrayList<RegionPlan>();
        int serversOverloaded = 0;
        boolean fetchFromTail = false;
        TreeMap<ServerName, BalanceInfo> serverBalanceInfo = new TreeMap<ServerName, BalanceInfo>();
        for (Map.Entry server2 : serversByLoad.descendingMap().entrySet()) {
            ServerAndLoad sal = (ServerAndLoad)server2.getKey();
            int load = sal.getLoad();
            if (load <= max) {
                serverBalanceInfo.put(sal.getServerName(), new BalanceInfo(0, 0));
                break;
            }
            ++serversOverloaded;
            List regions = (List)server2.getValue();
            int n = Math.min(load - max, regions.size());
            Collections.sort(regions, this.riComparator);
            int numTaken = 0;
            for (int i = 0; i <= n; ++i) {
                HRegionInfo hri = (HRegionInfo)regions.get(i);
                if (!fetchFromTail) continue;
                hri = (HRegionInfo)regions.get(regions.size() - 1 - i);
                if (this.shouldBeOnMaster(hri) && this.masterServerName.equals(sal.getServerName())) continue;
                regionsToMove.add(new RegionPlan(hri, sal.getServerName(), null));
                if (++numTaken < n) continue;
                break;
            }
            serverBalanceInfo.put(sal.getServerName(), new BalanceInfo(n, -1 * numTaken));
        }
        int totalNumMoved = regionsToMove.size();
        int neededRegions = 0;
        fetchFromTail = false;
        HashMap<ServerName, Integer> underloadedServers = new HashMap<ServerName, Integer>();
        int maxToTake = numRegions - min;
        for (Map.Entry entry : serversByLoad.entrySet()) {
            if (maxToTake == 0) break;
            int load = ((ServerAndLoad)entry.getKey()).getLoad();
            if (load >= min) continue;
            int regionsToPut = min - load;
            maxToTake -= regionsToPut;
            underloadedServers.put(((ServerAndLoad)entry.getKey()).getServerName(), regionsToPut);
        }
        int serversUnderloaded = underloadedServers.size();
        boolean bl = true;
        List<ServerName> sns = Arrays.asList(underloadedServers.keySet().toArray(new ServerName[serversUnderloaded]));
        Collections.shuffle(sns, RANDOM);
        while (regionsToMove.size() > 0) {
            void var23_28;
            int i;
            int cnt = 0;
            int n = i = var23_28 > 0 ? 0 : underloadedServers.size() - 1;
            while (i >= 0 && i < underloadedServers.size() && !regionsToMove.isEmpty()) {
                ServerName si = sns.get(i);
                int numToTake = (Integer)underloadedServers.get(si);
                if (numToTake != 0) {
                    this.addRegionPlan(regionsToMove, fetchFromTail, si, regionsToReturn);
                    underloadedServers.put(si, numToTake - 1);
                    ++cnt;
                    BalanceInfo bi = (BalanceInfo)serverBalanceInfo.get(si);
                    if (bi == null) {
                        bi = new BalanceInfo(0, 0);
                        serverBalanceInfo.put(si, bi);
                    }
                    bi.setNumRegionsAdded(bi.getNumRegionsAdded() + 1);
                }
                i += var23_28;
            }
            if (cnt == 0) break;
            var23_28 = -var23_28;
        }
        for (Integer i : underloadedServers.values()) {
            neededRegions += i.intValue();
        }
        if (neededRegions == 0 && regionsToMove.isEmpty()) {
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("Calculated a load balance in " + (endTime - startTime) + "ms. Moving " + totalNumMoved + " regions off of " + serversOverloaded + " overloaded servers onto " + serversUnderloaded + " less loaded servers"));
            return regionsToReturn;
        }
        if (neededRegions != 0) {
            for (Map.Entry server4 : serversByLoad.descendingMap().entrySet()) {
                int idx;
                BalanceInfo balanceInfo = (BalanceInfo)serverBalanceInfo.get(((ServerAndLoad)server4.getKey()).getServerName());
                int n = idx = balanceInfo == null ? 0 : balanceInfo.getNextRegionForUnload();
                if (idx >= ((List)server4.getValue()).size()) break;
                HRegionInfo region = (HRegionInfo)((List)server4.getValue()).get(idx);
                if (region.isMetaRegion()) continue;
                regionsToMove.add(new RegionPlan(region, ((ServerAndLoad)server4.getKey()).getServerName(), null));
                ++totalNumMoved;
                if (--neededRegions != 0) continue;
                break;
            }
        }
        Iterator endTime = serversByLoad.entrySet().iterator();
        while (endTime.hasNext() && (regionCount = ((ServerAndLoad)(server = endTime.next()).getKey()).getLoad()) < min) {
            BalanceInfo balanceInfo = (BalanceInfo)serverBalanceInfo.get(((ServerAndLoad)server.getKey()).getServerName());
            if (balanceInfo != null) {
                regionCount += balanceInfo.getNumRegionsAdded();
            }
            if (regionCount >= min) continue;
            int numToTake = min - regionCount;
            for (int numTaken = 0; numTaken < numToTake && 0 < regionsToMove.size(); ++numTaken) {
                this.addRegionPlan(regionsToMove, fetchFromTail, ((ServerAndLoad)server.getKey()).getServerName(), regionsToReturn);
            }
        }
        if (0 < regionsToMove.size()) {
            for (Map.Entry server5 : serversByLoad.entrySet()) {
                regionCount = ((ServerAndLoad)server5.getKey()).getLoad();
                BalanceInfo balanceInfo = (BalanceInfo)serverBalanceInfo.get(((ServerAndLoad)server5.getKey()).getServerName());
                if (balanceInfo != null) {
                    regionCount += balanceInfo.getNumRegionsAdded();
                }
                if (regionCount >= max) break;
                this.addRegionPlan(regionsToMove, fetchFromTail, ((ServerAndLoad)server5.getKey()).getServerName(), regionsToReturn);
                if (!regionsToMove.isEmpty()) continue;
                break;
            }
        }
        long endTime2 = System.currentTimeMillis();
        if (!regionsToMove.isEmpty() || neededRegions != 0) {
            LOG.warn((Object)("regionsToMove=" + totalNumMoved + ", numServers=" + numServers + ", serversOverloaded=" + serversOverloaded + ", serversUnderloaded=" + serversUnderloaded));
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<ServerName, List<HRegionInfo>> e : clusterMap.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(e.getKey().toString());
                sb.append(" ");
                sb.append(e.getValue().size());
            }
            LOG.warn((Object)("Input " + sb.toString()));
        }
        LOG.info((Object)("Done. Calculated a load balance in " + (endTime2 - startTime) + "ms. Moving " + totalNumMoved + " regions off of " + serversOverloaded + " overloaded servers onto " + serversUnderloaded + " less loaded servers"));
        return regionsToReturn;
    }

    private void addRegionPlan(MinMaxPriorityQueue<RegionPlan> regionsToMove, boolean fetchFromTail, ServerName sn, List<RegionPlan> regionsToReturn) {
        RegionPlan rp = null;
        rp = !fetchFromTail ? (RegionPlan)regionsToMove.remove() : regionsToMove.removeLast();
        rp.setDestination(sn);
        regionsToReturn.add(rp);
    }

    @Override
    public List<RegionPlan> balanceCluster(TableName tableName, Map<ServerName, List<HRegionInfo>> clusterState) throws HBaseIOException {
        return this.balanceCluster(clusterState);
    }

    static class BalanceInfo {
        private final int nextRegionForUnload;
        private int numRegionsAdded;

        public BalanceInfo(int nextRegionForUnload, int numRegionsAdded) {
            this.nextRegionForUnload = nextRegionForUnload;
            this.numRegionsAdded = numRegionsAdded;
        }

        int getNextRegionForUnload() {
            return this.nextRegionForUnload;
        }

        int getNumRegionsAdded() {
            return this.numRegionsAdded;
        }

        void setNumRegionsAdded(int numAdded) {
            this.numRegionsAdded = numAdded;
        }
    }
}

