/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.Export;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.GenericOptionsParser;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MediumTests.class})
public class TestImportExport {
    private static final Log LOG = LogFactory.getLog(TestImportExport.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytesBinary("\\x32row1");
    private static final byte[] ROW2 = Bytes.toBytesBinary("\\x32row2");
    private static final byte[] ROW3 = Bytes.toBytesBinary("\\x32row3");
    private static final String FAMILYA_STRING = "a";
    private static final String FAMILYB_STRING = "b";
    private static final byte[] FAMILYA = Bytes.toBytes("a");
    private static final byte[] FAMILYB = Bytes.toBytes("b");
    private static final byte[] QUAL = Bytes.toBytes("q");
    private static final String OUTPUT_DIR = "outputdir";
    private static String FQ_OUTPUT_DIR;
    private static final String EXPORT_BATCH_SIZE = "100";
    private static long now;
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setBoolean("hbase.test.local.fileSystem", true);
        UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        UTIL.setJobWithoutMRCluster();
        UTIL.startMiniCluster();
        FQ_OUTPUT_DIR = new Path(OUTPUT_DIR).makeQualified(FileSystem.get((Configuration)UTIL.getConfiguration())).toString();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    @After
    public void cleanup() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        fs.delete(new Path(OUTPUT_DIR), true);
    }

    boolean runExport(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(UTIL.getConfiguration()), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = Export.createSubmittableJob(conf, args);
        job.waitForCompletion(false);
        return job.isSuccessful();
    }

    boolean runImport(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(UTIL.getConfiguration()), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = Import.createSubmittableJob(conf, args);
        job.waitForCompletion(false);
        return job.isSuccessful();
    }

    @Test
    public void testSimpleCase() throws Exception {
        String EXPORT_TABLE = "exportSimpleCase";
        try (HTable t = UTIL.createTable(TableName.valueOf(EXPORT_TABLE), FAMILYA, 3);){
            Put p = new Put(ROW1);
            p.add(FAMILYA, QUAL, now, QUAL);
            p.add(FAMILYA, QUAL, now + 1L, QUAL);
            p.add(FAMILYA, QUAL, now + 2L, QUAL);
            t.put(p);
            p = new Put(ROW2);
            p.add(FAMILYA, QUAL, now, QUAL);
            p.add(FAMILYA, QUAL, now + 1L, QUAL);
            p.add(FAMILYA, QUAL, now + 2L, QUAL);
            t.put(p);
            p = new Put(ROW3);
            p.add(FAMILYA, QUAL, now, QUAL);
            p.add(FAMILYA, QUAL, now + 1L, QUAL);
            p.add(FAMILYA, QUAL, now + 2L, QUAL);
            t.put(p);
        }
        String[] args = new String[]{"-Dhbase.mapreduce.scan.row.start=\\x32row1", "-Dhbase.mapreduce.scan.row.stop=\\x32row3", EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = "importTableSimpleCase";
        try (HTable t = UTIL.createTable(TableName.valueOf(IMPORT_TABLE), FAMILYB, 3);){
            args = new String[]{"-DHBASE_IMPORTER_RENAME_CFS=a:b", IMPORT_TABLE, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Get g = new Get(ROW1);
            g.setMaxVersions();
            Result r = t.get(g);
            Assert.assertEquals((long)3L, (long)r.size());
            g = new Get(ROW2);
            g.setMaxVersions();
            r = t.get(g);
            Assert.assertEquals((long)3L, (long)r.size());
            g = new Get(ROW3);
            r = t.get(g);
            Assert.assertEquals((long)0L, (long)r.size());
        }
    }

    @Test
    public void testMetaExport() throws Exception {
        String EXPORT_TABLE = TableName.META_TABLE_NAME.getNameAsString();
        String[] args = new String[]{EXPORT_TABLE, FQ_OUTPUT_DIR, "1", "0", "0"};
        Assert.assertTrue((boolean)this.runExport(args));
    }

    @Test
    public void testImport94Table() throws Exception {
        String name = "exportedTableIn94Format";
        URL url = TestImportExport.class.getResource("exportedTableIn94Format");
        File f = new File(url.toURI());
        if (!f.exists()) {
            LOG.warn((Object)("FAILED TO FIND " + f + "; skipping out on test"));
            return;
        }
        Assert.assertTrue((boolean)f.exists());
        LOG.info((Object)("FILE=" + f));
        Path importPath = new Path(f.toURI());
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        fs.copyFromLocalFile(importPath, new Path(FQ_OUTPUT_DIR + "/" + "exportedTableIn94Format"));
        String IMPORT_TABLE = "exportedTableIn94Format";
        try (HTable t = UTIL.createTable(TableName.valueOf(IMPORT_TABLE), Bytes.toBytes("f1"), 3);){
            String[] args = new String[]{"-Dhbase.import.version=0.94", IMPORT_TABLE, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Assert.assertEquals((long)5L, (long)UTIL.countRows(t));
        }
    }

    @Test
    public void testExportScannerBatching() throws Exception {
        String BATCH_TABLE = "exportWithBatch";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(BATCH_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(1));
        UTIL.getHBaseAdmin().createTable(desc);
        try (HTable t = new HTable(UTIL.getConfiguration(), desc.getTableName());){
            Put p = new Put(ROW1);
            p.add(FAMILYA, QUAL, now, QUAL);
            p.add(FAMILYA, QUAL, now + 1L, QUAL);
            p.add(FAMILYA, QUAL, now + 2L, QUAL);
            p.add(FAMILYA, QUAL, now + 3L, QUAL);
            p.add(FAMILYA, QUAL, now + 4L, QUAL);
            t.put(p);
            String[] args = new String[]{"-Dhbase.export.scanner.batch=100", BATCH_TABLE, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runExport(args));
            FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
            fs.delete(new Path(FQ_OUTPUT_DIR), true);
        }
    }

    @Test
    public void testWithDeletes() throws Exception {
        String IMPORT_TABLE = "importWithDeletes";
        String EXPORT_TABLE = "exportWithDeletes";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(EXPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        UTIL.getHBaseAdmin().createTable(desc);
        try (HTable t = new HTable(UTIL.getConfiguration(), desc.getTableName());){
            Put p = new Put(ROW1);
            p.add(FAMILYA, QUAL, now, QUAL);
            p.add(FAMILYA, QUAL, now + 1L, QUAL);
            p.add(FAMILYA, QUAL, now + 2L, QUAL);
            p.add(FAMILYA, QUAL, now + 3L, QUAL);
            p.add(FAMILYA, QUAL, now + 4L, QUAL);
            t.put(p);
            Delete d = new Delete(ROW1, now + 3L);
            t.delete(d);
            d = new Delete(ROW1);
            d.deleteColumns(FAMILYA, QUAL, now + 2L);
            t.delete(d);
            String[] args = new String[]{"-Dhbase.mapreduce.include.deleted.rows=true", EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
            Assert.assertTrue((boolean)this.runExport(args));
            desc = new HTableDescriptor(TableName.valueOf(IMPORT_TABLE));
            desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        }
        UTIL.getHBaseAdmin().createTable(desc);
        t = new HTable(UTIL.getConfiguration(), desc.getTableName());
        var5_5 = null;
        try {
            String[] args = new String[]{IMPORT_TABLE, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Scan s = new Scan();
            s.setMaxVersions();
            s.setRaw(true);
            ResultScanner scanner = t.getScanner(s);
            Result r = scanner.next();
            Cell[] res = r.rawCells();
            Assert.assertTrue((boolean)CellUtil.isDeleteFamily(res[0]));
            Assert.assertEquals((long)(now + 4L), (long)res[1].getTimestamp());
            Assert.assertEquals((long)(now + 3L), (long)res[2].getTimestamp());
            Assert.assertTrue((boolean)CellUtil.isDelete(res[3]));
            Assert.assertEquals((long)(now + 2L), (long)res[4].getTimestamp());
            Assert.assertEquals((long)(now + 1L), (long)res[5].getTimestamp());
            Assert.assertEquals((long)now, (long)res[6].getTimestamp());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (t != null) {
                if (var5_5 != null) {
                    try {
                        t.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    t.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithMultipleDeleteFamilyMarkersOfSameRowSameFamily() throws Exception {
        String EXPORT_TABLE = "exportWithMultipleDeleteFamilyMarkersOfSameRowSameFamily";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(EXPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable exportT = new HTable(UTIL.getConfiguration(), EXPORT_TABLE);
        Put p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now, QUAL);
        exportT.put(p);
        Delete d = new Delete(ROW1, now + 3L);
        exportT.delete(d);
        p = new Put(ROW1);
        p.add(FAMILYA, QUAL, now + 5L, "s".getBytes());
        exportT.put(p);
        d = new Delete(ROW1, now + 7L);
        exportT.delete(d);
        String[] args = new String[]{"-Dhbase.mapreduce.include.deleted.rows=true", EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = "importWithMultipleDeleteFamilyMarkersOfSameRowSameFamily";
        desc = new HTableDescriptor(TableName.valueOf(IMPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5).setKeepDeletedCells(true));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable importT = new HTable(UTIL.getConfiguration(), IMPORT_TABLE);
        args = new String[]{IMPORT_TABLE, FQ_OUTPUT_DIR};
        Assert.assertTrue((boolean)this.runImport(args));
        Scan s = new Scan();
        s.setMaxVersions();
        s.setRaw(true);
        ResultScanner importedTScanner = importT.getScanner(s);
        Result importedTResult = importedTScanner.next();
        ResultScanner exportedTScanner = exportT.getScanner(s);
        Result exportedTResult = exportedTScanner.next();
        try {
            Result.compareResults(exportedTResult, importedTResult);
        }
        catch (Exception e) {
            Assert.fail((String)("Original and imported tables data comparision failed with error:" + e.getMessage()));
        }
        finally {
            exportT.close();
            importT.close();
        }
    }

    @Test
    public void testWithFilter() throws Exception {
        String EXPORT_TABLE = "exportSimpleCase_ImportWithFilter";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(EXPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable exportTable = new HTable(UTIL.getConfiguration(), desc.getTableName());
        Put p1 = new Put(ROW1);
        p1.add(FAMILYA, QUAL, now, QUAL);
        p1.add(FAMILYA, QUAL, now + 1L, QUAL);
        p1.add(FAMILYA, QUAL, now + 2L, QUAL);
        p1.add(FAMILYA, QUAL, now + 3L, QUAL);
        p1.add(FAMILYA, QUAL, now + 4L, QUAL);
        Put p2 = new Put(ROW2);
        p2.add(FAMILYA, QUAL, now, QUAL);
        exportTable.put(Arrays.asList(p1, p2));
        String[] args = new String[]{EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String IMPORT_TABLE = "importWithFilter";
        desc = new HTableDescriptor(TableName.valueOf(IMPORT_TABLE));
        desc.addFamily(new HColumnDescriptor(FAMILYA).setMaxVersions(5));
        UTIL.getHBaseAdmin().createTable(desc);
        HTable importTable = new HTable(UTIL.getConfiguration(), desc.getTableName());
        args = new String[]{"-Dimport.filter.class=" + PrefixFilter.class.getName(), "-Dimport.filter.args=" + Bytes.toString(ROW1), IMPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runImport(args));
        PrefixFilter filter = new PrefixFilter(ROW1);
        int count = this.getCount(exportTable, filter);
        Assert.assertEquals((String)"Unexpected row count between export and import tables", (long)count, (long)this.getCount(importTable, null));
        args = new String[]{"-Dimport.filter.class=" + Filter.class.getName(), "-Dimport.filter.args=" + Bytes.toString(ROW1) + "", EXPORT_TABLE, FQ_OUTPUT_DIR, "1000"};
        Assert.assertFalse((boolean)this.runImport(args));
        exportTable.close();
        importTable.close();
    }

    private int getCount(Table table, Filter filter) throws IOException {
        Scan scan = new Scan();
        scan.setFilter(filter);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            count += res.size();
        }
        results.close();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportMain() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            Import.main(args);
            Assert.fail((String)"should be SecurityException");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
            Assert.assertTrue((boolean)data.toString().contains("Wrong number of arguments:"));
            Assert.assertTrue((boolean)data.toString().contains("-Dimport.bulk.output=/path/for/output"));
            Assert.assertTrue((boolean)data.toString().contains("-Dimport.filter.class=<name of filter class>"));
            Assert.assertTrue((boolean)data.toString().contains("-Dimport.bulk.output=/path/for/output"));
            Assert.assertTrue((boolean)data.toString().contains("-Dmapreduce.reduce.speculative=false"));
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportMain() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager(newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            Export.main(args);
            Assert.fail((String)"should be SecurityException");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
            Assert.assertTrue((boolean)data.toString().contains("Wrong number of arguments:"));
            Assert.assertTrue((boolean)data.toString().contains("Usage: Export [-D <property=value>]* <tablename> <outputdir> [<versions> [<starttime> [<endtime>]] [^[regex pattern] or [Prefix] to filter]]"));
            Assert.assertTrue((boolean)data.toString().contains("-D hbase.mapreduce.scan.column.family=<familyName>"));
            Assert.assertTrue((boolean)data.toString().contains("-D hbase.mapreduce.include.deleted.rows=true"));
            Assert.assertTrue((boolean)data.toString().contains("-Dhbase.client.scanner.caching=100"));
            Assert.assertTrue((boolean)data.toString().contains("-Dmapreduce.map.speculative=false"));
            Assert.assertTrue((boolean)data.toString().contains("-Dmapreduce.reduce.speculative=false"));
            Assert.assertTrue((boolean)data.toString().contains("-Dhbase.export.scanner.batch=10"));
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    @Test
    public void testKeyValueImporter() throws Exception {
        Import.KeyValueImporter importer = new Import.KeyValueImporter();
        Configuration configuration = new Configuration();
        Mapper.Context ctx = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)ctx.getConfiguration()).thenReturn((Object)configuration);
        ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ImmutableBytesWritable writer = (ImmutableBytesWritable)invocation.getArguments()[0];
                KeyValue key = (KeyValue)invocation.getArguments()[1];
                Assert.assertEquals((Object)"Key", (Object)Bytes.toString(writer.get()));
                Assert.assertEquals((Object)"row", (Object)Bytes.toString(key.getRow()));
                return null;
            }
        }).when((Object)ctx)).write(Matchers.any(ImmutableBytesWritable.class), Matchers.any(KeyValue.class));
        importer.setup(ctx);
        Result value = (Result)Mockito.mock(Result.class);
        KeyValue[] keys = new KeyValue[]{new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("family"), Bytes.toBytes("qualifier"), Bytes.toBytes("value")), new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("family"), Bytes.toBytes("qualifier"), Bytes.toBytes("value1"))};
        Mockito.when((Object)value.rawCells()).thenReturn((Object)keys);
        importer.map(new ImmutableBytesWritable(Bytes.toBytes("Key")), value, ctx);
    }

    @Test
    public void testAddFilterAndArguments() throws IOException {
        Configuration configuration = new Configuration();
        ArrayList<String> args = new ArrayList<String>();
        args.add("param1");
        args.add("param2");
        Import.addFilterAndArguments(configuration, FilterBase.class, args);
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.filter.FilterBase", (Object)configuration.get("import.filter.class"));
        Assert.assertEquals((Object)"param1,param2", (Object)configuration.get("import.filter.args"));
    }

    @Test
    public void testDurability() throws IOException, InterruptedException, ClassNotFoundException {
        String exportTableName = "exporttestDurability";
        try (HTable exportTable = UTIL.createTable(TableName.valueOf(exportTableName), FAMILYA, 3);){
            Put put = new Put(ROW1);
            put.add(FAMILYA, QUAL, now, QUAL);
            put.add(FAMILYA, QUAL, now + 1L, QUAL);
            put.add(FAMILYA, QUAL, now + 2L, QUAL);
            exportTable.put(put);
            put = new Put(ROW2);
            put.add(FAMILYA, QUAL, now, QUAL);
            put.add(FAMILYA, QUAL, now + 1L, QUAL);
            put.add(FAMILYA, QUAL, now + 2L, QUAL);
            exportTable.put(put);
        }
        String[] args = new String[]{exportTableName, FQ_OUTPUT_DIR, "1000"};
        Assert.assertTrue((boolean)this.runExport(args));
        String importTableName = "importTestDurability1";
        WAL wal = null;
        HRegionInfo region = null;
        TableWALActionListener walListener = null;
        try (HTable importTable = UTIL.createTable(TableName.valueOf(importTableName), FAMILYA, 3);){
            walListener = new TableWALActionListener(importTableName);
            region = UTIL.getHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getOnlineRegions(importTable.getName()).get(0).getRegionInfo();
            wal = UTIL.getMiniHBaseCluster().getRegionServer(0).getWAL(region);
            wal.registerWALActionsListener(walListener);
            args = new String[]{"-Dimport.wal.durability=" + Durability.SKIP_WAL.name(), importTableName, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Assert.assertTrue((!walListener.isWALVisited() ? 1 : 0) != 0);
            Assert.assertTrue((this.getCount(importTable, null) == 2 ? 1 : 0) != 0);
        }
        importTableName = "importTestDurability2";
        importTable = UTIL.createTable(TableName.valueOf(importTableName), FAMILYA, 3);
        var8_12 = null;
        try {
            region = UTIL.getHBaseCluster().getRegionServerThreads().get(0).getRegionServer().getOnlineRegions(importTable.getName()).get(0).getRegionInfo();
            wal = UTIL.getMiniHBaseCluster().getRegionServer(0).getWAL(region);
            walListener = new TableWALActionListener(importTableName);
            wal.registerWALActionsListener(walListener);
            args = new String[]{importTableName, FQ_OUTPUT_DIR};
            Assert.assertTrue((boolean)this.runImport(args));
            Assert.assertTrue((boolean)walListener.isWALVisited());
            Assert.assertTrue((this.getCount(importTable, null) == 2 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            var8_12 = throwable;
            throw throwable;
        }
        finally {
            if (importTable != null) {
                if (var8_12 != null) {
                    try {
                        importTable.close();
                    }
                    catch (Throwable throwable) {
                        var8_12.addSuppressed(throwable);
                    }
                } else {
                    importTable.close();
                }
            }
        }
    }

    static {
        now = System.currentTimeMillis();
    }

    private static class TableWALActionListener
    extends WALActionsListener.Base {
        private String tableName;
        private boolean isVisited = false;

        public TableWALActionListener(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public void visitLogEntryBeforeWrite(HTableDescriptor htd, WALKey logKey, WALEdit logEdit) {
            if (this.tableName.equalsIgnoreCase(htd.getNameAsString())) {
                this.isVisited = true;
            }
        }

        public boolean isWALVisited() {
            return this.isVisited;
        }
    }
}

