/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.GroupingTableMapper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestGroupingTableMapper {
    @Test
    public void testGroupingTableMapper() throws Exception {
        GroupingTableMapper mapper = new GroupingTableMapper();
        Configuration configuration = new Configuration();
        configuration.set("hbase.mapred.groupingtablemap.columns", "family1:clm family2:clm");
        mapper.setConf(configuration);
        Result result = (Result)Mockito.mock(Result.class);
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        context.write(Mockito.any(ImmutableBytesWritable.class), Mockito.any(Result.class));
        ArrayList<KeyValue> keyValue = new ArrayList<KeyValue>();
        byte[] row = new byte[]{};
        keyValue.add(new KeyValue(row, Bytes.toBytes("family2"), Bytes.toBytes("clm"), Bytes.toBytes("value1")));
        keyValue.add(new KeyValue(row, Bytes.toBytes("family1"), Bytes.toBytes("clm"), Bytes.toBytes("value2")));
        Mockito.when(result.listCells()).thenReturn(keyValue);
        mapper.map(null, result, context);
        byte[][] data = new byte[][]{Bytes.toBytes("value1"), Bytes.toBytes("value2")};
        ImmutableBytesWritable ibw = mapper.createGroupKey(data);
        ((Mapper.Context)Mockito.verify((Object)context)).write((Object)ibw, (Object)result);
    }
}

