/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import drill.shaded.hbase.guava.com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.mapr.GenericHFactory;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mapreduce.KeyValueSerialization;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.PutSortReducer;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TextSortReducer;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HFileOutputFormat2
extends FileOutputFormat<ImmutableBytesWritable, Cell> {
    private static final Log LOG = LogFactory.getLog(HFileOutputFormat2.class);
    private static final String COMPRESSION_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.compression";
    private static final String BLOOM_TYPE_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.bloomtype";
    private static final String BLOCK_SIZE_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.blocksize";
    private static final String DATABLOCK_ENCODING_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.families.datablock.encoding";
    public static final String DATABLOCK_ENCODING_OVERRIDE_CONF_KEY = "hbase.mapreduce.hfileoutputformat.datablock.encoding";
    public static final String LOCALITY_SENSITIVE_CONF_KEY = "hbase.bulkload.locality.sensitive.enabled";
    private static final boolean DEFAULT_LOCALITY_SENSITIVE = true;
    private static final String OUTPUT_TABLE_NAME_CONF_KEY = "hbase.mapreduce.hfileoutputformat.table.name";

    public RecordWriter<ImmutableBytesWritable, Cell> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return HFileOutputFormat2.createRecordWriter(context, this.getOutputCommitter(context));
    }

    static <V extends Cell> RecordWriter<ImmutableBytesWritable, V> createRecordWriter(final TaskAttemptContext context, OutputCommitter committer) throws IOException {
        final Configuration conf = context.getConfiguration();
        String tablePathName = TableMapReduceUtil.getMapRTablePath(conf);
        if (tablePathName != null) {
            LOG.info((Object)("detected MapR table " + tablePathName + ", switching to BulkLoadRecordWriter"));
            Path tablePath = new Path(tablePathName);
            try {
                GenericHFactory recWriterFactory_ = new GenericHFactory();
                return (RecordWriter)recWriterFactory_.getImplementorInstance("com.mapr.fs.hbase.BulkLoadRecordWriter", new Object[]{conf, tablePath}, Configuration.class, Path.class);
            }
            catch (Throwable e) {
                GenericHFactory.handleIOException(e);
            }
        }
        final Path outputdir = ((FileOutputCommitter)committer).getWorkPath();
        final FileSystem fs = outputdir.getFileSystem(conf);
        final long maxsize = conf.getLong("hbase.hregion.max.filesize", 0x280000000L);
        String defaultCompressionStr = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        final Compression.Algorithm defaultCompression = AbstractHFileWriter.compressionByName(defaultCompressionStr);
        final boolean compactionExclude = conf.getBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", false);
        final Map<byte[], Compression.Algorithm> compressionMap = HFileOutputFormat2.createFamilyCompressionMap(conf);
        final Map<byte[], BloomType> bloomTypeMap = HFileOutputFormat2.createFamilyBloomTypeMap(conf);
        final Map<byte[], Integer> blockSizeMap = HFileOutputFormat2.createFamilyBlockSizeMap(conf);
        String dataBlockEncodingStr = conf.get(DATABLOCK_ENCODING_OVERRIDE_CONF_KEY);
        final Map<byte[], DataBlockEncoding> datablockEncodingMap = HFileOutputFormat2.createFamilyDataBlockEncodingMap(conf);
        final DataBlockEncoding overriddenEncoding = dataBlockEncodingStr != null ? DataBlockEncoding.valueOf(dataBlockEncodingStr) : null;
        return new RecordWriter<ImmutableBytesWritable, V>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private byte[] previousRow = HConstants.EMPTY_BYTE_ARRAY;
            private final byte[] now = Bytes.toBytes(System.currentTimeMillis());
            private boolean rollRequested = false;

            public void write(ImmutableBytesWritable row, V cell) throws IOException {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                if (row == null && kv == null) {
                    this.rollWriters();
                    return;
                }
                byte[] rowKey = CellUtil.cloneRow(kv);
                long length = kv.getLength();
                byte[] family = CellUtil.cloneFamily(kv);
                WriterLength wl = this.writers.get(family);
                if (wl == null) {
                    Path path = new Path(outputdir, Bytes.toString(family));
                    LOG.info((Object)("Creating directory: " + path));
                    fs.mkdirs(path);
                }
                if (wl != null && wl.written + length >= maxsize) {
                    this.rollRequested = true;
                }
                if (this.rollRequested && Bytes.compareTo(this.previousRow, rowKey) != 0) {
                    this.rollWriters();
                }
                if (wl == null || wl.writer == null) {
                    if (conf.getBoolean(HFileOutputFormat2.LOCALITY_SENSITIVE_CONF_KEY, true)) {
                        HRegionLocation loc = null;
                        String tableName = conf.get(HFileOutputFormat2.OUTPUT_TABLE_NAME_CONF_KEY);
                        if (tableName != null) {
                            try (Connection connection = ConnectionFactory.createConnection(conf);
                                 RegionLocator locator = connection.getRegionLocator(TableName.valueOf(tableName));){
                                loc = locator.getRegionLocation(rowKey);
                            }
                            catch (Throwable e) {
                                LOG.warn((Object)("there's something wrong when locating rowkey: " + Bytes.toString(rowKey)), e);
                                loc = null;
                            }
                        }
                        if (null == loc) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)("failed to get region location, so use default writer: " + Bytes.toString(rowKey)));
                            }
                            wl = this.getNewWriter(family, conf, null);
                        } else {
                            InetSocketAddress initialIsa;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("first rowkey: [" + Bytes.toString(rowKey) + "]"));
                            }
                            if ((initialIsa = new InetSocketAddress(loc.getHostname(), loc.getPort())).isUnresolved()) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("failed to resolve bind address: " + loc.getHostname() + ":" + loc.getPort() + ", so use default writer"));
                                }
                                wl = this.getNewWriter(family, conf, null);
                            } else {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("use favored nodes writer: " + initialIsa.getHostString()));
                                }
                                wl = this.getNewWriter(family, conf, new InetSocketAddress[]{initialIsa});
                            }
                        }
                    } else {
                        wl = this.getNewWriter(family, conf, null);
                    }
                }
                kv.updateLatestStamp(this.now);
                wl.writer.append(kv);
                wl.written += length;
                this.previousRow = rowKey;
            }

            private void rollWriters() throws IOException {
                for (WriterLength wl : this.writers.values()) {
                    if (wl.writer != null) {
                        LOG.info((Object)("Writer=" + wl.writer.getPath() + (wl.written == 0L ? "" : ", wrote=" + wl.written)));
                        this.close(wl.writer);
                    }
                    wl.writer = null;
                    wl.written = 0L;
                }
                this.rollRequested = false;
            }

            @SuppressWarnings(value={"BX_UNBOXING_IMMEDIATELY_REBOXED"}, justification="Not important")
            private WriterLength getNewWriter(byte[] family, Configuration conf2, InetSocketAddress[] favoredNodes) throws IOException {
                WriterLength wl = new WriterLength();
                Path familydir = new Path(outputdir, Bytes.toString(family));
                Compression.Algorithm compression = (Compression.Algorithm)((Object)compressionMap.get(family));
                compression = compression == null ? defaultCompression : compression;
                BloomType bloomType = (BloomType)((Object)bloomTypeMap.get(family));
                bloomType = bloomType == null ? BloomType.NONE : bloomType;
                Integer blockSize = (Integer)blockSizeMap.get(family);
                blockSize = blockSize == null ? 65536 : blockSize;
                DataBlockEncoding encoding = overriddenEncoding;
                encoding = encoding == null ? (DataBlockEncoding)((Object)datablockEncodingMap.get(family)) : encoding;
                encoding = encoding == null ? DataBlockEncoding.NONE : encoding;
                Configuration tempConf = new Configuration(conf2);
                tempConf.setFloat("hfile.block.cache.size", 0.0f);
                HFileContextBuilder contextBuilder = new HFileContextBuilder().withCompression(compression).withChecksumType(HStore.getChecksumType(conf2)).withBytesPerCheckSum(HStore.getBytesPerChecksum(conf2)).withBlockSize(blockSize);
                if (HFile.getFormatVersion(conf2) >= 3) {
                    contextBuilder.withIncludesTags(true);
                }
                contextBuilder.withDataBlockEncoding(encoding);
                HFileContext hFileContext = contextBuilder.build();
                wl.writer = null == favoredNodes ? new StoreFile.WriterBuilder(conf2, new CacheConfig(tempConf), fs).withOutputDir(familydir).withBloomType(bloomType).withComparator(KeyValue.COMPARATOR).withFileContext(hFileContext).build() : new StoreFile.WriterBuilder(conf2, new CacheConfig(tempConf), (FileSystem)new HFileSystem(fs)).withOutputDir(familydir).withBloomType(bloomType).withComparator(KeyValue.COMPARATOR).withFileContext(hFileContext).withFavoredNodes(favoredNodes).build();
                this.writers.put(family, wl);
                return wl;
            }

            private void close(StoreFile.Writer w) throws IOException {
                if (w != null) {
                    w.appendFileInfo(StoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes(System.currentTimeMillis()));
                    w.appendFileInfo(StoreFile.BULKLOAD_TASK_KEY, Bytes.toBytes(context.getTaskAttemptID().toString()));
                    w.appendFileInfo(StoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes(true));
                    w.appendFileInfo(StoreFile.EXCLUDE_FROM_MINOR_COMPACTION_KEY, Bytes.toBytes(compactionExclude));
                    w.appendTrackedTimestampsToMetadata();
                    w.close();
                }
            }

            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (WriterLength wl : this.writers.values()) {
                    this.close(wl.writer);
                }
            }
        };
    }

    @Deprecated
    public static void configureMapRTablePath(Job job, String tableName) throws IOException {
        TableMapReduceUtil.configureMapRTablePath(job, tableName);
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(RegionLocator table) throws IOException {
        byte[][] byteKeys = table.getStartKeys();
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>(byteKeys.length);
        for (byte[] byteKey : byteKeys) {
            ret.add(new ImmutableBytesWritable(byteKey));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys) throws IOException {
        LOG.info((Object)("Writing partition information to " + partitionsPath));
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (!Bytes.equals(first.get(), HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary(first.get()));
        }
        sorted.remove(first);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);){
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
    }

    @Deprecated
    public static void configureIncrementalLoad(Job job, HTable table) throws IOException {
        HFileOutputFormat2.configureIncrementalLoad(job, table.getTableDescriptor(), table.getRegionLocator());
    }

    public static void configureIncrementalLoad(Job job, Table table, RegionLocator regionLocator) throws IOException {
        HFileOutputFormat2.configureIncrementalLoad(job, table.getTableDescriptor(), regionLocator);
    }

    public static void configureIncrementalLoad(Job job, HTableDescriptor tableDescriptor, RegionLocator regionLocator) throws IOException {
        HFileOutputFormat2.configureIncrementalLoad(job, tableDescriptor, regionLocator, HFileOutputFormat2.class);
    }

    static void configureIncrementalLoad(Job job, HTableDescriptor tableDescriptor, RegionLocator regionLocator, Class<? extends OutputFormat<?, ?>> cls) throws IOException, UnsupportedEncodingException {
        Configuration conf = job.getConfiguration();
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        job.setOutputFormatClass(cls);
        if (KeyValue.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(KeyValueSortReducer.class);
        } else if (Put.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(PutSortReducer.class);
        } else if (Text.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(TextSortReducer.class);
        } else {
            LOG.warn((Object)("Unknown map output value type:" + job.getMapOutputValueClass()));
        }
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), KeyValueSerialization.class.getName()});
        String tableName = tableDescriptor.getTableName().getNameAsString();
        TableMapReduceUtil.configureMapRTablePath(job, tableName);
        if (conf.getBoolean(LOCALITY_SENSITIVE_CONF_KEY, true)) {
            LOG.info((Object)"bulkload locality sensitive enabled");
            conf.set(OUTPUT_TABLE_NAME_CONF_KEY, regionLocator.getName().getNameAsString());
        }
        LOG.info((Object)("Looking up current regions for table " + tableDescriptor.getTableName()));
        List<ImmutableBytesWritable> startKeys = HFileOutputFormat2.getRegionStartKeys(regionLocator);
        LOG.info((Object)("Configuring " + startKeys.size() + " reduce partitions to match current region count"));
        job.setNumReduceTasks(startKeys.size());
        HFileOutputFormat2.configurePartitioner(job, startKeys);
        HFileOutputFormat2.configureCompression(conf, tableDescriptor);
        HFileOutputFormat2.configureBloomType(tableDescriptor, conf);
        HFileOutputFormat2.configureBlockSize(tableDescriptor, conf);
        HFileOutputFormat2.configureDataBlockEncoding(tableDescriptor, conf);
        TableMapReduceUtil.addDependencyJars(job);
        TableMapReduceUtil.initCredentials(job);
        LOG.info((Object)("Incremental table " + regionLocator.getName() + " output configured."));
    }

    public static void configureIncrementalLoadMap(Job job, Table table) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(KeyValue.class);
        job.setOutputFormatClass(HFileOutputFormat2.class);
        String tableName = table.getTableDescriptor().getTableName().getAliasAsString();
        TableMapReduceUtil.configureMapRTablePath(job, tableName);
        HFileOutputFormat2.configureCompression(conf, table.getTableDescriptor());
        HFileOutputFormat2.configureBloomType(table.getTableDescriptor(), conf);
        HFileOutputFormat2.configureBlockSize(table.getTableDescriptor(), conf);
        HTableDescriptor tableDescriptor = table.getTableDescriptor();
        TableMapReduceUtil.addDependencyJars(job);
        TableMapReduceUtil.initCredentials(job);
        LOG.info((Object)("Incremental table " + table.getName() + " output configured."));
    }

    @VisibleForTesting
    static Map<byte[], Compression.Algorithm> createFamilyCompressionMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, COMPRESSION_FAMILIES_CONF_KEY);
        TreeMap<byte[], Compression.Algorithm> compressionMap = new TreeMap<byte[], Compression.Algorithm>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Compression.Algorithm algorithm = AbstractHFileWriter.compressionByName(e.getValue());
            compressionMap.put(e.getKey(), algorithm);
        }
        return compressionMap;
    }

    @VisibleForTesting
    static Map<byte[], BloomType> createFamilyBloomTypeMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, BLOOM_TYPE_FAMILIES_CONF_KEY);
        TreeMap<byte[], BloomType> bloomTypeMap = new TreeMap<byte[], BloomType>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            BloomType bloomType = BloomType.valueOf(e.getValue());
            bloomTypeMap.put(e.getKey(), bloomType);
        }
        return bloomTypeMap;
    }

    @VisibleForTesting
    static Map<byte[], Integer> createFamilyBlockSizeMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, BLOCK_SIZE_FAMILIES_CONF_KEY);
        TreeMap<byte[], Integer> blockSizeMap = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Integer blockSize = Integer.parseInt(e.getValue());
            blockSizeMap.put(e.getKey(), blockSize);
        }
        return blockSizeMap;
    }

    @VisibleForTesting
    static Map<byte[], DataBlockEncoding> createFamilyDataBlockEncodingMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, DATABLOCK_ENCODING_FAMILIES_CONF_KEY);
        TreeMap<byte[], DataBlockEncoding> encoderMap = new TreeMap<byte[], DataBlockEncoding>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            encoderMap.put(e.getKey(), DataBlockEncoding.valueOf(e.getValue()));
        }
        return encoderMap;
    }

    private static Map<byte[], String> createFamilyConfValueMap(Configuration conf, String confName) {
        TreeMap<byte[], String> confValMap = new TreeMap<byte[], String>(Bytes.BYTES_COMPARATOR);
        String confVal = conf.get(confName, "");
        for (String familyConf : confVal.split("&")) {
            String[] familySplit = familyConf.split("=");
            if (familySplit.length != 2) continue;
            try {
                confValMap.put(Bytes.toBytes(URLDecoder.decode(familySplit[0], "UTF-8")), URLDecoder.decode(familySplit[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return confValMap;
    }

    static void configurePartitioner(Job job, List<ImmutableBytesWritable> splitPoints) throws IOException {
        Configuration conf = job.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        String hbaseTmpFsDir = conf.get("hbase.fs.tmp.dir", HConstants.DEFAULT_TEMPORARY_HDFS_DIRECTORY);
        Path partitionsPath = new Path(hbaseTmpFsDir, "partitions_" + UUID.randomUUID());
        fs.makeQualified(partitionsPath);
        HFileOutputFormat2.writePartitions(conf, partitionsPath, splitPoints);
        LOG.info((Object)("Delete directory on exit: " + partitionsPath));
        fs.deleteOnExit(partitionsPath);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)partitionsPath);
    }

    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    @VisibleForTesting
    static void configureCompression(Configuration conf, HTableDescriptor tableDescriptor) throws UnsupportedEncodingException {
        StringBuilder compressionConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return;
        }
        Collection<HColumnDescriptor> families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                compressionConfigValue.append('&');
            }
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            compressionConfigValue.append('=');
            compressionConfigValue.append(URLEncoder.encode(familyDescriptor.getCompression().getName(), "UTF-8"));
        }
        conf.set(COMPRESSION_FAMILIES_CONF_KEY, compressionConfigValue.toString());
    }

    @VisibleForTesting
    static void configureBlockSize(HTableDescriptor tableDescriptor, Configuration conf) throws UnsupportedEncodingException {
        StringBuilder blockSizeConfigValue = new StringBuilder();
        if (tableDescriptor == null) {
            return;
        }
        Collection<HColumnDescriptor> families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                blockSizeConfigValue.append('&');
            }
            blockSizeConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            blockSizeConfigValue.append('=');
            blockSizeConfigValue.append(URLEncoder.encode(String.valueOf(familyDescriptor.getBlocksize()), "UTF-8"));
        }
        conf.set(BLOCK_SIZE_FAMILIES_CONF_KEY, blockSizeConfigValue.toString());
    }

    @VisibleForTesting
    static void configureBloomType(HTableDescriptor tableDescriptor, Configuration conf) throws UnsupportedEncodingException {
        if (tableDescriptor == null) {
            return;
        }
        StringBuilder bloomTypeConfigValue = new StringBuilder();
        Collection<HColumnDescriptor> families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                bloomTypeConfigValue.append('&');
            }
            bloomTypeConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            bloomTypeConfigValue.append('=');
            String bloomType = familyDescriptor.getBloomFilterType().toString();
            if (bloomType == null) {
                bloomType = HColumnDescriptor.DEFAULT_BLOOMFILTER;
            }
            bloomTypeConfigValue.append(URLEncoder.encode(bloomType, "UTF-8"));
        }
        conf.set(BLOOM_TYPE_FAMILIES_CONF_KEY, bloomTypeConfigValue.toString());
    }

    @VisibleForTesting
    static void configureDataBlockEncoding(HTableDescriptor tableDescriptor, Configuration conf) throws UnsupportedEncodingException {
        if (tableDescriptor == null) {
            return;
        }
        StringBuilder dataBlockEncodingConfigValue = new StringBuilder();
        Collection<HColumnDescriptor> families = tableDescriptor.getFamilies();
        int i = 0;
        for (HColumnDescriptor familyDescriptor : families) {
            if (i++ > 0) {
                dataBlockEncodingConfigValue.append('&');
            }
            dataBlockEncodingConfigValue.append(URLEncoder.encode(familyDescriptor.getNameAsString(), "UTF-8"));
            dataBlockEncodingConfigValue.append('=');
            DataBlockEncoding encoding = familyDescriptor.getDataBlockEncoding();
            if (encoding == null) {
                encoding = DataBlockEncoding.NONE;
            }
            dataBlockEncodingConfigValue.append(URLEncoder.encode(encoding.toString(), "UTF-8"));
        }
        conf.set(DATABLOCK_ENCODING_FAMILIES_CONF_KEY, dataBlockEncodingConfigValue.toString());
    }

    static class WriterLength {
        long written = 0L;
        StoreFile.Writer writer = null;

        WriterLength() {
        }
    }
}

