/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestParseFilter {
    ParseFilter f;
    Filter filter;

    @Before
    public void setUp() throws Exception {
        this.f = new ParseFilter();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testKeyOnlyFilter() throws IOException {
        String filterString = "KeyOnlyFilter()";
        this.doTestFilter(filterString, KeyOnlyFilter.class);
        String filterString2 = "KeyOnlyFilter ('') ";
        byte[] filterStringAsByteArray2 = Bytes.toBytes(filterString2);
        try {
            this.filter = this.f.parseFilterString(filterStringAsByteArray2);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testFirstKeyOnlyFilter() throws IOException {
        String filterString = " FirstKeyOnlyFilter( ) ";
        this.doTestFilter(filterString, FirstKeyOnlyFilter.class);
        String filterString2 = " FirstKeyOnlyFilter ('') ";
        byte[] filterStringAsByteArray2 = Bytes.toBytes(filterString2);
        try {
            this.filter = this.f.parseFilterString(filterStringAsByteArray2);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testPrefixFilter() throws IOException {
        String filterString = " PrefixFilter('row' ) ";
        PrefixFilter prefixFilter = this.doTestFilter(filterString, PrefixFilter.class);
        byte[] prefix = prefixFilter.getPrefix();
        Assert.assertEquals((Object)new String(prefix), (Object)"row");
        filterString = " PrefixFilter(row)";
        try {
            this.doTestFilter(filterString, PrefixFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testColumnPrefixFilter() throws IOException {
        String filterString = " ColumnPrefixFilter('qualifier' ) ";
        ColumnPrefixFilter columnPrefixFilter = this.doTestFilter(filterString, ColumnPrefixFilter.class);
        byte[] columnPrefix = columnPrefixFilter.getPrefix();
        Assert.assertEquals((Object)new String(columnPrefix), (Object)"qualifier");
    }

    @Test
    public void testMultipleColumnPrefixFilter() throws IOException {
        String filterString = " MultipleColumnPrefixFilter('qualifier1', 'qualifier2' ) ";
        MultipleColumnPrefixFilter multipleColumnPrefixFilter = this.doTestFilter(filterString, MultipleColumnPrefixFilter.class);
        byte[][] prefixes = multipleColumnPrefixFilter.getPrefix();
        Assert.assertEquals((Object)new String(prefixes[0]), (Object)"qualifier1");
        Assert.assertEquals((Object)new String(prefixes[1]), (Object)"qualifier2");
    }

    @Test
    public void testColumnCountGetFilter() throws IOException {
        String filterString = " ColumnCountGetFilter(4)";
        ColumnCountGetFilter columnCountGetFilter = this.doTestFilter(filterString, ColumnCountGetFilter.class);
        int limit = columnCountGetFilter.getLimit();
        Assert.assertEquals((long)limit, (long)4L);
        filterString = " ColumnCountGetFilter('abc')";
        try {
            this.doTestFilter(filterString, ColumnCountGetFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        filterString = " ColumnCountGetFilter(2147483648)";
        try {
            this.doTestFilter(filterString, ColumnCountGetFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testPageFilter() throws IOException {
        String filterString = " PageFilter(4)";
        PageFilter pageFilter = this.doTestFilter(filterString, PageFilter.class);
        long pageSize = pageFilter.getPageSize();
        Assert.assertEquals((long)pageSize, (long)4L);
        filterString = " PageFilter('123')";
        try {
            this.doTestFilter(filterString, PageFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("PageFilter needs an int as an argument");
        }
    }

    @Test
    public void testColumnPaginationFilter() throws IOException {
        String filterString = "ColumnPaginationFilter(4, 6)";
        ColumnPaginationFilter columnPaginationFilter = this.doTestFilter(filterString, ColumnPaginationFilter.class);
        int limit = columnPaginationFilter.getLimit();
        Assert.assertEquals((long)limit, (long)4L);
        int offset = columnPaginationFilter.getOffset();
        Assert.assertEquals((long)offset, (long)6L);
        filterString = " ColumnPaginationFilter('124')";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("ColumnPaginationFilter needs two arguments");
        }
        filterString = " ColumnPaginationFilter('4' , '123a')";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("ColumnPaginationFilter needs two ints as arguments");
        }
        filterString = " ColumnPaginationFilter('4' , '-123')";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("ColumnPaginationFilter arguments should not be negative");
        }
    }

    @Test
    public void testInclusiveStopFilter() throws IOException {
        String filterString = "InclusiveStopFilter ('row 3')";
        InclusiveStopFilter inclusiveStopFilter = this.doTestFilter(filterString, InclusiveStopFilter.class);
        byte[] stopRowKey = inclusiveStopFilter.getStopRowKey();
        Assert.assertEquals((Object)new String(stopRowKey), (Object)"row 3");
    }

    @Test
    public void testTimestampsFilter() throws IOException {
        String filterString = "TimestampsFilter(9223372036854775806, 6)";
        TimestampsFilter timestampsFilter = this.doTestFilter(filterString, TimestampsFilter.class);
        List<Long> timestamps = timestampsFilter.getTimestamps();
        Assert.assertEquals((long)timestamps.size(), (long)2L);
        Assert.assertEquals((Object)timestamps.get(0), (Object)new Long(6L));
        filterString = "TimestampsFilter()";
        timestampsFilter = this.doTestFilter(filterString, TimestampsFilter.class);
        timestamps = timestampsFilter.getTimestamps();
        Assert.assertEquals((long)timestamps.size(), (long)0L);
        filterString = "TimestampsFilter(9223372036854775808, 6)";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Long Argument was too large");
        }
        filterString = "TimestampsFilter(-45, 6)";
        try {
            this.doTestFilter(filterString, ColumnPaginationFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Timestamp Arguments should not be negative");
        }
    }

    @Test
    public void testRowFilter() throws IOException {
        String filterString = "RowFilter ( =,   'binary:regionse')";
        RowFilter rowFilter = this.doTestFilter(filterString, RowFilter.class);
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.EQUAL), (Object)((Object)rowFilter.getOperator()));
        Assert.assertTrue((boolean)(rowFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)rowFilter.getComparator();
        Assert.assertEquals((Object)"regionse", (Object)new String(binaryComparator.getValue()));
    }

    @Test
    public void testFamilyFilter() throws IOException {
        String filterString = "FamilyFilter(>=, 'binaryprefix:pre')";
        FamilyFilter familyFilter = this.doTestFilter(filterString, FamilyFilter.class);
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.GREATER_OR_EQUAL), (Object)((Object)familyFilter.getOperator()));
        Assert.assertTrue((boolean)(familyFilter.getComparator() instanceof BinaryPrefixComparator));
        BinaryPrefixComparator binaryPrefixComparator = (BinaryPrefixComparator)familyFilter.getComparator();
        Assert.assertEquals((Object)"pre", (Object)new String(binaryPrefixComparator.getValue()));
    }

    @Test
    public void testQualifierFilter() throws IOException {
        String filterString = "QualifierFilter(=, 'regexstring:pre*')";
        QualifierFilter qualifierFilter = this.doTestFilter(filterString, QualifierFilter.class);
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.EQUAL), (Object)((Object)qualifierFilter.getOperator()));
        Assert.assertTrue((boolean)(qualifierFilter.getComparator() instanceof RegexStringComparator));
        RegexStringComparator regexStringComparator = (RegexStringComparator)qualifierFilter.getComparator();
        Assert.assertEquals((Object)"pre*", (Object)new String(regexStringComparator.getValue()));
    }

    @Test
    public void testValueFilter() throws IOException {
        String filterString = "ValueFilter(!=, 'substring:pre')";
        ValueFilter valueFilter = this.doTestFilter(filterString, ValueFilter.class);
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.NOT_EQUAL), (Object)((Object)valueFilter.getOperator()));
        Assert.assertTrue((boolean)(valueFilter.getComparator() instanceof SubstringComparator));
        SubstringComparator substringComparator = (SubstringComparator)valueFilter.getComparator();
        Assert.assertEquals((Object)"pre", (Object)new String(substringComparator.getValue()));
    }

    @Test
    public void testColumnRangeFilter() throws IOException {
        String filterString = "ColumnRangeFilter('abc', true, 'xyz', false)";
        ColumnRangeFilter columnRangeFilter = this.doTestFilter(filterString, ColumnRangeFilter.class);
        Assert.assertEquals((Object)"abc", (Object)new String(columnRangeFilter.getMinColumn()));
        Assert.assertEquals((Object)"xyz", (Object)new String(columnRangeFilter.getMaxColumn()));
        Assert.assertTrue((boolean)columnRangeFilter.isMinColumnInclusive());
        Assert.assertFalse((boolean)columnRangeFilter.isMaxColumnInclusive());
    }

    @Test
    public void testDependentColumnFilter() throws IOException {
        String filterString = "DependentColumnFilter('family', 'qualifier', true, =, 'binary:abc')";
        DependentColumnFilter dependentColumnFilter = this.doTestFilter(filterString, DependentColumnFilter.class);
        Assert.assertEquals((Object)"family", (Object)new String(dependentColumnFilter.getFamily()));
        Assert.assertEquals((Object)"qualifier", (Object)new String(dependentColumnFilter.getQualifier()));
        Assert.assertTrue((boolean)dependentColumnFilter.getDropDependentColumn());
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.EQUAL), (Object)((Object)dependentColumnFilter.getOperator()));
        Assert.assertTrue((boolean)(dependentColumnFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)dependentColumnFilter.getComparator();
        Assert.assertEquals((Object)"abc", (Object)new String(binaryComparator.getValue()));
    }

    @Test
    public void testSingleColumnValueFilter() throws IOException {
        String filterString = "SingleColumnValueFilter ('family', 'qualifier', >=, 'binary:a', true, false)";
        SingleColumnValueFilter singleColumnValueFilter = this.doTestFilter(filterString, SingleColumnValueFilter.class);
        Assert.assertEquals((Object)"family", (Object)new String(singleColumnValueFilter.getFamily()));
        Assert.assertEquals((Object)"qualifier", (Object)new String(singleColumnValueFilter.getQualifier()));
        Assert.assertEquals((Object)((Object)singleColumnValueFilter.getOperator()), (Object)((Object)CompareFilter.CompareOp.GREATER_OR_EQUAL));
        Assert.assertTrue((boolean)(singleColumnValueFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)singleColumnValueFilter.getComparator();
        Assert.assertEquals((Object)new String(binaryComparator.getValue()), (Object)"a");
        Assert.assertTrue((boolean)singleColumnValueFilter.getFilterIfMissing());
        Assert.assertFalse((boolean)singleColumnValueFilter.getLatestVersionOnly());
        filterString = "SingleColumnValueFilter ('family', 'qualifier', >, 'binaryprefix:a')";
        singleColumnValueFilter = this.doTestFilter(filterString, SingleColumnValueFilter.class);
        Assert.assertEquals((Object)"family", (Object)new String(singleColumnValueFilter.getFamily()));
        Assert.assertEquals((Object)"qualifier", (Object)new String(singleColumnValueFilter.getQualifier()));
        Assert.assertEquals((Object)((Object)singleColumnValueFilter.getOperator()), (Object)((Object)CompareFilter.CompareOp.GREATER));
        Assert.assertTrue((boolean)(singleColumnValueFilter.getComparator() instanceof BinaryPrefixComparator));
        BinaryPrefixComparator binaryPrefixComparator = (BinaryPrefixComparator)singleColumnValueFilter.getComparator();
        Assert.assertEquals((Object)new String(binaryPrefixComparator.getValue()), (Object)"a");
        Assert.assertFalse((boolean)singleColumnValueFilter.getFilterIfMissing());
        Assert.assertTrue((boolean)singleColumnValueFilter.getLatestVersionOnly());
    }

    @Test
    public void testSingleColumnValueExcludeFilter() throws IOException {
        String filterString = "SingleColumnValueExcludeFilter ('family', 'qualifier', <, 'binaryprefix:a')";
        SingleColumnValueExcludeFilter singleColumnValueExcludeFilter = this.doTestFilter(filterString, SingleColumnValueExcludeFilter.class);
        Assert.assertEquals((Object)((Object)singleColumnValueExcludeFilter.getOperator()), (Object)((Object)CompareFilter.CompareOp.LESS));
        Assert.assertEquals((Object)"family", (Object)new String(singleColumnValueExcludeFilter.getFamily()));
        Assert.assertEquals((Object)"qualifier", (Object)new String(singleColumnValueExcludeFilter.getQualifier()));
        Assert.assertEquals((Object)new String(singleColumnValueExcludeFilter.getComparator().getValue()), (Object)"a");
        Assert.assertFalse((boolean)singleColumnValueExcludeFilter.getFilterIfMissing());
        Assert.assertTrue((boolean)singleColumnValueExcludeFilter.getLatestVersionOnly());
        filterString = "SingleColumnValueExcludeFilter ('family', 'qualifier', <=, 'binaryprefix:a', true, false)";
        singleColumnValueExcludeFilter = this.doTestFilter(filterString, SingleColumnValueExcludeFilter.class);
        Assert.assertEquals((Object)"family", (Object)new String(singleColumnValueExcludeFilter.getFamily()));
        Assert.assertEquals((Object)"qualifier", (Object)new String(singleColumnValueExcludeFilter.getQualifier()));
        Assert.assertEquals((Object)((Object)singleColumnValueExcludeFilter.getOperator()), (Object)((Object)CompareFilter.CompareOp.LESS_OR_EQUAL));
        Assert.assertTrue((boolean)(singleColumnValueExcludeFilter.getComparator() instanceof BinaryPrefixComparator));
        BinaryPrefixComparator binaryPrefixComparator = (BinaryPrefixComparator)singleColumnValueExcludeFilter.getComparator();
        Assert.assertEquals((Object)new String(binaryPrefixComparator.getValue()), (Object)"a");
        Assert.assertTrue((boolean)singleColumnValueExcludeFilter.getFilterIfMissing());
        Assert.assertFalse((boolean)singleColumnValueExcludeFilter.getLatestVersionOnly());
    }

    @Test
    public void testSkipFilter() throws IOException {
        String filterString = "SKIP ValueFilter( =,  'binary:0')";
        SkipFilter skipFilter = this.doTestFilter(filterString, SkipFilter.class);
        Assert.assertTrue((boolean)(skipFilter.getFilter() instanceof ValueFilter));
        ValueFilter valueFilter = (ValueFilter)skipFilter.getFilter();
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.EQUAL), (Object)((Object)valueFilter.getOperator()));
        Assert.assertTrue((boolean)(valueFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)valueFilter.getComparator();
        Assert.assertEquals((Object)"0", (Object)new String(binaryComparator.getValue()));
    }

    @Test
    public void testWhileFilter() throws IOException {
        String filterString = " WHILE   RowFilter ( !=, 'binary:row1')";
        WhileMatchFilter whileMatchFilter = this.doTestFilter(filterString, WhileMatchFilter.class);
        Assert.assertTrue((boolean)(whileMatchFilter.getFilter() instanceof RowFilter));
        RowFilter rowFilter = (RowFilter)whileMatchFilter.getFilter();
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.NOT_EQUAL), (Object)((Object)rowFilter.getOperator()));
        Assert.assertTrue((boolean)(rowFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)rowFilter.getComparator();
        Assert.assertEquals((Object)"row1", (Object)new String(binaryComparator.getValue()));
    }

    @Test
    public void testCompoundFilter1() throws IOException {
        String filterString = " (PrefixFilter ('realtime')AND  FirstKeyOnlyFilter())";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof PrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof FirstKeyOnlyFilter));
        PrefixFilter PrefixFilter2 = (PrefixFilter)filters.get(0);
        byte[] prefix = PrefixFilter2.getPrefix();
        Assert.assertEquals((Object)new String(prefix), (Object)"realtime");
        FirstKeyOnlyFilter firstKeyOnlyFilter = (FirstKeyOnlyFilter)filters.get(1);
    }

    @Test
    public void testCompoundFilter2() throws IOException {
        String filterString = "(PrefixFilter('realtime') AND QualifierFilter (>=, 'binary:e'))OR FamilyFilter (=, 'binary:qualifier') ";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filterListFilters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filterListFilters.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(filterListFilters.get(1) instanceof FamilyFilter));
        Assert.assertEquals((Object)((Object)filterList.getOperator()), (Object)((Object)FilterList.Operator.MUST_PASS_ONE));
        filterList = (FilterList)filterListFilters.get(0);
        FamilyFilter familyFilter = (FamilyFilter)filterListFilters.get(1);
        filterListFilters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filterListFilters.get(0) instanceof PrefixFilter));
        Assert.assertTrue((boolean)(filterListFilters.get(1) instanceof QualifierFilter));
        Assert.assertEquals((Object)((Object)filterList.getOperator()), (Object)((Object)FilterList.Operator.MUST_PASS_ALL));
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.EQUAL), (Object)((Object)familyFilter.getOperator()));
        Assert.assertTrue((boolean)(familyFilter.getComparator() instanceof BinaryComparator));
        BinaryComparator binaryComparator = (BinaryComparator)familyFilter.getComparator();
        Assert.assertEquals((Object)"qualifier", (Object)new String(binaryComparator.getValue()));
        PrefixFilter prefixFilter = (PrefixFilter)filterListFilters.get(0);
        byte[] prefix = prefixFilter.getPrefix();
        Assert.assertEquals((Object)new String(prefix), (Object)"realtime");
        QualifierFilter qualifierFilter = (QualifierFilter)filterListFilters.get(1);
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.GREATER_OR_EQUAL), (Object)((Object)qualifierFilter.getOperator()));
        Assert.assertTrue((boolean)(qualifierFilter.getComparator() instanceof BinaryComparator));
        binaryComparator = (BinaryComparator)qualifierFilter.getComparator();
        Assert.assertEquals((Object)"e", (Object)new String(binaryComparator.getValue()));
    }

    @Test
    public void testCompoundFilter3() throws IOException {
        String filterString = " ColumnPrefixFilter ('realtime')AND  FirstKeyOnlyFilter() OR SKIP FamilyFilter(=, 'substring:hihi')";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(filters.get(1) instanceof SkipFilter));
        filterList = (FilterList)filters.get(0);
        SkipFilter skipFilter = (SkipFilter)filters.get(1);
        filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof ColumnPrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof FirstKeyOnlyFilter));
        ColumnPrefixFilter columnPrefixFilter = (ColumnPrefixFilter)filters.get(0);
        byte[] columnPrefix = columnPrefixFilter.getPrefix();
        Assert.assertEquals((Object)new String(columnPrefix), (Object)"realtime");
        FirstKeyOnlyFilter firstKeyOnlyFilter = (FirstKeyOnlyFilter)filters.get(1);
        Assert.assertTrue((boolean)(skipFilter.getFilter() instanceof FamilyFilter));
        FamilyFilter familyFilter = (FamilyFilter)skipFilter.getFilter();
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.EQUAL), (Object)((Object)familyFilter.getOperator()));
        Assert.assertTrue((boolean)(familyFilter.getComparator() instanceof SubstringComparator));
        SubstringComparator substringComparator = (SubstringComparator)familyFilter.getComparator();
        Assert.assertEquals((Object)"hihi", (Object)new String(substringComparator.getValue()));
    }

    @Test
    public void testCompoundFilter4() throws IOException {
        String filterString = " ColumnPrefixFilter ('realtime') OR FirstKeyOnlyFilter() OR SKIP FamilyFilter(=, 'substring:hihi')";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof ColumnPrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof FirstKeyOnlyFilter));
        Assert.assertTrue((boolean)(filters.get(2) instanceof SkipFilter));
        ColumnPrefixFilter columnPrefixFilter = (ColumnPrefixFilter)filters.get(0);
        FirstKeyOnlyFilter firstKeyOnlyFilter = (FirstKeyOnlyFilter)filters.get(1);
        SkipFilter skipFilter = (SkipFilter)filters.get(2);
        byte[] columnPrefix = columnPrefixFilter.getPrefix();
        Assert.assertEquals((Object)new String(columnPrefix), (Object)"realtime");
        Assert.assertTrue((boolean)(skipFilter.getFilter() instanceof FamilyFilter));
        FamilyFilter familyFilter = (FamilyFilter)skipFilter.getFilter();
        Assert.assertEquals((Object)((Object)CompareFilter.CompareOp.EQUAL), (Object)((Object)familyFilter.getOperator()));
        Assert.assertTrue((boolean)(familyFilter.getComparator() instanceof SubstringComparator));
        SubstringComparator substringComparator = (SubstringComparator)familyFilter.getComparator();
        Assert.assertEquals((Object)"hihi", (Object)new String(substringComparator.getValue()));
    }

    @Test
    public void testCompoundFilter5() throws IOException {
        String filterStr = "(ValueFilter(!=, 'substring:pre'))";
        ValueFilter valueFilter = this.doTestFilter(filterStr, ValueFilter.class);
        Assert.assertTrue((boolean)(valueFilter.getComparator() instanceof SubstringComparator));
        filterStr = "(ValueFilter(>=,'binary:x') AND (ValueFilter(<=,'binary:y'))) OR ValueFilter(=,'binary:ab')";
        this.filter = this.f.parseFilterString(filterStr);
        Assert.assertTrue((boolean)(this.filter instanceof FilterList));
        List<Filter> list = ((FilterList)this.filter).getFilters();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(list.get(1) instanceof ValueFilter));
    }

    @Test
    public void testIncorrectCompareOperator() throws IOException {
        String filterString = "RowFilter ('>>' , 'binary:region')";
        try {
            this.doTestFilter(filterString, RowFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Incorrect compare operator >>");
        }
    }

    @Test
    public void testIncorrectComparatorType() throws IOException {
        String filterString = "RowFilter ('>=' , 'binaryoperator:region')";
        try {
            this.doTestFilter(filterString, RowFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Incorrect comparator type: binaryoperator");
        }
        filterString = "RowFilter ('>=' 'regexstring:pre*')";
        try {
            this.doTestFilter(filterString, RowFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("RegexStringComparator can only be used with EQUAL or NOT_EQUAL");
        }
        filterString = "SingleColumnValueFilter ('family', 'qualifier', '>=', 'substring:a', 'true', 'false')')";
        try {
            this.doTestFilter(filterString, RowFilter.class);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println("SubtringComparator can only be used with EQUAL or NOT_EQUAL");
        }
    }

    @Test
    public void testPrecedence1() throws IOException {
        String filterString = " (PrefixFilter ('realtime')AND  FirstKeyOnlyFilter() OR KeyOnlyFilter())";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(filters.get(1) instanceof KeyOnlyFilter));
        filterList = (FilterList)filters.get(0);
        filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof PrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof FirstKeyOnlyFilter));
        PrefixFilter prefixFilter = (PrefixFilter)filters.get(0);
        byte[] prefix = prefixFilter.getPrefix();
        Assert.assertEquals((Object)new String(prefix), (Object)"realtime");
    }

    @Test
    public void testPrecedence2() throws IOException {
        String filterString = " PrefixFilter ('realtime')AND  SKIP FirstKeyOnlyFilter()OR KeyOnlyFilter()";
        FilterList filterList = this.doTestFilter(filterString, FilterList.class);
        ArrayList filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof FilterList));
        Assert.assertTrue((boolean)(filters.get(1) instanceof KeyOnlyFilter));
        filterList = (FilterList)filters.get(0);
        filters = (ArrayList)filterList.getFilters();
        Assert.assertTrue((boolean)(filters.get(0) instanceof PrefixFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof SkipFilter));
        PrefixFilter prefixFilter = (PrefixFilter)filters.get(0);
        byte[] prefix = prefixFilter.getPrefix();
        Assert.assertEquals((Object)new String(prefix), (Object)"realtime");
        SkipFilter skipFilter = (SkipFilter)filters.get(1);
        Assert.assertTrue((boolean)(skipFilter.getFilter() instanceof FirstKeyOnlyFilter));
    }

    @Test
    public void testUnescapedQuote1() throws IOException {
        String filterString = "InclusiveStopFilter ('row''3')";
        InclusiveStopFilter inclusiveStopFilter = this.doTestFilter(filterString, InclusiveStopFilter.class);
        byte[] stopRowKey = inclusiveStopFilter.getStopRowKey();
        Assert.assertEquals((Object)new String(stopRowKey), (Object)"row'3");
    }

    @Test
    public void testUnescapedQuote2() throws IOException {
        String filterString = "InclusiveStopFilter ('row''3''')";
        InclusiveStopFilter inclusiveStopFilter = this.doTestFilter(filterString, InclusiveStopFilter.class);
        byte[] stopRowKey = inclusiveStopFilter.getStopRowKey();
        Assert.assertEquals((Object)new String(stopRowKey), (Object)"row'3'");
    }

    @Test
    public void testUnescapedQuote3() throws IOException {
        String filterString = "\tInclusiveStopFilter ('''')";
        InclusiveStopFilter inclusiveStopFilter = this.doTestFilter(filterString, InclusiveStopFilter.class);
        byte[] stopRowKey = inclusiveStopFilter.getStopRowKey();
        Assert.assertEquals((Object)new String(stopRowKey), (Object)"'");
    }

    @Test
    public void testIncorrectFilterString() throws IOException {
        String filterString = "()";
        byte[] filterStringAsByteArray = Bytes.toBytes(filterString);
        try {
            this.filter = this.f.parseFilterString(filterStringAsByteArray);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testCorrectFilterString() throws IOException {
        String filterString = "(FirstKeyOnlyFilter())";
        FirstKeyOnlyFilter firstKeyOnlyFilter = this.doTestFilter(filterString, FirstKeyOnlyFilter.class);
    }

    @Test
    public void testRegisterFilter() {
        ParseFilter.registerFilter("MyFilter", "some.class");
        Assert.assertTrue((boolean)this.f.getSupportedFilters().contains("MyFilter"));
    }

    private <T extends Filter> T doTestFilter(String filterString, Class<T> clazz) throws IOException {
        byte[] filterStringAsByteArray = Bytes.toBytes(filterString);
        this.filter = this.f.parseFilterString(filterStringAsByteArray);
        Assert.assertEquals(clazz, this.filter.getClass());
        return (T)((Filter)clazz.cast(this.filter));
    }
}

