/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import drill.shaded.hbase.guava.com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LossyCounting;

@InterfaceAudience.Private
public class MetaTableMetrics
extends BaseRegionObserver {
    private MetricRegistry registry;
    private LossyCounting clientMetricsLossyCounting;
    private LossyCounting regionMetricsLossyCounting;
    private boolean active = false;
    private Set<String> metrics = new HashSet<String>();
    private ImmutableMap<Class<? extends Row>, MetaTableOps> opsNameMap = ImmutableMap.builder().put(Put.class, MetaTableOps.PUT).put(Get.class, MetaTableOps.GET).put(Delete.class, MetaTableOps.DELETE).build();

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        this.registerAndMarkMetrics(e, get);
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
        this.registerAndMarkMetrics(e, put);
    }

    @Override
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
        this.registerAndMarkMetrics(e, delete);
    }

    private void registerAndMarkMetrics(ObserverContext<RegionCoprocessorEnvironment> e, Row row) {
        if (!this.active || !this.isMetaTableOp(e)) {
            return;
        }
        this.tableMetricRegisterAndMark(row);
        this.clientMetricRegisterAndMark();
        this.regionMetricRegisterAndMark(row);
        this.opMetricRegisterAndMark(row);
        this.opWithClientMetricRegisterAndMark(row);
    }

    private String getTableNameFromOp(Row op) {
        String tableRowKey = Bytes.toString(op.getRow());
        if (tableRowKey.isEmpty()) {
            return null;
        }
        String[] splits = tableRowKey.split(",");
        return splits.length > 0 ? splits[0] : null;
    }

    private String getRegionIdFromOp(Row op) {
        String tableRowKey = Bytes.toString(op.getRow());
        if (tableRowKey.isEmpty()) {
            return null;
        }
        String[] splits = tableRowKey.split(",");
        return splits.length > 2 ? splits[2] : null;
    }

    private boolean isMetaTableOp(ObserverContext<RegionCoprocessorEnvironment> e) {
        return TableName.META_TABLE_NAME.equals(e.getEnvironment().getRegionInfo().getTable());
    }

    private void clientMetricRegisterAndMark() {
        String clientIP;
        String string = clientIP = RpcServer.getRemoteIp() != null ? RpcServer.getRemoteIp().toString() : null;
        if (clientIP == null || clientIP.isEmpty()) {
            return;
        }
        String clientRequestMeter = this.clientRequestMeterName(clientIP);
        this.clientMetricsLossyCounting.add(clientRequestMeter);
        this.registerAndMarkMeter(clientRequestMeter);
    }

    private void tableMetricRegisterAndMark(Row op) {
        String tableName = this.getTableNameFromOp(op);
        if (tableName == null || tableName.isEmpty()) {
            return;
        }
        String tableRequestMeter = this.tableMeterName(tableName);
        this.registerAndMarkMeter(tableRequestMeter);
    }

    private void regionMetricRegisterAndMark(Row op) {
        String regionId = this.getRegionIdFromOp(op);
        if (regionId == null || regionId.isEmpty()) {
            return;
        }
        String regionRequestMeter = this.regionMeterName(regionId);
        this.regionMetricsLossyCounting.add(regionRequestMeter);
        this.registerAndMarkMeter(regionRequestMeter);
    }

    private void opMetricRegisterAndMark(Row op) {
        String opMeterName = this.opMeterName(op);
        if (opMeterName == null || opMeterName.isEmpty()) {
            return;
        }
        this.registerAndMarkMeter(opMeterName);
    }

    private void opWithClientMetricRegisterAndMark(Object op) {
        String opWithClientMeterName = this.opWithClientMeterName(op);
        if (opWithClientMeterName == null || opWithClientMeterName.isEmpty()) {
            return;
        }
        this.registerAndMarkMeter(opWithClientMeterName);
    }

    private void registerAndMarkMeter(String requestMeter) {
        if (requestMeter.isEmpty()) {
            return;
        }
        if (!this.registry.get(requestMeter).isPresent()) {
            this.metrics.add(requestMeter);
        }
        this.registry.meter(requestMeter).mark();
    }

    private String opWithClientMeterName(Object op) {
        String clientIP;
        String string = clientIP = RpcServer.getRemoteIp() != null ? RpcServer.getRemoteIp().toString() : "";
        if (clientIP.isEmpty()) {
            return "";
        }
        MetaTableOps ops = this.opsNameMap.get(op.getClass());
        String opWithClientMeterName = "";
        switch (ops) {
            case GET: {
                opWithClientMeterName = String.format("MetaTable_client_%s_get_request", clientIP);
                break;
            }
            case PUT: {
                opWithClientMeterName = String.format("MetaTable_client_%s_put_request", clientIP);
                break;
            }
            case DELETE: {
                opWithClientMeterName = String.format("MetaTable_client_%s_delete_request", clientIP);
                break;
            }
        }
        return opWithClientMeterName;
    }

    private String opMeterName(Object op) {
        MetaTableOps ops = this.opsNameMap.get(op.getClass());
        String opMeterName = "";
        switch (ops) {
            case GET: {
                opMeterName = "MetaTable_get_request";
                break;
            }
            case PUT: {
                opMeterName = "MetaTable_put_request";
                break;
            }
            case DELETE: {
                opMeterName = "MetaTable_delete_request";
                break;
            }
        }
        return opMeterName;
    }

    private String tableMeterName(String tableName) {
        return String.format("MetaTable_table_%s_request", tableName);
    }

    private String clientRequestMeterName(String clientIP) {
        if (clientIP.isEmpty()) {
            return "";
        }
        return String.format("MetaTable_client_%s_lossy_request", clientIP);
    }

    private String regionMeterName(String regionId) {
        return String.format("MetaTable_region_%s_lossy_request", regionId);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (env instanceof RegionCoprocessorEnvironment && ((RegionCoprocessorEnvironment)env).getRegionInfo().getTable() != null && ((RegionCoprocessorEnvironment)env).getRegionInfo().getTable().equals(TableName.META_TABLE_NAME)) {
            RegionCoprocessorEnvironment regionCoprocessorEnv = (RegionCoprocessorEnvironment)env;
            this.registry = regionCoprocessorEnv.getMetricRegistryForRegionServer();
            LossyCounting.LossyCountingListener listener = new LossyCounting.LossyCountingListener(){

                @Override
                public void sweep(String key) {
                    MetaTableMetrics.this.registry.remove(key);
                    MetaTableMetrics.this.metrics.remove(key);
                }
            };
            Configuration conf = regionCoprocessorEnv.getConfiguration();
            this.clientMetricsLossyCounting = new LossyCounting(conf, listener);
            this.regionMetricsLossyCounting = new LossyCounting(conf, listener);
            this.active = true;
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
        for (String metric : this.metrics) {
            this.registry.remove(metric);
        }
    }

    static enum MetaTableOps {
        GET,
        PUT,
        DELETE;

    }
}

