/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationAdmin {
    private static final Log LOG = LogFactory.getLog(TestReplicationAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String ID_ONE = "1";
    private final String KEY_ONE = "127.0.0.1:2181:/hbase";
    private final String ID_SECOND = "2";
    private final String KEY_SECOND = "127.0.0.1:2181:/hbase2";
    private static ReplicationAdmin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.replication", true);
        admin = new ReplicationAdmin(conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (admin != null) {
            admin.close();
        }
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testAddRemovePeer() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        admin.addPeer("1", rpc1);
        try {
            admin.addPeer("1", rpc1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.addPeer("1-2", "127.0.0.1:2181:/hbase");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.addPeer("lock", "127.0.0.1:2181:/hbase");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.removePeer("2");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.addPeer("2", rpc2);
        }
        catch (IllegalStateException iae) {
            Assert.fail();
        }
        Assert.assertEquals((long)2L, (long)admin.getPeersCount());
        admin.removePeer("1");
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        admin.removePeer("2");
        Assert.assertEquals((long)0L, (long)admin.getPeersCount());
    }

    @Test
    public void testAddPeerWithUnDeletedQueues() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        Configuration conf = TEST_UTIL.getConfiguration();
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "Test HBaseAdmin", null);
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues(zkw, conf, null);
        repQueues.init("server1");
        repQueues.addLog("1", "file1");
        try {
            admin.addPeer("1", rpc1);
            Assert.fail();
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        repQueues.removeQueue("1");
        Assert.assertEquals((long)0L, (long)repQueues.getAllQueues().size());
        repQueues.addLog("1-server2", "file1");
        try {
            admin.addPeer("1", rpc2);
            Assert.fail();
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        repQueues.removeAllQueues();
        zkw.close();
    }

    @Test
    public void testPeerConfig() throws Exception {
        ReplicationPeerConfig config = new ReplicationPeerConfig();
        config.setClusterKey("127.0.0.1:2181:/hbase");
        config.getConfiguration().put("key1", "value1");
        config.getConfiguration().put("key2", "value2");
        admin.addPeer("1", config, null);
        List<ReplicationPeer> peers = admin.listReplicationPeers();
        Assert.assertEquals((long)1L, (long)peers.size());
        ReplicationPeer peerOne = peers.get(0);
        Assert.assertNotNull((Object)peerOne);
        Assert.assertEquals((Object)"value1", (Object)peerOne.getConfiguration().get("key1"));
        Assert.assertEquals((Object)"value2", (Object)peerOne.getConfiguration().get("key2"));
        admin.removePeer("1");
    }

    @Test
    public void testEnableDisable() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        admin.addPeer("1", rpc1);
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        Assert.assertTrue((boolean)admin.getPeerState("1"));
        admin.disablePeer("1");
        Assert.assertFalse((boolean)admin.getPeerState("1"));
        try {
            admin.getPeerState("2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        admin.removePeer("1");
    }

    @Test
    public void testAppendPeerTableCFs() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        TableName tab1 = TableName.valueOf("t1");
        TableName tab2 = TableName.valueOf("t2");
        TableName tab3 = TableName.valueOf("t3");
        TableName tab4 = TableName.valueOf("t4");
        admin.addPeer("1", rpc1);
        HashMap tableCFs = new HashMap();
        tableCFs.put(tab1, null);
        admin.appendPeerTableCFs("1", tableCFs);
        Map<TableName, List<String>> result = admin.getPeerConfig("1").getTableCFsMap();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)true, (Object)result.containsKey(tab1));
        Assert.assertNull(result.get(tab1));
        tableCFs.clear();
        tableCFs.put(tab2, null);
        admin.appendPeerTableCFs("1", tableCFs);
        result = admin.getPeerConfig("1").getTableCFsMap();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tab1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tab2));
        Assert.assertNull(result.get(tab1));
        Assert.assertNull(result.get(tab2));
        tableCFs.clear();
        tableCFs.put(tab3, new ArrayList());
        ((List)tableCFs.get(tab3)).add("f1");
        admin.appendPeerTableCFs("1", tableCFs);
        result = admin.getPeerConfig("1").getTableCFsMap();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tab1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tab2));
        Assert.assertTrue((String)"Should contain t3", (boolean)result.containsKey(tab3));
        Assert.assertNull(result.get(tab1));
        Assert.assertNull(result.get(tab2));
        Assert.assertEquals((long)1L, (long)result.get(tab3).size());
        Assert.assertEquals((Object)"f1", (Object)result.get(tab3).get(0));
        tableCFs.clear();
        tableCFs.put(tab4, new ArrayList());
        ((List)tableCFs.get(tab4)).add("f1");
        ((List)tableCFs.get(tab4)).add("f2");
        admin.appendPeerTableCFs("1", tableCFs);
        result = admin.getPeerConfig("1").getTableCFsMap();
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tab1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tab2));
        Assert.assertTrue((String)"Should contain t3", (boolean)result.containsKey(tab3));
        Assert.assertTrue((String)"Should contain t4", (boolean)result.containsKey(tab4));
        Assert.assertNull(result.get(tab1));
        Assert.assertNull(result.get(tab2));
        Assert.assertEquals((long)1L, (long)result.get(tab3).size());
        Assert.assertEquals((Object)"f1", (Object)result.get(tab3).get(0));
        Assert.assertEquals((long)2L, (long)result.get(tab4).size());
        Assert.assertEquals((Object)"f1", (Object)result.get(tab4).get(0));
        Assert.assertEquals((Object)"f2", (Object)result.get(tab4).get(1));
        admin.removePeer("1");
    }

    @Test
    public void testRemovePeerTableCFs() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        TableName tab1 = TableName.valueOf("t1");
        TableName tab2 = TableName.valueOf("t2");
        TableName tab3 = TableName.valueOf("t3");
        admin.addPeer("1", rpc1);
        HashMap tableCFs = new HashMap();
        try {
            tableCFs.put(tab3, null);
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        Assert.assertNull(admin.getPeerConfig("1").getTableCFsMap());
        tableCFs.clear();
        tableCFs.put(tab1, null);
        tableCFs.put(tab2, new ArrayList());
        ((List)tableCFs.get(tab2)).add("cf1");
        admin.setPeerTableCFs("1", tableCFs);
        try {
            tableCFs.clear();
            tableCFs.put(tab3, null);
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        Map<TableName, List<String>> result = admin.getPeerConfig("1").getTableCFsMap();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tab1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tab2));
        Assert.assertNull(result.get(tab1));
        Assert.assertEquals((long)1L, (long)result.get(tab2).size());
        Assert.assertEquals((Object)"cf1", (Object)result.get(tab2).get(0));
        tableCFs.clear();
        tableCFs.put(tab1, new ArrayList());
        ((List)tableCFs.get(tab1)).add("f1");
        try {
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        tableCFs.clear();
        tableCFs.put(tab1, null);
        admin.removePeerTableCFs("1", tableCFs);
        result = admin.getPeerConfig("1").getTableCFsMap();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)result.get(tab2).size());
        Assert.assertEquals((Object)"cf1", (Object)result.get(tab2).get(0));
        tableCFs.clear();
        tableCFs.put(tab2, null);
        try {
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        tableCFs.clear();
        tableCFs.put(tab2, new ArrayList());
        ((List)tableCFs.get(tab2)).add("cf1");
        admin.removePeerTableCFs("1", tableCFs);
        Assert.assertNull(admin.getPeerConfig("1").getTableCFsMap());
        admin.removePeer("1");
    }

    @Test
    public void testPeerBandwidth() throws ReplicationException {
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        admin.addPeer("1", rpc);
        admin.peerAdded("1");
        rpc = admin.getPeerConfig("1");
        Assert.assertEquals((long)0L, (long)rpc.getBandwidth());
        rpc.setBandwidth(0x200000L);
        admin.updatePeerConfig("1", rpc);
        Assert.assertEquals((long)0x200000L, (long)admin.getPeerConfig("1").getBandwidth());
        admin.removePeer("1");
    }

    @Test
    public void testUpdatePeerConfig() throws Exception {
        TableName tab1 = TableName.valueOf("t1");
        TableName tab2 = TableName.valueOf("t2");
        HashMap tableCFs = new HashMap();
        ReplicationPeerConfig config = new ReplicationPeerConfig();
        config.setClusterKey("127.0.0.1:2181:/hbase");
        config.getConfiguration().put("key1", "value1");
        tableCFs.put(tab1, new ArrayList());
        config.setTableCFsMap(tableCFs);
        admin.addPeer("1", config, null);
        admin.peerAdded("1");
        config = admin.getPeerConfig("1");
        Assert.assertEquals((Object)"value1", (Object)config.getConfiguration().get("key1"));
        Assert.assertNull((Object)config.getConfiguration().get("key2"));
        Assert.assertTrue((boolean)config.getTableCFsMap().containsKey(tab1));
        Assert.assertFalse((boolean)config.getTableCFsMap().containsKey(tab2));
        config = new ReplicationPeerConfig();
        config.setClusterKey("127.0.0.1:2181:/hbase");
        config.getConfiguration().put("key2", "value2");
        tableCFs.clear();
        tableCFs.put(tab2, new ArrayList());
        config.setTableCFsMap(tableCFs);
        admin.updatePeerConfig("1", config);
        config = admin.getPeerConfig("1");
        Assert.assertEquals((Object)"value1", (Object)config.getConfiguration().get("key1"));
        Assert.assertEquals((Object)"value2", (Object)config.getConfiguration().get("key2"));
        Assert.assertFalse((boolean)config.getTableCFsMap().containsKey(tab1));
        Assert.assertTrue((boolean)config.getTableCFsMap().containsKey(tab2));
        admin.removePeer("1");
    }
}

