/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestScannersFromClientSide2 {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf("scan");
    private static byte[] FAMILY = Bytes.toBytes("cf");
    private static byte[] CQ1 = Bytes.toBytes("cq1");
    private static byte[] CQ2 = Bytes.toBytes("cq2");
    @Parameterized.Parameter(value=0)
    public boolean batch;
    @Parameterized.Parameter(value=1)
    public boolean smallResultSize;
    @Parameterized.Parameter(value=2)
    public boolean allowPartial;

    @Parameterized.Parameters(name="{index}: batch={0}, smallResultSize={1}, allowPartial={2}")
    public static List<Object[]> params() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        boolean[] values = new boolean[]{false, true};
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    params.add(new Object[]{values[i], values[j], values[k]});
                }
            }
        }
        return params;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        byte[][] splitKeys = new byte[8][];
        for (int i = 111; i < 999; i += 111) {
            splitKeys[i / 111 - 1] = Bytes.toBytes(String.format("%03d", i));
        }
        HTable table = TEST_UTIL.createTable(TABLE_NAME, FAMILY, (byte[][])splitKeys);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 1000; ++i) {
            puts.add(new Put(Bytes.toBytes(String.format("%03d", i))).addColumn(FAMILY, CQ1, Bytes.toBytes(i)).addColumn(FAMILY, CQ2, Bytes.toBytes(i * i)));
        }
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        table.put(puts);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private Scan createScan() {
        Scan scan = new Scan();
        if (this.batch) {
            scan.setBatch(1);
        }
        if (this.smallResultSize) {
            scan.setMaxResultSize(1L);
        }
        if (this.allowPartial) {
            scan.setAllowPartialResults(true);
        }
        return scan;
    }

    private void assertResultEquals(Result result, int i) {
        Assert.assertEquals((Object)String.format("%03d", i), (Object)Bytes.toString(result.getRow()));
        Assert.assertEquals((long)i, (long)Bytes.toInt(result.getValue(FAMILY, CQ1)));
        Assert.assertEquals((long)(i * i), (long)Bytes.toInt(result.getValue(FAMILY, CQ2)));
    }

    private List<Result> doScan(Scan scan) throws IOException {
        ArrayList<Result> results = new ArrayList<Result>();
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);
             ResultScanner scanner = table.getScanner(scan);){
            Result r;
            while ((r = scanner.next()) != null) {
                results.add(r);
            }
        }
        return this.assertAndCreateCompleteResults(results);
    }

    private List<Result> assertAndCreateCompleteResults(List<Result> results) throws IOException {
        if (!this.batch && !this.allowPartial || this.allowPartial && !this.batch && !this.smallResultSize) {
            for (Result result : results) {
                Assert.assertFalse((String)"Should not have partial result", (boolean)result.mayHaveMoreCellsInRow());
            }
            return results;
        }
        ArrayList<Result> completeResults = new ArrayList<Result>();
        ArrayList<Result> partialResults = new ArrayList<Result>();
        for (Result result : results) {
            if (!result.mayHaveMoreCellsInRow()) {
                Assert.assertFalse((String)"Should have partial result", (boolean)partialResults.isEmpty());
                partialResults.add(result);
                completeResults.add(Result.createCompleteResult(partialResults));
                partialResults.clear();
                continue;
            }
            partialResults.add(result);
        }
        Assert.assertTrue((String)"Should not have orphan partial result", (boolean)partialResults.isEmpty());
        return completeResults;
    }

    private void testScan(int start, boolean startInclusive, int stop, boolean stopInclusive, int limit) throws Exception {
        Scan scan = this.createScan().withStartRow(Bytes.toBytes(String.format("%03d", start)), startInclusive).withStopRow(Bytes.toBytes(String.format("%03d", stop)), stopInclusive);
        if (limit > 0) {
            scan.setLimit(limit);
        }
        List<Result> results = this.doScan(scan);
        int actualStart = startInclusive ? start : start + 1;
        int actualStop = stopInclusive ? stop + 1 : stop;
        int count = actualStop - actualStart;
        if (limit > 0) {
            count = Math.min(count, limit);
        }
        Assert.assertEquals((long)count, (long)results.size());
        for (int i = 0; i < count; ++i) {
            this.assertResultEquals(results.get(i), actualStart + i);
        }
    }

    private void testReversedScan(int start, boolean startInclusive, int stop, boolean stopInclusive, int limit) throws Exception {
        Scan scan = this.createScan().withStartRow(Bytes.toBytes(String.format("%03d", start)), startInclusive).withStopRow(Bytes.toBytes(String.format("%03d", stop)), stopInclusive).setReversed(true);
        if (limit > 0) {
            scan.setLimit(limit);
        }
        List<Result> results = this.doScan(scan);
        int actualStart = startInclusive ? start : start - 1;
        int actualStop = stopInclusive ? stop - 1 : stop;
        int count = actualStart - actualStop;
        if (limit > 0) {
            count = Math.min(count, limit);
        }
        Assert.assertEquals((long)count, (long)results.size());
        for (int i = 0; i < count; ++i) {
            this.assertResultEquals(results.get(i), actualStart - i);
        }
    }

    @Test
    public void testScanWithLimit() throws Exception {
        this.testScan(1, true, 998, false, 900);
        this.testScan(123, true, 345, true, 100);
        this.testScan(234, true, 456, false, 100);
        this.testScan(345, false, 567, true, 100);
        this.testScan(456, false, 678, false, 100);
    }

    @Test
    public void testScanWithLimitGreaterThanActualCount() throws Exception {
        this.testScan(1, true, 998, false, 1000);
        this.testScan(123, true, 345, true, 200);
        this.testScan(234, true, 456, false, 200);
        this.testScan(345, false, 567, true, 200);
        this.testScan(456, false, 678, false, 200);
    }

    @Test
    public void testReversedScanWithLimit() throws Exception {
        this.testReversedScan(998, true, 1, false, 900);
        this.testReversedScan(543, true, 321, true, 100);
        this.testReversedScan(654, true, 432, false, 100);
        this.testReversedScan(765, false, 543, true, 100);
        this.testReversedScan(876, false, 654, false, 100);
    }

    @Test
    public void testReversedScanWithLimitGreaterThanActualCount() throws Exception {
        this.testReversedScan(998, true, 1, false, 1000);
        this.testReversedScan(543, true, 321, true, 200);
        this.testReversedScan(654, true, 432, false, 200);
        this.testReversedScan(765, false, 543, true, 200);
        this.testReversedScan(876, false, 654, false, 200);
    }

    @Test
    public void testStartRowStopRowInclusive() throws Exception {
        this.testScan(1, true, 998, false, -1);
        this.testScan(123, true, 345, true, -1);
        this.testScan(234, true, 456, false, -1);
        this.testScan(345, false, 567, true, -1);
        this.testScan(456, false, 678, false, -1);
    }

    @Test
    public void testReversedStartRowStopRowInclusive() throws Exception {
        this.testReversedScan(998, true, 1, false, -1);
        this.testReversedScan(543, true, 321, true, -1);
        this.testReversedScan(654, true, 432, false, -1);
        this.testReversedScan(765, false, 543, true, -1);
        this.testReversedScan(876, false, 654, false, -1);
    }
}

