/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMultiRespectsLimits {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final MetricsAssertHelper METRICS_ASSERT = CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private static final byte[] FAMILY = Bytes.toBytes("D");
    public static final int MAX_SIZE = 500;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setLong("hbase.server.scanner.max.result.size", 500L);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMultiLimits() throws Exception {
        final TableName name = TableName.valueOf("testMultiLimits");
        HTable t = TEST_UTIL.createTable(name, FAMILY);
        TEST_UTIL.loadTable((Table)t, FAMILY, false);
        try (final HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();){
            admin.split(name);
            TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

                @Override
                public boolean evaluate() throws Exception {
                    return admin.getTableRegions(name).size() > 1;
                }
            });
        }
        ArrayList<Get> gets = new ArrayList<Get>(500);
        for (int i = 0; i < 500; ++i) {
            gets.add(new Get(HBaseTestingUtility.ROWS[i]));
        }
        RpcServerInterface rpcServer = TEST_UTIL.getHBaseCluster().getRegionServer(0).getRpcServer();
        MetricsHBaseServerSource s = rpcServer.getMetrics().getMetricsSource();
        long startingExceptions = METRICS_ASSERT.getCounter("exceptions", s);
        long startingMultiExceptions = METRICS_ASSERT.getCounter("exceptions.multiResponseTooLarge", s);
        Result[] results = t.get(gets);
        TestCase.assertEquals((int)500, (int)results.length);
        METRICS_ASSERT.assertCounterGt("exceptions", startingExceptions + 25L, s);
        METRICS_ASSERT.assertCounterGt("exceptions.multiResponseTooLarge", startingMultiExceptions + 25L, s);
    }

    @Test
    public void testBlockMultiLimits() throws Exception {
        final TableName name = TableName.valueOf("testBlockMultiLimits");
        HTableDescriptor desc = new HTableDescriptor(name);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        hcd.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
        desc.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        Table t = TEST_UTIL.getConnection().getTable(name);
        final HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        RpcServerInterface rpcServer = regionServer.getRpcServer();
        MetricsHBaseServerSource s = rpcServer.getMetrics().getMetricsSource();
        long startingExceptions = METRICS_ASSERT.getCounter("exceptions", s);
        long startingMultiExceptions = METRICS_ASSERT.getCounter("exceptions.multiResponseTooLarge", s);
        byte[] row = Bytes.toBytes("TEST");
        byte[][] cols = new byte[][]{Bytes.toBytes("0"), Bytes.toBytes("1"), Bytes.toBytes("2"), Bytes.toBytes("3"), Bytes.toBytes("4"), Bytes.toBytes("5")};
        byte[] value = new byte[400];
        ThreadLocalRandom.current().nextBytes(value);
        for (byte[] col : cols) {
            Put p = new Put(row);
            p.addImmutable(FAMILY, col, value);
            t.put(p);
        }
        try (HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();){
            admin.flush(name);
            TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

                @Override
                public boolean evaluate() throws Exception {
                    return regionServer.getOnlineRegions(name).get(0).getMaxFlushedSeqId() > 3L;
                }
            });
        }
        ArrayList<Get> gets = new ArrayList<Get>(2);
        Get g0 = new Get(row);
        g0.addColumn(FAMILY, cols[0]);
        gets.add(g0);
        Get g2 = new Get(row);
        g2.addColumn(FAMILY, cols[3]);
        gets.add(g2);
        Result[] results = t.get(gets);
        TestCase.assertEquals((int)2, (int)results.length);
        METRICS_ASSERT.assertCounterGt("exceptions", startingExceptions, s);
        METRICS_ASSERT.assertCounterGt("exceptions.multiResponseTooLarge", startingMultiExceptions, s);
    }
}

