/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class, ClientTests.class})
public class TestMalformedCellFromClient {
    private static final Log LOG = LogFactory.getLog(TestMalformedCellFromClient.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes("testFamily");
    private static final int CELL_SIZE = 100;
    private static final TableName TABLE_NAME = TableName.valueOf("TestMalformedCellFromClient");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        TEST_UTIL.startMiniCluster(1);
    }

    @Before
    public void before() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TABLE_NAME).addFamily(new HColumnDescriptor(FAMILY)).setValue("hbase.server.keyvalue.maxsize", String.valueOf(100));
        TEST_UTIL.getConnection().getAdmin().createTable(desc);
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : TEST_UTIL.getHBaseAdmin().listTables()) {
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testRegionException() throws InterruptedException, IOException {
        ArrayList<Row> batches = new ArrayList<Row>();
        batches.add(new Put(Bytes.toBytes("good")).addColumn(FAMILY, null, new byte[10]));
        RowMutations rm = new RowMutations(Bytes.toBytes("fail"));
        rm.add(new Put(rm.getRow()).addColumn(FAMILY, null, new byte[100]));
        batches.add(rm);
        Object[] results = new Object[batches.size()];
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            Throwable exceptionByCaught = null;
            try {
                table.batch(batches, results);
                Assert.fail((String)"Where is the exception? We put the malformed cells!!!");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                for (Throwable throwable : e.getCauses()) {
                    Assert.assertNotNull((Object)throwable);
                }
                Assert.assertEquals((long)1L, (long)e.getNumExceptions());
                exceptionByCaught = e.getCause(0);
            }
            for (Object obj : results) {
                Assert.assertNotNull((Object)obj);
            }
            Assert.assertEquals(Result.class, results[0].getClass());
            Assert.assertEquals(exceptionByCaught.getClass(), results[1].getClass());
            Result result = table.get(new Get(Bytes.toBytes("good")));
            Assert.assertEquals((long)1L, (long)result.size());
            Cell cell = result.getColumnLatestCell(FAMILY, null);
            Assert.assertTrue((boolean)Bytes.equals(CellUtil.cloneValue(cell), new byte[10]));
        }
    }

    @Test
    public void testAtomicOperations() throws Exception {
        RowMutations rm = new RowMutations(Bytes.toBytes("fail"));
        rm.add(new Put(rm.getRow()).addColumn(FAMILY, null, new byte[100]));
        rm.add(new Put(rm.getRow()).addColumn(FAMILY, null, new byte[10]));
        Put put = new Put(Bytes.toBytes("good")).addColumn(FAMILY, null, new byte[10]);
        HRegion r = TEST_UTIL.getMiniHBaseCluster().getRegions(TABLE_NAME).get(0);
        ClientProtos.MultiRequest request = ClientProtos.MultiRequest.newBuilder(TestMalformedCellFromClient.createRequest(rm, r.getRegionInfo().getRegionName())).addRegionAction(ClientProtos.RegionAction.newBuilder().setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, r.getRegionInfo().getRegionName())).addAction(ClientProtos.Action.newBuilder().setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.PUT, put)))).build();
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (Mutation m : rm.getMutations()) {
            cells.addAll(m.getCellList(FAMILY));
        }
        cells.addAll(put.getCellList(FAMILY));
        Assert.assertEquals((long)3L, (long)cells.size());
        HBaseRpcController controller = (HBaseRpcController)Mockito.mock(HBaseRpcController.class);
        Mockito.when((Object)controller.cellScanner()).thenReturn((Object)CellUtil.createCellScanner(cells));
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(TEST_UTIL.getMiniHBaseCluster().getServerHoldingRegion(TABLE_NAME, r.getRegionInfo().getRegionName()));
        ClientProtos.MultiResponse response = rs.getRSRpcServices().multi(controller, request);
        Assert.assertEquals((long)2L, (long)response.getRegionActionResultCount());
        Assert.assertTrue((boolean)response.getRegionActionResultList().get(0).hasException());
        Assert.assertFalse((boolean)response.getRegionActionResultList().get(1).hasException());
        Assert.assertEquals((long)1L, (long)response.getRegionActionResultList().get(1).getResultOrExceptionCount());
        Assert.assertTrue((boolean)response.getRegionActionResultList().get(1).getResultOrExceptionList().get(0).hasResult());
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            Result result = table.get(new Get(Bytes.toBytes("good")));
            Assert.assertEquals((long)1L, (long)result.size());
            Cell cell = result.getColumnLatestCell(FAMILY, null);
            Assert.assertTrue((boolean)Bytes.equals(CellUtil.cloneValue(cell), new byte[10]));
        }
    }

    private static ClientProtos.MultiRequest createRequest(RowMutations rm, byte[] regionName) throws IOException {
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion(ClientProtos.RegionAction.newBuilder(), regionName);
        builder.setAtomic(true);
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        ClientProtos.Condition condition = RequestConverter.buildCondition(rm.getRow(), FAMILY, FAMILY, new BinaryComparator(new byte[10]), HBaseProtos.CompareType.EQUAL);
        for (Mutation mutation : rm.getMutations()) {
            ClientProtos.MutationProto.MutationType mutateType = null;
            if (mutation instanceof Put) {
                mutateType = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                mutateType = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new DoNotRetryIOException("RowMutations supports only put and delete, not " + mutation.getClass().getName());
            }
            mutationBuilder.clear();
            ClientProtos.MutationProto mp = ProtobufUtil.toMutationNoData(mutateType, mutation, mutationBuilder);
            actionBuilder.clear();
            actionBuilder.setMutation(mp);
            builder.addAction(actionBuilder.build());
        }
        ClientProtos.MultiRequest request = ClientProtos.MultiRequest.newBuilder().addRegionAction(builder.build()).setCondition(condition).build();
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAtomicOperations() throws InterruptedException, IOException {
        Increment inc = new Increment(Bytes.toBytes("good")).addColumn(FAMILY, FAMILY, 100L);
        ArrayList<Mutation> batches = new ArrayList<Mutation>();
        batches.add(new Put(Bytes.toBytes("fail")).addColumn(FAMILY, null, new byte[100]));
        batches.add(new Put(Bytes.toBytes("fail")).addColumn(FAMILY, null, new byte[100]));
        batches.add(inc);
        batches.add(new Put(Bytes.toBytes("good")).addColumn(FAMILY, null, new byte[1]));
        Object[] objs = new Object[batches.size()];
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            table.batch(batches, objs);
            Assert.fail((String)"Where is the exception? We put the malformed cells!!!");
        }
        catch (RetriesExhaustedWithDetailsException e) {
            Assert.assertEquals((long)2L, (long)e.getNumExceptions());
            for (int i = 0; i != e.getNumExceptions(); ++i) {
                Assert.assertNotNull((Object)e.getCause(i));
                Assert.assertEquals(DoNotRetryIOException.class, e.getCause(i).getClass());
                Assert.assertEquals((Object)"fail", (Object)Bytes.toString(e.getRow(i).getRow()));
            }
        }
        finally {
            TestMalformedCellFromClient.assertObjects(objs, batches.size());
            Assert.assertTrue((boolean)(objs[0] instanceof IOException));
            Assert.assertTrue((boolean)(objs[1] instanceof IOException));
            Assert.assertEquals(Result.class, objs[2].getClass());
            Assert.assertEquals(Result.class, objs[3].getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowMutations() throws InterruptedException, IOException {
        Put put = new Put(Bytes.toBytes("good")).addColumn(FAMILY, null, new byte[1]);
        ArrayList<RowMutations> batches = new ArrayList<RowMutations>();
        RowMutations mutations = new RowMutations(Bytes.toBytes("fail"));
        mutations.add(new Put(Bytes.toBytes("fail")).addColumn(FAMILY, null, new byte[100]));
        mutations.add(new Put(Bytes.toBytes("fail")).addColumn(FAMILY, null, new byte[100]));
        batches.add(mutations);
        mutations = new RowMutations(Bytes.toBytes("good"));
        mutations.add(put);
        mutations.add(put);
        batches.add(mutations);
        Object[] objs = new Object[batches.size()];
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            table.batch(batches, objs);
            Assert.fail((String)"Where is the exception? We put the malformed cells!!!");
        }
        catch (RetriesExhaustedWithDetailsException e) {
            Assert.assertEquals((long)1L, (long)e.getNumExceptions());
            for (int i = 0; i != e.getNumExceptions(); ++i) {
                Assert.assertNotNull((Object)e.getCause(i));
                Assert.assertTrue((boolean)(e.getCause(i) instanceof IOException));
                Assert.assertEquals((Object)"fail", (Object)Bytes.toString(e.getRow(i).getRow()));
            }
        }
        finally {
            TestMalformedCellFromClient.assertObjects(objs, batches.size());
            Assert.assertTrue((boolean)(objs[0] instanceof IOException));
            Assert.assertEquals(Result.class, objs[1].getClass());
        }
    }

    private static void assertObjects(Object[] objs, int expectedSize) {
        int count = 0;
        for (Object obj : objs) {
            Assert.assertNotNull((Object)obj);
            ++count;
        }
        Assert.assertEquals((long)expectedSize, (long)count);
    }
}

