/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestFromClientSide3 {
    private static final Log LOG = LogFactory.getLog(TestFromClientSide3.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes("testFamily");
    private static Random random = new Random();
    private static int SLAVES = 3;
    private static final byte[] ROW = Bytes.toBytes("testRow");
    private static final byte[] ANOTHERROW = Bytes.toBytes("anotherrow");
    private static final byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static final byte[] VALUE = Bytes.toBytes("testValue");
    private static final byte[] COL_QUAL = Bytes.toBytes("f1");
    private static final byte[] VAL_BYTES = Bytes.toBytes("v1");
    private static final byte[] ROW_BYTES = Bytes.toBytes("r1");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : TEST_UTIL.getHBaseAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    private void randomCFPuts(Table table, byte[] row, byte[] family, int nPuts) throws Exception {
        Put put = new Put(row);
        for (int i = 0; i < nPuts; ++i) {
            byte[] qualifier = Bytes.toBytes(random.nextInt());
            byte[] value = Bytes.toBytes(random.nextInt());
            put.add(family, qualifier, value);
        }
        table.put(put);
    }

    private void performMultiplePutAndFlush(HBaseAdmin admin, HTable table, byte[] row, byte[] family, int nFlushes, int nPuts) throws Exception {
        HRegionLocation loc = table.getRegionLocation(row, true);
        AdminProtos.AdminService.BlockingInterface server = admin.getConnection().getAdmin(loc.getServerName());
        byte[] regName = loc.getRegionInfo().getRegionName();
        for (int i = 0; i < nFlushes; ++i) {
            this.randomCFPuts(table, row, family, nPuts);
            List<String> sf = ProtobufUtil.getStoreFiles(server, regName, FAMILY);
            int sfCount = sf.size();
            admin.flush(table.getTableName());
            while (ProtobufUtil.getStoreFiles(server, regName, FAMILY).size() == sfCount) {
                Thread.sleep(40L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Cell> toList(ResultScanner scanner) {
        try {
            ArrayList<Cell> cells = new ArrayList<Cell>();
            for (Result r : scanner) {
                cells.addAll(r.listCells());
            }
            ArrayList<Cell> arrayList = cells;
            return arrayList;
        }
        finally {
            scanner.close();
        }
    }

    @Test
    public void testScanAfterDeletingSpecifiedRow() throws IOException {
        TableName tableName = TableName.valueOf("testScanAfterDeletingSpecifiedRow");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        byte[] row = Bytes.toBytes("SpecifiedRow");
        byte[] value0 = Bytes.toBytes("value_0");
        byte[] value1 = Bytes.toBytes("value_1");
        try (Table t = TEST_UTIL.getConnection().getTable(tableName);){
            Put put = new Put(row);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            t.put(put);
            Delete d = new Delete(row);
            t.delete(d);
            put = new Put(row);
            put.addColumn(FAMILY, null, value0);
            t.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, null, value1);
            t.put(put);
            List<Cell> cells = TestFromClientSide3.toList(t.getScanner(new Scan()));
            Assert.assertEquals((long)1L, (long)cells.size());
            Assert.assertEquals((Object)"value_1", (Object)Bytes.toString(CellUtil.cloneValue(cells.get(0))));
            cells = TestFromClientSide3.toList(t.getScanner(new Scan().addFamily(FAMILY)));
            Assert.assertEquals((long)1L, (long)cells.size());
            Assert.assertEquals((Object)"value_1", (Object)Bytes.toString(CellUtil.cloneValue(cells.get(0))));
            cells = TestFromClientSide3.toList(t.getScanner(new Scan().addColumn(FAMILY, QUALIFIER)));
            Assert.assertEquals((long)0L, (long)cells.size());
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            cells = TestFromClientSide3.toList(t.getScanner(new Scan()));
            Assert.assertEquals((long)1L, (long)cells.size());
            Assert.assertEquals((Object)"value_1", (Object)Bytes.toString(CellUtil.cloneValue(cells.get(0))));
            cells = TestFromClientSide3.toList(t.getScanner(new Scan().addFamily(FAMILY)));
            Assert.assertEquals((long)1L, (long)cells.size());
            Assert.assertEquals((Object)"value_1", (Object)Bytes.toString(CellUtil.cloneValue(cells.get(0))));
            cells = TestFromClientSide3.toList(t.getScanner(new Scan().addColumn(FAMILY, QUALIFIER)));
            Assert.assertEquals((long)0L, (long)cells.size());
        }
    }

    @Test
    public void testScanAfterDeletingSpecifiedRowV2() throws IOException {
        TableName tableName = TableName.valueOf("testScanAfterDeletingSpecifiedRowV2");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        byte[] row = Bytes.toBytes("SpecifiedRow");
        byte[] qual0 = Bytes.toBytes("qual0");
        byte[] qual1 = Bytes.toBytes("qual1");
        try (Table t = TEST_UTIL.getConnection().getTable(tableName);){
            Delete d = new Delete(row);
            t.delete(d);
            Put put = new Put(row);
            put.addColumn(FAMILY, null, VALUE);
            t.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qual1, qual1);
            t.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qual0, qual0);
            t.put(put);
            Result r = t.get(new Get(row));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((Object)"testValue", (Object)Bytes.toString(CellUtil.cloneValue(r.rawCells()[0])));
            Assert.assertEquals((Object)"qual0", (Object)Bytes.toString(CellUtil.cloneValue(r.rawCells()[1])));
            Assert.assertEquals((Object)"qual1", (Object)Bytes.toString(CellUtil.cloneValue(r.rawCells()[2])));
            TEST_UTIL.getHBaseAdmin().flush(tableName);
            r = t.get(new Get(row));
            Assert.assertEquals((long)3L, (long)r.size());
            Assert.assertEquals((Object)"testValue", (Object)Bytes.toString(CellUtil.cloneValue(r.rawCells()[0])));
            Assert.assertEquals((Object)"qual0", (Object)Bytes.toString(CellUtil.cloneValue(r.rawCells()[1])));
            Assert.assertEquals((Object)"qual1", (Object)Bytes.toString(CellUtil.cloneValue(r.rawCells()[2])));
        }
    }

    @Test(timeout=60000L)
    public void testAdvancedConfigOverride() throws Exception {
        Pair<Integer, Integer> st;
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compaction.min", 3);
        String tableName = "testAdvancedConfigOverride";
        TableName TABLE = TableName.valueOf(tableName);
        HTable hTable = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        ClusterConnection connection = (ClusterConnection)TEST_UTIL.getConnection();
        byte[] row = Bytes.toBytes(random.nextInt());
        this.performMultiplePutAndFlush(admin, hTable, row, FAMILY, 3, 100);
        HRegionLocation loc = hTable.getRegionLocation(row, true);
        byte[] regionName = loc.getRegionInfo().getRegionName();
        AdminProtos.AdminService.BlockingInterface server = connection.getAdmin(loc.getServerName());
        Assert.assertTrue((ProtobufUtil.getStoreFiles(server, regionName, FAMILY).size() > 1 ? 1 : 0) != 0);
        admin.compact(TABLE.getName());
        for (int i = 0; i < 250; ++i) {
            loc = hTable.getRegionLocation(row, true);
            if (!loc.getRegionInfo().isOffline()) {
                regionName = loc.getRegionInfo().getRegionName();
                server = connection.getAdmin(loc.getServerName());
                if (ProtobufUtil.getStoreFiles(server, regionName, FAMILY).size() <= 1) break;
            }
            Thread.sleep(40L);
        }
        Assert.assertTrue((ProtobufUtil.getStoreFiles(server, regionName, FAMILY).size() <= 1 ? 1 : 0) != 0);
        LOG.info((Object)"hbase.hstore.compaction.min should now be 5");
        HTableDescriptor htd = new HTableDescriptor(hTable.getTableDescriptor());
        htd.setValue("hbase.hstore.compaction.min", String.valueOf(5));
        admin.modifyTable(TABLE, htd);
        while (null != (st = admin.getAlterStatus(TABLE)) && st.getFirst() > 0) {
            LOG.debug((Object)(st.getFirst() + " regions left to update"));
            Thread.sleep(40L);
        }
        LOG.info((Object)"alter status finished");
        this.performMultiplePutAndFlush(admin, hTable, row, FAMILY, 3, 10);
        admin.compact(TABLE.getName());
        Thread.sleep(10000L);
        loc = hTable.getRegionLocation(row, true);
        regionName = loc.getRegionInfo().getRegionName();
        server = connection.getAdmin(loc.getServerName());
        int sfCount = ProtobufUtil.getStoreFiles(server, regionName, FAMILY).size();
        Assert.assertTrue((sfCount > 1 ? 1 : 0) != 0);
        LOG.info((Object)"hbase.hstore.compaction.min should now be 2");
        HColumnDescriptor hcd = new HColumnDescriptor(htd.getFamily(FAMILY));
        hcd.setValue("hbase.hstore.compaction.min", String.valueOf(2));
        htd.modifyFamily(hcd);
        admin.modifyTable(TABLE, htd);
        while (null != (st = admin.getAlterStatus(TABLE)) && st.getFirst() > 0) {
            LOG.debug((Object)(st.getFirst() + " regions left to update"));
            Thread.sleep(40L);
        }
        LOG.info((Object)"alter status finished");
        admin.compact(TABLE.getName());
        for (int i = 0; i < 250; ++i) {
            loc = hTable.getRegionLocation(row, true);
            regionName = loc.getRegionInfo().getRegionName();
            try {
                server = connection.getAdmin(loc.getServerName());
                if (ProtobufUtil.getStoreFiles(server, regionName, FAMILY).size() < sfCount) {
                    break;
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("Waiting for region to come online: " + Bytes.toString(regionName)));
            }
            Thread.sleep(40L);
        }
        Assert.assertTrue((ProtobufUtil.getStoreFiles(server, regionName, FAMILY).size() < sfCount ? 1 : 0) != 0);
        LOG.info((Object)"Removing CF config value");
        LOG.info((Object)"hbase.hstore.compaction.min should now be 5");
        hcd = new HColumnDescriptor(htd.getFamily(FAMILY));
        hcd.setValue("hbase.hstore.compaction.min", null);
        htd.modifyFamily(hcd);
        admin.modifyTable(TABLE, htd);
        while (null != (st = admin.getAlterStatus(TABLE)) && st.getFirst() > 0) {
            LOG.debug((Object)(st.getFirst() + " regions left to update"));
            Thread.sleep(40L);
        }
        LOG.info((Object)"alter status finished");
        Assert.assertNull((Object)hTable.getTableDescriptor().getFamily(FAMILY).getValue("hbase.hstore.compaction.min"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTableBatchWithEmptyPut() throws Exception {
        try (HTable table = TEST_UTIL.createTable(Bytes.toBytes("testHTableBatchWithEmptyPut"), (byte[][])new byte[][]{FAMILY});){
            ArrayList<Put> actions = new ArrayList<Put>();
            Object[] results = new Object[2];
            Put put1 = new Put(ROW);
            actions.add(put1);
            Put put2 = new Put(ANOTHERROW);
            put2.add(FAMILY, QUALIFIER, VALUE);
            actions.add(put2);
            table.batch(actions, results);
            Assert.fail((String)"Empty Put should have failed the batch call");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTableWithLargeBatch() throws Exception {
        int sixtyFourK = 65536;
        try (HTable table = TEST_UTIL.createTable(TableName.valueOf("testHTableWithLargeBatch"), (byte[][])new byte[][]{FAMILY});){
            ArrayList<Put> actions = new ArrayList<Put>();
            Object[] results = new Object[(sixtyFourK + 1) * 2];
            for (int i = 0; i < sixtyFourK + 1; ++i) {
                Put put1 = new Put(ROW);
                put1.addColumn(FAMILY, QUALIFIER, VALUE);
                actions.add(put1);
                Put put2 = new Put(ANOTHERROW);
                put2.addColumn(FAMILY, QUALIFIER, VALUE);
                actions.add(put2);
            }
            table.batch(actions, results);
        }
    }

    @Test
    public void testBatchWithRowMutation() throws Exception {
        LOG.info((Object)"Starting testBatchWithRowMutation");
        TableName TABLENAME = TableName.valueOf("testBatchWithRowMutation");
        try (HTable t = TEST_UTIL.createTable(TABLENAME, FAMILY);){
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes("a"), Bytes.toBytes("b")};
            RowMutations arm = new RowMutations(ROW);
            Put p = new Put(ROW);
            p.addColumn(FAMILY, QUALIFIERS[0], VALUE);
            arm.add(p);
            Object[] batchResult = new Object[1];
            t.batch(Arrays.asList(arm), batchResult);
            Get g = new Get(ROW);
            Result r = t.get(g);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo(VALUE, r.getValue(FAMILY, QUALIFIERS[0])));
            arm = new RowMutations(ROW);
            p = new Put(ROW);
            p.addColumn(FAMILY, QUALIFIERS[1], VALUE);
            arm.add(p);
            Delete d = new Delete(ROW);
            d.addColumns(FAMILY, QUALIFIERS[0]);
            arm.add(d);
            t.batch(Arrays.asList(arm), batchResult);
            r = t.get(g);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo(VALUE, r.getValue(FAMILY, QUALIFIERS[1])));
            Assert.assertNull((Object)r.getValue(FAMILY, QUALIFIERS[0]));
            try {
                arm = new RowMutations(ROW);
                p = new Put(ROW);
                p.addColumn(new byte[]{98, 111, 103, 117, 115}, QUALIFIERS[0], VALUE);
                arm.add(p);
                t.batch(Arrays.asList(arm), batchResult);
                Assert.fail((String)"Expected RetriesExhaustedWithDetailsException with NoSuchColumnFamilyException");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                String msg = e.getMessage();
                Assert.assertTrue((boolean)msg.contains("NoSuchColumnFamilyException"));
            }
        }
    }

    @Test
    public void testHTableExistsMethodSingleRegionSingleGet() throws Exception {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes("testHTableExistsMethodSingleRegionSingleGet"), (byte[][])new byte[][]{FAMILY});
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        Get get = new Get(ROW);
        boolean exist = table.exists(get);
        Assert.assertEquals((Object)exist, (Object)false);
        table.put(put);
        exist = table.exists(get);
        Assert.assertEquals((Object)exist, (Object)true);
    }

    @Test
    public void testHTableExistsMethodSingleRegionMultipleGets() throws Exception {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes("testHTableExistsMethodSingleRegionMultipleGets"), (byte[][])new byte[][]{FAMILY});
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        ArrayList<Get> gets = new ArrayList<Get>();
        gets.add(new Get(ROW));
        gets.add(new Get(ANOTHERROW));
        Boolean[] results = table.exists(gets);
        Assert.assertTrue((boolean)results[0]);
        junit.framework.Assert.assertFalse((boolean)results[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTableExistsBeforeGet() throws Exception {
        try (HTable table = TEST_UTIL.createTable(Bytes.toBytes("testHTableExistsBeforeGet"), (byte[][])new byte[][]{FAMILY});){
            Put put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            Get get = new Get(ROW);
            boolean exist = table.exists(get);
            Assert.assertEquals((Object)true, (Object)exist);
            Result result = table.get(get);
            Assert.assertEquals((Object)false, (Object)result.isEmpty());
            Assert.assertTrue((boolean)Bytes.equals(VALUE, result.getValue(FAMILY, QUALIFIER)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHTableExistsAllBeforeGet() throws Exception {
        byte[] ROW2 = Bytes.add(ROW, Bytes.toBytes("2"));
        try (HTable table = TEST_UTIL.createTable(Bytes.toBytes("testHTableExistsAllBeforeGet"), (byte[][])new byte[][]{FAMILY});){
            Put put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            put = new Put(ROW2);
            put.add(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            Get get = new Get(ROW);
            Get get2 = new Get(ROW2);
            ArrayList<Get> getList = new ArrayList<Get>(2);
            getList.add(get);
            getList.add(get2);
            boolean[] exists = table.existsAll(getList);
            Assert.assertEquals((Object)true, (Object)exists[0]);
            Assert.assertEquals((Object)true, (Object)exists[1]);
            Result[] result = table.get(getList);
            Assert.assertEquals((Object)false, (Object)result[0].isEmpty());
            Assert.assertTrue((boolean)Bytes.equals(VALUE, result[0].getValue(FAMILY, QUALIFIER)));
            Assert.assertEquals((Object)false, (Object)result[1].isEmpty());
            Assert.assertTrue((boolean)Bytes.equals(VALUE, result[1].getValue(FAMILY, QUALIFIER)));
        }
    }

    @Test
    public void testHTableExistsMethodMultipleRegionsSingleGet() throws Exception {
        HTable table = TEST_UTIL.createTable(TableName.valueOf("testHTableExistsMethodMultipleRegionsSingleGet"), (byte[][])new byte[][]{FAMILY}, 1, new byte[]{0}, new byte[]{-1}, 255);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        Get get = new Get(ROW);
        boolean exist = table.exists(get);
        Assert.assertEquals((Object)exist, (Object)false);
        table.put(put);
        exist = table.exists(get);
        Assert.assertEquals((Object)exist, (Object)true);
    }

    @Test
    public void testHTableExistsMethodMultipleRegionsMultipleGets() throws Exception {
        HTable table = TEST_UTIL.createTable(TableName.valueOf("testHTableExistsMethodMultipleRegionsMultipleGets"), (byte[][])new byte[][]{FAMILY}, 1, new byte[]{0}, new byte[]{-1}, 255);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        ArrayList<Get> gets = new ArrayList<Get>();
        gets.add(new Get(ANOTHERROW));
        gets.add(new Get(Bytes.add(ROW, new byte[]{0})));
        gets.add(new Get(ROW));
        gets.add(new Get(Bytes.add(ANOTHERROW, new byte[]{0})));
        LOG.info((Object)"Calling exists");
        Boolean[] results = table.exists(gets);
        Assert.assertEquals((Object)results[0], (Object)false);
        Assert.assertEquals((Object)results[1], (Object)false);
        Assert.assertEquals((Object)results[2], (Object)true);
        Assert.assertEquals((Object)results[3], (Object)false);
        put = new Put(new byte[]{0});
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        gets = new ArrayList();
        gets.add(new Get(new byte[]{0}));
        gets.add(new Get(new byte[]{0, 0}));
        results = table.exists(gets);
        Assert.assertEquals((Object)results[0], (Object)true);
        Assert.assertEquals((Object)results[1], (Object)false);
        put = new Put(new byte[]{-1, -1});
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        gets = new ArrayList();
        gets.add(new Get(new byte[]{-1}));
        gets.add(new Get(new byte[]{-1, -1}));
        gets.add(new Get(new byte[]{-1, -1, -1}));
        results = table.exists(gets);
        Assert.assertEquals((Object)results[0], (Object)false);
        Assert.assertEquals((Object)results[1], (Object)true);
        Assert.assertEquals((Object)results[2], (Object)false);
    }

    @Test
    public void testGetEmptyRow() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(Bytes.toBytes("test")));
        desc.addFamily(new HColumnDescriptor(FAMILY));
        admin.createTable(desc);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), desc.getTableName());
        Put put = new Put(ROW_BYTES);
        put.add(FAMILY, COL_QUAL, VAL_BYTES);
        table.put(put);
        Result res = null;
        try {
            res = table.get(new Get(new byte[0]));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertTrue((res == null ? 1 : 0) != 0);
        res = table.get(new Get(Bytes.toBytes("r1-not-exist")));
        Assert.assertTrue((res.isEmpty() ? 1 : 0) != 0);
        res = table.get(new Get(ROW_BYTES));
        Assert.assertTrue((boolean)Arrays.equals(res.getValue(FAMILY, COL_QUAL), VAL_BYTES));
        table.close();
    }

    @Test(timeout=30000L)
    public void testMultiRowMutations() throws Exception, Throwable {
        final TableName tableName = TableName.valueOf("testMultiRowMutations");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addCoprocessor(MultiRowMutationEndpoint.class.getName());
        desc.addCoprocessor(WatiingForMultiMutationsObserver.class.getName());
        desc.setConfiguration("hbase.rowlock.wait.duration", String.valueOf(5000));
        desc.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        Configuration copy = new Configuration(TEST_UTIL.getConfiguration());
        copy.setInt("hbase.client.retries.number", 2);
        try (final Connection con = ConnectionFactory.createConnection(copy);){
            final byte[] row = Bytes.toBytes("ROW-0");
            final byte[] rowLocked = Bytes.toBytes("ROW-1");
            final byte[] value0 = Bytes.toBytes("VALUE-0");
            final byte[] value1 = Bytes.toBytes("VALUE-1");
            final byte[] value2 = Bytes.toBytes("VALUE-2");
            TestFromClientSide3.assertNoLocks(tableName);
            ExecutorService putService = Executors.newSingleThreadExecutor();
            putService.execute(new Runnable(){

                @Override
                public void run() {
                    try (Table table = con.getTable(tableName);){
                        Put put0 = new Put(rowLocked);
                        put0.addColumn(FAMILY, QUALIFIER, value0);
                        table.put(put0);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            ExecutorService cpService = Executors.newSingleThreadExecutor();
            cpService.execute(new Runnable(){

                @Override
                public void run() {
                    boolean threw;
                    Put put1 = new Put(row);
                    Put put2 = new Put(rowLocked);
                    put1.addColumn(FAMILY, QUALIFIER, value1);
                    put2.addColumn(FAMILY, QUALIFIER, value2);
                    try (Table table = con.getTable(tableName);){
                        final MultiRowMutationProtos.MutateRowsRequest request = MultiRowMutationProtos.MutateRowsRequest.newBuilder().addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, put1)).addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, put2)).build();
                        table.coprocessorService(MultiRowMutationProtos.MultiRowMutationService.class, ROW, ROW, new Batch.Call<MultiRowMutationProtos.MultiRowMutationService, MultiRowMutationProtos.MutateRowsResponse>(){

                            @Override
                            public MultiRowMutationProtos.MutateRowsResponse call(MultiRowMutationProtos.MultiRowMutationService instance) throws IOException {
                                ServerRpcController controller = new ServerRpcController();
                                BlockingRpcCallback<MultiRowMutationProtos.MutateRowsResponse> rpcCallback = new BlockingRpcCallback<MultiRowMutationProtos.MutateRowsResponse>();
                                instance.mutateRows(controller, request, rpcCallback);
                                return rpcCallback.get();
                            }
                        });
                        threw = false;
                    }
                    catch (Throwable ex) {
                        threw = true;
                    }
                    if (!threw) {
                        Assert.fail((String)"This cp should fail because the target lock is blocked by previous put");
                    }
                }
            });
            cpService.shutdown();
            cpService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            WatiingForMultiMutationsObserver observer = TestFromClientSide3.find(tableName, WatiingForMultiMutationsObserver.class);
            observer.latch.countDown();
            putService.shutdown();
            putService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            try (Table table = con.getTable(tableName);){
                Get g0 = new Get(row);
                Get g1 = new Get(rowLocked);
                Result r0 = table.get(g0);
                Result r1 = table.get(g1);
                Assert.assertTrue((boolean)r0.isEmpty());
                junit.framework.Assert.assertFalse((boolean)r1.isEmpty());
                Assert.assertTrue((boolean)Bytes.equals(r1.getValue(FAMILY, QUALIFIER), value0));
            }
            TestFromClientSide3.assertNoLocks(tableName);
        }
    }

    private static void assertNoLocks(TableName tableName) throws IOException, InterruptedException {
        HRegion region = (HRegion)TestFromClientSide3.find(tableName);
        Assert.assertEquals((long)0L, (long)region.getLockedRows().size());
    }

    private static Region find(TableName tableName) throws IOException, InterruptedException {
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(tableName);
        List<Region> regions = rs.getOnlineRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        return regions.get(0);
    }

    private static <T extends RegionObserver> T find(TableName tableName, Class<T> clz) throws IOException, InterruptedException {
        Region region = TestFromClientSide3.find(tableName);
        Coprocessor cp = region.getCoprocessorHost().findCoprocessor(clz.getName());
        Assert.assertTrue((String)("The cp instance should be " + clz.getName() + ", current instance is " + cp.getClass().getName()), (boolean)clz.isInstance(cp));
        return (T)((RegionObserver)clz.cast(cp));
    }

    private static byte[] generateHugeValue(int size) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        byte[] value = new byte[size];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)((Random)rand).nextInt(256);
        }
        return value;
    }

    @Test
    public void testScanWithBatchSizeReturnIncompleteCells() throws IOException {
        Result result;
        ArrayList<Result> list;
        TableName tableName = TableName.valueOf("testScanWithBatchSizeReturnIncompleteCells");
        HTableDescriptor hd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY).setMaxVersions(3);
        hd.addFamily(hcd);
        HTable table = TEST_UTIL.createTable(hd, (byte[][])null);
        Put put = new Put(ROW);
        put.addColumn(FAMILY, Bytes.toBytes(0), TestFromClientSide3.generateHugeValue(0x300000));
        table.put(put);
        put = new Put(ROW);
        put.addColumn(FAMILY, Bytes.toBytes(1), TestFromClientSide3.generateHugeValue(0x400000));
        table.put(put);
        for (int i = 2; i < 5; ++i) {
            for (int version = 0; version < 2; ++version) {
                put = new Put(ROW);
                put.addColumn(FAMILY, Bytes.toBytes(i), TestFromClientSide3.generateHugeValue(1024));
                table.put(put);
            }
        }
        Scan scan = new Scan();
        scan.withStartRow(ROW).withStopRow(ROW, true).addFamily(FAMILY).setBatch(3).setMaxResultSize(0x400000L);
        try (ResultScanner scanner = table.getScanner(scan);){
            list = new ArrayList<Result>();
            while ((result = scanner.next()) != null) {
                list.add(result);
            }
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((long)3L, (long)((Result)list.get(0)).size());
            Assert.assertEquals((long)2L, (long)((Result)list.get(1)).size());
        }
        scan = new Scan();
        scan.withStartRow(ROW).withStopRow(ROW, true).addFamily(FAMILY).setBatch(2).setMaxResultSize(0x400000L);
        scanner = table.getScanner(scan);
        var9_12 = null;
        try {
            list = new ArrayList();
            while ((result = scanner.next()) != null) {
                list.add(result);
            }
            Assert.assertEquals((long)3L, (long)list.size());
            Assert.assertEquals((long)2L, (long)((Result)list.get(0)).size());
            Assert.assertEquals((long)2L, (long)((Result)list.get(1)).size());
            Assert.assertEquals((long)1L, (long)((Result)list.get(2)).size());
        }
        catch (Throwable throwable) {
            var9_12 = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (var9_12 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        var9_12.addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
    }

    public static class WatiingForMultiMutationsObserver
    extends BaseRegionObserver {
        final CountDownLatch latch = new CountDownLatch(1);

        @Override
        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            try {
                this.latch.await();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
    }
}

