/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.EmptyWatcher;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;

@InterfaceAudience.Private
public class ZKUtil {
    private static final Log LOG = LogFactory.getLog(ZKUtil.class);
    public static final char ZNODE_PATH_SEPARATOR = '/';
    private static int zkDumpConnectionTimeOut;

    public static RecoverableZooKeeper connect(Configuration conf, Watcher watcher) throws IOException {
        String ensemble = ZKConfig.getZKQuorumServersString(conf);
        return ZKUtil.connect(conf, ensemble, watcher);
    }

    public static RecoverableZooKeeper connect(Configuration conf, String ensemble, Watcher watcher) throws IOException {
        return ZKUtil.connect(conf, ensemble, watcher, null);
    }

    public static RecoverableZooKeeper connect(Configuration conf, String ensemble, Watcher watcher, String identifier) throws IOException {
        if (ensemble == null) {
            throw new IOException("Unable to determine ZooKeeper ensemble");
        }
        int timeout = conf.getInt("zookeeper.session.timeout", 180000);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(identifier + " opening connection to ZooKeeper ensemble=" + ensemble));
        }
        int retry = conf.getInt("zookeeper.recovery.retry", 3);
        int retryIntervalMillis = conf.getInt("zookeeper.recovery.retry.intervalmill", 1000);
        int maxSleepTime = conf.getInt("zookeeper.recovery.retry.maxsleeptime", 60000);
        zkDumpConnectionTimeOut = conf.getInt("zookeeper.dump.connection.timeout", 1000);
        return new RecoverableZooKeeper(ensemble, timeout, watcher, retry, retryIntervalMillis, maxSleepTime, identifier);
    }

    public static void loginServer(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKUtil.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.serverconfig", "zookeeper-server-keytab-kerberos");
    }

    public static void loginClient(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKUtil.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.clientconfig", "zookeeper-client-keytab-kerberos");
    }

    private static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname, String loginContextProperty, String loginContextName) throws IOException {
        if (!ZKUtil.isSecureZooKeeper(conf)) {
            return;
        }
        if (System.getProperty("java.security.auth.login.config") != null) {
            return;
        }
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null) {
            LOG.warn((Object)("no keytab specified for: " + keytabFileKey));
            return;
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal((String)principalConfig, (String)hostname);
        JaasConfiguration jaasConf = new JaasConfiguration(loginContextName, principalName, keytabFilename);
        javax.security.auth.login.Configuration.setConfiguration(jaasConf);
        System.setProperty(loginContextProperty, loginContextName);
    }

    public static String joinZNode(String prefix, String suffix) {
        return prefix + '/' + suffix;
    }

    public static String getParent(String node) {
        int idx = node.lastIndexOf(47);
        return idx <= 0 ? null : node.substring(0, idx);
    }

    public static String getNodeName(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static boolean watchAndCheckExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            boolean exists;
            Stat s = zkw.getRecoverableZooKeeper().exists(znode, zkw);
            boolean bl = exists = s != null;
            if (exists) {
                LOG.debug((Object)zkw.prefix("Set watcher on existing znode=" + znode));
            } else {
                LOG.debug((Object)zkw.prefix("Set watcher on znode that does not yet exist, " + znode));
            }
            return exists;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static boolean setWatchIfNodeExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().getData(znode, true, null);
            return true;
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int checkExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            Stat s = zkw.getRecoverableZooKeeper().exists(znode, null);
            return s != null ? s.getVersion() : -1;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.keeperException(e);
            return -1;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static List<String> listChildrenAndWatchForNewChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            List<String> children = zkw.getRecoverableZooKeeper().getChildren(znode, zkw);
            return children;
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug((Object)zkw.prefix("Unable to list children of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static List<String> listChildrenAndWatchThem(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        List<String> children = ZKUtil.listChildrenAndWatchForNewChildren(zkw, znode);
        if (children == null) {
            return null;
        }
        for (String child : children) {
            ZKUtil.watchAndCheckExists(zkw, ZKUtil.joinZNode(znode, child));
        }
        return children;
    }

    public static List<String> listChildrenNoWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        List<String> children = null;
        try {
            children = zkw.getRecoverableZooKeeper().getChildren(znode, null);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
        return children;
    }

    public static boolean nodeHasChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            return !zkw.getRecoverableZooKeeper().getChildren(znode, null).isEmpty();
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug((Object)zkw.prefix("Unable to list children of znode " + znode + " because node does not exist (not an error)"));
            return false;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int getNumberOfChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            Stat stat = zkw.getRecoverableZooKeeper().exists(znode, null);
            return stat == null ? 0 : stat.getNumChildren();
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get children of node " + znode));
            zkw.keeperException(e);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
        }
        return 0;
    }

    public static byte[] getData(ZooKeeperWatcher zkw, String znode) throws KeeperException, InterruptedException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, null, null);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
    }

    public static byte[] getDataAndWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, null, true);
    }

    public static byte[] getDataAndWatch(ZooKeeperWatcher zkw, String znode, Stat stat) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, stat, true);
    }

    private static byte[] getDataInternal(ZooKeeperWatcher zkw, String znode, Stat stat, boolean watcherSet) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, zkw, stat);
            ZKUtil.logRetrievedMsg(zkw, znode, data, watcherSet);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.trace((Object)zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static byte[] getDataNoWatch(ZooKeeperWatcher zkw, String znode, Stat stat) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, null, stat);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " because node does not exist (not necessarily an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static List<NodeAndData> getChildDataAndWatchForNewChildren(ZooKeeperWatcher zkw, String baseNode) throws KeeperException {
        List<String> nodes = ZKUtil.listChildrenAndWatchForNewChildren(zkw, baseNode);
        if (nodes != null) {
            ArrayList<NodeAndData> newNodes = new ArrayList<NodeAndData>();
            for (String node : nodes) {
                String nodePath = ZKUtil.joinZNode(baseNode, node);
                byte[] data = ZKUtil.getDataAndWatch(zkw, nodePath);
                newNodes.add(new NodeAndData(nodePath, data));
            }
            return newNodes;
        }
        return null;
    }

    public static void updateExistingNodeData(ZooKeeperWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().setData(znode, data, expectedVersion);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static boolean setData(ZooKeeperWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException, KeeperException.NoNodeException {
        try {
            return zkw.getRecoverableZooKeeper().setData(znode, data, expectedVersion) != null;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
    }

    public static void createSetData(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        if (ZKUtil.checkExists(zkw, znode) == -1) {
            ZKUtil.createWithParents(zkw, znode, data);
        } else {
            ZKUtil.setData(zkw, znode, data);
        }
    }

    public static void setData(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NoNodeException {
        ZKUtil.setData(zkw, (ZKUtilOp.SetData)ZKUtilOp.setData(znode, data));
    }

    private static void setData(ZooKeeperWatcher zkw, ZKUtilOp.SetData setData) throws KeeperException, KeeperException.NoNodeException {
        SetDataRequest sd = (SetDataRequest)ZKUtil.toZooKeeperOp(zkw, setData).toRequestRecord();
        ZKUtil.setData(zkw, sd.getPath(), sd.getData(), sd.getVersion());
    }

    public static boolean isSecureZooKeeper(Configuration conf) {
        try {
            javax.security.auth.login.Configuration testConfig = javax.security.auth.login.Configuration.getConfiguration();
            if (testConfig.getAppConfigurationEntry("Client") == null && testConfig.getAppConfigurationEntry("zookeeper-client-keytab-kerberos") == null && testConfig.getAppConfigurationEntry("zookeeper-server-keytab-kerberos") == null && conf.get("hbase.zookeeper.client.kerberos.principal") == null && conf.get("hbase.zookeeper.server.kerberos.principal") == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        String securityConfValue = conf.get("hbase.security.authentication");
        return "kerberos".equalsIgnoreCase(securityConfValue) || "maprsasl".equalsIgnoreCase(securityConfValue);
    }

    private static ArrayList<ACL> createACL(ZooKeeperWatcher zkw, String node) {
        return ZKUtil.createACL(zkw, node, ZKUtil.isSecureZooKeeper(zkw.getConfiguration()));
    }

    public static ArrayList<ACL> createACL(ZooKeeperWatcher zkw, String node, boolean isSecureZooKeeper) {
        if (!node.startsWith(zkw.baseZNode)) {
            return ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        if (isSecureZooKeeper) {
            ArrayList<ACL> acls = new ArrayList<ACL>();
            String[] superUsers = zkw.getConfiguration().getStrings("hbase.superuser");
            String hbaseUser = null;
            try {
                hbaseUser = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                LOG.debug((Object)"Could not acquire current User.", (Throwable)e);
            }
            if (superUsers != null) {
                ArrayList<String> groups = new ArrayList<String>();
                for (String user : superUsers) {
                    if (AuthUtil.isGroupPrincipal(user)) {
                        groups.add(user);
                        continue;
                    }
                    if (user.equals(hbaseUser)) continue;
                    acls.add(new ACL(31, new Id("sasl", user)));
                }
                if (!groups.isEmpty()) {
                    LOG.warn((Object)("Znode ACL setting for group " + groups + " is skipped, Zookeeper doesn't support this feature presently."));
                }
            }
            if (zkw.isClientReadable(node)) {
                acls.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
                acls.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
            } else {
                acls.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
            }
            return acls;
        }
        return ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    public static boolean createEphemeralNodeAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        boolean ret = true;
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException nee) {
            ret = false;
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!ZKUtil.watchAndCheckExists(zkw, znode)) {
            return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, data);
        }
        return ret;
    }

    public static boolean createNodeIfNotExistsAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        boolean ret = true;
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            ret = false;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        try {
            zkw.getRecoverableZooKeeper().exists(znode, zkw);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        return ret;
    }

    public static String createNodeIfNotExistsNoWatch(ZooKeeperWatcher zkw, String znode, byte[] data, CreateMode createMode) throws KeeperException {
        String createdZNode = null;
        try {
            createdZNode = zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), createMode);
        }
        catch (KeeperException.NodeExistsException nee) {
            return znode;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return null;
        }
        return createdZNode;
    }

    public static int createAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NodeExistsException {
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT);
            Stat stat = zkw.getRecoverableZooKeeper().exists(znode, zkw);
            if (stat == null) {
                throw KeeperException.create((KeeperException.Code)KeeperException.Code.SYSTEMERROR, (String)("ZK.exists returned null (i.e.: znode does not exist) for znode=" + znode));
            }
            return stat.getVersion();
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static void asyncCreate(ZooKeeperWatcher zkw, String znode, byte[] data, AsyncCallback.StringCallback cb, Object ctx) {
        zkw.getRecoverableZooKeeper().getZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT, cb, ctx);
    }

    public static void createAndFailSilent(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        ZKUtil.createAndFailSilent(zkw, znode, new byte[0]);
    }

    public static void createAndFailSilent(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        ZKUtil.createAndFailSilent(zkw, (ZKUtilOp.CreateAndFailSilent)ZKUtilOp.createAndFailSilent(znode, data));
    }

    private static void createAndFailSilent(ZooKeeperWatcher zkw, ZKUtilOp.CreateAndFailSilent cafs) throws KeeperException {
        CreateRequest create = (CreateRequest)ZKUtil.toZooKeeperOp(zkw, cafs).toRequestRecord();
        String znode = create.getPath();
        try {
            RecoverableZooKeeper zk = zkw.getRecoverableZooKeeper();
            if (zk.exists(znode, false) == null) {
                zk.create(znode, create.getData(), create.getAcl(), CreateMode.fromFlag((int)create.getFlags()));
            }
        }
        catch (KeeperException.NodeExistsException zk) {
        }
        catch (KeeperException.NoAuthException nee) {
            try {
                if (null == zkw.getRecoverableZooKeeper().exists(znode, false)) {
                    throw nee;
                }
            }
            catch (InterruptedException ie) {
                zkw.interruptedException(ie);
            }
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void createWithParents(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        ZKUtil.createWithParents(zkw, znode, new byte[0]);
    }

    public static void createWithParents(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        try {
            if (znode == null) {
                return;
            }
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            return;
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createWithParents(zkw, ZKUtil.getParent(znode));
            ZKUtil.createWithParents(zkw, znode, data);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNode(ZooKeeperWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNode(zkw, node, -1);
    }

    public static boolean deleteNode(ZooKeeperWatcher zkw, String node, int version) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().delete(node, version);
            return true;
        }
        catch (KeeperException.BadVersionException bve) {
            return false;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
            return false;
        }
    }

    public static void deleteNodeFailSilent(ZooKeeperWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNodeFailSilent(zkw, (ZKUtilOp.DeleteNodeFailSilent)ZKUtilOp.deleteNodeFailSilent(node));
    }

    private static void deleteNodeFailSilent(ZooKeeperWatcher zkw, ZKUtilOp.DeleteNodeFailSilent dnfs) throws KeeperException {
        DeleteRequest delete = (DeleteRequest)ZKUtil.toZooKeeperOp(zkw, dnfs).toRequestRecord();
        try {
            zkw.getRecoverableZooKeeper().delete(delete.getPath(), delete.getVersion());
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNodeRecursively(ZooKeeperWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNodeRecursivelyMultiOrSequential(zkw, true, node);
    }

    public static void deleteChildrenRecursively(ZooKeeperWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteChildrenRecursivelyMultiOrSequential(zkw, true, node);
    }

    public static void deleteChildrenRecursivelyMultiOrSequential(ZooKeeperWatcher zkw, boolean runSequentialOnMultiFailure, String ... pathRoots) throws KeeperException {
        if (pathRoots == null || pathRoots.length <= 0) {
            LOG.warn((Object)"Given path is not valid!");
            return;
        }
        ArrayList<ZKUtilOp> ops = new ArrayList<ZKUtilOp>();
        for (String eachRoot : pathRoots) {
            List<String> children = ZKUtil.listChildrenBFSNoWatch(zkw, eachRoot);
            for (int i = children.size() - 1; i >= 0; --i) {
                ops.add(ZKUtilOp.deleteNodeFailSilent(children.get(i)));
            }
        }
        if (ops.size() > 0) {
            ZKUtil.multiOrSequential(zkw, ops, runSequentialOnMultiFailure);
        }
    }

    public static void deleteNodeRecursivelyMultiOrSequential(ZooKeeperWatcher zkw, boolean runSequentialOnMultiFailure, String ... pathRoots) throws KeeperException {
        if (pathRoots == null || pathRoots.length <= 0) {
            LOG.warn((Object)"Given path is not valid!");
            return;
        }
        ArrayList<ZKUtilOp> ops = new ArrayList<ZKUtilOp>();
        for (String eachRoot : pathRoots) {
            List<String> children = ZKUtil.listChildrenBFSAndWatchThem(zkw, eachRoot);
            for (int i = children.size() - 1; i >= 0; --i) {
                ops.add(ZKUtilOp.deleteNodeFailSilent(children.get(i)));
            }
            try {
                if (zkw.getRecoverableZooKeeper().exists(eachRoot, zkw) == null) continue;
                ops.add(ZKUtilOp.deleteNodeFailSilent(eachRoot));
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
            }
        }
        if (ops.size() > 0) {
            ZKUtil.multiOrSequential(zkw, ops, runSequentialOnMultiFailure);
        }
    }

    private static List<String> listChildrenBFSNoWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(znode);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = ZKUtil.listChildrenNoWatch(zkw, node);
            if (children == null) continue;
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    private static List<String> listChildrenBFSAndWatchThem(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        String node;
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<String> tree = new ArrayList<String>();
        queue.add(znode);
        while ((node = (String)queue.pollFirst()) != null) {
            List<String> children = ZKUtil.listChildrenAndWatchThem(zkw, node);
            if (children == null) continue;
            for (String child : children) {
                String childPath = node + "/" + child;
                queue.add(childPath);
                tree.add(childPath);
            }
        }
        return tree;
    }

    private static Op toZooKeeperOp(ZooKeeperWatcher zkw, ZKUtilOp op) throws UnsupportedOperationException {
        if (op == null) {
            return null;
        }
        if (op instanceof ZKUtilOp.CreateAndFailSilent) {
            ZKUtilOp.CreateAndFailSilent cafs = (ZKUtilOp.CreateAndFailSilent)op;
            return Op.create((String)cafs.getPath(), (byte[])cafs.getData(), ZKUtil.createACL(zkw, cafs.getPath()), (CreateMode)CreateMode.PERSISTENT);
        }
        if (op instanceof ZKUtilOp.DeleteNodeFailSilent) {
            ZKUtilOp.DeleteNodeFailSilent dnfs = (ZKUtilOp.DeleteNodeFailSilent)op;
            return Op.delete((String)dnfs.getPath(), (int)-1);
        }
        if (op instanceof ZKUtilOp.SetData) {
            ZKUtilOp.SetData sd = (ZKUtilOp.SetData)op;
            return Op.setData((String)sd.getPath(), (byte[])sd.getData(), (int)-1);
        }
        throw new UnsupportedOperationException("Unexpected ZKUtilOp type: " + op.getClass().getName());
    }

    public static void multiOrSequential(ZooKeeperWatcher zkw, List<ZKUtilOp> ops, boolean runSequentialOnMultiFailure) throws KeeperException {
        if (ops == null) {
            return;
        }
        boolean useMulti = zkw.getConfiguration().getBoolean("hbase.zookeeper.useMulti", false);
        if (useMulti) {
            LinkedList<Op> zkOps = new LinkedList<Op>();
            for (ZKUtilOp op : ops) {
                zkOps.add(ZKUtil.toZooKeeperOp(zkw, op));
            }
            try {
                zkw.getRecoverableZooKeeper().multi(zkOps);
            }
            catch (KeeperException ke) {
                switch (ke.code()) {
                    case NODEEXISTS: 
                    case NONODE: 
                    case BADVERSION: 
                    case NOAUTH: {
                        if (runSequentialOnMultiFailure) {
                            LOG.info((Object)("On call to ZK.multi, received exception: " + ke.toString() + ".  Attempting to run operations sequentially because runSequentialOnMultiFailure is: " + runSequentialOnMultiFailure + "."));
                            ZKUtil.processSequentially(zkw, ops);
                            break;
                        }
                    }
                    default: {
                        throw ke;
                    }
                }
            }
            catch (InterruptedException ie) {
                zkw.interruptedException(ie);
            }
        } else {
            ZKUtil.processSequentially(zkw, ops);
        }
    }

    private static void processSequentially(ZooKeeperWatcher zkw, List<ZKUtilOp> ops) throws KeeperException, KeeperException.NoNodeException {
        for (ZKUtilOp op : ops) {
            if (op instanceof ZKUtilOp.CreateAndFailSilent) {
                ZKUtil.createAndFailSilent(zkw, (ZKUtilOp.CreateAndFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtilOp.DeleteNodeFailSilent) {
                ZKUtil.deleteNodeFailSilent(zkw, (ZKUtilOp.DeleteNodeFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtilOp.SetData) {
                ZKUtil.setData(zkw, (ZKUtilOp.SetData)op);
                continue;
            }
            throw new UnsupportedOperationException("Unexpected ZKUtilOp type: " + op.getClass().getName());
        }
    }

    public static String dump(ZooKeeperWatcher zkw) {
        StringBuilder sb = new StringBuilder();
        try {
            String[] servers;
            sb.append("HBase is rooted at ").append(zkw.baseZNode);
            sb.append("\nActive master address: ");
            try {
                sb.append(MasterAddressTracker.getMasterAddress(zkw));
            }
            catch (IOException e) {
                sb.append("<<FAILED LOOKUP: " + e.getMessage() + ">>");
            }
            sb.append("\nBackup master addresses:");
            for (String child : ZKUtil.listChildrenNoWatch(zkw, zkw.backupMasterAddressesZNode)) {
                sb.append("\n ").append(child);
            }
            sb.append("\nRegion server holding hbase:meta: " + new MetaTableLocator().getMetaRegionLocation(zkw));
            Configuration conf = HBaseConfiguration.create();
            int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
            for (int i = 1; i < numMetaReplicas; ++i) {
                sb.append("\nRegion server holding hbase:meta, replicaId " + i + " " + new MetaTableLocator().getMetaRegionLocation(zkw, i));
            }
            sb.append("\nRegion servers:");
            for (String child : ZKUtil.listChildrenNoWatch(zkw, zkw.rsZNode)) {
                sb.append("\n ").append(child);
            }
            try {
                ZKUtil.getReplicationZnodesDump(zkw, sb);
            }
            catch (KeeperException ke) {
                LOG.warn((Object)"Couldn't get the replication znode dump", (Throwable)ke);
            }
            sb.append("\nQuorum Server Statistics:");
            for (String server : servers = zkw.getQuorum().split(",")) {
                sb.append("\n ").append(server);
                try {
                    String[] stat = ZKUtil.getServerStats(server, zkDumpConnectionTimeOut);
                    if (stat == null) {
                        sb.append("[Error] invalid quorum server: " + server);
                        break;
                    }
                    for (String s : stat) {
                        sb.append("\n  ").append(s);
                    }
                }
                catch (Exception e) {
                    sb.append("\n  ERROR: ").append(e.getMessage());
                }
            }
        }
        catch (KeeperException ke) {
            sb.append("\nFATAL ZooKeeper Exception!\n");
            sb.append("\n" + ke.getMessage());
        }
        return sb.toString();
    }

    private static void getReplicationZnodesDump(ZooKeeperWatcher zkw, StringBuilder sb) throws KeeperException {
        String replicationZNodeName = zkw.getConfiguration().get("zookeeper.znode.replication", "replication");
        String replicationZnode = ZKUtil.joinZNode(zkw.baseZNode, replicationZNodeName);
        if (ZKUtil.checkExists(zkw, replicationZnode) == -1) {
            return;
        }
        sb.append("\n").append(replicationZnode).append(": ");
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, replicationZnode);
        for (String child : children) {
            String znode = ZKUtil.joinZNode(replicationZnode, child);
            if (child.equals(zkw.getConfiguration().get("zookeeper.znode.replication.peers", "peers"))) {
                ZKUtil.appendPeersZnodes(zkw, znode, sb);
                continue;
            }
            if (child.equals(zkw.getConfiguration().get("zookeeper.znode.replication.rs", "rs"))) {
                ZKUtil.appendRSZnodes(zkw, znode, sb);
                continue;
            }
            if (!child.equals(zkw.getConfiguration().get("zookeeper.znode.replication.hfile.refs", "hfile-refs"))) continue;
            ZKUtil.appendHFileRefsZnodes(zkw, znode, sb);
        }
    }

    private static void appendHFileRefsZnodes(ZooKeeperWatcher zkw, String hfileRefsZnode, StringBuilder sb) throws KeeperException {
        sb.append("\n").append(hfileRefsZnode).append(": ");
        for (String peerIdZnode : ZKUtil.listChildrenNoWatch(zkw, hfileRefsZnode)) {
            String znodeToProcess = ZKUtil.joinZNode(hfileRefsZnode, peerIdZnode);
            sb.append("\n").append(znodeToProcess).append(": ");
            List<String> peerHFileRefsZnodes = ZKUtil.listChildrenNoWatch(zkw, znodeToProcess);
            int size = peerHFileRefsZnodes.size();
            for (int i = 0; i < size; ++i) {
                sb.append(peerHFileRefsZnodes.get(i));
                if (i == size - 1) continue;
                sb.append(", ");
            }
        }
    }

    public static String getReplicationZnodesDump(ZooKeeperWatcher zkw) throws KeeperException {
        StringBuilder sb = new StringBuilder();
        ZKUtil.getReplicationZnodesDump(zkw, sb);
        return sb.toString();
    }

    private static void appendRSZnodes(ZooKeeperWatcher zkw, String znode, StringBuilder sb) throws KeeperException {
        LinkedList<String> stack = new LinkedList<String>();
        stack.add(znode);
        do {
            byte[] data;
            String znodeToProcess = (String)stack.remove(stack.size() - 1);
            sb.append("\n").append(znodeToProcess).append(": ");
            try {
                data = ZKUtil.getData(zkw, znodeToProcess);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
            if (data != null && data.length > 0) {
                long position = 0L;
                try {
                    position = ZKUtil.parseWALPositionFrom(ZKUtil.getData(zkw, znodeToProcess));
                    sb.append(position);
                }
                catch (DeserializationException deserializationException) {
                }
                catch (InterruptedException e) {
                    zkw.interruptedException(e);
                    return;
                }
            }
            for (String zNodeChild : ZKUtil.listChildrenNoWatch(zkw, znodeToProcess)) {
                stack.add(ZKUtil.joinZNode(znodeToProcess, zNodeChild));
            }
        } while (stack.size() > 0);
    }

    private static void appendPeersZnodes(ZooKeeperWatcher zkw, String peersZnode, StringBuilder sb) throws KeeperException {
        int pblen = ProtobufUtil.lengthOfPBMagic();
        sb.append("\n").append(peersZnode).append(": ");
        for (String peerIdZnode : ZKUtil.listChildrenNoWatch(zkw, peersZnode)) {
            byte[] data;
            String znodeToProcess = ZKUtil.joinZNode(peersZnode, peerIdZnode);
            try {
                data = ZKUtil.getData(zkw, znodeToProcess);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
            try {
                ZooKeeperProtos.ReplicationPeer.Builder builder = ZooKeeperProtos.ReplicationPeer.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, data, pblen, data.length - pblen);
                String clusterKey = builder.getClusterkey();
                sb.append("\n").append(znodeToProcess).append(": ").append(clusterKey);
                ZKUtil.appendPeerState(zkw, znodeToProcess, sb);
            }
            catch (IOException ipbe) {
                LOG.warn((Object)("Got Exception while parsing peer: " + znodeToProcess), (Throwable)ipbe);
            }
        }
    }

    private static void appendPeerState(ZooKeeperWatcher zkw, String znodeToProcess, StringBuilder sb) throws KeeperException, InvalidProtocolBufferException {
        String peerState = zkw.getConfiguration().get("zookeeper.znode.replication.peers.state", "peer-state");
        int pblen = ProtobufUtil.lengthOfPBMagic();
        for (String child : ZKUtil.listChildrenNoWatch(zkw, znodeToProcess)) {
            if (!child.equals(peerState)) continue;
            String peerStateZnode = ZKUtil.joinZNode(znodeToProcess, child);
            sb.append("\n").append(peerStateZnode).append(": ");
            try {
                byte[] peerStateData = ZKUtil.getData(zkw, peerStateZnode);
                ZooKeeperProtos.ReplicationState.Builder builder = ZooKeeperProtos.ReplicationState.newBuilder();
                ProtobufUtil.mergeFrom((Message.Builder)builder, peerStateData, pblen, peerStateData.length - pblen);
                sb.append(builder.getState().name());
            }
            catch (IOException ipbe) {
                LOG.warn((Object)("Got Exception while parsing peer: " + znodeToProcess), (Throwable)ipbe);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return;
            }
        }
    }

    public static String[] getServerStats(String server, int timeout) throws IOException {
        String line;
        String[] sp = server.split(":");
        if (sp == null || sp.length == 0) {
            return null;
        }
        String host = sp[0];
        int port = sp.length > 1 ? Integer.parseInt(sp[1]) : 5181;
        Socket socket = new Socket();
        InetSocketAddress sockAddr = new InetSocketAddress(host, port);
        socket.connect(sockAddr, timeout);
        socket.setSoTimeout(timeout);
        PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8)), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
        out.println("stat");
        out.flush();
        ArrayList<String> res = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            res.add(line);
        }
        socket.close();
        return res.toArray(new String[res.size()]);
    }

    private static void logRetrievedMsg(ZooKeeperWatcher zkw, String znode, byte[] data, boolean watcherSet) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        LOG.trace((Object)zkw.prefix("Retrieved " + (data == null ? 0 : data.length) + " byte(s) of data from znode " + znode + (watcherSet ? " and set watcher; " : "; data=") + (data == null ? "null" : (data.length == 0 ? "empty" : (znode.startsWith(zkw.assignmentZNode) ? ZKAssign.toString(data) : (znode.startsWith("meta-region-server") ? ZKUtil.getServerNameOrEmptyString(data) : (znode.startsWith(zkw.backupMasterAddressesZNode) ? ZKUtil.getServerNameOrEmptyString(data) : StringUtils.abbreviate((String)Bytes.toStringBinary(data), (int)32))))))));
    }

    private static String getServerNameOrEmptyString(byte[] data) {
        try {
            return ServerName.parseFrom(data).toString();
        }
        catch (DeserializationException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBaseZNode(Configuration conf) throws IOException {
        LOG.info((Object)"Waiting until the base znode is available");
        String parentZNode = conf.get("zookeeper.znode.parent", "/hbase");
        ZooKeeper zk = new ZooKeeper(ZKConfig.getZKQuorumServersString(conf), conf.getInt("zookeeper.session.timeout", 180000), (Watcher)EmptyWatcher.instance);
        int maxTimeMs = 10000;
        int maxNumAttempts = 50;
        KeeperException keeperEx = null;
        try {
            try {
                for (int attempt = 0; attempt < 50; ++attempt) {
                    block9: {
                        try {
                            if (zk.exists(parentZNode, false) == null) break block9;
                            LOG.info((Object)("Parent znode exists: " + parentZNode));
                            keeperEx = null;
                            break;
                        }
                        catch (KeeperException e) {
                            keeperEx = e;
                        }
                    }
                    Threads.sleepWithoutInterrupt(200L);
                }
            }
            finally {
                zk.close();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (keeperEx != null) {
            throw new IOException(keeperEx);
        }
    }

    public static byte[] blockUntilAvailable(ZooKeeperWatcher zkw, String znode, long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (zkw == null) {
            throw new IllegalArgumentException();
        }
        if (znode == null) {
            throw new IllegalArgumentException();
        }
        byte[] data = null;
        boolean finished = false;
        long endTime = System.currentTimeMillis() + timeout;
        while (!finished) {
            try {
                data = ZKUtil.getData(zkw, znode);
            }
            catch (KeeperException e) {
                if (e instanceof KeeperException.SessionExpiredException || e instanceof KeeperException.AuthFailedException) {
                    throw new InterruptedException("interrupted due to " + (Object)((Object)e));
                }
                LOG.warn((Object)"Unexpected exception handling blockUntilAvailable", (Throwable)e);
            }
            if (data == null && System.currentTimeMillis() + 200L < endTime) {
                Thread.sleep(200L);
                continue;
            }
            finished = true;
        }
        return data;
    }

    public static KeeperException convert(DeserializationException e) {
        KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
        ke.initCause((Throwable)e);
        return ke;
    }

    public static void logZKTree(ZooKeeperWatcher zkw, String root) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)"Current zk system:");
        String prefix = "|-";
        LOG.debug((Object)(prefix + root));
        try {
            ZKUtil.logZKTree(zkw, root, prefix);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void logZKTree(ZooKeeperWatcher zkw, String root, String prefix) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, root);
        if (children == null) {
            return;
        }
        for (String child : children) {
            LOG.debug((Object)(prefix + child));
            String node = ZKUtil.joinZNode(root.equals("/") ? "" : root, child);
            ZKUtil.logZKTree(zkw, node, prefix + "---");
        }
    }

    public static byte[] positionToByteArray(long position) {
        byte[] bytes = ZooKeeperProtos.ReplicationHLogPosition.newBuilder().setPosition(position).build().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    public static long parseWALPositionFrom(byte[] bytes) throws DeserializationException {
        if (bytes == null) {
            throw new DeserializationException("Unable to parse null WAL position.");
        }
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            ZooKeeperProtos.ReplicationHLogPosition position;
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.ReplicationHLogPosition.Builder builder = ZooKeeperProtos.ReplicationHLogPosition.newBuilder();
            try {
                ProtobufUtil.mergeFrom((Message.Builder)builder, bytes, pblen, bytes.length - pblen);
                position = builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
            return position.getPosition();
        }
        if (bytes.length > 0) {
            return Bytes.toLong(bytes);
        }
        return 0L;
    }

    public static byte[] regionSequenceIdsToByteArray(Long regionLastFlushedSequenceId, Map<byte[], Long> storeSequenceIds) {
        ClusterStatusProtos.RegionStoreSequenceIds.Builder regionSequenceIdsBuilder = ClusterStatusProtos.RegionStoreSequenceIds.newBuilder();
        ClusterStatusProtos.StoreSequenceId.Builder storeSequenceIdBuilder = ClusterStatusProtos.StoreSequenceId.newBuilder();
        if (storeSequenceIds != null) {
            for (Map.Entry<byte[], Long> e : storeSequenceIds.entrySet()) {
                byte[] columnFamilyName = e.getKey();
                Long curSeqId = e.getValue();
                storeSequenceIdBuilder.setFamilyName(ByteStringer.wrap(columnFamilyName));
                storeSequenceIdBuilder.setSequenceId(curSeqId);
                regionSequenceIdsBuilder.addStoreSequenceId(storeSequenceIdBuilder.build());
                storeSequenceIdBuilder.clear();
            }
        }
        regionSequenceIdsBuilder.setLastFlushedSequenceId(regionLastFlushedSequenceId);
        byte[] result = regionSequenceIdsBuilder.build().toByteArray();
        return ProtobufUtil.prependPBMagic(result);
    }

    public static ClusterStatusProtos.RegionStoreSequenceIds parseRegionStoreSequenceIds(byte[] bytes) throws DeserializationException {
        if (bytes == null || !ProtobufUtil.isPBMagicPrefix(bytes)) {
            throw new DeserializationException("Unable to parse RegionStoreSequenceIds.");
        }
        ClusterStatusProtos.RegionStoreSequenceIds.Builder regionSequenceIdsBuilder = ClusterStatusProtos.RegionStoreSequenceIds.newBuilder();
        int pblen = ProtobufUtil.lengthOfPBMagic();
        ClusterStatusProtos.RegionStoreSequenceIds storeIds = null;
        try {
            ProtobufUtil.mergeFrom((Message.Builder)regionSequenceIdsBuilder, bytes, pblen, bytes.length - pblen);
            storeIds = regionSequenceIdsBuilder.build();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return storeIds;
    }

    public static abstract class ZKUtilOp {
        private String path;

        private ZKUtilOp(String path) {
            this.path = path;
        }

        public static ZKUtilOp createAndFailSilent(String path, byte[] data) {
            return new CreateAndFailSilent(path, data);
        }

        public static ZKUtilOp deleteNodeFailSilent(String path) {
            return new DeleteNodeFailSilent(path);
        }

        public static ZKUtilOp setData(String path, byte[] data) {
            return new SetData(path, data);
        }

        public String getPath() {
            return this.path;
        }

        public static class SetData
        extends ZKUtilOp {
            private byte[] data;

            private SetData(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            public byte[] getData() {
                return this.data;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SetData)) {
                    return false;
                }
                SetData op = (SetData)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
            }

            public int hashCode() {
                int ret = this.getPath().hashCode();
                return ret * 31 + Bytes.hashCode(this.data);
            }
        }

        public static class DeleteNodeFailSilent
        extends ZKUtilOp {
            private DeleteNodeFailSilent(String path) {
                super(path);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DeleteNodeFailSilent)) {
                    return false;
                }
                return super.equals(o);
            }

            public int hashCode() {
                return this.getPath().hashCode();
            }
        }

        public static class CreateAndFailSilent
        extends ZKUtilOp {
            private byte[] data;

            private CreateAndFailSilent(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            public byte[] getData() {
                return this.data;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof CreateAndFailSilent)) {
                    return false;
                }
                CreateAndFailSilent op = (CreateAndFailSilent)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
            }

            public int hashCode() {
                int ret = 17 + this.getPath().hashCode() * 31;
                return ret * 31 + Bytes.hashCode(this.data);
            }
        }
    }

    @Deprecated
    public static class NodeAndData {
        private String node;
        private byte[] data;

        public NodeAndData(String node, byte[] data) {
            this.node = node;
            this.data = data;
        }

        public String getNode() {
            return this.node;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return this.node;
        }

        public boolean isEmpty() {
            return this.data == null || this.data.length == 0;
        }
    }

    private static class JaasConfiguration
    extends javax.security.auth.login.Configuration {
        private static final String SERVER_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-server-keytab-kerberos";
        private static final String CLIENT_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-client-keytab-kerberos";
        private static final Map<String, String> BASIC_JAAS_OPTIONS = new HashMap<String, String>();
        private static final Map<String, String> KEYTAB_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry KEYTAB_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] KEYTAB_KERBEROS_CONF;
        private javax.security.auth.login.Configuration baseConfig;
        private final String loginContextName;
        private final boolean useTicketCache;
        private final String keytabFile;
        private final String principal;

        public JaasConfiguration(String loginContextName, String principal) {
            this(loginContextName, principal, null, true);
        }

        public JaasConfiguration(String loginContextName, String principal, String keytabFile) {
            this(loginContextName, principal, keytabFile, keytabFile == null || keytabFile.length() == 0);
        }

        private JaasConfiguration(String loginContextName, String principal, String keytabFile, boolean useTicketCache) {
            try {
                this.baseConfig = javax.security.auth.login.Configuration.getConfiguration();
            }
            catch (SecurityException e) {
                this.baseConfig = null;
            }
            this.loginContextName = loginContextName;
            this.useTicketCache = useTicketCache;
            this.keytabFile = keytabFile;
            this.principal = principal;
            LOG.info((Object)("JaasConfiguration loginContextName=" + loginContextName + " principal=" + principal + " useTicketCache=" + useTicketCache + " keytabFile=" + keytabFile));
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.loginContextName.equals(appName)) {
                if (!this.useTicketCache) {
                    KEYTAB_KERBEROS_OPTIONS.put("keyTab", this.keytabFile);
                    KEYTAB_KERBEROS_OPTIONS.put("useKeyTab", "true");
                }
                KEYTAB_KERBEROS_OPTIONS.put("principal", this.principal);
                KEYTAB_KERBEROS_OPTIONS.put("useTicketCache", this.useTicketCache ? "true" : "false");
                return KEYTAB_KERBEROS_CONF;
            }
            if (this.baseConfig != null) {
                return this.baseConfig.getAppConfigurationEntry(appName);
            }
            return null;
        }

        static {
            String jaasEnvVar = System.getenv("HBASE_JAAS_DEBUG");
            if (jaasEnvVar != null && "true".equalsIgnoreCase(jaasEnvVar)) {
                BASIC_JAAS_OPTIONS.put("debug", "true");
            }
            KEYTAB_KERBEROS_OPTIONS = new HashMap<String, String>();
            KEYTAB_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            KEYTAB_KERBEROS_OPTIONS.put("storeKey", "true");
            KEYTAB_KERBEROS_OPTIONS.put("refreshKrb5Config", "true");
            KEYTAB_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
            KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, KEYTAB_KERBEROS_OPTIONS);
            KEYTAB_KERBEROS_CONF = new AppConfigurationEntry[]{KEYTAB_KERBEROS_LOGIN};
        }
    }
}

