/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestWALOpenAfterDNRollingStart {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static long DataNodeRestartInterval;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        DataNodeRestartInterval = 15000L;
        long checkLowReplicationInterval = 10000L;
        TEST_UTIL.getConfiguration().setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", false);
        TEST_UTIL.getConfiguration().setLong("hbase.regionserver.hlog.check.lowreplication.interval", checkLowReplicationInterval);
        TEST_UTIL.startMiniDFSCluster(3);
        TEST_UTIL.startMiniCluster(1);
    }

    @Test(timeout=300000L)
    public void test() throws Exception {
        HRegionServer server = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        FSHLog hlog = (FSHLog)server.getWAL(null);
        Path currentFile = hlog.getCurrentFileName();
        for (int i = 0; i < TEST_UTIL.getDFSCluster().getDataNodes().size(); ++i) {
            TEST_UTIL.getDFSCluster().restartDataNode(0);
            Thread.sleep(DataNodeRestartInterval);
        }
        WAL.Reader reader = WALFactory.createReader(TEST_UTIL.getTestFileSystem(), currentFile, TEST_UTIL.getConfiguration());
    }
}

