/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWALMethods {
    private static final byte[] TEST_REGION = Bytes.toBytes("test_region");
    private static final TableName TEST_TABLE = TableName.valueOf("test_table");
    private final HBaseTestingUtility util = new HBaseTestingUtility();

    @Test
    public void testServerNameFromWAL() throws Exception {
        Path walPath = new Path("/hbase/WALs/regionserver-2.example.com,22101,1487767381290", "regionserver-2.example.com%2C22101%2C1487767381290.null0.1487785392316");
        ServerName name = DefaultWALProvider.getServerNameFromWALDirectoryName(walPath);
        Assert.assertEquals((Object)ServerName.valueOf("regionserver-2.example.com", 22101, 1487767381290L), (Object)name);
    }

    @Test
    public void testServerNameFromTestWAL() throws Exception {
        Path walPath = new Path("/user/example/test-data/12ff1404-68c6-4715-a4b9-775e763842bc/WALs/TestWALRecordReader", "TestWALRecordReader.default.1487787939118");
        ServerName name = DefaultWALProvider.getServerNameFromWALDirectoryName(walPath);
        Assert.assertNull((Object)name);
    }

    @Ignore
    @Test
    public void testGetSplitEditFilesSorted() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.util.getConfiguration());
        Path regiondir = this.util.getDataTestDir("regiondir");
        fs.delete(regiondir, true);
        fs.mkdirs(regiondir);
        Path recoverededits = WALSplitter.getRegionDirRecoveredEditsDir(regiondir);
        String first = WALSplitter.formatRecoveredEditsFileName(-1L);
        this.createFile(fs, recoverededits, first);
        this.createFile(fs, recoverededits, WALSplitter.formatRecoveredEditsFileName(0L));
        this.createFile(fs, recoverededits, WALSplitter.formatRecoveredEditsFileName(1L));
        this.createFile(fs, recoverededits, WALSplitter.formatRecoveredEditsFileName(11L));
        this.createFile(fs, recoverededits, WALSplitter.formatRecoveredEditsFileName(2L));
        this.createFile(fs, recoverededits, WALSplitter.formatRecoveredEditsFileName(50L));
        String last = WALSplitter.formatRecoveredEditsFileName(Long.MAX_VALUE);
        this.createFile(fs, recoverededits, last);
        this.createFile(fs, recoverededits, Long.toString(Long.MAX_VALUE) + "." + System.currentTimeMillis());
        Configuration walConf = new Configuration(this.util.getConfiguration());
        FSUtils.setRootDir(walConf, regiondir);
        new WALFactory(walConf, null, "dummyLogName").getWAL(new byte[0], null);
        NavigableSet<Path> files = WALSplitter.getSplitEditFilesSorted(fs, regiondir);
        Assert.assertEquals((long)7L, (long)files.size());
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)first);
        Assert.assertEquals((Object)files.pollLast().getName(), (Object)last);
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)WALSplitter.formatRecoveredEditsFileName(0L));
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)WALSplitter.formatRecoveredEditsFileName(1L));
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)WALSplitter.formatRecoveredEditsFileName(2L));
        Assert.assertEquals((Object)files.pollFirst().getName(), (Object)WALSplitter.formatRecoveredEditsFileName(11L));
    }

    private void createFile(FileSystem fs, Path testdir, String name) throws IOException {
        FSDataOutputStream fdos = fs.create(new Path(testdir, name), true);
        fdos.close();
    }

    @Test
    public void testRegionEntryBuffer() throws Exception {
        WALSplitter.RegionEntryBuffer reb = new WALSplitter.RegionEntryBuffer(TEST_TABLE, TEST_REGION);
        Assert.assertEquals((long)0L, (long)reb.heapSize());
        reb.appendEntry(this.createTestLogEntry(1));
        Assert.assertTrue((reb.heapSize() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testEntrySink() throws Exception {
        Configuration conf = new Configuration();
        ZooKeeperProtos.SplitLogTask.RecoveryMode mode = conf.getBoolean("hbase.master.distributed.log.replay", false) ? ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY : ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
        WALSplitter.EntryBuffers sink = new WALSplitter.EntryBuffers(new WALSplitter.PipelineController(), 0x100000L);
        for (int i = 0; i < 1000; ++i) {
            WAL.Entry entry = this.createTestLogEntry(i);
            sink.appendEntry(entry);
        }
        Assert.assertTrue((sink.totalBuffered > 0L ? 1 : 0) != 0);
        long amountInChunk = sink.totalBuffered;
        WALSplitter.RegionEntryBuffer chunk = sink.getChunkToWrite();
        Assert.assertEquals((long)chunk.heapSize(), (long)amountInChunk);
        Assert.assertTrue((boolean)sink.isRegionCurrentlyWriting(TEST_REGION));
        for (int i = 0; i < 500; ++i) {
            WAL.Entry entry = this.createTestLogEntry(i);
            sink.appendEntry(entry);
        }
        Assert.assertNull((Object)sink.getChunkToWrite());
        sink.doneWriting(chunk);
        WALSplitter.RegionEntryBuffer chunk2 = sink.getChunkToWrite();
        Assert.assertNotNull((Object)chunk2);
        Assert.assertNotSame((Object)chunk, (Object)chunk2);
        long amountInChunk2 = sink.totalBuffered;
        Assert.assertTrue((amountInChunk2 < amountInChunk ? 1 : 0) != 0);
        sink.doneWriting(chunk2);
        Assert.assertEquals((long)0L, (long)sink.totalBuffered);
    }

    private WAL.Entry createTestLogEntry(int i) {
        long seq = i;
        long now = i * 1000;
        WALEdit edit = new WALEdit();
        edit.add(KeyValueTestUtil.create("row", "fam", "qual", 1234L, "val"));
        WALKey key = new WALKey(TEST_REGION, TEST_TABLE, seq, now, HConstants.DEFAULT_CLUSTER_ID);
        WAL.Entry entry = new WAL.Entry(key, edit);
        return entry;
    }
}

