/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.util.hbck.OfflineMetaRebuildTestCore;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestOfflineMetaRebuildBase
extends OfflineMetaRebuildTestCore {
    private static final Log LOG = LogFactory.getLog(TestOfflineMetaRebuildBase.class);

    @Test(timeout=120000L)
    public void testMetaRebuild() throws Exception {
        this.wipeOutMeta();
        Assert.assertEquals((long)1L, (long)this.scanMeta());
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
        this.TEST_UTIL.shutdownMiniHBaseCluster();
        this.TEST_UTIL.shutdownMiniZKCluster();
        HBaseFsck fsck = new HBaseFsck(this.conf);
        Assert.assertTrue((boolean)fsck.rebuildMeta(false));
        Assert.assertTrue((String)"HBCK meta recovery WAL directory exist.", (boolean)this.validateHBCKMetaRecoveryWALDir());
        this.TEST_UTIL.startMiniZKCluster();
        this.TEST_UTIL.restartHBaseCluster(3);
        this.validateMetaAndUserTableRows(1, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testHMasterStartupOnMetaRebuild() throws Exception {
        this.TEST_UTIL.shutdownMiniHBaseCluster();
        this.TEST_UTIL.getConfiguration().set("hbase.balancer.tablesOnMaster", "hbase:meta");
        this.TEST_UTIL.getConfiguration().set("hbase.master.namespace.init.timeout", "150000");
        this.TEST_UTIL.restartHBaseCluster(3);
        this.TEST_UTIL.getMiniHBaseCluster().waitForActiveAndReadyMaster();
        try {
            this.TEST_UTIL.getHBaseAdmin().createNamespace(NamespaceDescriptor.create("ns1").build());
            this.TEST_UTIL.getHBaseAdmin().createNamespace(NamespaceDescriptor.create("ns2").build());
            this.TEST_UTIL.createTable(TableName.valueOf("ns1:testHMasterStartupOnMetaRebuild"), Bytes.toBytes("cf1"));
            this.TEST_UTIL.createTable(TableName.valueOf("ns2:testHMasterStartupOnMetaRebuild"), Bytes.toBytes("cf1"));
            this.TEST_UTIL.flush(TableName.META_TABLE_NAME);
            this.TEST_UTIL.getHBaseCluster().getMaster().shutdown();
            List<JVMClusterUtil.RegionServerThread> regionServerThreads = this.TEST_UTIL.getHBaseCluster().getRegionServerThreads();
            for (JVMClusterUtil.RegionServerThread regionServerThread : regionServerThreads) {
                this.TEST_UTIL.getHBaseCluster().killRegionServer(regionServerThread.getRegionServer().getServerName());
            }
            HBaseFsck fsck = new HBaseFsck(this.conf);
            Assert.assertTrue((boolean)fsck.rebuildMeta(false));
            this.TEST_UTIL.restartHBaseCluster(3);
            this.validateMetaAndUserTableRows(3, 7);
        }
        finally {
            this.TEST_UTIL.deleteTable("ns1:testHMasterStartupOnMetaRebuild");
            this.TEST_UTIL.deleteTable("ns2:testHMasterStartupOnMetaRebuild");
            this.TEST_UTIL.getHBaseAdmin().deleteNamespace("ns1");
            this.TEST_UTIL.getHBaseAdmin().deleteNamespace("ns2");
        }
    }

    private void validateMetaAndUserTableRows(int totalTableCount, int totalRegionCount) throws Exception {
        try (Connection connection = ConnectionFactory.createConnection(this.TEST_UTIL.getConfiguration());){
            Admin admin = connection.getAdmin();
            admin.enableTable(this.table);
            LOG.info((Object)"Waiting for no more RIT");
            this.TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
            LOG.info((Object)"No more RIT in ZK, now doing final test verification");
            Assert.assertEquals((long)totalRegionCount, (long)this.scanMeta());
            Object[] htbls = admin.listTables();
            LOG.info((Object)("Tables present after restart: " + Arrays.toString(htbls)));
            Assert.assertEquals((long)totalTableCount, (long)htbls.length);
        }
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
        LOG.info((Object)("Table " + this.table + " has " + this.tableRowCount(this.conf, this.table) + " entries."));
        Assert.assertEquals((long)16L, (long)this.tableRowCount(this.conf, this.table));
    }

    private boolean validateHBCKMetaRecoveryWALDir() throws IOException {
        Path rootdir = FSUtils.getRootDir(this.TEST_UTIL.getConfiguration());
        Path walLogDir = new Path(rootdir, "WALs");
        FileSystem fs = this.TEST_UTIL.getTestFileSystem();
        FileStatus[] walFiles = FSUtils.listStatus(fs, walLogDir, null);
        Assert.assertNotNull((Object)walFiles);
        for (FileStatus fsStat : walFiles) {
            if (!fsStat.isDirectory() || !fsStat.getPath().getName().startsWith("hregion-")) continue;
            return false;
        }
        return true;
    }
}

