/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Strings;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SmallTests.class})
public class TestStrings {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAppendKeyValue() {
        Assert.assertEquals((Object)"foo, bar=baz", (Object)Strings.appendKeyValue(new StringBuilder("foo"), "bar", "baz").toString());
        Assert.assertEquals((Object)"bar->baz", (Object)Strings.appendKeyValue(new StringBuilder(), "bar", "baz", "->", "| ").toString());
        Assert.assertEquals((Object)"foo, bar=baz", (Object)Strings.appendKeyValue(new StringBuilder("foo"), "bar", "baz", "=", ", ").toString());
        Assert.assertEquals((Object)"foo| bar->baz", (Object)Strings.appendKeyValue(new StringBuilder("foo"), "bar", "baz", "->", "| ").toString());
    }

    @Test
    public void testDomainNamePointerToHostName() {
        Assert.assertNull((Object)Strings.domainNamePointerToHostName(null));
        Assert.assertEquals((Object)"foo", (Object)Strings.domainNamePointerToHostName("foo"));
        Assert.assertEquals((Object)"foo.com", (Object)Strings.domainNamePointerToHostName("foo.com"));
        Assert.assertEquals((Object)"foo.bar.com", (Object)Strings.domainNamePointerToHostName("foo.bar.com"));
        Assert.assertEquals((Object)"foo.bar.com", (Object)Strings.domainNamePointerToHostName("foo.bar.com."));
    }

    @Test
    public void testPadFront() {
        Assert.assertEquals((Object)"ddfoo", (Object)Strings.padFront("foo", 'd', 5));
        this.thrown.expect(IllegalArgumentException.class);
        Strings.padFront("foo", 'd', 1);
    }
}

