/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Merge;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMergeTool
extends HBaseTestCase {
    private static final Log LOG = LogFactory.getLog(TestMergeTool.class);
    HBaseTestingUtility TEST_UTIL;
    static final byte[] FAMILY = Bytes.toBytes("contents");
    static final byte[] QUALIFIER = Bytes.toBytes("dc");
    private final HRegionInfo[] sourceRegions = new HRegionInfo[5];
    private final HRegion[] regions = new HRegion[5];
    private HTableDescriptor desc;
    private byte[][][] rows;
    private MiniDFSCluster dfsCluster = null;
    private WALFactory wals;

    @Override
    public void setUp() throws Exception {
        this.conf.setLong("hbase.zookeeper.recoverable.waittime", 10L);
        this.conf.setInt("hbase.zookeeper.property.clientPort", 10001);
        this.conf.set("hbase.hstore.compactionThreshold", "2");
        this.desc = new HTableDescriptor(TableName.valueOf("TestMergeTool"));
        this.desc.addFamily(new HColumnDescriptor(FAMILY));
        this.sourceRegions[0] = new HRegionInfo(this.desc.getTableName(), Bytes.toBytes("row_0200"), Bytes.toBytes("row_0300"));
        this.sourceRegions[1] = new HRegionInfo(this.desc.getTableName(), Bytes.toBytes("row_0250"), Bytes.toBytes("row_0400"));
        this.sourceRegions[2] = new HRegionInfo(this.desc.getTableName(), Bytes.toBytes("row_0100"), Bytes.toBytes("row_0200"));
        this.sourceRegions[3] = new HRegionInfo(this.desc.getTableName(), Bytes.toBytes("row_0500"), Bytes.toBytes("row_0600"));
        this.sourceRegions[4] = new HRegionInfo(this.desc.getTableName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
        this.rows = new byte[5][][];
        this.rows[0] = Bytes.toByteArrays(new String[]{"row_0210", "row_0280"});
        this.rows[1] = Bytes.toByteArrays(new String[]{"row_0260", "row_0350", "row_035"});
        this.rows[2] = Bytes.toByteArrays(new String[]{"row_0110", "row_0175", "row_0175", "row_0175"});
        this.rows[3] = Bytes.toByteArrays(new String[]{"row_0525", "row_0560", "row_0560", "row_0560", "row_0560"});
        this.rows[4] = Bytes.toByteArrays(new String[]{"row_0050", "row_1000", "row_1000", "row_1000", "row_1000", "row_1000"});
        this.TEST_UTIL = new HBaseTestingUtility(this.conf);
        this.dfsCluster = this.TEST_UTIL.startMiniDFSCluster(2);
        this.fs = this.dfsCluster.getFileSystem();
        System.out.println("fs=" + this.fs);
        FSUtils.setFsDefault(this.conf, new Path(this.fs.getUri()));
        this.TEST_UTIL.createRootDir();
        super.setUp();
        this.wals = new WALFactory(this.conf, null, "TestMergeTool");
        try {
            this.createMetaRegion();
            new FSTableDescriptors(this.conf, this.fs, testDir).createTableDescriptor(this.desc);
            for (int i = 0; i < this.sourceRegions.length; ++i) {
                this.regions[i] = HRegion.createHRegion(this.sourceRegions[i], testDir, this.conf, this.desc);
                for (int j = 0; j < this.rows[i].length; ++j) {
                    byte[] row = this.rows[i][j];
                    Put put = new Put(row);
                    put.add(FAMILY, QUALIFIER, row);
                    this.regions[i].put(put);
                }
                HRegion.addRegionToMETA(this.meta, this.regions[i]);
            }
            this.closeRootAndMeta();
        }
        catch (Exception e) {
            this.TEST_UTIL.shutdownMiniCluster();
            throw e;
        }
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        for (int i = 0; i < this.sourceRegions.length; ++i) {
            HRegion r = this.regions[i];
            if (r == null) continue;
            HRegion.closeHRegion(r);
        }
        this.wals.close();
        this.TEST_UTIL.shutdownMiniCluster();
    }

    private HRegion mergeAndVerify(String msg, String regionName1, String regionName2, WAL log, int upperbound) throws Exception {
        Merge merger = new Merge(this.conf);
        LOG.info((Object)msg);
        LOG.info((Object)("fs2=" + this.conf.get("fs.defaultFS")));
        int errCode = ToolRunner.run((Configuration)this.conf, (Tool)merger, (String[])new String[]{this.desc.getTableName().getNameAsString(), regionName1, regionName2});
        TestMergeTool.assertTrue((String)("'" + msg + "' failed with errCode " + errCode), (errCode == 0 ? 1 : 0) != 0);
        HRegionInfo mergedInfo = merger.getMergedHRegionInfo();
        HRegion merged = HRegion.openHRegion(mergedInfo, this.desc, log, this.conf);
        this.verifyMerge(merged, upperbound);
        merged.close();
        LOG.info((Object)("Verified " + msg));
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyMerge(HRegion merged, int upperbound) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        try (RegionScanner scanner = merged.getScanner(scan);){
            boolean hasNext;
            ArrayList<Cell> testRes = null;
            while (hasNext = scanner.next(testRes = new ArrayList<Cell>())) {
            }
        }
        for (int i = 0; i < upperbound; ++i) {
            for (int j = 0; j < this.rows[i].length; ++j) {
                Get get = new Get(this.rows[i][j]);
                get.addFamily(FAMILY);
                Result result = merged.get(get);
                TestMergeTool.assertEquals((int)1, (int)result.size());
                byte[] bytes = CellUtil.cloneValue(result.rawCells()[0]);
                TestMergeTool.assertNotNull((String)Bytes.toStringBinary(this.rows[i][j]), (Object)bytes);
                TestMergeTool.assertTrue((boolean)Bytes.equals(bytes, this.rows[i][j]));
            }
        }
    }

    public void testMergeTool() throws Exception {
        for (int i = 0; i < this.regions.length; ++i) {
            for (int j = 0; j < this.rows[i].length; ++j) {
                Get get = new Get(this.rows[i][j]);
                get.addFamily(FAMILY);
                Result result = this.regions[i].get(get);
                byte[] bytes = CellUtil.cloneValue(result.rawCells()[0]);
                TestMergeTool.assertNotNull((Object)bytes);
                TestMergeTool.assertTrue((boolean)Bytes.equals(bytes, this.rows[i][j]));
            }
            HRegion.closeHRegion(this.regions[i]);
        }
        WAL log = this.wals.getWAL(new byte[0], null);
        HRegion merged = this.mergeAndVerify("merging regions 0 and 1 ", this.sourceRegions[0].getRegionNameAsString(), this.sourceRegions[1].getRegionNameAsString(), log, 2);
        merged = this.mergeAndVerify("merging regions 0+1 and 2", merged.getRegionInfo().getRegionNameAsString(), this.sourceRegions[2].getRegionNameAsString(), log, 3);
        merged = this.mergeAndVerify("merging regions 0+1+2 and 3", merged.getRegionInfo().getRegionNameAsString(), this.sourceRegions[3].getRegionNameAsString(), log, 4);
        merged = this.mergeAndVerify("merging regions 0+1+2+3 and 4", merged.getRegionInfo().getRegionNameAsString(), this.sourceRegions[4].getRegionNameAsString(), log, this.rows.length);
    }
}

