/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MultiThreadedAction;
import org.apache.hadoop.hbase.util.MultiThreadedReader;
import org.apache.hadoop.hbase.util.MultiThreadedReaderWithACL;
import org.apache.hadoop.hbase.util.MultiThreadedUpdater;
import org.apache.hadoop.hbase.util.MultiThreadedUpdaterWithACL;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.apache.hadoop.hbase.util.MultiThreadedWriterWithACL;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.hbase.util.test.LoadTestDataGeneratorWithACL;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.zookeeper.ZooKeeper;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class LoadTestTool
extends AbstractHBaseTool {
    private static final Log LOG = LogFactory.getLog(LoadTestTool.class);
    private static final String COLON = ":";
    private TableName tableName;
    private byte[][] families;
    protected static final String DEFAULT_TABLE_NAME = "cluster_test";
    public static byte[] DEFAULT_COLUMN_FAMILY = Bytes.toBytes("test_cf");
    public static final byte[][] DEFAULT_COLUMN_FAMILIES = new byte[][]{DEFAULT_COLUMN_FAMILY};
    protected static final int DEFAULT_DATA_SIZE = 64;
    protected static final int DEFAULT_NUM_THREADS = 20;
    protected static final String OPT_USAGE_LOAD = "<avg_cols_per_key>:<avg_data_size>[:<#threads=20>]";
    protected static final String OPT_USAGE_READ = "<verify_percent>[:<#threads=20>]";
    protected static final String OPT_USAGE_UPDATE = "<update_percent>[:<#threads=20>][:<#whether to ignore nonce collisions=0>]";
    protected static final String OPT_USAGE_BLOOM = "Bloom filter type, one of " + Arrays.toString((Object[])BloomType.values());
    protected static final String OPT_USAGE_COMPRESSION = "Compression type, one of " + Arrays.toString((Object[])Compression.Algorithm.values());
    public static final String OPT_DATA_BLOCK_ENCODING_USAGE = "Encoding algorithm (e.g. prefix compression) to use for data blocks in the test column family, one of " + Arrays.toString((Object[])DataBlockEncoding.values()) + ".";
    protected static final String OPT_VERBOSE = "verbose";
    public static final String OPT_BLOOM = "bloom";
    public static final String OPT_COMPRESSION = "compression";
    public static final String OPT_DEFERRED_LOG_FLUSH = "deferredlogflush";
    public static final String OPT_DEFERRED_LOG_FLUSH_USAGE = "Enable deferred log flush.";
    public static final String OPT_DATA_BLOCK_ENCODING = "DATA_BLOCK_ENCODING".toLowerCase(Locale.ROOT);
    public static final String OPT_INMEMORY = "in_memory";
    public static final String OPT_USAGE_IN_MEMORY = "Tries to keep the HFiles of the CF inmemory as far as possible.  Not guaranteed that reads are always served from inmemory";
    public static final String OPT_GENERATOR = "generator";
    public static final String OPT_GENERATOR_USAGE = "The class which generates load for the tool. Any args for this class can be passed as colon separated after class name";
    public static final String OPT_WRITER = "writer";
    public static final String OPT_WRITER_USAGE = "The class for executing the write requests";
    public static final String OPT_UPDATER = "updater";
    public static final String OPT_UPDATER_USAGE = "The class for executing the update requests";
    public static final String OPT_READER = "reader";
    public static final String OPT_READER_USAGE = "The class for executing the read requests";
    protected static final String OPT_KEY_WINDOW = "key_window";
    protected static final String OPT_WRITE = "write";
    protected static final String OPT_MAX_READ_ERRORS = "max_read_errors";
    public static final String OPT_MULTIPUT = "multiput";
    public static final String OPT_MULTIGET = "multiget_batchsize";
    protected static final String OPT_NUM_KEYS = "num_keys";
    protected static final String OPT_READ = "read";
    protected static final String OPT_START_KEY = "start_key";
    public static final String OPT_TABLE_NAME = "tn";
    public static final String OPT_COLUMN_FAMILIES = "families";
    protected static final String OPT_ZK_QUORUM = "zk";
    protected static final String OPT_ZK_PARENT_NODE = "zk_root";
    protected static final String OPT_SKIP_INIT = "skip_init";
    protected static final String OPT_INIT_ONLY = "init_only";
    protected static final String NUM_TABLES = "num_tables";
    protected static final String OPT_BATCHUPDATE = "batchupdate";
    protected static final String OPT_UPDATE = "update";
    public static final String OPT_ENCRYPTION = "encryption";
    protected static final String OPT_ENCRYPTION_USAGE = "Enables transparent encryption on the test table, one of " + Arrays.toString(Encryption.getSupportedCiphers());
    public static final String OPT_NUM_REGIONS_PER_SERVER = "num_regions_per_server";
    protected static final String OPT_NUM_REGIONS_PER_SERVER_USAGE = "Desired number of regions per region server. Defaults to 5.";
    public static int DEFAULT_NUM_REGIONS_PER_SERVER = 5;
    public static final String OPT_REGION_REPLICATION = "region_replication";
    protected static final String OPT_REGION_REPLICATION_USAGE = "Desired number of replicas per region";
    public static final String OPT_REGION_REPLICA_ID = "region_replica_id";
    protected static final String OPT_REGION_REPLICA_ID_USAGE = "Region replica id to do the reads from";
    protected static final long DEFAULT_START_KEY = 0L;
    protected CommandLine cmd;
    protected MultiThreadedWriter writerThreads = null;
    protected MultiThreadedReader readerThreads = null;
    protected MultiThreadedUpdater updaterThreads = null;
    protected long startKey;
    protected long endKey;
    protected boolean isVerbose;
    protected boolean isWrite;
    protected boolean isRead;
    protected boolean isUpdate;
    protected boolean deferredLogFlush;
    protected DataBlockEncoding dataBlockEncodingAlgo;
    protected Compression.Algorithm compressAlgo;
    protected BloomType bloomType;
    private boolean inMemoryCF;
    private User userOwner;
    protected int numWriterThreads = 20;
    protected int minColsPerKey;
    protected int maxColsPerKey;
    protected int minColDataSize = 64;
    protected int maxColDataSize = 64;
    protected boolean isMultiPut;
    protected int numUpdaterThreads = 20;
    protected int updatePercent;
    protected boolean ignoreConflicts = false;
    protected boolean isBatchUpdate;
    private int numReaderThreads = 20;
    private int keyWindow = 0;
    private int multiGetBatchSize = 1;
    private int maxReadErrors = 10;
    private int verifyPercent;
    private int numTables = 1;
    private String superUser;
    private String userNames;
    private String authnFileName;
    private int numRegionsPerServer = DEFAULT_NUM_REGIONS_PER_SERVER;
    private int regionReplication = -1;
    private int regionReplicaId = -1;
    protected boolean isSkipInit = false;
    protected boolean isInitOnly = false;
    protected Cipher cipher = null;
    protected AtomicReference<Throwable> thrown = new AtomicReference();

    protected String[] splitColonSeparated(String option, int minNumCols, int maxNumCols) {
        String optVal = this.cmd.getOptionValue(option);
        String[] cols = optVal.split(COLON);
        if (cols.length < minNumCols || cols.length > maxNumCols) {
            throw new IllegalArgumentException("Expected at least " + minNumCols + " columns but no more than " + maxNumCols + " in the colon-separated value '" + optVal + "' of the -" + option + " option");
        }
        return cols;
    }

    protected int getNumThreads(String numThreadsStr) {
        return LoadTestTool.parseInt(numThreadsStr, 1, Short.MAX_VALUE);
    }

    public byte[][] getColumnFamilies() {
        return this.families;
    }

    protected void applyColumnFamilyOptions(TableName tableName, byte[][] columnFamilies) throws IOException {
        HBaseAdmin admin = new HBaseAdmin(this.conf);
        HTableDescriptor tableDesc = admin.getTableDescriptor(tableName);
        LOG.info((Object)("Disabling table " + tableName));
        admin.disableTable(tableName);
        for (byte[] cf : columnFamilies) {
            boolean isNewCf;
            HColumnDescriptor columnDesc = tableDesc.getFamily(cf);
            boolean bl = isNewCf = columnDesc == null;
            if (isNewCf) {
                columnDesc = new HColumnDescriptor(cf);
            }
            if (this.bloomType != null) {
                columnDesc.setBloomFilterType(this.bloomType);
            }
            if (this.compressAlgo != null) {
                columnDesc.setCompressionType(this.compressAlgo);
            }
            if (this.dataBlockEncodingAlgo != null) {
                columnDesc.setDataBlockEncoding(this.dataBlockEncodingAlgo);
            }
            if (this.inMemoryCF) {
                columnDesc.setInMemory(this.inMemoryCF);
            }
            if (this.cipher != null) {
                byte[] keyBytes = new byte[this.cipher.getKeyLength()];
                new SecureRandom().nextBytes(keyBytes);
                columnDesc.setEncryptionType(this.cipher.getName());
                columnDesc.setEncryptionKey(EncryptionUtil.wrapKey(this.conf, User.getCurrent().getShortName(), new SecretKeySpec(keyBytes, this.cipher.getName())));
            }
            if (isNewCf) {
                admin.addColumn(tableName, columnDesc);
                continue;
            }
            admin.modifyColumn(tableName, columnDesc);
        }
        LOG.info((Object)("Enabling table " + tableName));
        admin.enableTable(tableName);
        admin.close();
    }

    @Override
    protected void addOptions() {
        this.addOptNoArg("v", OPT_VERBOSE, "Will display a full readout of logs, including ZooKeeper");
        this.addOptWithArg(OPT_ZK_QUORUM, "ZK quorum as comma-separated host names without port numbers");
        this.addOptWithArg(OPT_ZK_PARENT_NODE, "name of parent znode in zookeeper");
        this.addOptWithArg(OPT_TABLE_NAME, "The name of the table to read or write");
        this.addOptWithArg(OPT_COLUMN_FAMILIES, "The name of the column families to use separated by comma");
        this.addOptWithArg(OPT_WRITE, OPT_USAGE_LOAD);
        this.addOptWithArg(OPT_READ, OPT_USAGE_READ);
        this.addOptWithArg(OPT_UPDATE, OPT_USAGE_UPDATE);
        this.addOptNoArg(OPT_INIT_ONLY, "Initialize the test table only, don't do any loading");
        this.addOptWithArg(OPT_BLOOM, OPT_USAGE_BLOOM);
        this.addOptWithArg(OPT_COMPRESSION, OPT_USAGE_COMPRESSION);
        this.addOptWithArg(OPT_DATA_BLOCK_ENCODING, OPT_DATA_BLOCK_ENCODING_USAGE);
        this.addOptWithArg(OPT_MAX_READ_ERRORS, "The maximum number of read errors to tolerate before terminating all reader threads. The default is 10.");
        this.addOptWithArg(OPT_MULTIGET, "Whether to use multi-gets as opposed to separate gets for every column in a row");
        this.addOptWithArg(OPT_KEY_WINDOW, "The 'key window' to maintain between reads and writes for concurrent write/read workload. The default is 0.");
        this.addOptNoArg(OPT_MULTIPUT, "Whether to use multi-puts as opposed to separate puts for every column in a row");
        this.addOptNoArg(OPT_BATCHUPDATE, "Whether to use batch as opposed to separate updates for every column in a row");
        this.addOptNoArg(OPT_INMEMORY, OPT_USAGE_IN_MEMORY);
        this.addOptWithArg(OPT_GENERATOR, OPT_GENERATOR_USAGE);
        this.addOptWithArg(OPT_WRITER, OPT_WRITER_USAGE);
        this.addOptWithArg(OPT_UPDATER, OPT_UPDATER_USAGE);
        this.addOptWithArg(OPT_READER, OPT_READER_USAGE);
        this.addOptWithArg(OPT_NUM_KEYS, "The number of keys to read/write");
        this.addOptWithArg(OPT_START_KEY, "The first key to read/write (a 0-based index). The default value is 0.");
        this.addOptNoArg(OPT_SKIP_INIT, "Skip the initialization; assume test table already exists");
        this.addOptWithArg(NUM_TABLES, "A positive integer number. When a number n is speicfied, load test tool  will load n table parallely. -tn parameter value becomes table name prefix. Each table name is in format <tn>_1...<tn>_n");
        this.addOptWithArg(OPT_ENCRYPTION, OPT_ENCRYPTION_USAGE);
        this.addOptNoArg(OPT_DEFERRED_LOG_FLUSH, OPT_DEFERRED_LOG_FLUSH_USAGE);
        this.addOptWithArg(OPT_NUM_REGIONS_PER_SERVER, OPT_NUM_REGIONS_PER_SERVER_USAGE);
        this.addOptWithArg(OPT_REGION_REPLICATION, OPT_REGION_REPLICATION_USAGE);
        this.addOptWithArg(OPT_REGION_REPLICA_ID, OPT_REGION_REPLICA_ID_USAGE);
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        int colIndex;
        this.cmd = cmd;
        this.tableName = TableName.valueOf(cmd.getOptionValue(OPT_TABLE_NAME, DEFAULT_TABLE_NAME));
        if (cmd.hasOption(OPT_COLUMN_FAMILIES)) {
            String[] list = cmd.getOptionValue(OPT_COLUMN_FAMILIES).split(",");
            this.families = new byte[list.length][];
            for (int i = 0; i < list.length; ++i) {
                this.families[i] = Bytes.toBytes(list[i]);
            }
        } else {
            this.families = DEFAULT_COLUMN_FAMILIES;
        }
        this.isVerbose = cmd.hasOption(OPT_VERBOSE);
        this.isWrite = cmd.hasOption(OPT_WRITE);
        this.isRead = cmd.hasOption(OPT_READ);
        this.isUpdate = cmd.hasOption(OPT_UPDATE);
        this.isInitOnly = cmd.hasOption(OPT_INIT_ONLY);
        this.deferredLogFlush = cmd.hasOption(OPT_DEFERRED_LOG_FLUSH);
        if (!(this.isWrite || this.isRead || this.isUpdate || this.isInitOnly)) {
            throw new IllegalArgumentException("Either -write or -update or -read has to be specified");
        }
        if (this.isInitOnly && (this.isRead || this.isWrite || this.isUpdate)) {
            throw new IllegalArgumentException("init_only cannot be specified with either -write or -update or -read");
        }
        if (!this.isInitOnly) {
            if (!cmd.hasOption(OPT_NUM_KEYS)) {
                throw new IllegalArgumentException("num_keys must be specified in read or write mode");
            }
            this.startKey = LoadTestTool.parseLong(cmd.getOptionValue(OPT_START_KEY, String.valueOf(0L)), 0L, Long.MAX_VALUE);
            long numKeys = LoadTestTool.parseLong(cmd.getOptionValue(OPT_NUM_KEYS), 1L, Long.MAX_VALUE - this.startKey);
            this.endKey = this.startKey + numKeys;
            this.isSkipInit = cmd.hasOption(OPT_SKIP_INIT);
            System.out.println("Key range: [" + this.startKey + ".." + (this.endKey - 1L) + "]");
        }
        this.parseColumnFamilyOptions(cmd);
        if (this.isWrite) {
            String[] writeOpts = this.splitColonSeparated(OPT_WRITE, 2, 3);
            colIndex = 0;
            this.minColsPerKey = 1;
            this.maxColsPerKey = 2 * Integer.parseInt(writeOpts[colIndex++]);
            int avgColDataSize = LoadTestTool.parseInt(writeOpts[colIndex++], 1, Integer.MAX_VALUE);
            this.minColDataSize = avgColDataSize / 2;
            this.maxColDataSize = avgColDataSize * 3 / 2;
            if (colIndex < writeOpts.length) {
                this.numWriterThreads = this.getNumThreads(writeOpts[colIndex++]);
            }
            this.isMultiPut = cmd.hasOption(OPT_MULTIPUT);
            System.out.println("Multi-puts: " + this.isMultiPut);
            System.out.println("Columns per key: " + this.minColsPerKey + ".." + this.maxColsPerKey);
            System.out.println("Data size per column: " + this.minColDataSize + ".." + this.maxColDataSize);
        }
        if (this.isUpdate) {
            String[] mutateOpts = this.splitColonSeparated(OPT_UPDATE, 1, 3);
            colIndex = 0;
            this.updatePercent = LoadTestTool.parseInt(mutateOpts[colIndex++], 0, 100);
            if (colIndex < mutateOpts.length) {
                this.numUpdaterThreads = this.getNumThreads(mutateOpts[colIndex++]);
            }
            if (colIndex < mutateOpts.length) {
                this.ignoreConflicts = LoadTestTool.parseInt(mutateOpts[colIndex++], 0, 1) == 1;
            }
            this.isBatchUpdate = cmd.hasOption(OPT_BATCHUPDATE);
            System.out.println("Batch updates: " + this.isBatchUpdate);
            System.out.println("Percent of keys to update: " + this.updatePercent);
            System.out.println("Updater threads: " + this.numUpdaterThreads);
            System.out.println("Ignore nonce conflicts: " + this.ignoreConflicts);
        }
        if (this.isRead) {
            String[] readOpts = this.splitColonSeparated(OPT_READ, 1, 2);
            colIndex = 0;
            this.verifyPercent = LoadTestTool.parseInt(readOpts[colIndex++], 0, 100);
            if (colIndex < readOpts.length) {
                this.numReaderThreads = this.getNumThreads(readOpts[colIndex++]);
            }
            if (cmd.hasOption(OPT_MAX_READ_ERRORS)) {
                this.maxReadErrors = LoadTestTool.parseInt(cmd.getOptionValue(OPT_MAX_READ_ERRORS), 0, Integer.MAX_VALUE);
            }
            if (cmd.hasOption(OPT_KEY_WINDOW)) {
                this.keyWindow = LoadTestTool.parseInt(cmd.getOptionValue(OPT_KEY_WINDOW), 0, Integer.MAX_VALUE);
            }
            if (cmd.hasOption(OPT_MULTIGET)) {
                this.multiGetBatchSize = LoadTestTool.parseInt(cmd.getOptionValue(OPT_MULTIGET), 0, Integer.MAX_VALUE);
            }
            System.out.println("Multi-gets (value of 1 means no multigets): " + this.multiGetBatchSize);
            System.out.println("Percent of keys to verify: " + this.verifyPercent);
            System.out.println("Reader threads: " + this.numReaderThreads);
        }
        this.numTables = 1;
        if (cmd.hasOption(NUM_TABLES)) {
            this.numTables = LoadTestTool.parseInt(cmd.getOptionValue(NUM_TABLES), 1, Short.MAX_VALUE);
        }
        this.numRegionsPerServer = DEFAULT_NUM_REGIONS_PER_SERVER;
        if (cmd.hasOption(OPT_NUM_REGIONS_PER_SERVER)) {
            this.numRegionsPerServer = Integer.parseInt(cmd.getOptionValue(OPT_NUM_REGIONS_PER_SERVER));
        }
        this.regionReplication = 1;
        if (cmd.hasOption(OPT_REGION_REPLICATION)) {
            this.regionReplication = Integer.parseInt(cmd.getOptionValue(OPT_REGION_REPLICATION));
        }
        this.regionReplicaId = -1;
        if (cmd.hasOption(OPT_REGION_REPLICA_ID)) {
            this.regionReplicaId = Integer.parseInt(cmd.getOptionValue(OPT_REGION_REPLICA_ID));
        }
    }

    private void parseColumnFamilyOptions(CommandLine cmd) {
        String dataBlockEncodingStr = cmd.getOptionValue(OPT_DATA_BLOCK_ENCODING);
        this.dataBlockEncodingAlgo = dataBlockEncodingStr == null ? null : DataBlockEncoding.valueOf(dataBlockEncodingStr);
        String compressStr = cmd.getOptionValue(OPT_COMPRESSION);
        this.compressAlgo = compressStr == null ? Compression.Algorithm.NONE : Compression.Algorithm.valueOf(compressStr);
        String bloomStr = cmd.getOptionValue(OPT_BLOOM);
        this.bloomType = bloomStr == null ? BloomType.ROW : BloomType.valueOf(bloomStr);
        this.inMemoryCF = cmd.hasOption(OPT_INMEMORY);
        if (cmd.hasOption(OPT_ENCRYPTION)) {
            this.cipher = Encryption.getCipher(this.conf, cmd.getOptionValue(OPT_ENCRYPTION));
        }
    }

    public void initTestTable() throws IOException {
        Durability durability = Durability.USE_DEFAULT;
        if (this.deferredLogFlush) {
            durability = Durability.ASYNC_WAL;
        }
        HBaseTestingUtility.createPreSplitLoadTestTable(this.conf, this.tableName, this.getColumnFamilies(), this.compressAlgo, this.dataBlockEncodingAlgo, this.numRegionsPerServer, this.regionReplication, durability);
        this.applyColumnFamilyOptions(this.tableName, this.getColumnFamilies());
    }

    @Override
    protected int doWork() throws IOException {
        if (!this.isVerbose) {
            LogManager.getLogger((String)ZooKeeper.class.getName()).setLevel(Level.WARN);
        }
        if (this.numTables > 1) {
            return this.parallelLoadTables();
        }
        return this.loadTable();
    }

    protected int loadTable() throws IOException {
        if (this.cmd.hasOption(OPT_ZK_QUORUM)) {
            this.conf.set("hbase.zookeeper.quorum", this.cmd.getOptionValue(OPT_ZK_QUORUM));
        }
        if (this.cmd.hasOption(OPT_ZK_PARENT_NODE)) {
            this.conf.set("zookeeper.znode.parent", this.cmd.getOptionValue(OPT_ZK_PARENT_NODE));
        }
        if (this.isInitOnly) {
            LOG.info((Object)"Initializing only; no reads or writes");
            this.initTestTable();
            return 0;
        }
        if (!this.isSkipInit) {
            this.initTestTable();
        }
        LoadTestDataGenerator dataGen = null;
        if (this.cmd.hasOption(OPT_GENERATOR)) {
            String[] args;
            String[] clazzAndArgs = this.cmd.getOptionValue(OPT_GENERATOR).split(COLON);
            dataGen = this.getLoadGeneratorInstance(clazzAndArgs[0]);
            if (dataGen instanceof LoadTestDataGeneratorWithACL) {
                LOG.info((Object)"Using LoadTestDataGeneratorWithACL");
                if (User.isHBaseSecurityEnabled(this.conf)) {
                    LOG.info((Object)"Security is enabled");
                    this.authnFileName = clazzAndArgs[1];
                    this.superUser = clazzAndArgs[2];
                    this.userNames = clazzAndArgs[3];
                    args = Arrays.copyOfRange(clazzAndArgs, 2, clazzAndArgs.length);
                    Properties authConfig = new Properties();
                    authConfig.load(this.getClass().getClassLoader().getResourceAsStream(this.authnFileName));
                    try {
                        this.addAuthInfoToConf(authConfig, this.conf, this.superUser, this.userNames);
                    }
                    catch (IOException exp) {
                        LOG.error((Object)exp);
                        return 1;
                    }
                    this.userOwner = User.create(LoadTestTool.loginAndReturnUGI(this.conf, this.superUser));
                } else {
                    this.superUser = clazzAndArgs[1];
                    this.userNames = clazzAndArgs[2];
                    args = Arrays.copyOfRange(clazzAndArgs, 1, clazzAndArgs.length);
                    this.userOwner = User.createUserForTesting(this.conf, this.superUser, new String[0]);
                }
            } else {
                args = clazzAndArgs.length == 1 ? new String[]{} : Arrays.copyOfRange(clazzAndArgs, 1, clazzAndArgs.length);
            }
            dataGen.initialize(args);
        } else {
            dataGen = new MultiThreadedAction.DefaultDataGenerator(this.minColDataSize, this.maxColDataSize, this.minColsPerKey, this.maxColsPerKey, this.families);
        }
        if (this.userOwner != null) {
            LOG.info((Object)("Granting permissions for user " + this.userOwner.getShortName()));
            Permission.Action[] actions = new Permission.Action[]{Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE};
            try {
                AccessControlClient.grant(ConnectionFactory.createConnection(this.conf), this.tableName, this.userOwner.getShortName(), null, null, actions);
            }
            catch (Throwable e) {
                LOG.fatal((Object)("Error in granting permission for the user " + this.userOwner.getShortName()), e);
                return 1;
            }
        }
        if (this.userNames != null) {
            String[] users = this.userNames.split(",");
            User user = null;
            for (String userStr : users) {
                user = User.isHBaseSecurityEnabled(this.conf) ? User.create(LoadTestTool.loginAndReturnUGI(this.conf, userStr)) : User.createUserForTesting(this.conf, userStr, new String[0]);
            }
        }
        if (this.isWrite) {
            if (this.userOwner != null) {
                this.writerThreads = new MultiThreadedWriterWithACL(dataGen, this.conf, this.tableName, this.userOwner);
            } else {
                String writerClass = null;
                writerClass = this.cmd.hasOption(OPT_WRITER) ? this.cmd.getOptionValue(OPT_WRITER) : MultiThreadedWriter.class.getCanonicalName();
                this.writerThreads = this.getMultiThreadedWriterInstance(writerClass, dataGen);
            }
            this.writerThreads.setMultiPut(this.isMultiPut);
        }
        if (this.isUpdate) {
            if (this.userOwner != null) {
                this.updaterThreads = new MultiThreadedUpdaterWithACL(dataGen, this.conf, this.tableName, this.updatePercent, this.userOwner, this.userNames);
            } else {
                String updaterClass = null;
                updaterClass = this.cmd.hasOption(OPT_UPDATER) ? this.cmd.getOptionValue(OPT_UPDATER) : MultiThreadedUpdater.class.getCanonicalName();
                this.updaterThreads = this.getMultiThreadedUpdaterInstance(updaterClass, dataGen);
            }
            this.updaterThreads.setBatchUpdate(this.isBatchUpdate);
            this.updaterThreads.setIgnoreNonceConflicts(this.ignoreConflicts);
        }
        if (this.isRead) {
            if (this.userOwner != null) {
                this.readerThreads = new MultiThreadedReaderWithACL(dataGen, this.conf, this.tableName, this.verifyPercent, this.userNames);
            } else {
                String readerClass = null;
                readerClass = this.cmd.hasOption(OPT_READER) ? this.cmd.getOptionValue(OPT_READER) : MultiThreadedReader.class.getCanonicalName();
                this.readerThreads = this.getMultiThreadedReaderInstance(readerClass, dataGen);
            }
            this.readerThreads.setMaxErrors(this.maxReadErrors);
            this.readerThreads.setKeyWindow(this.keyWindow);
            this.readerThreads.setMultiGetBatchSize(this.multiGetBatchSize);
            this.readerThreads.setRegionReplicaId(this.regionReplicaId);
        }
        if (this.isUpdate && this.isWrite) {
            LOG.info((Object)"Concurrent write/update workload: making updaters aware of the write point");
            this.updaterThreads.linkToWriter(this.writerThreads);
        }
        if (this.isRead && (this.isUpdate || this.isWrite)) {
            LOG.info((Object)"Concurrent write/read workload: making readers aware of the write point");
            this.readerThreads.linkToWriter(this.isUpdate ? this.updaterThreads : this.writerThreads);
        }
        if (this.isWrite) {
            System.out.println("Starting to write data...");
            this.writerThreads.start(this.startKey, this.endKey, this.numWriterThreads);
        }
        if (this.isUpdate) {
            LOG.info((Object)"Starting to mutate data...");
            System.out.println("Starting to mutate data...");
            this.updaterThreads.start(this.startKey, this.endKey, this.numUpdaterThreads);
        }
        if (this.isRead) {
            System.out.println("Starting to read data...");
            this.readerThreads.start(this.startKey, this.endKey, this.numReaderThreads);
        }
        if (this.isWrite) {
            this.writerThreads.waitForFinish();
        }
        if (this.isUpdate) {
            this.updaterThreads.waitForFinish();
        }
        if (this.isRead) {
            this.readerThreads.waitForFinish();
        }
        boolean success = true;
        if (this.isWrite) {
            boolean bl = success = success && this.writerThreads.getNumWriteFailures() == 0;
        }
        if (this.isUpdate) {
            boolean bl = success = success && this.updaterThreads.getNumWriteFailures() == 0;
        }
        if (this.isRead) {
            success = success && this.readerThreads.getNumReadErrors() == 0L && this.readerThreads.getNumReadFailures() == 0L;
        }
        return success ? 0 : 1;
    }

    private LoadTestDataGenerator getLoadGeneratorInstance(String clazzName) throws IOException {
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[][].class);
            return (LoadTestDataGenerator)constructor.newInstance(new Object[]{this.minColDataSize, this.maxColDataSize, this.minColsPerKey, this.maxColsPerKey, this.families});
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private MultiThreadedWriter getMultiThreadedWriterInstance(String clazzName, LoadTestDataGenerator dataGen) throws IOException {
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> constructor = clazz.getConstructor(LoadTestDataGenerator.class, Configuration.class, TableName.class);
            return (MultiThreadedWriter)constructor.newInstance(dataGen, this.conf, this.tableName);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private MultiThreadedUpdater getMultiThreadedUpdaterInstance(String clazzName, LoadTestDataGenerator dataGen) throws IOException {
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> constructor = clazz.getConstructor(LoadTestDataGenerator.class, Configuration.class, TableName.class, Double.TYPE);
            return (MultiThreadedUpdater)constructor.newInstance(dataGen, this.conf, this.tableName, this.updatePercent);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private MultiThreadedReader getMultiThreadedReaderInstance(String clazzName, LoadTestDataGenerator dataGen) throws IOException {
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> constructor = clazz.getConstructor(LoadTestDataGenerator.class, Configuration.class, TableName.class, Double.TYPE);
            return (MultiThreadedReader)constructor.newInstance(dataGen, this.conf, this.tableName, this.verifyPercent);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static byte[] generateData(Random r, int length) {
        byte[] b = new byte[length];
        int i = 0;
        for (i = 0; i < length - 8; i += 8) {
            b[i] = (byte)(65 + r.nextInt(26));
            b[i + 1] = b[i];
            b[i + 2] = b[i];
            b[i + 3] = b[i];
            b[i + 4] = b[i];
            b[i + 5] = b[i];
            b[i + 6] = b[i];
            b[i + 7] = b[i];
        }
        byte a = (byte)(65 + r.nextInt(26));
        while (i < length) {
            b[i] = a;
            ++i;
        }
        return b;
    }

    public static void main(String[] args) {
        new LoadTestTool().doStaticMain(args);
    }

    private int parallelLoadTables() throws IOException {
        String tableName = this.cmd.getOptionValue(OPT_TABLE_NAME, DEFAULT_TABLE_NAME);
        String[] newArgs = null;
        if (!this.cmd.hasOption(OPT_TABLE_NAME)) {
            newArgs = new String[this.cmdLineArgs.length + 2];
            newArgs[0] = "-tn";
            newArgs[1] = DEFAULT_TABLE_NAME;
            System.arraycopy(this.cmdLineArgs, 0, newArgs, 2, this.cmdLineArgs.length);
        } else {
            newArgs = this.cmdLineArgs;
        }
        int tableNameValueIndex = -1;
        for (int j = 0; j < newArgs.length; ++j) {
            if (newArgs[j].endsWith(OPT_TABLE_NAME)) {
                tableNameValueIndex = j + 1;
                continue;
            }
            if (!newArgs[j].endsWith(NUM_TABLES)) continue;
            newArgs[j + 1] = "1";
        }
        ArrayList<WorkerThread> workers = new ArrayList<WorkerThread>();
        for (int i = 0; i < this.numTables; ++i) {
            String[] workerArgs = (String[])newArgs.clone();
            workerArgs[tableNameValueIndex] = tableName + "_" + (i + 1);
            WorkerThread worker = new WorkerThread(i, workerArgs);
            workers.add(worker);
            LOG.info((Object)(worker + " starting"));
            worker.start();
        }
        LOG.info((Object)"Waiting for worker threads to finish");
        for (WorkerThread t : workers) {
            try {
                t.join();
            }
            catch (InterruptedException ie) {
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(ie);
                throw iie;
            }
            this.checkForErrors();
        }
        return 0;
    }

    private void workerThreadError(Throwable t) {
        this.thrown.compareAndSet(null, t);
    }

    private void checkForErrors() throws IOException {
        Throwable thrown = this.thrown.get();
        if (thrown == null) {
            return;
        }
        if (thrown instanceof IOException) {
            throw (IOException)thrown;
        }
        throw new RuntimeException(thrown);
    }

    private void addAuthInfoToConf(Properties authConfig, Configuration conf, String owner, String userList) throws IOException {
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(userList.split(",")));
        users.add(owner);
        for (String user : users) {
            String keyTabFileConfKey = "hbase." + user + ".keytab.file";
            String principalConfKey = "hbase." + user + ".kerberos.principal";
            if (authConfig.containsKey(keyTabFileConfKey) && authConfig.containsKey(principalConfKey)) continue;
            throw new IOException("Authentication configs missing for user : " + user);
        }
        for (String key : authConfig.stringPropertyNames()) {
            conf.set(key, authConfig.getProperty(key));
        }
        LOG.debug((Object)"Added authentication properties to config successfully.");
    }

    public static UserGroupInformation loginAndReturnUGI(Configuration conf, String username) throws IOException {
        String hostname = InetAddress.getLocalHost().getHostName();
        String keyTabFileConfKey = "hbase." + username + ".keytab.file";
        String keyTabFileLocation = conf.get(keyTabFileConfKey);
        String principalConfKey = "hbase." + username + ".kerberos.principal";
        String principal = SecurityUtil.getServerPrincipal((String)conf.get(principalConfKey), (String)hostname);
        if (keyTabFileLocation == null || principal == null) {
            LOG.warn((Object)("Principal or key tab file null for : " + principalConfKey + ", " + keyTabFileConfKey));
        }
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keyTabFileLocation);
        return ugi;
    }

    class WorkerThread
    extends Thread {
        private String[] workerArgs;

        WorkerThread(int i, String[] args) {
            super("WorkerThread-" + i);
            this.workerArgs = args;
        }

        @Override
        public void run() {
            try {
                int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new LoadTestTool(), (String[])this.workerArgs);
                if (ret != 0) {
                    throw new RuntimeException("LoadTestTool exit with non-zero return code.");
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error in worker thread", (Throwable)ex);
                LoadTestTool.this.workerThreadError(ex);
            }
        }
    }
}

