/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MD5Hash;

@InterfaceAudience.Private
public class LoadTestKVGenerator {
    private static final Log LOG = LogFactory.getLog(LoadTestKVGenerator.class);
    private static int logLimit = 10;
    private Random randomForValueSize = new Random();
    private final int minValueSize;
    private final int maxValueSize;

    public LoadTestKVGenerator(int minValueSize, int maxValueSize) {
        if (minValueSize <= 0 || maxValueSize <= 0) {
            throw new IllegalArgumentException("Invalid min/max value sizes: " + minValueSize + ", " + maxValueSize);
        }
        this.minValueSize = minValueSize;
        this.maxValueSize = maxValueSize;
    }

    public static boolean verify(byte[] value, byte[] ... seedStrings) {
        byte[] expectedData = LoadTestKVGenerator.getValueForRowColumn(value.length, seedStrings);
        boolean equals = Bytes.equals(expectedData, value);
        if (!equals && LOG.isDebugEnabled() && logLimit > 0) {
            LOG.debug((Object)("verify failed, expected value: " + Bytes.toStringBinary(expectedData) + " actual value: " + Bytes.toStringBinary(value)));
            --logLimit;
        }
        return equals;
    }

    public static String md5PrefixedKey(long key) {
        String stringKey = Long.toString(key);
        String md5hash = MD5Hash.getMD5AsHex(Bytes.toBytes(stringKey));
        return md5hash + "-" + stringKey;
    }

    public byte[] generateRandomSizeValue(byte[] ... seedStrings) {
        int dataSize = this.minValueSize;
        if (this.minValueSize != this.maxValueSize) {
            dataSize = this.minValueSize + this.randomForValueSize.nextInt(Math.abs(this.maxValueSize - this.minValueSize));
        }
        return LoadTestKVGenerator.getValueForRowColumn(dataSize, seedStrings);
    }

    private static byte[] getValueForRowColumn(int dataSize, byte[] ... seedStrings) {
        long seed = dataSize;
        for (byte[] str : seedStrings) {
            String bytesString = Bytes.toString(str);
            if (bytesString == null) continue;
            seed += (long)bytesString.hashCode();
        }
        Random seededRandom = new Random(seed);
        byte[] randomBytes = new byte[dataSize];
        seededRandom.nextBytes(randomBytes);
        return randomBytes;
    }
}

