/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.snapshot.FlushSnapshotSubprocedure;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotManifestV2;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestRegionSnapshotTask {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration conf;
    private static FileSystem fs;
    private static Path rootDir;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hfile.compaction.discharger.interval", 1000);
        conf.setInt("hbase.master.hfilecleaner.ttl", 1000);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        rootDir = FSUtils.getRootDir(conf);
        fs = TEST_UTIL.getTestFileSystem();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=30000L)
    public void testAddRegionWithCompactions() throws Exception {
        TableName tableName = TableName.valueOf("test_table");
        Table table = this.setupTable(tableName);
        List<HRegion> hRegions = TEST_UTIL.getHBaseCluster().getRegions(tableName);
        final HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setTable(tableName.getNameAsString()).setType(HBaseProtos.SnapshotDescription.Type.FLUSH).setName("test_table_snapshot").setVersion(2).build();
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(snapshot.getName());
        final HRegion region = (HRegion)Mockito.spy((Object)hRegions.get(0));
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, rootDir, conf);
        final SnapshotManifest manifest = SnapshotManifest.create(conf, fs, workingDir, snapshot, monitor);
        manifest.addTableDescriptor(table.getTableDescriptor());
        if (!fs.exists(workingDir)) {
            fs.mkdirs(workingDir);
        }
        Assert.assertTrue((boolean)fs.exists(workingDir));
        SnapshotDescriptionUtils.writeSnapshotInfo(snapshot, workingDir, fs);
        ((HRegion)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                TestRegionSnapshotTask.this.addRegionToSnapshot(snapshot, region, manifest);
                return null;
            }
        }).when((Object)region)).addRegionToSnapshot(snapshot, monitor);
        FlushSnapshotSubprocedure.RegionSnapshotTask snapshotTask = new FlushSnapshotSubprocedure.RegionSnapshotTask(region, snapshot, true, monitor);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<Void> f = executor.submit(snapshotTask);
        this.LOG.info((Object)"Starting major compaction");
        region.compact(true);
        this.LOG.info((Object)"Finished major compaction");
        f.get();
        manifest.consolidate();
        Assert.assertNotNull(manifest.getRegionManifests());
        Assert.assertEquals((long)1L, (long)manifest.getRegionManifests().size());
        SnapshotReferenceUtil.verifySnapshot(conf, fs, manifest);
    }

    private void addRegionToSnapshot(HBaseProtos.SnapshotDescription snapshot, HRegion region, SnapshotManifest manifest) throws Exception {
        this.LOG.info((Object)("Adding region to snapshot: " + region.getRegionInfo().getRegionNameAsString()));
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, rootDir, conf);
        SnapshotManifest.RegionVisitor visitor = this.createRegionVisitorWithDelay(snapshot, workingDir);
        manifest.addRegion(region, visitor);
        this.LOG.info((Object)("Added the region to snapshot: " + region.getRegionInfo().getRegionNameAsString()));
    }

    private SnapshotManifest.RegionVisitor createRegionVisitorWithDelay(HBaseProtos.SnapshotDescription desc, Path workingDir) {
        return new SnapshotManifestV2.ManifestBuilder(conf, fs, workingDir){

            @Override
            public void storeFile(SnapshotProtos.SnapshotRegionManifest.Builder region, SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder family, StoreFileInfo storeFile) throws IOException {
                try {
                    TestRegionSnapshotTask.this.LOG.debug((Object)"Introducing delay before adding store file to manifest");
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    TestRegionSnapshotTask.this.LOG.error((Object)("Interrupted due to error: " + ex));
                }
                super.storeFile(region, family, storeFile);
            }
        };
    }

    private Table setupTable(TableName tableName) throws Exception {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.setMemStoreFlushSize(5000L).setConfiguration("hbase.hstore.compactionThreshold", "250");
        htd.setRegionSplitPolicyClassName(ConstantSizeRegionSplitPolicy.class.getName());
        htd.setMaxFileSize(0x6400000L);
        byte[] fam = Bytes.toBytes("fam");
        HTable table = TEST_UTIL.createTable(htd, (byte[][])new byte[][]{fam}, TEST_UTIL.getConfiguration());
        TEST_UTIL.loadTable((Table)table, fam);
        return table;
    }
}

