/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import drill.shaded.hbase.guava.com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class RestoreSnapshotHelper {
    private static final Log LOG = LogFactory.getLog(RestoreSnapshotHelper.class);
    private final Map<byte[], byte[]> regionsMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    private final Map<String, Pair<String, String>> parentsMap = new HashMap<String, Pair<String, String>>();
    private final ForeignExceptionDispatcher monitor;
    private final MonitoredTask status;
    private final SnapshotManifest snapshotManifest;
    private final HBaseProtos.SnapshotDescription snapshotDesc;
    private final TableName snapshotTable;
    private final HTableDescriptor tableDesc;
    private final Path rootDir;
    private final Path tableDir;
    private final Configuration conf;
    private final FileSystem fs;
    private final boolean createBackRefs;

    public RestoreSnapshotHelper(Configuration conf, FileSystem fs, SnapshotManifest manifest, HTableDescriptor tableDescriptor, Path rootDir, ForeignExceptionDispatcher monitor, MonitoredTask status) {
        this(conf, fs, manifest, tableDescriptor, rootDir, monitor, status, true);
    }

    public RestoreSnapshotHelper(Configuration conf, FileSystem fs, SnapshotManifest manifest, HTableDescriptor tableDescriptor, Path rootDir, ForeignExceptionDispatcher monitor, MonitoredTask status, boolean createBackRefs) {
        this.fs = fs;
        this.conf = conf;
        this.snapshotManifest = manifest;
        this.snapshotDesc = manifest.getSnapshotDescription();
        this.snapshotTable = TableName.valueOf(this.snapshotDesc.getTable());
        this.tableDesc = tableDescriptor;
        this.rootDir = rootDir;
        this.tableDir = FSUtils.getTableDir(rootDir, this.tableDesc.getTableName());
        this.monitor = monitor;
        this.status = status;
        this.createBackRefs = createBackRefs;
    }

    public RestoreMetaChanges restoreHdfsRegions() throws IOException {
        ThreadPoolExecutor exec = SnapshotManifest.createExecutor(this.conf, "RestoreSnapshot");
        try {
            RestoreMetaChanges restoreMetaChanges = this.restoreHdfsRegions(exec);
            return restoreMetaChanges;
        }
        finally {
            exec.shutdown();
        }
    }

    private RestoreMetaChanges restoreHdfsRegions(ThreadPoolExecutor exec) throws IOException {
        LOG.debug((Object)"starting restore");
        Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests = this.snapshotManifest.getRegionManifestsMap();
        if (regionManifests == null) {
            LOG.warn((Object)("Nothing to restore. Snapshot " + this.snapshotDesc + " looks empty"));
            return null;
        }
        RestoreMetaChanges metaChanges = new RestoreMetaChanges(this.tableDesc, this.parentsMap);
        HashSet<String> regionNames = new HashSet<String>(regionManifests.keySet());
        List<HRegionInfo> tableRegions = this.getTableRegions();
        if (tableRegions != null) {
            this.monitor.rethrowException();
            for (HRegionInfo hRegionInfo : tableRegions) {
                String regionName = hRegionInfo.getEncodedName();
                if (regionNames.contains(regionName)) {
                    LOG.info((Object)("region to restore: " + regionName));
                    regionNames.remove(regionName);
                    metaChanges.addRegionToRestore(HRegionInfo.convert(regionManifests.get(regionName).getRegionInfo()));
                    continue;
                }
                LOG.info((Object)("region to remove: " + regionName));
                metaChanges.addRegionToRemove(hRegionInfo);
            }
        }
        ArrayList<HRegionInfo> regionsToAdd = new ArrayList<HRegionInfo>(regionNames.size());
        if (regionNames.size() > 0) {
            this.monitor.rethrowException();
            for (String regionName : regionNames) {
                LOG.info((Object)("region to add: " + regionName));
                regionsToAdd.add(HRegionInfo.convert(regionManifests.get(regionName).getRegionInfo()));
            }
        }
        this.monitor.rethrowException();
        this.status.setStatus("Cloning regions...");
        HRegionInfo[] hRegionInfoArray = this.cloneHdfsRegions(exec, regionManifests, regionsToAdd);
        metaChanges.setNewRegions(hRegionInfoArray);
        this.status.setStatus("Finished cloning regions.");
        this.monitor.rethrowException();
        this.status.setStatus("Restoring table regions...");
        this.restoreHdfsRegions(exec, regionManifests, metaChanges.getRegionsToRestore());
        this.status.setStatus("Finished restoring all table regions.");
        this.monitor.rethrowException();
        this.status.setStatus("Starting to delete excess regions from table");
        this.removeHdfsRegions(exec, metaChanges.getRegionsToRemove());
        this.status.setStatus("Finished deleting excess regions from table.");
        return metaChanges;
    }

    private void removeHdfsRegions(ThreadPoolExecutor exec, List<HRegionInfo> regions) throws IOException {
        if (regions == null || regions.size() == 0) {
            return;
        }
        ModifyRegionUtils.editRegions(exec, regions, new ModifyRegionUtils.RegionEditTask(){

            @Override
            public void editRegion(HRegionInfo hri) throws IOException {
                HFileArchiver.archiveRegion(RestoreSnapshotHelper.this.conf, RestoreSnapshotHelper.this.fs, hri);
            }
        });
    }

    private void restoreHdfsRegions(ThreadPoolExecutor exec, final Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests, List<HRegionInfo> regions) throws IOException {
        if (regions == null || regions.size() == 0) {
            return;
        }
        ModifyRegionUtils.editRegions(exec, regions, new ModifyRegionUtils.RegionEditTask(){

            @Override
            public void editRegion(HRegionInfo hri) throws IOException {
                RestoreSnapshotHelper.this.restoreRegion(hri, (SnapshotProtos.SnapshotRegionManifest)regionManifests.get(hri.getEncodedName()));
            }
        });
    }

    private Map<String, List<SnapshotProtos.SnapshotRegionManifest.StoreFile>> getRegionHFileReferences(SnapshotProtos.SnapshotRegionManifest manifest) {
        HashMap<String, List<SnapshotProtos.SnapshotRegionManifest.StoreFile>> familyMap = new HashMap<String, List<SnapshotProtos.SnapshotRegionManifest.StoreFile>>(manifest.getFamilyFilesCount());
        for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles familyFiles : manifest.getFamilyFilesList()) {
            familyMap.put(familyFiles.getFamilyName().toStringUtf8(), new ArrayList<SnapshotProtos.SnapshotRegionManifest.StoreFile>(familyFiles.getStoreFilesList()));
        }
        return familyMap;
    }

    private void restoreRegion(HRegionInfo regionInfo, SnapshotProtos.SnapshotRegionManifest regionManifest) throws IOException {
        Map<String, List<SnapshotProtos.SnapshotRegionManifest.StoreFile>> snapshotFiles = this.getRegionHFileReferences(regionManifest);
        Path regionDir = new Path(this.tableDir, regionInfo.getEncodedName());
        String tableName = this.tableDesc.getTableName().getNameAsString();
        for (Path path : FSUtils.getFamilyDirs(this.fs, regionDir)) {
            byte[] family = Bytes.toBytes(path.getName());
            Set<String> familyFiles = this.getTableRegionFamilyFiles(path);
            List<SnapshotProtos.SnapshotRegionManifest.StoreFile> snapshotFamilyFiles = snapshotFiles.remove(path.getName());
            if (snapshotFamilyFiles != null) {
                ArrayList<SnapshotProtos.SnapshotRegionManifest.StoreFile> hfilesToAdd = new ArrayList<SnapshotProtos.SnapshotRegionManifest.StoreFile>();
                for (SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile : snapshotFamilyFiles) {
                    if (familyFiles.contains(storeFile.getName())) {
                        familyFiles.remove(storeFile.getName());
                        continue;
                    }
                    hfilesToAdd.add(storeFile);
                }
                for (String hfileName : familyFiles) {
                    Path hfile = new Path(path, hfileName);
                    LOG.trace((Object)("Removing hfile=" + hfileName + " from region=" + regionInfo.getEncodedName() + " table=" + tableName));
                    HFileArchiver.archiveStoreFile(this.conf, this.fs, regionInfo, this.tableDir, family, hfile);
                }
                for (SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile : hfilesToAdd) {
                    LOG.debug((Object)("Adding HFileLink " + storeFile.getName() + " to region=" + regionInfo.getEncodedName() + " table=" + tableName));
                    this.restoreStoreFile(path, regionInfo, storeFile, this.createBackRefs);
                }
                continue;
            }
            LOG.trace((Object)("Removing family=" + Bytes.toString(family) + " from region=" + regionInfo.getEncodedName() + " table=" + tableName));
            HFileArchiver.archiveFamily(this.fs, this.conf, regionInfo, this.tableDir, family);
            LOG.info((Object)("Deleting: " + path));
            this.fs.delete(path, true);
        }
        for (Map.Entry entry : snapshotFiles.entrySet()) {
            Path familyDir = new Path(regionDir, (String)entry.getKey());
            LOG.info((Object)("Creating directory: " + familyDir));
            if (!this.fs.mkdirs(familyDir)) {
                throw new IOException("Unable to create familyDir=" + familyDir);
            }
            for (SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile : (List)entry.getValue()) {
                LOG.trace((Object)("Adding HFileLink " + storeFile.getName() + " to table=" + tableName));
                this.restoreStoreFile(familyDir, regionInfo, storeFile, this.createBackRefs);
            }
        }
    }

    private Set<String> getTableRegionFamilyFiles(Path familyDir) throws IOException {
        FileStatus[] hfiles = FSUtils.listStatus(this.fs, familyDir);
        if (hfiles == null) {
            return Collections.emptySet();
        }
        HashSet<String> familyFiles = new HashSet<String>(hfiles.length);
        for (int i = 0; i < hfiles.length; ++i) {
            String hfileName = hfiles[i].getPath().getName();
            familyFiles.add(hfileName);
        }
        return familyFiles;
    }

    private HRegionInfo[] cloneHdfsRegions(ThreadPoolExecutor exec, final Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests, List<HRegionInfo> regions) throws IOException {
        if (regions == null || regions.size() == 0) {
            return null;
        }
        final HashMap<String, HRegionInfo> snapshotRegions = new HashMap<String, HRegionInfo>(regions.size());
        HRegionInfo[] clonedRegionsInfo = new HRegionInfo[regions.size()];
        for (int i = 0; i < clonedRegionsInfo.length; ++i) {
            HRegionInfo snapshotRegionInfo = regions.get(i);
            clonedRegionsInfo[i] = this.cloneRegionInfo(snapshotRegionInfo);
            String snapshotRegionName = snapshotRegionInfo.getEncodedName();
            String clonedRegionName = clonedRegionsInfo[i].getEncodedName();
            this.regionsMap.put(Bytes.toBytes(snapshotRegionName), Bytes.toBytes(clonedRegionName));
            LOG.info((Object)("clone region=" + snapshotRegionName + " as " + clonedRegionName));
            snapshotRegions.put(clonedRegionName, snapshotRegionInfo);
        }
        ModifyRegionUtils.createRegions(exec, this.conf, this.rootDir, this.tableDir, this.tableDesc, clonedRegionsInfo, new ModifyRegionUtils.RegionFillTask(){

            @Override
            public void fillRegion(HRegion region) throws IOException {
                HRegionInfo snapshotHri = (HRegionInfo)snapshotRegions.get(region.getRegionInfo().getEncodedName());
                RestoreSnapshotHelper.this.cloneRegion(region, snapshotHri, (SnapshotProtos.SnapshotRegionManifest)regionManifests.get(snapshotHri.getEncodedName()));
            }
        });
        return clonedRegionsInfo;
    }

    private void cloneRegion(HRegion region, HRegionInfo snapshotRegionInfo, SnapshotProtos.SnapshotRegionManifest manifest) throws IOException {
        Path regionDir = new Path(this.tableDir, region.getRegionInfo().getEncodedName());
        String tableName = this.tableDesc.getTableName().getNameAsString();
        for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles familyFiles : manifest.getFamilyFilesList()) {
            Path familyDir = new Path(regionDir, familyFiles.getFamilyName().toStringUtf8());
            for (SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile : familyFiles.getStoreFilesList()) {
                LOG.info((Object)("Adding HFileLink " + storeFile.getName() + " to table=" + tableName));
                this.restoreStoreFile(familyDir, snapshotRegionInfo, storeFile, this.createBackRefs);
            }
        }
    }

    private void restoreStoreFile(Path familyDir, HRegionInfo regionInfo, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile, boolean createBackRef) throws IOException {
        String hfileName = storeFile.getName();
        if (HFileLink.isHFileLink(hfileName)) {
            HFileLink.createFromHFileLink(this.conf, this.fs, familyDir, hfileName, createBackRef);
        } else if (StoreFileInfo.isReference(hfileName)) {
            this.restoreReferenceFile(familyDir, regionInfo, storeFile);
        } else {
            HFileLink.create(this.conf, this.fs, familyDir, regionInfo, hfileName, createBackRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreReferenceFile(Path familyDir, HRegionInfo regionInfo, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
        String hfileName = storeFile.getName();
        Path refPath = StoreFileInfo.getReferredToFile(new Path(new Path(new Path(new Path(this.snapshotTable.getNamespaceAsString(), this.snapshotTable.getQualifierAsString()), regionInfo.getEncodedName()), familyDir.getName()), hfileName));
        String snapshotRegionName = refPath.getParent().getParent().getName();
        String fileName = refPath.getName();
        String clonedRegionName = Bytes.toString(this.regionsMap.get(Bytes.toBytes(snapshotRegionName)));
        if (clonedRegionName == null) {
            clonedRegionName = snapshotRegionName;
        }
        Path linkPath = null;
        String refLink = fileName;
        if (!HFileLink.isHFileLink(fileName)) {
            refLink = HFileLink.createHFileLinkName(this.snapshotTable, snapshotRegionName, fileName);
            linkPath = new Path(familyDir, HFileLink.createHFileLinkName(this.snapshotTable, regionInfo.getEncodedName(), hfileName));
        }
        Path outPath = new Path(familyDir, refLink + '.' + clonedRegionName);
        if (storeFile.hasReference()) {
            Reference reference = Reference.convert(storeFile.getReference());
            reference.write(this.fs, outPath);
        } else {
            FSDataInputStream in;
            if (linkPath != null) {
                in = HFileLink.buildFromHFileLinkPattern(this.conf, linkPath).open(this.fs);
            } else {
                linkPath = new Path(new Path(new Path(this.snapshotManifest.getSnapshotDir(), regionInfo.getEncodedName()), familyDir.getName()), hfileName);
                in = this.fs.open(linkPath);
            }
            FSDataOutputStream out = this.fs.create(outPath);
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)this.conf);
        }
        String regionName = Bytes.toString(this.regionsMap.get(regionInfo.getEncodedNameAsBytes()));
        if (regionName == null) {
            regionName = regionInfo.getEncodedName();
        }
        LOG.debug((Object)("Restore reference " + regionName + " to " + clonedRegionName));
        Map<String, Pair<String, String>> map = this.parentsMap;
        synchronized (map) {
            Pair<String, String> daughters = this.parentsMap.get(clonedRegionName);
            if (daughters == null) {
                daughters = new Pair<String, String>(regionName, regionName);
                this.parentsMap.put(clonedRegionName, daughters);
            } else if (!regionName.equals(daughters.getFirst())) {
                daughters.setSecond(regionName);
            }
        }
    }

    public HRegionInfo cloneRegionInfo(HRegionInfo snapshotRegionInfo) {
        return RestoreSnapshotHelper.cloneRegionInfo(this.tableDesc.getTableName(), snapshotRegionInfo);
    }

    public static HRegionInfo cloneRegionInfo(TableName tableName, HRegionInfo snapshotRegionInfo) {
        HRegionInfo regionInfo = new HRegionInfo(tableName, snapshotRegionInfo.getStartKey(), snapshotRegionInfo.getEndKey(), snapshotRegionInfo.isSplit(), snapshotRegionInfo.getRegionId());
        regionInfo.setOffline(snapshotRegionInfo.isOffline());
        return regionInfo;
    }

    private List<HRegionInfo> getTableRegions() throws IOException {
        LOG.debug((Object)("get table regions: " + this.tableDir));
        FileStatus[] regionDirs = FSUtils.listStatus(this.fs, this.tableDir, new FSUtils.RegionDirFilter(this.fs));
        if (regionDirs == null) {
            return null;
        }
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(regionDirs.length);
        for (int i = 0; i < regionDirs.length; ++i) {
            HRegionInfo hri = HRegionFileSystem.loadRegionInfoFileContent(this.fs, regionDirs[i].getPath());
            regions.add(hri);
        }
        LOG.debug((Object)("found " + regions.size() + " regions for table=" + this.tableDesc.getTableName().getNameAsString()));
        return regions;
    }

    public static RestoreMetaChanges copySnapshotForScanner(Configuration conf, FileSystem fs, Path rootDir, Path restoreDir, String snapshotName) throws IOException {
        if (!restoreDir.getFileSystem(conf).getUri().equals(rootDir.getFileSystem(conf).getUri())) {
            throw new IllegalArgumentException("Filesystems for restore directory and HBase root directory should be the same");
        }
        if (restoreDir.toUri().getPath().startsWith(rootDir.toUri().getPath() + "/")) {
            throw new IllegalArgumentException("Restore directory cannot be a sub directory of HBase root directory. RootDir: " + rootDir + ", restoreDir: " + restoreDir);
        }
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir);
        HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir, snapshotDesc);
        MonitoredTask status = TaskMonitor.get().createStatus("Restoring  snapshot '" + snapshotName + "' to directory " + restoreDir);
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher();
        RestoreSnapshotHelper helper = new RestoreSnapshotHelper(conf, fs, manifest, manifest.getTableDescriptor(), restoreDir, monitor, status, false);
        RestoreMetaChanges metaChanges = helper.restoreHdfsRegions();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Restored table dir:" + restoreDir));
            FSUtils.logFileSystemState(fs, restoreDir, LOG);
        }
        return metaChanges;
    }

    public static void restoreSnapshotACL(HBaseProtos.SnapshotDescription snapshot, TableName newTableName, Configuration conf) throws IOException {
        if (snapshot.hasUsersAndPermissions()) {
            LOG.info((Object)("Restore snapshot acl to table. snapshot: " + snapshot + ", table: " + newTableName));
            ListMultimap<String, TablePermission> perms = ProtobufUtil.toUserTablePermissions(snapshot.getUsersAndPermissions());
            try {
                for (Map.Entry e : perms.entries()) {
                    String user = (String)e.getKey();
                    TablePermission perm = (TablePermission)((Object)e.getValue());
                    perm.setTableName(newTableName);
                    AccessControlClient.grant(conf, perm.getTableName(), user, perm.getFamily(), perm.getQualifier(), perm.getActions());
                }
            }
            catch (Throwable e) {
                throw new IOException("Grant acl into newly creatd table failed. snapshot: " + snapshot + ", table: " + newTableName, e);
            }
        }
    }

    public static class RestoreMetaChanges {
        private final Map<String, Pair<String, String>> parentsMap;
        private final HTableDescriptor htd;
        private List<HRegionInfo> regionsToRestore = null;
        private List<HRegionInfo> regionsToRemove = null;
        private List<HRegionInfo> regionsToAdd = null;

        RestoreMetaChanges(HTableDescriptor htd, Map<String, Pair<String, String>> parentsMap) {
            this.parentsMap = parentsMap;
            this.htd = htd;
        }

        public HTableDescriptor getTableDescriptor() {
            return this.htd;
        }

        public boolean hasRegionsToAdd() {
            return this.regionsToAdd != null && this.regionsToAdd.size() > 0;
        }

        public List<HRegionInfo> getRegionsToAdd() {
            return this.regionsToAdd;
        }

        public boolean hasRegionsToRestore() {
            return this.regionsToRestore != null && this.regionsToRestore.size() > 0;
        }

        public List<HRegionInfo> getRegionsToRestore() {
            return this.regionsToRestore;
        }

        public boolean hasRegionsToRemove() {
            return this.regionsToRemove != null && this.regionsToRemove.size() > 0;
        }

        public List<HRegionInfo> getRegionsToRemove() {
            return this.regionsToRemove;
        }

        void setNewRegions(HRegionInfo[] hris) {
            this.regionsToAdd = hris != null ? Arrays.asList(hris) : null;
        }

        void addRegionToRemove(HRegionInfo hri) {
            if (this.regionsToRemove == null) {
                this.regionsToRemove = new LinkedList<HRegionInfo>();
            }
            this.regionsToRemove.add(hri);
        }

        void addRegionToRestore(HRegionInfo hri) {
            if (this.regionsToRestore == null) {
                this.regionsToRestore = new LinkedList<HRegionInfo>();
            }
            this.regionsToRestore.add(hri);
        }

        public void updateMetaParentRegions(Connection connection, List<HRegionInfo> regionInfos) throws IOException {
            if (regionInfos == null || this.parentsMap.isEmpty()) {
                return;
            }
            HashMap<String, HRegionInfo> regionsByName = new HashMap<String, HRegionInfo>(regionInfos.size());
            LinkedList<HRegionInfo> parentRegions = new LinkedList<HRegionInfo>();
            for (HRegionInfo regionInfo : regionInfos) {
                if (regionInfo.isSplitParent()) {
                    parentRegions.add(regionInfo);
                    continue;
                }
                regionsByName.put(regionInfo.getEncodedName(), regionInfo);
            }
            for (HRegionInfo regionInfo : parentRegions) {
                Pair<String, String> daughters = this.parentsMap.get(regionInfo.getEncodedName());
                if (daughters == null) {
                    LOG.warn((Object)("Skip update of unreferenced offline parent: " + regionInfo));
                    continue;
                }
                if (daughters.getSecond() == null) {
                    daughters.setSecond(daughters.getFirst());
                }
                LOG.debug((Object)("Update splits parent " + regionInfo.getEncodedName() + " -> " + daughters));
                MetaTableAccessor.addRegionToMeta(connection, regionInfo, (HRegionInfo)regionsByName.get(daughters.getFirst()), (HRegionInfo)regionsByName.get(daughters.getSecond()));
            }
        }
    }
}

