/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelOrdinalProvider;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.security.visibility.ZKVisibilityLabelWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class VisibilityLabelsCache
implements VisibilityLabelOrdinalProvider {
    private static final Log LOG = LogFactory.getLog(VisibilityLabelsCache.class);
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    private static final Set<Integer> EMPTY_SET = Collections.emptySet();
    private static VisibilityLabelsCache instance;
    private ZKVisibilityLabelWatcher zkVisibilityWatcher;
    private Map<String, Integer> labels = new HashMap<String, Integer>();
    private Map<Integer, String> ordinalVsLabels = new HashMap<Integer, String>();
    private Map<String, Set<Integer>> userAuths = new HashMap<String, Set<Integer>>();
    private Map<String, Set<Integer>> groupAuths = new HashMap<String, Set<Integer>>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private VisibilityLabelsCache(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        this.zkVisibilityWatcher = new ZKVisibilityLabelWatcher(watcher, this, conf);
        try {
            this.zkVisibilityWatcher.start();
        }
        catch (KeeperException ke) {
            LOG.error((Object)"ZooKeeper initialization failed", (Throwable)ke);
            throw new IOException(ke);
        }
    }

    public static synchronized VisibilityLabelsCache createAndGet(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        if (instance == null || watcher != VisibilityLabelsCache.instance.zkVisibilityWatcher.getWatcher()) {
            instance = new VisibilityLabelsCache(watcher, conf);
        }
        return instance;
    }

    public static VisibilityLabelsCache get() {
        if (instance == null) {
            throw new IllegalStateException("VisibilityLabelsCache not yet instantiated");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLabelsCache(byte[] data) throws IOException {
        List<VisibilityLabelsProtos.VisibilityLabel> visibilityLabels = null;
        try {
            visibilityLabels = VisibilityUtils.readLabelsFromZKData(data);
        }
        catch (DeserializationException dse) {
            throw new IOException(dse);
        }
        this.lock.writeLock().lock();
        try {
            this.labels.clear();
            this.ordinalVsLabels.clear();
            for (VisibilityLabelsProtos.VisibilityLabel visLabel : visibilityLabels) {
                String label = Bytes.toString(visLabel.getLabel().toByteArray());
                this.labels.put(label, visLabel.getOrdinal());
                this.ordinalVsLabels.put(visLabel.getOrdinal(), label);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUserAuthsCache(byte[] data) throws IOException {
        VisibilityLabelsProtos.MultiUserAuthorizations multiUserAuths = null;
        try {
            multiUserAuths = VisibilityUtils.readUserAuthsFromZKData(data);
        }
        catch (DeserializationException dse) {
            throw new IOException(dse);
        }
        this.lock.writeLock().lock();
        try {
            this.userAuths.clear();
            this.groupAuths.clear();
            for (VisibilityLabelsProtos.UserAuthorizations userAuths : multiUserAuths.getUserAuthsList()) {
                String user = Bytes.toString(userAuths.getUser().toByteArray());
                if (AuthUtil.isGroupPrincipal(user)) {
                    this.groupAuths.put(AuthUtil.getGroupName(user), new HashSet<Integer>(userAuths.getAuthList()));
                    continue;
                }
                this.userAuths.put(user, new HashSet<Integer>(userAuths.getAuthList()));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int getLabelOrdinal(String label) {
        Integer ordinal = null;
        this.lock.readLock().lock();
        try {
            ordinal = this.labels.get(label);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (ordinal != null) {
            return ordinal;
        }
        return 0;
    }

    @Override
    public String getLabel(int ordinal) {
        this.lock.readLock().lock();
        try {
            String string = this.ordinalVsLabels.get(ordinal);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getLabelsCount() {
        this.lock.readLock().lock();
        try {
            int n = this.labels.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserAuths(String user) {
        this.lock.readLock().lock();
        try {
            List<String> auths = EMPTY_LIST;
            Set<Integer> authOrdinals = this.getUserAuthsAsOrdinals(user);
            if (!authOrdinals.equals(EMPTY_SET)) {
                auths = new ArrayList<String>(authOrdinals.size());
                for (Integer authOrdinal : authOrdinals) {
                    auths.add(this.ordinalVsLabels.get(authOrdinal));
                }
            }
            List<String> list = auths;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupAuths(String[] groups) {
        this.lock.readLock().lock();
        try {
            List<String> auths = EMPTY_LIST;
            Set<Integer> authOrdinals = this.getGroupAuthsAsOrdinals(groups);
            if (!authOrdinals.equals(EMPTY_SET)) {
                auths = new ArrayList<String>(authOrdinals.size());
                for (Integer authOrdinal : authOrdinals) {
                    auths.add(this.ordinalVsLabels.get(authOrdinal));
                }
            }
            List<String> list = auths;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getUserAuthsAsOrdinals(String user) {
        this.lock.readLock().lock();
        try {
            Set<Integer> auths = this.userAuths.get(user);
            Set<Integer> set = auths == null ? EMPTY_SET : auths;
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getGroupAuthsAsOrdinals(String[] groups) {
        this.lock.readLock().lock();
        try {
            HashSet<Integer> authOrdinals = new HashSet<Integer>();
            if (groups != null && groups.length > 0) {
                Set<Integer> groupAuthOrdinals = null;
                for (String group : groups) {
                    groupAuthOrdinals = this.groupAuths.get(group);
                    if (groupAuthOrdinals == null || groupAuthOrdinals.isEmpty()) continue;
                    authOrdinals.addAll(groupAuthOrdinals);
                }
            }
            Set<Integer> set = authOrdinals.isEmpty() ? EMPTY_SET : authOrdinals;
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void writeToZookeeper(byte[] data, boolean labelsOrUserAuths) throws IOException {
        if (labelsOrUserAuths) {
            this.refreshLabelsCache(data);
        } else {
            this.refreshUserAuthsCache(data);
        }
        this.zkVisibilityWatcher.writeToZookeeper(data, labelsOrUserAuths);
    }
}

