/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestVisibilityLablesWithGroups {
    public static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW_1 = Bytes.toBytes("row1");
    private static final byte[] CF = Bytes.toBytes("f");
    private static final byte[] Q1 = Bytes.toBytes("q1");
    private static final byte[] Q2 = Bytes.toBytes("q2");
    private static final byte[] Q3 = Bytes.toBytes("q3");
    private static final byte[] value1 = Bytes.toBytes("value1");
    private static final byte[] value2 = Bytes.toBytes("value2");
    private static final byte[] value3 = Bytes.toBytes("value3");
    public static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;
    public static User TESTUSER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.set("hbase.superuser", "@supergroup");
        TEST_UTIL.startMiniCluster(1);
        SUPERUSER = User.createUserForTesting(conf, "admin", new String[]{"supergroup"});
        TESTUSER = User.createUserForTesting(conf, "test", new String[]{"testgroup"});
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);){
                    VisibilityClient.addLabels(conn, new String[]{TestVisibilityLablesWithGroups.SECRET, TestVisibilityLablesWithGroups.CONFIDENTIAL});
                    VisibilityClient.setAuths(conn, new String[]{TestVisibilityLablesWithGroups.CONFIDENTIAL}, "@testgroup");
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        });
    }

    @Test
    public void testGroupAuths() throws Exception {
        final TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        TEST_UTIL.createTable(tableName, CF);
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table table = connection.getTable(tableName);){
                    Put put = new Put(ROW_1);
                    put.add(CF, Q1, Long.MAX_VALUE, value1);
                    put.setCellVisibility(new CellVisibility(TestVisibilityLablesWithGroups.SECRET));
                    table.put(put);
                    put = new Put(ROW_1);
                    put.add(CF, Q2, Long.MAX_VALUE, value2);
                    put.setCellVisibility(new CellVisibility(TestVisibilityLablesWithGroups.CONFIDENTIAL));
                    table.put(put);
                    put = new Put(ROW_1);
                    put.add(CF, Q3, Long.MAX_VALUE, value3);
                    table.put(put);
                }
                return null;
            }
        });
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table table = connection.getTable(tableName);){
                    Scan s = new Scan();
                    ResultScanner scanner = table.getScanner(s);
                    Result[] next = scanner.next(1);
                    Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
                    CellScanner cellScanner = next[0].cellScanner();
                    cellScanner.advance();
                    Cell current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), ROW_1, 0, ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals(current.getQualifier(), Q1));
                    Assert.assertTrue((boolean)Bytes.equals(current.getValue(), value1));
                    cellScanner.advance();
                    current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), ROW_1, 0, ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals(current.getQualifier(), Q2));
                    Assert.assertTrue((boolean)Bytes.equals(current.getValue(), value2));
                    cellScanner.advance();
                    current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), ROW_1, 0, ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals(current.getQualifier(), Q3));
                    Assert.assertTrue((boolean)Bytes.equals(current.getValue(), value3));
                }
                return null;
            }
        });
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    Connection conn = ConnectionFactory.createConnection(conf);
                    Object object = null;
                    try {
                        authsResponse = VisibilityClient.getAuths(conn, "@testgroup");
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (conn != null) {
                            if (object != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>();
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString(authBS.toByteArray()));
                }
                Assert.assertEquals((long)1L, (long)authsList.size());
                Assert.assertTrue((boolean)authsList.contains(TestVisibilityLablesWithGroups.CONFIDENTIAL));
                return null;
            }
        });
        TESTUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table table = connection.getTable(tableName);){
                    Scan s = new Scan();
                    ResultScanner scanner = table.getScanner(s);
                    Result[] next = scanner.next(1);
                    Assert.assertTrue((next.length == 1 ? 1 : 0) != 0);
                    CellScanner cellScanner = next[0].cellScanner();
                    cellScanner.advance();
                    Cell current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), ROW_1, 0, ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals(current.getQualifier(), Q2));
                    Assert.assertTrue((boolean)Bytes.equals(current.getValue(), value2));
                    cellScanner.advance();
                    current = cellScanner.current();
                    Assert.assertTrue((boolean)Bytes.equals(current.getRowArray(), current.getRowOffset(), current.getRowLength(), ROW_1, 0, ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals(current.getQualifier(), Q3));
                    Assert.assertTrue((boolean)Bytes.equals(current.getValue(), value3));
                    Scan s1 = new Scan();
                    s1.setAuthorizations(new Authorizations(TestVisibilityLablesWithGroups.SECRET, TestVisibilityLablesWithGroups.CONFIDENTIAL));
                    ResultScanner scanner1 = table.getScanner(s1);
                    Result[] next1 = scanner1.next(1);
                    Assert.assertTrue((next1.length == 1 ? 1 : 0) != 0);
                    CellScanner cellScanner1 = next1[0].cellScanner();
                    cellScanner1.advance();
                    Cell current1 = cellScanner1.current();
                    Assert.assertTrue((boolean)Bytes.equals(current1.getRowArray(), current1.getRowOffset(), current1.getRowLength(), ROW_1, 0, ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals(current1.getQualifier(), Q2));
                    Assert.assertTrue((boolean)Bytes.equals(current1.getValue(), value2));
                    cellScanner1.advance();
                    current1 = cellScanner1.current();
                    Assert.assertTrue((boolean)Bytes.equals(current1.getRowArray(), current1.getRowOffset(), current1.getRowLength(), ROW_1, 0, ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals(current1.getQualifier(), Q3));
                    Assert.assertTrue((boolean)Bytes.equals(current1.getValue(), value3));
                    Scan s2 = new Scan();
                    s2.setAuthorizations(new Authorizations(TestVisibilityLablesWithGroups.SECRET));
                    ResultScanner scanner2 = table.getScanner(s2);
                    Result next2 = scanner2.next();
                    CellScanner cellScanner2 = next2.cellScanner();
                    cellScanner2.advance();
                    Cell current2 = cellScanner2.current();
                    Assert.assertTrue((boolean)Bytes.equals(current2.getRowArray(), current2.getRowOffset(), current2.getRowLength(), ROW_1, 0, ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals(current2.getQualifier(), Q3));
                    Assert.assertTrue((boolean)Bytes.equals(current2.getValue(), value3));
                    Assert.assertFalse((boolean)cellScanner2.advance());
                }
                return null;
            }
        });
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                VisibilityLabelsProtos.VisibilityLabelsResponse response = null;
                try (Connection conn = ConnectionFactory.createConnection(conf);){
                    response = VisibilityClient.clearAuths(conn, new String[]{TestVisibilityLablesWithGroups.CONFIDENTIAL}, "@testgroup");
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
        SUPERUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    Connection conn = ConnectionFactory.createConnection(conf);
                    Object object = null;
                    try {
                        authsResponse = VisibilityClient.getAuths(conn, "@testgroup");
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (conn != null) {
                            if (object != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>();
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString(authBS.toByteArray()));
                }
                Assert.assertEquals((long)0L, (long)authsList.size());
                return null;
            }
        });
        TESTUSER.runAs(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table table = connection.getTable(tableName);){
                    Scan s1 = new Scan();
                    s1.setAuthorizations(new Authorizations(TestVisibilityLablesWithGroups.SECRET, TestVisibilityLablesWithGroups.CONFIDENTIAL));
                    ResultScanner scanner1 = table.getScanner(s1);
                    Result[] next1 = scanner1.next(1);
                    Assert.assertTrue((next1.length == 1 ? 1 : 0) != 0);
                    CellScanner cellScanner1 = next1[0].cellScanner();
                    cellScanner1.advance();
                    Cell current1 = cellScanner1.current();
                    Assert.assertTrue((boolean)Bytes.equals(current1.getRowArray(), current1.getRowOffset(), current1.getRowLength(), ROW_1, 0, ROW_1.length));
                    Assert.assertTrue((boolean)Bytes.equals(current1.getQualifier(), Q3));
                    Assert.assertTrue((boolean)Bytes.equals(current1.getValue(), value3));
                    Assert.assertFalse((boolean)cellScanner1.advance());
                }
                return null;
            }
        });
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

