/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestVisibilityLabelsWithACL {
    private static final String PRIVATE = "private";
    private static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes("row1");
    private static final byte[] fam = Bytes.toBytes("info");
    private static final byte[] qual = Bytes.toBytes("qual");
    private static final byte[] value = Bytes.toBytes("value");
    private static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    private static User SUPERUSER;
    private static User NORMAL_USER1;
    private static User NORMAL_USER2;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.metahandler.count", 10);
        SecureTestUtil.enableSecurity(conf);
        conf.set("hbase.coprocessor.master.classes", AccessController.class.getName() + "," + VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName() + "," + VisibilityController.class.getName());
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName(), 50000L);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityLabelsWithACL.addLabels();
        SUPERUSER = User.createUserForTesting(conf, "admin", new String[]{"supergroup"});
        NORMAL_USER1 = User.createUserForTesting(conf, "user1", new String[0]);
        NORMAL_USER2 = User.createUserForTesting(conf, "user2", new String[0]);
        SecureTestUtil.grantOnTable(TEST_UTIL, NORMAL_USER1.getShortName(), VisibilityConstants.LABELS_TABLE_NAME, null, null, Permission.Action.EXEC);
        SecureTestUtil.grantOnTable(TEST_UTIL, NORMAL_USER2.getShortName(), VisibilityConstants.LABELS_TABLE_NAME, null, null, Permission.Action.EXEC);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testScanForUserWithFewerLabelAuthsThanLabelsInScanAuthorizations() throws Throwable {
        String[] auths = new String[]{SECRET};
        String user = "user2";
        VisibilityClient.setAuths(TEST_UTIL.getConnection(), auths, user);
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        final Table table = TestVisibilityLabelsWithACL.createTableAndWriteDataWithLabels(tableName, "secret&confidential&!private", "secret&!private");
        SecureTestUtil.grantOnTable(TEST_UTIL, NORMAL_USER2.getShortName(), tableName, null, null, Permission.Action.READ);
        PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Scan s = new Scan();
                s.setAuthorizations(new Authorizations(TestVisibilityLabelsWithACL.SECRET, TestVisibilityLabelsWithACL.CONFIDENTIAL));
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table t = connection.getTable(table.getName());){
                    ResultScanner scanner = t.getScanner(s);
                    Result result = scanner.next();
                    Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)Bytes.equals(Bytes.toBytes("row2"), result.getRow()));
                    result = scanner.next();
                    Assert.assertNull((Object)result);
                }
                return null;
            }
        };
        NORMAL_USER2.runAs(scanAction);
    }

    @Test
    public void testScanForSuperUserWithFewerLabelAuths() throws Throwable {
        String[] auths = new String[]{SECRET};
        String user = "admin";
        try (Connection conn = ConnectionFactory.createConnection(conf);){
            VisibilityClient.setAuths(conn, auths, user);
        }
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        final Table table = TestVisibilityLabelsWithACL.createTableAndWriteDataWithLabels(tableName, "secret&confidential&!private", "secret&!private");
        PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Scan s = new Scan();
                s.setAuthorizations(new Authorizations(TestVisibilityLabelsWithACL.SECRET, TestVisibilityLabelsWithACL.CONFIDENTIAL));
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table t = connection.getTable(table.getName());){
                    ResultScanner scanner = t.getScanner(s);
                    Result[] result = scanner.next(5);
                    Assert.assertTrue((result.length == 2 ? 1 : 0) != 0);
                }
                return null;
            }
        };
        SUPERUSER.runAs(scanAction);
    }

    @Test
    public void testGetForSuperUserWithFewerLabelAuths() throws Throwable {
        String[] auths = new String[]{SECRET};
        String user = "admin";
        VisibilityClient.setAuths(TEST_UTIL.getConnection(), auths, user);
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        final Table table = TestVisibilityLabelsWithACL.createTableAndWriteDataWithLabels(tableName, "secret&confidential&!private", "secret&!private");
        PrivilegedExceptionAction<Void> scanAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Get g = new Get(row1);
                g.setAuthorizations(new Authorizations(TestVisibilityLabelsWithACL.SECRET, TestVisibilityLabelsWithACL.CONFIDENTIAL));
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table t = connection.getTable(table.getName());){
                    Result result = t.get(g);
                    Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
                }
                return null;
            }
        };
        SUPERUSER.runAs(scanAction);
    }

    @Test
    public void testVisibilityLabelsForUserWithNoAuths() throws Throwable {
        String user = "admin";
        String[] auths = new String[]{SECRET};
        try (Connection conn = ConnectionFactory.createConnection(conf);){
            VisibilityClient.clearAuths(conn, auths, user);
            VisibilityClient.setAuths(conn, auths, "user1");
        }
        TableName tableName = TableName.valueOf(this.TEST_NAME.getMethodName());
        final Table table = TestVisibilityLabelsWithACL.createTableAndWriteDataWithLabels(tableName, SECRET);
        SecureTestUtil.grantOnTable(TEST_UTIL, NORMAL_USER1.getShortName(), tableName, null, null, Permission.Action.READ);
        SecureTestUtil.grantOnTable(TEST_UTIL, NORMAL_USER2.getShortName(), tableName, null, null, Permission.Action.READ);
        PrivilegedExceptionAction<Void> getAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Get g = new Get(row1);
                g.setAuthorizations(new Authorizations(TestVisibilityLabelsWithACL.SECRET, TestVisibilityLabelsWithACL.CONFIDENTIAL));
                try (Connection connection = ConnectionFactory.createConnection(conf);
                     Table t = connection.getTable(table.getName());){
                    Result result = t.get(g);
                    Assert.assertTrue((boolean)result.isEmpty());
                }
                return null;
            }
        };
        NORMAL_USER2.runAs(getAction);
    }

    @Test
    public void testLabelsTableOpsWithDifferentUsers() throws Throwable {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.addLabels(conn, new String[]{"l1", "l2"});
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        VisibilityLabelsProtos.VisibilityLabelsResponse response = NORMAL_USER1.runAs(action);
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(0).getException().getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(1).getException().getName());
        action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths(conn, new String[]{TestVisibilityLabelsWithACL.CONFIDENTIAL, TestVisibilityLabelsWithACL.PRIVATE}, "user1");
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        response = NORMAL_USER1.runAs(action);
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(0).getException().getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(1).getException().getName());
        action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.setAuths(conn, new String[]{TestVisibilityLabelsWithACL.CONFIDENTIAL, TestVisibilityLabelsWithACL.PRIVATE}, "user1");
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        response = SUPERUSER.runAs(action);
        Assert.assertTrue((boolean)response.getResult(0).getException().getValue().isEmpty());
        Assert.assertTrue((boolean)response.getResult(1).getException().getValue().isEmpty());
        action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);){
                    VisibilityLabelsProtos.VisibilityLabelsResponse visibilityLabelsResponse = VisibilityClient.clearAuths(conn, new String[]{TestVisibilityLabelsWithACL.CONFIDENTIAL, TestVisibilityLabelsWithACL.PRIVATE}, "user1");
                    return visibilityLabelsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        response = NORMAL_USER1.runAs(action);
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(0).getException().getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(1).getException().getName());
        response = VisibilityClient.clearAuths(TEST_UTIL.getConnection(), new String[]{CONFIDENTIAL, PRIVATE}, "user1");
        Assert.assertTrue((boolean)response.getResult(0).getException().getValue().isEmpty());
        Assert.assertTrue((boolean)response.getResult(1).getException().getValue().isEmpty());
        VisibilityClient.setAuths(TEST_UTIL.getConnection(), new String[]{CONFIDENTIAL, PRIVATE}, "user3");
        PrivilegedExceptionAction<VisibilityLabelsProtos.GetAuthsResponse> action1 = new PrivilegedExceptionAction<VisibilityLabelsProtos.GetAuthsResponse>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VisibilityLabelsProtos.GetAuthsResponse run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection(conf);){
                    VisibilityLabelsProtos.GetAuthsResponse getAuthsResponse = VisibilityClient.getAuths(conn, "user3");
                    return getAuthsResponse;
                }
                catch (Throwable throwable6) {
                    return null;
                }
            }
        };
        VisibilityLabelsProtos.GetAuthsResponse authsResponse = NORMAL_USER1.runAs(action1);
        Assert.assertNull((Object)authsResponse);
        authsResponse = SUPERUSER.runAs(action1);
        ArrayList<String> authsList = new ArrayList<String>();
        for (ByteString authBS : authsResponse.getAuthList()) {
            authsList.add(Bytes.toString(authBS.toByteArray()));
        }
        Assert.assertEquals((long)2L, (long)authsList.size());
        Assert.assertTrue((boolean)authsList.contains(CONFIDENTIAL));
        Assert.assertTrue((boolean)authsList.contains(PRIVATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Table createTableAndWriteDataWithLabels(TableName tableName, String ... labelExps) throws Exception {
        try (HTable table = null;){
            table = TEST_UTIL.createTable(tableName, fam);
            int i = 1;
            ArrayList<Put> puts = new ArrayList<Put>();
            for (String labelExp : labelExps) {
                Put put = new Put(Bytes.toBytes("row" + i));
                put.add(fam, qual, Long.MAX_VALUE, value);
                put.setCellVisibility(new CellVisibility(labelExp));
                puts.add(put);
                ++i;
            }
            table.put(puts);
        }
        return table;
    }

    private static void addLabels() throws IOException {
        String[] labels = new String[]{SECRET, CONFIDENTIAL, PRIVATE};
        try {
            VisibilityClient.addLabels(TEST_UTIL.getConnection(), labels);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }
}

