/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import drill.shaded.hbase.guava.com.google.common.collect.ArrayListMultimap;
import drill.shaded.hbase.guava.com.google.common.collect.ListMultimap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.HbaseObjectWritableFor96Migration;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTablePermissions {
    private static final Log LOG = LogFactory.getLog(TestTablePermissions.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static ZooKeeperWatcher ZKW;
    private static final Abortable ABORTABLE;
    private static String TEST_NAMESPACE;
    private static String TEST_NAMESPACE2;
    private static TableName TEST_TABLE;
    private static TableName TEST_TABLE2;
    private static byte[] TEST_FAMILY;
    private static byte[] TEST_QUALIFIER;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        SecureTestUtil.enableSecurity(conf);
        UTIL.startMiniCluster();
        UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME);
        ZKW = new ZooKeeperWatcher(UTIL.getConfiguration(), "TestTablePermissions", ABORTABLE);
        UTIL.createTable(TEST_TABLE, TEST_FAMILY);
        UTIL.waitUntilAllRegionsAssigned(TEST_TABLE);
        UTIL.createTable(TEST_TABLE2, TEST_FAMILY);
        UTIL.waitUntilAllRegionsAssigned(TEST_TABLE2);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
            AccessControlLists.removeTablePermissions(conf, TEST_TABLE, table);
            AccessControlLists.removeTablePermissions(conf, TEST_TABLE2, table);
            AccessControlLists.removeTablePermissions(conf, AccessControlLists.ACL_TABLE_NAME, table);
        }
    }

    @Test
    public void testMigration() throws DeserializationException {
        Configuration conf = UTIL.getConfiguration();
        ListMultimap<String, TablePermission> permissions = this.createPermissions();
        byte[] bytes = TestTablePermissions.writePermissionsAsBytes(permissions, conf);
        AccessControlLists.readPermissions(bytes, conf);
    }

    public static byte[] writePermissionsAsBytes(ListMultimap<String, ? extends Permission> perms, Configuration conf) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            TestTablePermissions.writePermissions(new DataOutputStream(bos), perms, conf);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error serializing permissions", ioe);
        }
    }

    public static void writePermissions(DataOutput out, ListMultimap<String, ? extends Permission> perms, Configuration conf) throws IOException {
        Set keys = perms.keySet();
        out.writeInt(keys.size());
        for (String key : keys) {
            Text.writeString((DataOutput)out, (String)key);
            HbaseObjectWritableFor96Migration.writeObject(out, perms.get(key), List.class, conf);
        }
    }

    @Test
    public void testBasicWrite() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("george"), TEST_TABLE, null, (byte[])null, Permission.Action.READ, Permission.Action.WRITE), table);
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("hubert"), TEST_TABLE, null, (byte[])null, Permission.Action.READ), table);
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("humphrey"), TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, Permission.Action.READ), table);
        }
        ListMultimap<String, TablePermission> perms = AccessControlLists.getTablePermissions(conf, TEST_TABLE);
        List<TablePermission> userPerms = perms.get("george");
        Assert.assertNotNull((String)"Should have permissions for george", userPerms);
        Assert.assertEquals((String)"Should have 1 permission for george", (long)1L, (long)userPerms.size());
        TablePermission permission = userPerms.get(0);
        Assert.assertEquals((String)("Permission should be for " + TEST_TABLE), (Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertNull((String)"Column family should be empty", (Object)permission.getFamily());
        Assert.assertNotNull((Object)permission.getActions());
        Assert.assertEquals((long)2L, (long)permission.getActions().length);
        List<Permission.Action> actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains((Object)Permission.Action.READ));
        Assert.assertTrue((boolean)actions.contains((Object)Permission.Action.WRITE));
        userPerms = perms.get("hubert");
        Assert.assertNotNull((String)"Should have permissions for hubert", userPerms);
        Assert.assertEquals((String)"Should have 1 permission for hubert", (long)1L, (long)userPerms.size());
        permission = userPerms.get(0);
        Assert.assertEquals((String)("Permission should be for " + TEST_TABLE), (Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertNull((String)"Column family should be empty", (Object)permission.getFamily());
        Assert.assertNotNull((Object)permission.getActions());
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains((Object)Permission.Action.READ));
        Assert.assertFalse((boolean)actions.contains((Object)Permission.Action.WRITE));
        userPerms = perms.get("humphrey");
        Assert.assertNotNull((String)"Should have permissions for humphrey", userPerms);
        Assert.assertEquals((String)"Should have 1 permission for humphrey", (long)1L, (long)userPerms.size());
        permission = userPerms.get(0);
        Assert.assertEquals((String)("Permission should be for " + TEST_TABLE), (Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertTrue((String)("Permission should be for family " + Bytes.toString(TEST_FAMILY)), (boolean)Bytes.equals(TEST_FAMILY, permission.getFamily()));
        Assert.assertTrue((String)("Permission should be for qualifier " + Bytes.toString(TEST_QUALIFIER)), (boolean)Bytes.equals(TEST_QUALIFIER, permission.getQualifier()));
        Assert.assertNotNull((Object)permission.getActions());
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains((Object)Permission.Action.READ));
        Assert.assertFalse((boolean)actions.contains((Object)Permission.Action.WRITE));
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("hubert"), TEST_TABLE2, null, (byte[])null, Permission.Action.READ, Permission.Action.WRITE), table);
        }
        Map<byte[], ListMultimap<String, TablePermission>> allPerms = AccessControlLists.loadAll(conf);
        Assert.assertEquals((String)"Full permission map should have entries for both test tables", (long)2L, (long)allPerms.size());
        userPerms = allPerms.get(TEST_TABLE.getName()).get("hubert");
        Assert.assertNotNull(userPerms);
        Assert.assertEquals((long)1L, (long)userPerms.size());
        permission = userPerms.get(0);
        Assert.assertEquals((Object)TEST_TABLE, (Object)permission.getTableName());
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        Assert.assertEquals((Object)((Object)Permission.Action.READ), (Object)((Object)permission.getActions()[0]));
        userPerms = allPerms.get(TEST_TABLE2.getName()).get("hubert");
        Assert.assertNotNull(userPerms);
        Assert.assertEquals((long)1L, (long)userPerms.size());
        permission = userPerms.get(0);
        Assert.assertEquals((Object)TEST_TABLE2, (Object)permission.getTableName());
        Assert.assertEquals((long)2L, (long)permission.getActions().length);
        actions = Arrays.asList(permission.getActions());
        Assert.assertTrue((boolean)actions.contains((Object)Permission.Action.READ));
        Assert.assertTrue((boolean)actions.contains((Object)Permission.Action.WRITE));
    }

    @Test
    public void testPersistence() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("albert"), TEST_TABLE, null, (byte[])null, Permission.Action.READ), table);
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("betty"), TEST_TABLE, null, (byte[])null, Permission.Action.READ, Permission.Action.WRITE), table);
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("clark"), TEST_TABLE, TEST_FAMILY, Permission.Action.READ), table);
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("dwight"), TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, Permission.Action.WRITE), table);
        }
        ListMultimap<String, TablePermission> preperms = AccessControlLists.getTablePermissions(conf, TEST_TABLE);
        HTable table = new HTable(conf, TEST_TABLE);
        table.put(new Put(Bytes.toBytes("row1")).add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes("v1")));
        table.put(new Put(Bytes.toBytes("row2")).add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes("v2")));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.split(TEST_TABLE);
        Thread.sleep(10000L);
        ListMultimap<String, TablePermission> postperms = AccessControlLists.getTablePermissions(conf, TEST_TABLE);
        this.checkMultimapEqual(preperms, postperms);
    }

    @Test
    public void testSerialization() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        ListMultimap<String, TablePermission> permissions = this.createPermissions();
        byte[] permsData = AccessControlLists.writePermissionsAsBytes(permissions, conf);
        ListMultimap<String, TablePermission> copy = AccessControlLists.readPermissions(permsData, conf);
        this.checkMultimapEqual(permissions, copy);
    }

    private ListMultimap<String, TablePermission> createPermissions() {
        ArrayListMultimap<String, TablePermission> permissions = ArrayListMultimap.create();
        permissions.put("george", new TablePermission(TEST_TABLE, null, Permission.Action.READ));
        permissions.put("george", new TablePermission(TEST_TABLE, TEST_FAMILY, Permission.Action.WRITE));
        permissions.put("george", new TablePermission(TEST_TABLE2, null, Permission.Action.READ));
        permissions.put("hubert", new TablePermission(TEST_TABLE2, null, Permission.Action.READ, Permission.Action.WRITE));
        permissions.put("bruce", new TablePermission(TEST_NAMESPACE, Permission.Action.READ));
        return permissions;
    }

    public void checkMultimapEqual(ListMultimap<String, TablePermission> first, ListMultimap<String, TablePermission> second) {
        Assert.assertEquals((long)first.size(), (long)second.size());
        for (String key : first.keySet()) {
            List<TablePermission> firstPerms = first.get(key);
            List<TablePermission> secondPerms = second.get(key);
            Assert.assertNotNull(secondPerms);
            Assert.assertEquals((long)firstPerms.size(), (long)secondPerms.size());
            LOG.info((Object)("First permissions: " + firstPerms.toString()));
            LOG.info((Object)("Second permissions: " + secondPerms.toString()));
            for (TablePermission p : firstPerms) {
                Assert.assertTrue((String)("Permission " + p.toString() + " not found"), (boolean)secondPerms.contains((Object)p));
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        TablePermission p1 = new TablePermission(TEST_TABLE, null, Permission.Action.READ);
        TablePermission p2 = new TablePermission(TEST_TABLE, null, Permission.Action.READ);
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, null, Permission.Action.READ, Permission.Action.WRITE);
        p2 = new TablePermission(TEST_TABLE, null, Permission.Action.WRITE, Permission.Action.READ);
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, TEST_FAMILY, Permission.Action.READ, Permission.Action.WRITE);
        p2 = new TablePermission(TEST_TABLE, TEST_FAMILY, Permission.Action.WRITE, Permission.Action.READ);
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, Permission.Action.READ, Permission.Action.WRITE);
        p2 = new TablePermission(TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, Permission.Action.WRITE, Permission.Action.READ);
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertTrue((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, null, Permission.Action.READ);
        p2 = new TablePermission(TEST_TABLE, TEST_FAMILY, Permission.Action.READ);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, null, Permission.Action.READ);
        p2 = new TablePermission(TEST_TABLE, null, Permission.Action.WRITE);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p2 = new TablePermission(TEST_TABLE, null, Permission.Action.READ, Permission.Action.WRITE);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_TABLE, null, Permission.Action.READ);
        p2 = new TablePermission(TEST_TABLE2, null, Permission.Action.READ);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p2 = new TablePermission(TEST_TABLE, null, new Permission.Action[0]);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
        p1 = new TablePermission(TEST_NAMESPACE, Permission.Action.READ);
        p2 = new TablePermission(TEST_NAMESPACE, Permission.Action.READ);
        Assert.assertEquals((Object)((Object)p1), (Object)((Object)p2));
        p1 = new TablePermission(TEST_NAMESPACE, Permission.Action.READ);
        p2 = new TablePermission(TEST_NAMESPACE2, Permission.Action.READ);
        Assert.assertFalse((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p2.equals((Object)p1));
    }

    @Test
    public void testGlobalPermission() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("user1"), Permission.Action.READ, Permission.Action.WRITE), table);
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("user2"), Permission.Action.CREATE), table);
            AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("user3"), Permission.Action.ADMIN, Permission.Action.READ, Permission.Action.CREATE), table);
        }
        ListMultimap<String, TablePermission> perms = AccessControlLists.getTablePermissions(conf, null);
        List<TablePermission> user1Perms = perms.get("user1");
        Assert.assertEquals((String)"Should have 1 permission for user1", (long)1L, (long)user1Perms.size());
        Assert.assertEquals((String)"user1 should have WRITE permission", (Object[])new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}, (Object[])user1Perms.get(0).getActions());
        List<TablePermission> user2Perms = perms.get("user2");
        Assert.assertEquals((String)"Should have 1 permission for user2", (long)1L, (long)user2Perms.size());
        Assert.assertEquals((String)"user2 should have CREATE permission", (Object[])new Permission.Action[]{Permission.Action.CREATE}, (Object[])user2Perms.get(0).getActions());
        List<TablePermission> user3Perms = perms.get("user3");
        Assert.assertEquals((String)"Should have 1 permission for user3", (long)1L, (long)user3Perms.size());
        Assert.assertEquals((String)"user3 should have ADMIN, READ, CREATE permission", (Object[])new Permission.Action[]{Permission.Action.READ, Permission.Action.CREATE, Permission.Action.ADMIN}, (Object[])user3Perms.get(0).getActions());
    }

    @Test
    public void testAuthManager() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        TableAuthManager authManager = TableAuthManager.getOrCreate(ZKW, conf);
        User currentUser = User.getCurrent();
        Assert.assertTrue((boolean)authManager.authorize(currentUser, Permission.Action.ADMIN));
        try (Connection connection = ConnectionFactory.createConnection(conf);
             Table table = connection.getTable(AccessControlLists.ACL_TABLE_NAME);){
            for (int i = 1; i <= 50; ++i) {
                AccessControlLists.addUserPermission(conf, new UserPermission(Bytes.toBytes("testauth" + i), Permission.Action.ADMIN, Permission.Action.READ, Permission.Action.WRITE), table);
                Assert.assertTrue((String)("Failed current user auth check on iter " + i), (boolean)authManager.authorize(currentUser, Permission.Action.ADMIN));
            }
        }
    }

    static {
        ABORTABLE = new Abortable(){
            private final AtomicBoolean abort = new AtomicBoolean(false);

            @Override
            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
                this.abort.set(true);
            }

            @Override
            public boolean isAborted() {
                return this.abort.get();
            }
        };
        TEST_NAMESPACE = "perms_test_ns";
        TEST_NAMESPACE2 = "perms_test_ns2";
        TEST_TABLE = TableName.valueOf("perms_test");
        TEST_TABLE2 = TableName.valueOf("perms_test2");
        TEST_FAMILY = Bytes.toBytes("f1");
        TEST_QUALIFIER = Bytes.toBytes("col1");
    }
}

