/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.replication.master.TableCFsUpdater;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestTableCFsUpdater
extends TableCFsUpdater {
    private static final Log LOG = LogFactory.getLog(TestTableCFsUpdater.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ZooKeeperWatcher zkw = null;
    private static Abortable abortable = null;

    public TestTableCFsUpdater() {
        super(zkw, TEST_UTIL.getConfiguration(), abortable);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        abortable = new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        };
        zkw = new ZooKeeperWatcher(conf, "TableCFs", abortable, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Ignore
    @Test
    public void testUpgrade() throws KeeperException, InterruptedException, DeserializationException {
        String peerId = "1";
        TableName tab1 = TableName.valueOf("table1");
        TableName tab2 = TableName.valueOf("table2");
        TableName tab3 = TableName.valueOf("table3");
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(zkw.getQuorum());
        String peerNode = this.getPeerNode(peerId);
        ZKUtil.createWithParents(zkw, peerNode, ReplicationSerDeHelper.toByteArray(rpc));
        String tableCFs = "table1:cf1,cf2;table2:cf3;table3";
        String tableCFsNode = this.getTableCFsNode(peerId);
        LOG.info((Object)("create tableCFs :" + tableCFsNode + " for peerId=" + peerId));
        ZKUtil.createWithParents(zkw, tableCFsNode, Bytes.toBytes(tableCFs));
        ReplicationPeerConfig actualRpc = ReplicationSerDeHelper.parsePeerFrom(ZKUtil.getData(zkw, peerNode));
        String actualTableCfs = Bytes.toString(ZKUtil.getData(zkw, tableCFsNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        Assert.assertNull(actualRpc.getTableCFsMap());
        Assert.assertEquals((Object)tableCFs, (Object)actualTableCfs);
        peerId = "2";
        rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(zkw.getQuorum());
        peerNode = this.getPeerNode(peerId);
        ZKUtil.createWithParents(zkw, peerNode, ReplicationSerDeHelper.toByteArray(rpc));
        tableCFs = "table1:cf1,cf3;table2:cf2";
        tableCFsNode = this.getTableCFsNode(peerId);
        LOG.info((Object)("create tableCFs :" + tableCFsNode + " for peerId=" + peerId));
        ZKUtil.createWithParents(zkw, tableCFsNode, Bytes.toBytes(tableCFs));
        actualRpc = ReplicationSerDeHelper.parsePeerFrom(ZKUtil.getData(zkw, peerNode));
        actualTableCfs = Bytes.toString(ZKUtil.getData(zkw, tableCFsNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        Assert.assertNull(actualRpc.getTableCFsMap());
        Assert.assertEquals((Object)tableCFs, (Object)actualTableCfs);
        this.update();
        peerId = "1";
        peerNode = this.getPeerNode(peerId);
        actualRpc = ReplicationSerDeHelper.parsePeerFrom(ZKUtil.getData(zkw, peerNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        Map<TableName, List<String>> tableNameListMap = actualRpc.getTableCFsMap();
        Assert.assertEquals((long)3L, (long)tableNameListMap.size());
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tab1));
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tab2));
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tab3));
        Assert.assertEquals((long)2L, (long)tableNameListMap.get(tab1).size());
        Assert.assertEquals((Object)"cf1", (Object)tableNameListMap.get(tab1).get(0));
        Assert.assertEquals((Object)"cf2", (Object)tableNameListMap.get(tab1).get(1));
        Assert.assertEquals((long)1L, (long)tableNameListMap.get(tab2).size());
        Assert.assertEquals((Object)"cf3", (Object)tableNameListMap.get(tab2).get(0));
        Assert.assertNull(tableNameListMap.get(tab3));
        peerId = "2";
        peerNode = this.getPeerNode(peerId);
        actualRpc = ReplicationSerDeHelper.parsePeerFrom(ZKUtil.getData(zkw, peerNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        tableNameListMap = actualRpc.getTableCFsMap();
        Assert.assertEquals((long)2L, (long)tableNameListMap.size());
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tab1));
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tab2));
        Assert.assertEquals((long)2L, (long)tableNameListMap.get(tab1).size());
        Assert.assertEquals((Object)"cf1", (Object)tableNameListMap.get(tab1).get(0));
        Assert.assertEquals((Object)"cf3", (Object)tableNameListMap.get(tab1).get(1));
        Assert.assertEquals((long)1L, (long)tableNameListMap.get(tab2).size());
        Assert.assertEquals((Object)"cf2", (Object)tableNameListMap.get(tab2).get(0));
    }
}

