/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSyncUp;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestReplicationSyncUpTool
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationSyncUpTool.class);
    private static final TableName t1_su = TableName.valueOf("t1_syncup");
    private static final TableName t2_su = TableName.valueOf("t2_syncup");
    protected static final byte[] famName = Bytes.toBytes("cf1");
    private static final byte[] qualName = Bytes.toBytes("q1");
    protected static final byte[] noRepfamName = Bytes.toBytes("norep");
    private HTableDescriptor t1_syncupSource;
    private HTableDescriptor t1_syncupTarget;
    private HTableDescriptor t2_syncupSource;
    private HTableDescriptor t2_syncupTarget;
    protected Table ht1Source;
    protected Table ht2Source;
    protected Table ht1TargetAtPeer1;
    protected Table ht2TargetAtPeer1;

    @Before
    public void setUp() throws Exception {
        this.t1_syncupSource = new HTableDescriptor(t1_su);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        this.t1_syncupSource.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.t1_syncupSource.addFamily(fam);
        this.t1_syncupTarget = new HTableDescriptor(t1_su);
        fam = new HColumnDescriptor(famName);
        this.t1_syncupTarget.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.t1_syncupTarget.addFamily(fam);
        this.t2_syncupSource = new HTableDescriptor(t2_su);
        fam = new HColumnDescriptor(famName);
        fam.setScope(1);
        this.t2_syncupSource.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.t2_syncupSource.addFamily(fam);
        this.t2_syncupTarget = new HTableDescriptor(t2_su);
        fam = new HColumnDescriptor(famName);
        this.t2_syncupTarget.addFamily(fam);
        fam = new HColumnDescriptor(noRepfamName);
        this.t2_syncupTarget.addFamily(fam);
    }

    @Test(timeout=300000L)
    public void testSyncUpTool() throws Exception {
        this.setupReplication();
        this.putAndReplicateRows();
        this.mimicSyncUpAfterDelete();
        this.mimicSyncUpAfterPut();
    }

    protected void setupReplication() throws Exception {
        ReplicationAdmin admin1 = new ReplicationAdmin(conf1);
        ReplicationAdmin admin2 = new ReplicationAdmin(conf2);
        HBaseAdmin ha = new HBaseAdmin(conf1);
        ha.createTable(this.t1_syncupSource);
        ha.createTable(this.t2_syncupSource);
        ha.close();
        ha = new HBaseAdmin(conf2);
        ha.createTable(this.t1_syncupTarget);
        ha.createTable(this.t2_syncupTarget);
        ha.close();
        this.ht1Source = new HTable(conf1, t1_su);
        this.ht1Source.setWriteBufferSize(1024L);
        this.ht2Source = new HTable(conf1, t2_su);
        this.ht1Source.setWriteBufferSize(1024L);
        this.ht1TargetAtPeer1 = new HTable(conf2, t1_su);
        this.ht1TargetAtPeer1.setWriteBufferSize(1024L);
        this.ht2TargetAtPeer1 = new HTable(conf2, t2_su);
        this.ht2TargetAtPeer1.setWriteBufferSize(1024L);
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility2.getClusterKey());
        admin1.addPeer("1", rpc);
        admin1.close();
        admin2.close();
    }

    private void putAndReplicateRows() throws Exception {
        Put p;
        int i;
        LOG.debug((Object)"putAndReplicateRows");
        for (i = 0; i < 100; ++i) {
            p = new Put(Bytes.toBytes("row" + i));
            p.add(famName, qualName, Bytes.toBytes("val" + i));
            this.ht1Source.put(p);
        }
        p = new Put(Bytes.toBytes("row9999"));
        p.add(noRepfamName, qualName, Bytes.toBytes("val9999"));
        this.ht1Source.put(p);
        for (i = 0; i < 200; ++i) {
            p = new Put(Bytes.toBytes("row" + i));
            p.add(famName, qualName, Bytes.toBytes("val" + i));
            this.ht2Source.put(p);
        }
        p = new Put(Bytes.toBytes("row9999"));
        p.add(noRepfamName, qualName, Bytes.toBytes("val9999"));
        this.ht2Source.put(p);
        Thread.sleep(500L);
        int rowCount_ht1Source = utility1.countRows(this.ht1Source);
        for (int i2 = 0; i2 < 10; ++i2) {
            int rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
            if (i2 == 9) {
                Assert.assertEquals((String)"t1_syncup has 101 rows on source, and 100 on slave1", (long)(rowCount_ht1Source - 1), (long)rowCount_ht1TargetAtPeer1);
            }
            if (rowCount_ht1Source - 1 == rowCount_ht1TargetAtPeer1) break;
            Thread.sleep(500L);
        }
        int rowCount_ht2Source = utility1.countRows(this.ht2Source);
        for (int i3 = 0; i3 < 10; ++i3) {
            int rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
            if (i3 == 9) {
                Assert.assertEquals((String)"t2_syncup has 201 rows on source, and 200 on slave1", (long)(rowCount_ht2Source - 1), (long)rowCount_ht2TargetAtPeer1);
            }
            if (rowCount_ht2Source - 1 == rowCount_ht2TargetAtPeer1) break;
            Thread.sleep(500L);
        }
    }

    private void mimicSyncUpAfterDelete() throws Exception {
        Delete del;
        String rowKey;
        int i;
        LOG.debug((Object)"mimicSyncUpAfterDelete");
        utility2.shutdownMiniHBaseCluster();
        ArrayList<Delete> list = new ArrayList<Delete>();
        for (i = 0; i < 50; ++i) {
            rowKey = "row" + i;
            del = new Delete(rowKey.getBytes());
            list.add(del);
        }
        this.ht1Source.delete(list);
        for (i = 0; i < 100; ++i) {
            rowKey = "row" + i;
            del = new Delete(rowKey.getBytes());
            list.add(del);
        }
        this.ht2Source.delete(list);
        int rowCount_ht1Source = utility1.countRows(this.ht1Source);
        Assert.assertEquals((String)"t1_syncup has 51 rows on source, after remove 50 of the replicated colfam", (long)51L, (long)rowCount_ht1Source);
        int rowCount_ht2Source = utility1.countRows(this.ht2Source);
        Assert.assertEquals((String)"t2_syncup has 101 rows on source, after remove 100 of the replicated colfam", (long)101L, (long)rowCount_ht2Source);
        utility1.shutdownMiniHBaseCluster();
        utility2.restartHBaseCluster(1);
        Thread.sleep(500L);
        int rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
        int rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should still have 100 rows", (long)100L, (long)rowCount_ht1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should still have 200 rows", (long)200L, (long)rowCount_ht2TargetAtPeer1);
        for (int i2 = 0; i2 < 10; ++i2) {
            this.syncUp(utility1);
            rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
            rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
            if (i2 == 9) {
                if (rowCount_ht1TargetAtPeer1 != 50 || rowCount_ht2TargetAtPeer1 != 100) {
                    utility1.restartHBaseCluster(1);
                    rowCount_ht1Source = utility1.countRows(this.ht1Source);
                    LOG.debug((Object)("t1_syncup should have 51 rows at source, and it is " + rowCount_ht1Source));
                    rowCount_ht2Source = utility1.countRows(this.ht2Source);
                    LOG.debug((Object)("t2_syncup should have 101 rows at source, and it is " + rowCount_ht2Source));
                }
                Assert.assertEquals((String)"@Peer1 t1_syncup should be sync up and have 50 rows", (long)50L, (long)rowCount_ht1TargetAtPeer1);
                Assert.assertEquals((String)"@Peer1 t2_syncup should be sync up and have 100 rows", (long)100L, (long)rowCount_ht2TargetAtPeer1);
            }
            if (rowCount_ht1TargetAtPeer1 == 50 && rowCount_ht2TargetAtPeer1 == 100) {
                LOG.info((Object)("SyncUpAfterDelete succeeded at retry = " + i2));
                break;
            }
            LOG.debug((Object)("SyncUpAfterDelete failed at retry = " + i2 + ", with rowCount_ht1TargetPeer1 =" + rowCount_ht1TargetAtPeer1 + " and rowCount_ht2TargetAtPeer1 =" + rowCount_ht2TargetAtPeer1));
            Thread.sleep(500L);
        }
    }

    private void mimicSyncUpAfterPut() throws Exception {
        Put p;
        int i;
        LOG.debug((Object)"mimicSyncUpAfterPut");
        utility1.restartHBaseCluster(1);
        utility2.shutdownMiniHBaseCluster();
        for (i = 0; i < 100; ++i) {
            p = new Put(Bytes.toBytes("row" + i));
            p.add(famName, qualName, Bytes.toBytes("val" + i));
            this.ht1Source.put(p);
        }
        p = new Put(Bytes.toBytes("row9998"));
        p.add(noRepfamName, qualName, Bytes.toBytes("val9998"));
        this.ht1Source.put(p);
        for (i = 0; i < 200; ++i) {
            p = new Put(Bytes.toBytes("row" + i));
            p.add(famName, qualName, Bytes.toBytes("val" + i));
            this.ht2Source.put(p);
        }
        p = new Put(Bytes.toBytes("row9998"));
        p.add(noRepfamName, qualName, Bytes.toBytes("val9998"));
        this.ht2Source.put(p);
        int rowCount_ht1Source = utility1.countRows(this.ht1Source);
        Assert.assertEquals((String)"t1_syncup has 102 rows on source", (long)102L, (long)rowCount_ht1Source);
        int rowCount_ht2Source = utility1.countRows(this.ht2Source);
        Assert.assertEquals((String)"t2_syncup has 202 rows on source", (long)202L, (long)rowCount_ht2Source);
        utility1.shutdownMiniHBaseCluster();
        utility2.restartHBaseCluster(1);
        Thread.sleep(500L);
        int rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
        int rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t1_syncup should be NOT sync up and have 50 rows", (long)50L, (long)rowCount_ht1TargetAtPeer1);
        Assert.assertEquals((String)"@Peer1 t2_syncup should be NOT sync up and have 100 rows", (long)100L, (long)rowCount_ht2TargetAtPeer1);
        for (int i2 = 0; i2 < 10; ++i2) {
            this.syncUp(utility1);
            rowCount_ht1TargetAtPeer1 = utility2.countRows(this.ht1TargetAtPeer1);
            rowCount_ht2TargetAtPeer1 = utility2.countRows(this.ht2TargetAtPeer1);
            if (i2 == 9) {
                if (rowCount_ht1TargetAtPeer1 != 100 || rowCount_ht2TargetAtPeer1 != 200) {
                    utility1.restartHBaseCluster(1);
                    rowCount_ht1Source = utility1.countRows(this.ht1Source);
                    LOG.debug((Object)("t1_syncup should have 102 rows at source, and it is " + rowCount_ht1Source));
                    rowCount_ht2Source = utility1.countRows(this.ht2Source);
                    LOG.debug((Object)("t2_syncup should have 202 rows at source, and it is " + rowCount_ht2Source));
                }
                Assert.assertEquals((String)"@Peer1 t1_syncup should be sync up and have 100 rows", (long)100L, (long)rowCount_ht1TargetAtPeer1);
                Assert.assertEquals((String)"@Peer1 t2_syncup should be sync up and have 200 rows", (long)200L, (long)rowCount_ht2TargetAtPeer1);
            }
            if (rowCount_ht1TargetAtPeer1 == 100 && rowCount_ht2TargetAtPeer1 == 200) {
                LOG.info((Object)("SyncUpAfterPut succeeded at retry = " + i2));
                break;
            }
            LOG.debug((Object)("SyncUpAfterPut failed at retry = " + i2 + ", with rowCount_ht1TargetPeer1 =" + rowCount_ht1TargetAtPeer1 + " and rowCount_ht2TargetAtPeer1 =" + rowCount_ht2TargetAtPeer1));
            Thread.sleep(500L);
        }
    }

    protected void syncUp(HBaseTestingUtility ut) throws Exception {
        ReplicationSyncUp.setConfigure(ut.getConfiguration());
        String[] arguments = new String[]{null};
        new ReplicationSyncUp().run(arguments);
    }
}

