/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWALCellCodecWithCompression {
    @Test
    public void testEncodeDecodeKVsWithTags() throws Exception {
        this.doTest(false);
    }

    @Test
    public void testEncodeDecodeKVsWithTagsWithTagsCompression() throws Exception {
        this.doTest(true);
    }

    private void doTest(boolean compressTags) throws Exception {
        Configuration conf = new Configuration(false);
        conf.setBoolean("hbase.regionserver.wal.tags.enablecompression", compressTags);
        WALCellCodec codec = new WALCellCodec(conf, new CompressionContext(LRUDictionary.class, false, compressTags));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        Codec.Encoder encoder = codec.getEncoder(bos);
        encoder.write(this.createKV(1));
        encoder.write(this.createKV(0));
        encoder.write(this.createKV(2));
        ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
        Codec.Decoder decoder = codec.getDecoder(is);
        decoder.advance();
        KeyValue kv = (KeyValue)decoder.current();
        List<Tag> tags = kv.getTags();
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertEquals((Object)"tagValue1", (Object)Bytes.toString(tags.get(0).getValue()));
        decoder.advance();
        kv = (KeyValue)decoder.current();
        tags = kv.getTags();
        Assert.assertEquals((long)0L, (long)tags.size());
        decoder.advance();
        kv = (KeyValue)decoder.current();
        tags = kv.getTags();
        Assert.assertEquals((long)2L, (long)tags.size());
        Assert.assertEquals((Object)"tagValue1", (Object)Bytes.toString(tags.get(0).getValue()));
        Assert.assertEquals((Object)"tagValue2", (Object)Bytes.toString(tags.get(1).getValue()));
    }

    private KeyValue createKV(int noOfTags) {
        byte[] row = Bytes.toBytes("myRow");
        byte[] cf = Bytes.toBytes("myCF");
        byte[] q = Bytes.toBytes("myQualifier");
        byte[] value = Bytes.toBytes("myValue");
        ArrayList<Tag> tags = new ArrayList<Tag>(noOfTags);
        for (int i = 1; i <= noOfTags; ++i) {
            tags.add(new Tag((byte)i, Bytes.toBytes("tagValue" + i)));
        }
        return new KeyValue(row, cf, q, Long.MAX_VALUE, value, tags);
    }
}

