/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.throttle;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public abstract class PressureAwareThroughputController
extends Configured
implements ThroughputController,
Stoppable {
    private static final Log LOG = LogFactory.getLog(PressureAwareThroughputController.class);
    protected long maxThroughputUpperBound;
    protected long maxThroughputLowerBound;
    protected OffPeakHours offPeakHours;
    protected long controlPerSize;
    protected int tuningPeriod;
    private volatile double maxThroughput;
    private volatile double maxThroughputPerOperation;
    protected final ConcurrentMap<String, ActiveOperation> activeOperations = new ConcurrentHashMap<String, ActiveOperation>();
    private volatile boolean stopped = false;

    @Override
    public abstract void setup(RegionServerServices var1);

    protected String throughputDesc(long deltaSize, long elapsedTime) {
        return this.throughputDesc((double)deltaSize / (double)elapsedTime * 1000.0);
    }

    protected String throughputDesc(double speed) {
        if (speed >= 1.0E15) {
            return "unlimited";
        }
        return String.format("%.2f MB/sec", speed / 1024.0 / 1024.0);
    }

    @Override
    public void start(String opName) {
        this.activeOperations.put(opName, new ActiveOperation());
        this.maxThroughputPerOperation = this.getMaxThroughput() / (double)this.activeOperations.size();
    }

    @Override
    public long control(String opName, long size) throws InterruptedException {
        ActiveOperation operation;
        ActiveOperation activeOperation = operation = (ActiveOperation)this.activeOperations.get(opName);
        activeOperation.totalSize = activeOperation.totalSize + size;
        long deltaSize = operation.totalSize - operation.lastControlSize;
        if (deltaSize < this.controlPerSize) {
            return 0L;
        }
        long now = EnvironmentEdgeManager.currentTime();
        long minTimeAllowed = (long)((double)deltaSize / this.maxThroughputPerOperation * 1000.0);
        long elapsedTime = now - operation.lastControlTime;
        operation.lastControlSize = operation.totalSize;
        if (elapsedTime >= minTimeAllowed) {
            operation.lastControlTime = EnvironmentEdgeManager.currentTime();
            return 0L;
        }
        long sleepTime = minTimeAllowed - elapsedTime;
        if (LOG.isDebugEnabled() && now - operation.lastLogTime > 5000L) {
            LOG.debug((Object)("deltaSize: " + deltaSize + " bytes; elapseTime: " + elapsedTime + " ns"));
            LOG.debug((Object)(opName + " sleep " + sleepTime + " ms because current throughput is " + this.throughputDesc(deltaSize, elapsedTime) + ", max allowed is " + this.throughputDesc(this.maxThroughputPerOperation) + ", already slept " + operation.numberOfSleeps + " time(s) and total slept time is " + operation.totalSleepTime + " ms till now."));
            operation.lastLogTime = now;
        }
        Thread.sleep(sleepTime);
        operation.numberOfSleeps++;
        ActiveOperation activeOperation2 = operation;
        activeOperation2.totalSleepTime = activeOperation2.totalSleepTime + sleepTime;
        operation.lastControlTime = EnvironmentEdgeManager.currentTime();
        return sleepTime;
    }

    @Override
    public void finish(String opName) {
        ActiveOperation operation = (ActiveOperation)this.activeOperations.remove(opName);
        this.maxThroughputPerOperation = this.getMaxThroughput() / (double)this.activeOperations.size();
        long elapsedTime = EnvironmentEdgeManager.currentTime() - operation.startTime;
        LOG.info((Object)(opName + " average throughput is " + this.throughputDesc(operation.totalSize, elapsedTime) + ", slept " + operation.numberOfSleeps + " time(s) and total slept time is " + operation.totalSleepTime + " ms. " + this.activeOperations.size() + " active operations remaining, total limit is " + this.throughputDesc(this.getMaxThroughput())));
    }

    @Override
    public void stop(String why) {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public double getMaxThroughput() {
        return this.maxThroughput;
    }

    public void setMaxThroughput(double maxThroughput) {
        this.maxThroughput = maxThroughput;
        this.maxThroughputPerOperation = this.getMaxThroughput() / (double)this.activeOperations.size();
    }

    private static final class ActiveOperation {
        private final long startTime;
        private long lastControlTime;
        private long lastControlSize;
        private long totalSize;
        private long numberOfSleeps;
        private long totalSleepTime;
        private long lastLogTime;

        ActiveOperation() {
            long currentTime;
            this.startTime = currentTime = EnvironmentEdgeManager.currentTime();
            this.lastControlTime = currentTime;
            this.lastLogTime = currentTime;
        }
    }
}

