/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanDeleteTracker;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestScanDeleteTracker {
    private ScanDeleteTracker sdt;
    private long timestamp = 10L;

    @Before
    public void setUp() throws Exception {
        this.sdt = new ScanDeleteTracker();
    }

    @Test
    public void testDeletedByDelete() {
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), Bytes.toBytes("qualifier"), this.timestamp, KeyValue.Type.Delete);
        this.sdt.add(kv);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.VERSION_DELETED), (Object)((Object)ret));
    }

    @Test
    public void testDeletedByDeleteColumn() {
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), Bytes.toBytes("qualifier"), this.timestamp, KeyValue.Type.DeleteColumn);
        this.sdt.add(kv);
        this.timestamp -= 5L;
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), Bytes.toBytes("qualifier"), this.timestamp, KeyValue.Type.DeleteColumn);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.COLUMN_DELETED), (Object)((Object)ret));
    }

    @Test
    public void testDeletedByDeleteFamily() {
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), Bytes.toBytes("qualifier"), this.timestamp, KeyValue.Type.DeleteFamily);
        this.sdt.add(kv);
        this.timestamp -= 5L;
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), Bytes.toBytes("qualifier"), this.timestamp, KeyValue.Type.DeleteColumn);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.FAMILY_DELETED), (Object)((Object)ret));
    }

    @Test
    public void testDeletedByDeleteFamilyVersion() {
        byte[] qualifier1 = Bytes.toBytes("qualifier1");
        byte[] qualifier2 = Bytes.toBytes("qualifier2");
        byte[] qualifier3 = Bytes.toBytes("qualifier3");
        byte[] qualifier4 = Bytes.toBytes("qualifier4");
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), null, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        this.sdt.add(kv);
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier1, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED), (Object)((Object)ret));
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier2, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED), (Object)((Object)ret));
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier3, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED), (Object)((Object)ret));
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier4, this.timestamp, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.FAMILY_VERSION_DELETED), (Object)((Object)ret));
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier1, this.timestamp + 3L, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.NOT_DELETED), (Object)((Object)ret));
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier2, this.timestamp - 2L, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.NOT_DELETED), (Object)((Object)ret));
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier3, this.timestamp - 5L, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.NOT_DELETED), (Object)((Object)ret));
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier4, this.timestamp + 8L, KeyValue.Type.DeleteFamilyVersion);
        ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.NOT_DELETED), (Object)((Object)ret));
    }

    @Test
    public void testDeleteDeleteColumn() {
        byte[] qualifier = Bytes.toBytes("qualifier");
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier, this.timestamp, KeyValue.Type.Delete);
        this.sdt.add(kv);
        this.timestamp -= 5L;
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier, this.timestamp, KeyValue.Type.DeleteColumn);
        this.sdt.add(kv);
        this.timestamp -= 5L;
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier, this.timestamp, KeyValue.Type.DeleteColumn);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.COLUMN_DELETED), (Object)((Object)ret));
    }

    @Test
    public void testDeleteColumnDelete() {
        byte[] qualifier = Bytes.toBytes("qualifier");
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier, this.timestamp, KeyValue.Type.DeleteColumn);
        this.sdt.add(kv);
        qualifier = Bytes.toBytes("qualifier1");
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier, this.timestamp, KeyValue.Type.Delete);
        this.sdt.add(kv);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.VERSION_DELETED), (Object)((Object)ret));
    }

    @Test
    public void testDeleteKeepDelete() {
        byte[] qualifier = Bytes.toBytes("qualifier");
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier, this.timestamp, KeyValue.Type.Delete);
        this.sdt.add(kv);
        this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)false, (Object)this.sdt.isEmpty());
    }

    @Test
    public void testDeleteKeepVersionZero() {
        byte[] qualifier = Bytes.toBytes("qualifier");
        long deleteTimestamp = 10L;
        long valueTimestamp = 0L;
        this.sdt.reset();
        KeyValue kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier, deleteTimestamp, KeyValue.Type.Delete);
        this.sdt.add(kv);
        kv = new KeyValue(Bytes.toBytes("row"), Bytes.toBytes("f"), qualifier, valueTimestamp, KeyValue.Type.Delete);
        DeleteTracker.DeleteResult ret = this.sdt.isDeleted(kv);
        Assert.assertEquals((Object)((Object)DeleteTracker.DeleteResult.NOT_DELETED), (Object)((Object)ret));
    }
}

