/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import drill.shaded.hbase.guava.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@Deprecated
@InterfaceAudience.Private
public class LegacyScanQueryMatcher
extends ScanQueryMatcher {
    private final TimeRange tr;
    private final Filter filter;
    private final DeleteTracker deletes;
    private boolean retainDeletesInOutput;
    private final KeepDeletedCells keepDeletedCells;
    private final long timeToPurgeDeletes;
    private final boolean hasNullColumn;
    private final long maxReadPointToTrackVersions;
    protected final long earliestPutTs;
    private final byte[] stopRow;
    private byte[] dropDeletesFromRow = null;
    private byte[] dropDeletesToRow = null;

    private LegacyScanQueryMatcher(Scan scan, ScanInfo scanInfo, ColumnTracker columns, boolean hasNullColumn, DeleteTracker deletes, ScanType scanType, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now) {
        super(LegacyScanQueryMatcher.createStartKeyFromRow(scan.getStartRow(), scanInfo), scanInfo, columns, oldestUnexpiredTS, now);
        TimeRange timeRange = scan.getColumnFamilyTimeRange().get(scanInfo.getFamily());
        this.tr = timeRange == null ? scan.getTimeRange() : timeRange;
        this.hasNullColumn = hasNullColumn;
        this.deletes = deletes;
        this.filter = scan.getFilter();
        this.maxReadPointToTrackVersions = readPointToUse;
        this.timeToPurgeDeletes = scanInfo.getTimeToPurgeDeletes();
        this.earliestPutTs = earliestPutTs;
        this.keepDeletedCells = scanInfo.getKeepDeletedCells();
        this.retainDeletesInOutput = scanType == ScanType.COMPACT_RETAIN_DELETES;
        this.stopRow = scan.getStopRow();
    }

    private LegacyScanQueryMatcher(Scan scan, ScanInfo scanInfo, ColumnTracker columns, boolean hasNullColumn, DeleteTracker deletes, ScanType scanType, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) {
        this(scan, scanInfo, columns, hasNullColumn, deletes, scanType, readPointToUse, earliestPutTs, oldestUnexpiredTS, now);
        this.dropDeletesFromRow = Preconditions.checkNotNull(dropDeletesFromRow);
        this.dropDeletesToRow = Preconditions.checkNotNull(dropDeletesToRow);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ScanQueryMatcher.MatchCode match(Cell cell) throws IOException {
        int timestampComparison;
        if (this.filter != null && this.filter.filterAllRemaining()) {
            return ScanQueryMatcher.MatchCode.DONE_SCAN;
        }
        ScanQueryMatcher.MatchCode returnCode = this.preCheck(cell);
        if (returnCode != null) {
            return returnCode;
        }
        long timestamp = cell.getTimestamp();
        byte typeByte = cell.getTypeByte();
        long mvccVersion = cell.getSequenceId();
        int qualifierOffset = cell.getQualifierOffset();
        int qualifierLength = cell.getQualifierLength();
        if (CellUtil.isDelete(typeByte)) {
            boolean includeDeleteMarker;
            if ((this.keepDeletedCells == KeepDeletedCells.FALSE || this.keepDeletedCells == KeepDeletedCells.TTL && timestamp < this.oldestUnexpiredTS) && (includeDeleteMarker = this.tr.withinOrAfterTimeRange(timestamp)) && mvccVersion <= this.maxReadPointToTrackVersions) {
                this.deletes.add(cell);
            }
            if (this.timeToPurgeDeletes > 0L && EnvironmentEdgeManager.currentTime() - timestamp <= this.timeToPurgeDeletes) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            if (this.retainDeletesInOutput || mvccVersion > this.maxReadPointToTrackVersions) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            if (this.keepDeletedCells != KeepDeletedCells.TRUE && (this.keepDeletedCells != KeepDeletedCells.TTL || timestamp < this.oldestUnexpiredTS)) return ScanQueryMatcher.MatchCode.SKIP;
            if (timestamp < this.earliestPutTs) {
                return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
            }
        } else if (!this.deletes.isEmpty()) {
            DeleteTracker.DeleteResult deleteResult = this.deletes.isDeleted(cell);
            switch (deleteResult) {
                case FAMILY_DELETED: 
                case COLUMN_DELETED: {
                    return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
                }
                case VERSION_DELETED: 
                case FAMILY_VERSION_DELETED: {
                    return ScanQueryMatcher.MatchCode.SKIP;
                }
                case NOT_DELETED: {
                    break;
                }
                default: {
                    throw new RuntimeException("UNEXPECTED");
                }
            }
        }
        if ((timestampComparison = this.tr.compare(timestamp)) >= 1) {
            return ScanQueryMatcher.MatchCode.SKIP;
        }
        if (timestampComparison <= -1) {
            return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
        }
        ScanQueryMatcher.MatchCode colChecker = this.columns.checkColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength, typeByte);
        if (colChecker != ScanQueryMatcher.MatchCode.INCLUDE) return colChecker;
        Filter.ReturnCode filterResponse = Filter.ReturnCode.SKIP;
        if (this.filter != null) {
            filterResponse = this.filter.filterKeyValue(cell);
            switch (filterResponse) {
                case SKIP: {
                    return ScanQueryMatcher.MatchCode.SKIP;
                }
                case NEXT_COL: {
                    return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
                }
                case NEXT_ROW: {
                    return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
                }
                case SEEK_NEXT_USING_HINT: {
                    return ScanQueryMatcher.MatchCode.SEEK_NEXT_USING_HINT;
                }
            }
        }
        colChecker = this.columns.checkVersions(cell.getQualifierArray(), qualifierOffset, qualifierLength, timestamp, typeByte, mvccVersion > this.maxReadPointToTrackVersions);
        return filterResponse == Filter.ReturnCode.INCLUDE_AND_NEXT_COL && colChecker == ScanQueryMatcher.MatchCode.INCLUDE ? ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL : colChecker;
    }

    @Override
    public boolean hasNullColumnInQuery() {
        return this.hasNullColumn;
    }

    private void checkPartialDropDeleteRange(Cell curCell) {
        byte[] rowArray = curCell.getRowArray();
        int rowOffset = curCell.getRowOffset();
        short rowLength = curCell.getRowLength();
        if (this.dropDeletesFromRow != null && (Arrays.equals(this.dropDeletesFromRow, HConstants.EMPTY_START_ROW) || Bytes.compareTo(rowArray, rowOffset, rowLength, this.dropDeletesFromRow, 0, this.dropDeletesFromRow.length) >= 0)) {
            this.retainDeletesInOutput = false;
            this.dropDeletesFromRow = null;
        }
        if (this.dropDeletesFromRow == null && this.dropDeletesToRow != null && !Arrays.equals(this.dropDeletesToRow, HConstants.EMPTY_END_ROW) && Bytes.compareTo(rowArray, rowOffset, rowLength, this.dropDeletesToRow, 0, this.dropDeletesToRow.length) >= 0) {
            this.retainDeletesInOutput = true;
            this.dropDeletesToRow = null;
        }
    }

    @Override
    protected void reset() {
        this.checkPartialDropDeleteRange(this.currentRow);
    }

    @Override
    public boolean isUserScan() {
        return false;
    }

    @Override
    public boolean moreRowsMayExistAfter(Cell cell) {
        if (this.stopRow == null || this.stopRow.length == 0) {
            return true;
        }
        return this.rowComparator.compareRows(cell, this.stopRow, 0, this.stopRow.length) < 0;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Cell getNextKeyHint(Cell cell) throws IOException {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getNextCellHint(cell);
    }

    public static LegacyScanQueryMatcher create(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, ScanType scanType, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now, byte[] dropDeletesFromRow, byte[] dropDeletesToRow, RegionCoprocessorHost regionCoprocessorHost) throws IOException {
        ColumnTracker columnTracker;
        boolean hasNullColumn;
        int maxVersions = Math.min(scan.getMaxVersions(), scanInfo.getMaxVersions());
        if (columns == null || columns.size() == 0) {
            hasNullColumn = true;
            columnTracker = new ScanWildcardColumnTracker(scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS);
        } else {
            hasNullColumn = ((byte[])columns.first()).length == 0;
            columnTracker = new ExplicitColumnTracker(columns, scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS);
        }
        DeleteTracker deletes = LegacyScanQueryMatcher.instantiateDeleteTracker(regionCoprocessorHost);
        if (dropDeletesFromRow == null) {
            return new LegacyScanQueryMatcher(scan, scanInfo, columnTracker, hasNullColumn, deletes, scanType, readPointToUse, earliestPutTs, oldestUnexpiredTS, now);
        }
        return new LegacyScanQueryMatcher(scan, scanInfo, columnTracker, hasNullColumn, deletes, scanType, readPointToUse, earliestPutTs, oldestUnexpiredTS, now, dropDeletesFromRow, dropDeletesToRow);
    }
}

