/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import drill.shaded.hbase.guava.com.google.common.collect.ImmutableList;
import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StripeMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.StripeStoreConfig;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.StripeStoreFlusher;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.TestCompactor;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcatenatedLists;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestStripeCompactionPolicy {
    private static final byte[] KEY_A = Bytes.toBytes("aaa");
    private static final byte[] KEY_B = Bytes.toBytes("bbb");
    private static final byte[] KEY_C = Bytes.toBytes("ccc");
    private static final byte[] KEY_D = Bytes.toBytes("ddd");
    private static final byte[] KEY_E = Bytes.toBytes("eee");
    private static final KeyValue KV_A = new KeyValue(KEY_A, 0L);
    private static final KeyValue KV_B = new KeyValue(KEY_B, 0L);
    private static final KeyValue KV_C = new KeyValue(KEY_C, 0L);
    private static final KeyValue KV_D = new KeyValue(KEY_D, 0L);
    private static final KeyValue KV_E = new KeyValue(KEY_E, 0L);
    private static long defaultSplitSize = 18L;
    private static float defaultSplitCount = 1.8f;
    private static final int defaultInitialCount = 1;
    private static long defaultTtl = 1000000L;
    @Parameterized.Parameter
    public boolean usePrivateReaders;

    @Parameterized.Parameters(name="{index}: usePrivateReaders={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testNoStripesFromFlush() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.store.stripe.compaction.flushToL0", true);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesL0Only(0, 0L);
        KeyValue[] input = new KeyValue[]{KV_A, KV_B, KV_C, KV_D, KV_E};
        KeyValue[][] expected = new KeyValue[][]{input};
        this.verifyFlush(policy, si, input, expected, null);
    }

    @Test
    public void testOldStripesFromFlush() throws Exception {
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create());
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripes(0, KEY_C, KEY_D);
        KeyValue[] input = new KeyValue[]{KV_B, KV_C, KV_C, KV_D, KV_E};
        KeyValue[][] expected = new KeyValue[][]{{KV_B}, {KV_C, KV_C}, {KV_D, KV_E}};
        this.verifyFlush(policy, si, input, expected, new byte[][]{StripeStoreFileManager.OPEN_KEY, KEY_C, KEY_D, StripeStoreFileManager.OPEN_KEY});
    }

    @Test
    public void testNewStripesFromFlush() throws Exception {
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create());
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesL0Only(0, 0L);
        KeyValue[] input = new KeyValue[]{KV_B, KV_C, KV_C, KV_D, KV_E};
        KeyValue[][] expected = new KeyValue[][]{input};
        this.verifyFlush(policy, si, input, expected, new byte[][]{StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY});
    }

    @Test
    public void testSingleStripeCompaction() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setFloat("hbase.hstore.compaction.ratio", 1.0f);
        conf.setInt("hbase.store.stripe.compaction.minFiles", 3);
        conf.setInt("hbase.store.stripe.compaction.maxFiles", 4);
        conf.setLong("hbase.store.stripe.sizeToSplit", 1000L);
        StoreConfigInformation sci = (StoreConfigInformation)Mockito.mock(StoreConfigInformation.class);
        StripeStoreConfig ssc = new StripeStoreConfig(conf, sci);
        StripeCompactionPolicy policy = new StripeCompactionPolicy(conf, sci, ssc){

            @Override
            public StripeCompactionPolicy.StripeCompactionRequest selectCompaction(StripeCompactionPolicy.StripeInformationProvider si, List<StoreFile> filesCompacting, boolean isOffpeak) throws IOException {
                if (!filesCompacting.isEmpty()) {
                    return null;
                }
                return this.selectSingleStripeCompaction(si, false, false, isOffpeak);
            }

            @Override
            public boolean needsCompactions(StripeCompactionPolicy.StripeInformationProvider si, List<StoreFile> filesCompacting) {
                if (!filesCompacting.isEmpty()) {
                    return false;
                }
                return this.needsSingleStripeCompaction(si);
            }
        };
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {2L}, {3L, 3L}, {5L, 1L});
        this.verifyNoCompaction(policy, si);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {2L}, {3L, 3L}, {5L, 1L, 1L});
        Assert.assertNull((Object)policy.selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), false));
        Assert.assertTrue((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new StoreFile[0])));
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {2L}, {3L, 3L}, {5L, 4L, 3L});
        this.verifySingleStripeCompaction(policy, si, 2, null);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {3L, 2L, 2L}, {2L, 2L, 1L}, {3L, 2L, 2L, 1L});
        this.verifySingleStripeCompaction(policy, si, 2, null);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {5L}, {3L, 2L, 2L, 1L}, {3L, 2L, 2L});
        this.verifySingleStripeCompaction(policy, si, 1, null);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {3L, 3L, 3L}, {3L, 1L, 2L}, {3L, 2L, 2L});
        this.verifySingleStripeCompaction(policy, si, 1, null);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {5L}, {5L, 4L, 4L, 4L, 4L});
        List sfs = si.getStripes().get(1).subList(1, 5);
        this.verifyCompaction(policy, si, sfs, null, 1, null, si.getStartRow(1), si.getEndRow(1), true);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, {5L}, {50L, 4L, 4L, 4L, 4L});
        sfs = si.getStripes().get(1).subList(1, 5);
        this.verifyCompaction(policy, si, sfs, null, 1, null, si.getStartRow(1), si.getEndRow(1), true);
    }

    @Test
    public void testWithParallelCompaction() throws Exception {
        Assert.assertNull((Object)TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create()).selectCompaction((StripeCompactionPolicy.StripeInformationProvider)Mockito.mock(StripeCompactionPolicy.StripeInformationProvider.class), TestStripeCompactionPolicy.al(TestStripeCompactionPolicy.createFile()), false));
    }

    @Test
    public void testWithReferences() throws Exception {
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create());
        StripeCompactor sc = (StripeCompactor)Mockito.mock(StripeCompactor.class);
        StoreFile ref = TestStripeCompactionPolicy.createFile();
        Mockito.when((Object)ref.isReference()).thenReturn((Object)true);
        StripeCompactionPolicy.StripeInformationProvider si = (StripeCompactionPolicy.StripeInformationProvider)Mockito.mock(StripeCompactionPolicy.StripeInformationProvider.class);
        ArrayList<StoreFile> sfs = TestStripeCompactionPolicy.al(ref, TestStripeCompactionPolicy.createFile());
        Mockito.when(si.getStorefiles()).thenReturn(sfs);
        Assert.assertTrue((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new StoreFile[0])));
        StripeCompactionPolicy.StripeCompactionRequest scr = policy.selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), false);
        Assert.assertEquals(si.getStorefiles(), scr.getRequest().getFiles());
        scr.execute(sc, NoLimitThroughputController.INSTANCE, null);
        ((StripeCompactor)Mockito.verify((Object)sc, (VerificationMode)Mockito.only())).compact((CompactionRequest)Matchers.eq((Object)scr.getRequest()), Matchers.anyInt(), Matchers.anyLong(), AdditionalMatchers.aryEq((byte[])StripeStoreFileManager.OPEN_KEY), AdditionalMatchers.aryEq((byte[])StripeStoreFileManager.OPEN_KEY), AdditionalMatchers.aryEq((byte[])StripeStoreFileManager.OPEN_KEY), AdditionalMatchers.aryEq((byte[])StripeStoreFileManager.OPEN_KEY), (ThroughputController)Matchers.any(NoLimitThroughputController.class), (User)Matchers.any(User.class));
    }

    @Test
    public void testInitialCountFromL0() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFilesL0", 2);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf, defaultSplitSize, defaultSplitCount, 2, false);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesL0Only(3, 8L);
        this.verifyCompaction(policy, si, si.getStorefiles(), true, 2, 12L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, true);
        si = TestStripeCompactionPolicy.createStripesL0Only(3, 10L);
        this.verifyCompaction(policy, si, si.getStorefiles(), true, 3, 10L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, true);
        policy = TestStripeCompactionPolicy.createPolicy(conf, defaultSplitSize, defaultSplitCount, 6, false);
        this.verifyCompaction(policy, si, si.getStorefiles(), true, 6, 5L, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY, true);
    }

    @Test
    public void testExistingStripesFromL0() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFilesL0", 3);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripes(3, new byte[][]{KEY_A});
        this.verifyCompaction(TestStripeCompactionPolicy.createPolicy(conf), si, si.getLevel0Files(), null, null, si.getStripeBoundaries());
    }

    @Test
    public void testNothingToCompactFromL0() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFilesL0", 4);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesL0Only(3, 10L);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        this.verifyNoCompaction(policy, si);
        si = TestStripeCompactionPolicy.createStripes(3, new byte[][]{KEY_A});
        this.verifyNoCompaction(policy, si);
    }

    @Test
    public void testSplitOffStripe() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFiles", 2);
        Long[] toSplit = new Long[]{defaultSplitSize - 2L, 1L, 1L};
        Long[] noSplit = new Long[]{defaultSplitSize - 2L, 1L};
        long splitTargetSize = (long)((float)defaultSplitSize / defaultSplitCount);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, new Long[][]{{defaultSplitSize - 2L, 2L}});
        Assert.assertNull((Object)TestStripeCompactionPolicy.createPolicy(conf).selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), false));
        conf.setFloat("hbase.hstore.compaction.ratio", 500.0f);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        this.verifyWholeStripesCompaction(policy, si, 0, 0, null, 2, splitTargetSize);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, noSplit, noSplit, toSplit);
        this.verifyWholeStripesCompaction(policy, si, 2, 2, null, 2, splitTargetSize);
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, noSplit, toSplit, noSplit);
        this.verifyWholeStripesCompaction(policy, si, 1, 1, null, 2, splitTargetSize);
        StripeCompactionPolicy specPolicy = TestStripeCompactionPolicy.createPolicy(conf, defaultSplitSize + 1L, defaultSplitCount, 1, false);
        this.verifySingleStripeCompaction(specPolicy, si, 1, null);
    }

    @Test
    public void testSplitOffStripeOffPeak() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFiles", 2);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, new Long[][]{{defaultSplitSize - 2L, 1L, 1L}});
        Assert.assertEquals((long)2L, (long)TestStripeCompactionPolicy.createPolicy(conf).selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), false).getRequest().getFiles().size());
        conf.setFloat("hbase.hstore.compaction.ratio.offpeak", 500.0f);
        Assert.assertEquals((long)3L, (long)TestStripeCompactionPolicy.createPolicy(conf).selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), true).getRequest().getFiles().size());
    }

    @Test
    public void testSplitOffStripeDropDeletes() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.store.stripe.compaction.minFiles", 2);
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        Long[] toSplit = new Long[]{defaultSplitSize / 2L, defaultSplitSize / 2L};
        Long[] noSplit = new Long[]{1L};
        long splitTargetSize = (long)((float)defaultSplitSize / defaultSplitCount);
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, noSplit, toSplit);
        this.verifyWholeStripesCompaction(policy, si, 1, 1, true, null, splitTargetSize);
        si = TestStripeCompactionPolicy.createStripesWithSizes(2, 2L, noSplit, toSplit);
        this.verifyWholeStripesCompaction(policy, si, 1, 1, false, null, splitTargetSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeExpiredFiles() throws Exception {
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        long now = defaultTtl + 2L;
        edge.setValue(now);
        EnvironmentEdgeManager.injectEdge(edge);
        try {
            StoreFile expiredFile = TestStripeCompactionPolicy.createFile();
            StoreFile notExpiredFile = TestStripeCompactionPolicy.createFile();
            Mockito.when((Object)expiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl - 1L));
            Mockito.when((Object)notExpiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl + 1L));
            ArrayList<StoreFile> expired = Lists.newArrayList(expiredFile, expiredFile);
            ArrayList<StoreFile> notExpired = Lists.newArrayList(notExpiredFile, notExpiredFile);
            ArrayList<StoreFile> mixed = Lists.newArrayList(expiredFile, notExpiredFile);
            StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create(), defaultSplitSize, defaultSplitCount, 1, true);
            StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithFiles(new List[]{expired, expired, expired});
            this.verifyWholeStripesCompaction(policy, si, 0, 2, null, 1, Long.MAX_VALUE, false);
            si = TestStripeCompactionPolicy.createStripesWithFiles(new List[]{notExpired, notExpired, notExpired});
            Assert.assertNull((Object)policy.selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), false));
            si = TestStripeCompactionPolicy.createStripesWithFiles(new List[]{notExpired, expired, notExpired});
            this.verifyWholeStripesCompaction(policy, si, 1, 2, null, 1, Long.MAX_VALUE, false);
            si = TestStripeCompactionPolicy.createStripesWithFiles(notExpired, expired, notExpired, expired, expired, notExpired);
            this.verifyWholeStripesCompaction(policy, si, 3, 4, null, 1, Long.MAX_VALUE, false);
            si = TestStripeCompactionPolicy.createStripesWithFiles(expired, expired, notExpired, expired, mixed);
            this.verifyWholeStripesCompaction(policy, si, 0, 1, null, 1, Long.MAX_VALUE, false);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMergeExpiredStripes() throws Exception {
        ManualEnvironmentEdge edge = new ManualEnvironmentEdge();
        long now = defaultTtl + 2L;
        edge.setValue(now);
        EnvironmentEdgeManager.injectEdge(edge);
        try {
            StoreFile expiredFile = TestStripeCompactionPolicy.createFile();
            StoreFile notExpiredFile = TestStripeCompactionPolicy.createFile();
            Mockito.when((Object)expiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl - 1L));
            Mockito.when((Object)notExpiredFile.getReader().getMaxTimestamp()).thenReturn((Object)(now - defaultTtl + 1L));
            ArrayList<StoreFile> expired = Lists.newArrayList(expiredFile, expiredFile);
            ArrayList<StoreFile> notExpired = Lists.newArrayList(notExpiredFile, notExpiredFile);
            StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(HBaseConfiguration.create(), defaultSplitSize, defaultSplitCount, 1, true);
            StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithFiles(new List[]{expired, expired, expired});
            this.verifyMergeCompatcion(policy, si, 0, 2);
            si = TestStripeCompactionPolicy.createStripesWithFiles(notExpired, expired, notExpired, expired, expired, notExpired);
            this.verifyMergeCompatcion(policy, si, 3, 4);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesWithFiles(List<StoreFile> ... stripeFiles) throws Exception {
        return TestStripeCompactionPolicy.createStripesWithFiles(TestStripeCompactionPolicy.createBoundaries(stripeFiles.length), Lists.newArrayList(stripeFiles), new ArrayList<StoreFile>());
    }

    @Test
    public void testSingleStripeDropDeletes() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        StripeCompactionPolicy policy = TestStripeCompactionPolicy.createPolicy(conf);
        Long[][] stripes = new Long[][]{{3L, 2L, 2L, 2L}, {6L}};
        StripeCompactionPolicy.StripeInformationProvider si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, stripes);
        this.verifySingleStripeCompaction(policy, si, 0, true);
        si = TestStripeCompactionPolicy.createStripesWithSizes(2, 2L, stripes);
        this.verifySingleStripeCompaction(policy, si, 0, false);
        si = TestStripeCompactionPolicy.createStripesWithSizes(6, 2L, stripes);
        ConcatenatedLists<StoreFile> sfs = new ConcatenatedLists<StoreFile>();
        sfs.addSublist(si.getLevel0Files());
        sfs.addSublist((List)si.getStripes().get(0));
        this.verifyCompaction(policy, si, sfs, si.getStartRow(0), si.getEndRow(0), si.getStripeBoundaries());
        si = TestStripeCompactionPolicy.createStripesWithSizes(6, 2L, {10L, 1L, 1L, 1L, 1L}, {12L});
        this.verifyCompaction(policy, si, si.getLevel0Files(), null, null, si.getStripeBoundaries());
        stripes = new Long[][]{{100L, 3L, 2L, 2L, 2L}, {6L}};
        si = TestStripeCompactionPolicy.createStripesWithSizes(0, 0L, stripes);
        ArrayList<StoreFile> compact_file = new ArrayList<StoreFile>();
        ListIterator iter = si.getStripes().get(0).listIterator(1);
        while (iter.hasNext()) {
            compact_file.add((StoreFile)iter.next());
        }
        this.verifyCompaction(policy, si, compact_file, false, 1, null, si.getStartRow(0), si.getEndRow(0), true);
    }

    private static StripeCompactionPolicy createPolicy(Configuration conf) throws Exception {
        return TestStripeCompactionPolicy.createPolicy(conf, defaultSplitSize, defaultSplitCount, 1, false);
    }

    private static StripeCompactionPolicy createPolicy(Configuration conf, long splitSize, float splitCount, int initialCount, boolean hasTtl) throws Exception {
        conf.setLong("hbase.store.stripe.sizeToSplit", splitSize);
        conf.setFloat("hbase.store.stripe.splitPartCount", splitCount);
        conf.setInt("hbase.store.stripe.initialStripeCount", initialCount);
        StoreConfigInformation sci = (StoreConfigInformation)Mockito.mock(StoreConfigInformation.class);
        Mockito.when((Object)sci.getStoreFileTtl()).thenReturn((Object)(hasTtl ? defaultTtl : Long.MAX_VALUE));
        StripeStoreConfig ssc = new StripeStoreConfig(conf, sci);
        return new StripeCompactionPolicy(conf, sci, ssc);
    }

    private static ArrayList<StoreFile> al(StoreFile ... sfs) {
        return new ArrayList<StoreFile>(Arrays.asList(sfs));
    }

    private void verifyMergeCompatcion(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, int from, int to) throws Exception {
        StripeCompactionPolicy.StripeCompactionRequest scr = policy.selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), false);
        List<StoreFile> sfs = TestStripeCompactionPolicy.getAllFiles(si, from, to);
        this.verifyCollectionsEqual(sfs, scr.getRequest().getFiles());
        StripeCompactor sc = this.createCompactor();
        List<Path> paths = scr.execute(sc, NoLimitThroughputController.INSTANCE, null);
        Assert.assertEquals((long)1L, (long)paths.size());
    }

    private void verifyWholeStripesCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, int from, int to, Boolean dropDeletes, Integer count, Long size, boolean needsCompaction) throws IOException {
        this.verifyCompaction(policy, si, TestStripeCompactionPolicy.getAllFiles(si, from, to), dropDeletes, count, size, si.getStartRow(from), si.getEndRow(to), needsCompaction);
    }

    private void verifyWholeStripesCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, int from, int to, Boolean dropDeletes, Integer count, Long size) throws IOException {
        this.verifyWholeStripesCompaction(policy, si, from, to, dropDeletes, count, size, true);
    }

    private void verifySingleStripeCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, int index, Boolean dropDeletes) throws IOException {
        this.verifyWholeStripesCompaction(policy, si, index, index, dropDeletes, 1, null, true);
    }

    private void verifyNoCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si) throws IOException {
        Assert.assertNull((Object)policy.selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), false));
        Assert.assertFalse((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new StoreFile[0])));
    }

    private void verifyCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, Collection<StoreFile> sfs, byte[] dropDeletesFrom, byte[] dropDeletesTo, final List<byte[]> boundaries) throws Exception {
        StripeCompactor sc = (StripeCompactor)Mockito.mock(StripeCompactor.class);
        Assert.assertTrue((boolean)policy.needsCompactions(si, TestStripeCompactionPolicy.al(new StoreFile[0])));
        StripeCompactionPolicy.StripeCompactionRequest scr = policy.selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), false);
        this.verifyCollectionsEqual(sfs, scr.getRequest().getFiles());
        scr.execute(sc, NoLimitThroughputController.INSTANCE, null);
        ((StripeCompactor)Mockito.verify((Object)sc, (VerificationMode)Mockito.times((int)1))).compact((CompactionRequest)Matchers.eq((Object)scr.getRequest()), (List)Matchers.argThat((Matcher)new ArgumentMatcher<List<byte[]>>(){

            public boolean matches(Object argument) {
                List other = (List)argument;
                if (other.size() != boundaries.size()) {
                    return false;
                }
                for (int i = 0; i < other.size(); ++i) {
                    if (Bytes.equals((byte[])other.get(i), (byte[])boundaries.get(i))) continue;
                    return false;
                }
                return true;
            }
        }), dropDeletesFrom == null ? (byte[])Matchers.isNull(byte[].class) : AdditionalMatchers.aryEq((byte[])dropDeletesFrom), dropDeletesTo == null ? (byte[])Matchers.isNull(byte[].class) : AdditionalMatchers.aryEq((byte[])dropDeletesTo), (ThroughputController)Matchers.any(NoLimitThroughputController.class), (User)Matchers.any(User.class));
    }

    private void verifyCompaction(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, Collection<StoreFile> sfs, Boolean dropDeletes, Integer count, Long size, byte[] start, byte[] end, boolean needsCompaction) throws IOException {
        StripeCompactor sc = (StripeCompactor)Mockito.mock(StripeCompactor.class);
        Assert.assertTrue((!needsCompaction || policy.needsCompactions(si, TestStripeCompactionPolicy.al(new StoreFile[0])) ? 1 : 0) != 0);
        StripeCompactionPolicy.StripeCompactionRequest scr = policy.selectCompaction(si, TestStripeCompactionPolicy.al(new StoreFile[0]), false);
        this.verifyCollectionsEqual(sfs, scr.getRequest().getFiles());
        scr.execute(sc, NoLimitThroughputController.INSTANCE, null);
        ((StripeCompactor)Mockito.verify((Object)sc, (VerificationMode)Mockito.times((int)1))).compact((CompactionRequest)Matchers.eq((Object)scr.getRequest()), count == null ? Matchers.anyInt() : Matchers.eq((int)count), size == null ? Matchers.anyLong() : Matchers.eq((long)size), AdditionalMatchers.aryEq((byte[])start), AdditionalMatchers.aryEq((byte[])end), this.dropDeletesMatcher(dropDeletes, start), this.dropDeletesMatcher(dropDeletes, end), (ThroughputController)Matchers.any(NoLimitThroughputController.class), (User)Matchers.any(User.class));
    }

    protected void verifyFlush(StripeCompactionPolicy policy, StripeCompactionPolicy.StripeInformationProvider si, KeyValue[] input, KeyValue[][] expected, byte[][] boundaries) throws IOException {
        TestCompactor.StoreFileWritersCapture writers = new TestCompactor.StoreFileWritersCapture();
        StripeStoreFlusher.StripeFlushRequest req = policy.selectFlush(new KeyValue.KVComparator(), si, input.length);
        StripeMultiFileWriter mw = req.createWriter();
        mw.init(null, writers);
        for (KeyValue kv : input) {
            mw.append(kv);
        }
        boolean hasMetadata = boundaries != null;
        mw.commitWriters(0L, false);
        writers.verifyKvs(expected, true, hasMetadata);
        if (hasMetadata) {
            writers.verifyBoundaries(boundaries);
        }
    }

    private byte[] dropDeletesMatcher(Boolean dropDeletes, byte[] value) {
        return dropDeletes == null ? (byte[])Matchers.any(byte[].class) : (dropDeletes != false ? AdditionalMatchers.aryEq((byte[])value) : (byte[])Matchers.isNull(byte[].class));
    }

    private void verifyCollectionsEqual(Collection<StoreFile> sfs, Collection<StoreFile> scr) {
        Assert.assertEquals((long)sfs.size(), (long)scr.size());
        Assert.assertTrue((boolean)scr.containsAll(sfs));
    }

    private static List<StoreFile> getAllFiles(StripeCompactionPolicy.StripeInformationProvider si, int fromStripe, int toStripe) {
        ArrayList<StoreFile> expected = new ArrayList<StoreFile>();
        for (int i = fromStripe; i <= toStripe; ++i) {
            expected.addAll((Collection<StoreFile>)si.getStripes().get(i));
        }
        return expected;
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripes(int l0Count, byte[] ... boundaries) throws Exception {
        ArrayList<Long> l0Sizes = new ArrayList<Long>();
        for (int i = 0; i < l0Count; ++i) {
            l0Sizes.add(5L);
        }
        ArrayList<List<Long>> sizes = new ArrayList<List<Long>>();
        for (int i = 0; i <= boundaries.length; ++i) {
            sizes.add(Arrays.asList(5L));
        }
        return TestStripeCompactionPolicy.createStripes(Arrays.asList(boundaries), sizes, l0Sizes);
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesL0Only(int l0Count, long l0Size) throws Exception {
        ArrayList<Long> l0Sizes = new ArrayList<Long>();
        for (int i = 0; i < l0Count; ++i) {
            l0Sizes.add(l0Size);
        }
        return TestStripeCompactionPolicy.createStripes(null, new ArrayList<List<Long>>(), l0Sizes);
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesWithSizes(int l0Count, long l0Size, Long[] ... sizes) throws Exception {
        ArrayList<List<Long>> sizeList = new ArrayList<List<Long>>();
        for (Long[] size : sizes) {
            sizeList.add(Arrays.asList(size));
        }
        return TestStripeCompactionPolicy.createStripesWithSizes(l0Count, l0Size, sizeList);
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesWithSizes(int l0Count, long l0Size, List<List<Long>> sizes) throws Exception {
        List<byte[]> boundaries = TestStripeCompactionPolicy.createBoundaries(sizes.size());
        ArrayList<Long> l0Sizes = new ArrayList<Long>();
        for (int i = 0; i < l0Count; ++i) {
            l0Sizes.add(l0Size);
        }
        return TestStripeCompactionPolicy.createStripes(boundaries, sizes, l0Sizes);
    }

    private static List<byte[]> createBoundaries(int stripeCount) {
        byte[][] keys = new byte[][]{KEY_A, KEY_B, KEY_C, KEY_D, KEY_E};
        assert (stripeCount <= keys.length + 1);
        ArrayList<byte[]> boundaries = new ArrayList<byte[]>();
        boundaries.addAll(Arrays.asList(keys).subList(0, stripeCount - 1));
        return boundaries;
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripes(List<byte[]> boundaries, List<List<Long>> stripeSizes, List<Long> l0Sizes) throws Exception {
        ArrayList<List<StoreFile>> stripeFiles = new ArrayList<List<StoreFile>>(stripeSizes.size());
        for (List<Long> sizes : stripeSizes) {
            ArrayList<StoreFile> sfs = new ArrayList<StoreFile>();
            for (Long size : sizes) {
                sfs.add(TestStripeCompactionPolicy.createFile(size));
            }
            stripeFiles.add(sfs);
        }
        ArrayList<StoreFile> l0Files = new ArrayList<StoreFile>();
        for (Long size : l0Sizes) {
            l0Files.add(TestStripeCompactionPolicy.createFile(size));
        }
        return TestStripeCompactionPolicy.createStripesWithFiles(boundaries, stripeFiles, l0Files);
    }

    private static StripeCompactionPolicy.StripeInformationProvider createStripesWithFiles(List<byte[]> boundaries, List<List<StoreFile>> stripeFiles, List<StoreFile> l0Files) throws Exception {
        ArrayList stripes = new ArrayList();
        ArrayList<byte[]> boundariesList = new ArrayList<byte[]>();
        StripeCompactionPolicy.StripeInformationProvider si = (StripeCompactionPolicy.StripeInformationProvider)Mockito.mock(StripeCompactionPolicy.StripeInformationProvider.class);
        if (!stripeFiles.isEmpty()) {
            assert (stripeFiles.size() == boundaries.size() + 1);
            boundariesList.add(StripeStoreFileManager.OPEN_KEY);
            for (int i = 0; i <= boundaries.size(); ++i) {
                byte[] startKey = i == 0 ? StripeStoreFileManager.OPEN_KEY : boundaries.get(i - 1);
                byte[] endKey = i == boundaries.size() ? StripeStoreFileManager.OPEN_KEY : boundaries.get(i);
                boundariesList.add(endKey);
                for (StoreFile sf : stripeFiles.get(i)) {
                    TestStripeCompactionPolicy.setFileStripe(sf, startKey, endKey);
                }
                stripes.add(ImmutableList.copyOf((Collection)stripeFiles.get(i)));
                Mockito.when((Object)si.getStartRow(Matchers.eq((int)i))).thenReturn((Object)startKey);
                Mockito.when((Object)si.getEndRow(Matchers.eq((int)i))).thenReturn((Object)endKey);
            }
        }
        ConcatenatedLists<Object> sfs = new ConcatenatedLists<Object>();
        sfs.addAllSublists(stripes);
        sfs.addSublist(l0Files);
        Mockito.when(si.getStorefiles()).thenReturn(sfs);
        Mockito.when(si.getStripes()).thenReturn(stripes);
        Mockito.when(si.getStripeBoundaries()).thenReturn(boundariesList);
        Mockito.when((Object)si.getStripeCount()).thenReturn((Object)stripes.size());
        Mockito.when(si.getLevel0Files()).thenReturn(l0Files);
        return si;
    }

    private static StoreFile createFile(long size) throws Exception {
        StoreFile sf = (StoreFile)Mockito.mock(StoreFile.class);
        Mockito.when((Object)sf.getPath()).thenReturn((Object)new Path("moo"));
        StoreFile.Reader r = (StoreFile.Reader)Mockito.mock(StoreFile.Reader.class);
        Mockito.when((Object)r.getEntries()).thenReturn((Object)size);
        Mockito.when((Object)r.length()).thenReturn((Object)size);
        Mockito.when((Object)((Object)r.getBloomFilterType())).thenReturn((Object)BloomType.NONE);
        Mockito.when((Object)r.getHFileReader()).thenReturn(Mockito.mock(HFile.Reader.class));
        Mockito.when((Object)r.getStoreFileScanner(Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean())).thenReturn(Mockito.mock(StoreFileScanner.class));
        Mockito.when((Object)sf.getReader()).thenReturn((Object)r);
        Mockito.when((Object)sf.createReader(Matchers.anyBoolean())).thenReturn((Object)r);
        Mockito.when((Object)sf.createReader()).thenReturn((Object)r);
        Mockito.when((Object)sf.cloneForReader()).thenReturn((Object)sf);
        return sf;
    }

    private static StoreFile createFile() throws Exception {
        return TestStripeCompactionPolicy.createFile(0L);
    }

    private static void setFileStripe(StoreFile sf, byte[] startKey, byte[] endKey) {
        Mockito.when((Object)sf.getMetadataValue(StripeStoreFileManager.STRIPE_START_KEY)).thenReturn((Object)startKey);
        Mockito.when((Object)sf.getMetadataValue(StripeStoreFileManager.STRIPE_END_KEY)).thenReturn((Object)endKey);
    }

    private StripeCompactor createCompactor() throws Exception {
        HColumnDescriptor col = new HColumnDescriptor(Bytes.toBytes("foo"));
        TestCompactor.StoreFileWritersCapture writers = new TestCompactor.StoreFileWritersCapture();
        Store store = (Store)Mockito.mock(Store.class);
        HRegionInfo info = (HRegionInfo)Mockito.mock(HRegionInfo.class);
        Mockito.when((Object)info.getRegionNameAsString()).thenReturn((Object)"testRegion");
        Mockito.when((Object)store.getFamily()).thenReturn((Object)col);
        Mockito.when((Object)store.getRegionInfo()).thenReturn((Object)info);
        Mockito.when((Object)store.createWriterInTmp(Matchers.anyLong(), (Compression.Algorithm)((Object)Matchers.any(Compression.Algorithm.class)), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean())).thenAnswer((Answer)writers);
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.regionserver.compaction.private.readers", this.usePrivateReaders);
        final Scanner scanner = new Scanner(new KeyValue[0]);
        return new StripeCompactor(conf, store){

            @Override
            protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
                return scanner;
            }

            @Override
            protected InternalScanner createScanner(Store store, List<StoreFileScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
                return scanner;
            }
        };
    }

    private static class Scanner
    implements InternalScanner {
        private final ArrayList<KeyValue> kvs;

        public Scanner(KeyValue ... kvs) {
            this.kvs = new ArrayList<KeyValue>(Arrays.asList(kvs));
        }

        @Override
        public boolean next(List<Cell> results) throws IOException {
            if (this.kvs.isEmpty()) {
                return false;
            }
            results.add(this.kvs.remove(0));
            return !this.kvs.isEmpty();
        }

        @Override
        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            return this.next(result);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

