/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRemoveRegionMetrics {
    private static MiniHBaseCluster cluster;
    private static Configuration conf;
    private static HBaseTestingUtility TEST_UTIL;
    private static MetricsAssertHelper metricsHelper;

    @BeforeClass
    public static void startCluster() throws Exception {
        metricsHelper = CompatibilityFactory.getInstance(MetricsAssertHelper.class);
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        conf.getLong("hbase.splitlog.max.resubmit", 0L);
        conf.setInt("zookeeper.recovery.retry", 0);
        conf.setInt("hbase.regionserver.info.port", -1);
        TEST_UTIL.startMiniCluster(1, 2);
        cluster = TEST_UTIL.getHBaseCluster();
        cluster.waitForActiveAndReadyMaster();
        while (cluster.getLiveRegionServerThreads().size() < 2) {
            Threads.sleep(100L);
        }
    }

    @Test
    public void testMoveRegion() throws IOException, InterruptedException {
        String tableNameString = "testMoveRegion";
        TableName tableName = TableName.valueOf(tableNameString);
        HTable t = TEST_UTIL.createTable(tableName, Bytes.toBytes("D"));
        TEST_UTIL.waitUntilAllRegionsAssigned(t.getName());
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        byte[] row = Bytes.toBytes("r1");
        for (int i = 0; i < 30; ++i) {
            HRegionInfo regionInfo;
            boolean moved = false;
            try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
                regionInfo = locator.getRegionLocation(row, true).getRegionInfo();
            }
            int currentServerIdx = cluster.getServerWith(regionInfo.getRegionName());
            int destServerIdx = (currentServerIdx + 1) % cluster.getLiveRegionServerThreads().size();
            HRegionServer currentServer = cluster.getRegionServer(currentServerIdx);
            HRegionServer destServer = cluster.getRegionServer(destServerIdx);
            Put p = new Put(row);
            p.addColumn(Bytes.toBytes("D"), Bytes.toBytes("Zero"), Bytes.toBytes("VALUE"));
            t.put(p);
            MetricsRegionAggregateSource currentAgg = currentServer.getRegion(regionInfo.getRegionName()).getMetrics().getSource().getAggregateSource();
            String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + regionInfo.getEncodedName() + "_metric";
            metricsHelper.assertCounter(prefix + "_putCount", 1L, currentAgg);
            try {
                TEST_UTIL.moveRegionAndWait(regionInfo, destServer.getServerName());
                moved = true;
            }
            catch (IOException ioe) {
                moved = false;
            }
            if (!moved) continue;
            MetricsRegionAggregateSource destAgg = destServer.getRegion(regionInfo.getRegionName()).getMetrics().getSource().getAggregateSource();
            metricsHelper.assertCounter(prefix + "_putCount", 0L, destAgg);
        }
        TEST_UTIL.deleteTable(tableName);
    }
}

