/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.ZkOpenRegionCoordination;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerNoMaster {
    private static final Log LOG = LogFactory.getLog(TestRegionServerNoMaster.class);
    private static final int NB_SERVERS = 1;
    private static HTable table;
    private static final byte[] row;
    private static HRegionInfo hri;
    private static byte[] regionName;
    private static final HBaseTestingUtility HTU;

    @BeforeClass
    public static void before() throws Exception {
        HTU.getConfiguration().setBoolean("hbase.assignment.usezk", true);
        HTU.startMiniCluster(1);
        TableName tableName = TableName.valueOf(TestRegionServerNoMaster.class.getSimpleName());
        table = HTU.createTable(tableName, HConstants.CATALOG_FAMILY);
        Put p = new Put(row);
        p.add(HConstants.CATALOG_FAMILY, row, row);
        table.put(p);
        hri = table.getRegionLocation(row, false).getRegionInfo();
        regionName = hri.getRegionName();
        TestRegionServerNoMaster.stopMasterAndAssignMeta(HTU);
    }

    public static void stopMasterAndAssignMeta(HBaseTestingUtility HTU) throws KeeperException.NodeExistsException, KeeperException, IOException, InterruptedException {
        HMaster master = HTU.getHBaseCluster().getMaster();
        JVMClusterUtil.MasterThread masterThread = HTU.getHBaseCluster().getMasterThread();
        ServerName masterAddr = master.getServerName();
        master.stopMaster();
        LOG.info((Object)"Waiting until master thread exits");
        while (masterThread != null && masterThread.isAlive()) {
            Threads.sleep(100L);
        }
    }

    public static void flushRegion(HBaseTestingUtility HTU, HRegionInfo regionInfo) throws IOException {
        for (JVMClusterUtil.RegionServerThread rst : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
            Region region = rst.getRegionServer().getRegionByEncodedName(regionInfo.getEncodedName());
            if (region == null) continue;
            region.flush(true);
            return;
        }
        throw new IOException("Region to flush cannot be found");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        table.close();
        HTU.shutdownMiniCluster();
    }

    @After
    public void after() throws Exception {
        ZKAssign.deleteNodeFailSilent(HTU.getZooKeeperWatcher(), hri);
    }

    private static HRegionServer getRS() {
        return HTU.getHBaseCluster().getLiveRegionServerThreads().get(0).getRegionServer();
    }

    public static void openRegion(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        ZKAssign.createNodeOffline(HTU.getZooKeeperWatcher(), hri, rs.getServerName());
        AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest(rs.getServerName(), hri, 0, null, null);
        AdminProtos.OpenRegionResponse responseOpen = rs.rpcServices.openRegion(null, orr);
        Assert.assertTrue((responseOpen.getOpeningStateCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)responseOpen.getOpeningState(0).equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED));
        TestRegionServerNoMaster.checkRegionIsOpened(HTU, rs, hri);
    }

    public static void checkRegionIsOpened(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        while (!rs.getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((boolean)rs.getRegion(hri.getRegionName()).isAvailable());
        Assert.assertTrue((boolean)ZKAssign.deleteOpenedNode(HTU.getZooKeeperWatcher(), hri.getEncodedName(), rs.getServerName()));
    }

    public static void closeRegion(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        ZKAssign.createNodeClosing(HTU.getZooKeeperWatcher(), hri, rs.getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest(rs.getServerName(), hri.getEncodedName(), true);
        AdminProtos.CloseRegionResponse responseClose = rs.rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, rs, hri);
        ZKAssign.deleteClosedNode(HTU.getZooKeeperWatcher(), hri.getEncodedName(), null);
    }

    public static void checkRegionIsClosed(HBaseTestingUtility HTU, HRegionServer rs, HRegionInfo hri) throws Exception {
        while (!rs.getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        boolean exception = false;
        try {
            while (rs.getRegion(hri.getRegionName()).isAvailable()) {
                Thread.sleep(10L);
            }
        }
        catch (NotServingRegionException expected) {
            exception = true;
        }
        assert (exception);
    }

    private void closeRegionNoZK() throws Exception {
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest(TestRegionServerNoMaster.getRS().getServerName(), regionName, false);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testCloseByRegionServer() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testCloseByMasterWithoutZNode() throws Exception {
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest(TestRegionServerNoMaster.getRS().getServerName(), regionName, true);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        while (!TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((String)"The close should have failed", (boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
    }

    @Test(timeout=60000L)
    public void testOpenCloseByMasterWithZNode() throws Exception {
        ZKAssign.createNodeClosing(HTU.getZooKeeperWatcher(), hri, TestRegionServerNoMaster.getRS().getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest(TestRegionServerNoMaster.getRS().getServerName(), regionName, true);
        AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        ZKAssign.deleteClosedNode(HTU.getZooKeeperWatcher(), hri.getEncodedName(), TestRegionServerNoMaster.getRS().getServerName());
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testMultipleOpen() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        ZKAssign.createNodeOffline(HTU.getZooKeeperWatcher(), hri, TestRegionServerNoMaster.getRS().getServerName());
        for (int i = 0; i < 10; ++i) {
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest(TestRegionServerNoMaster.getRS().getServerName(), hri, 0, null, null);
            AdminProtos.OpenRegionResponse responseOpen = TestRegionServerNoMaster.getRS().rpcServices.openRegion(null, orr);
            Assert.assertTrue((responseOpen.getOpeningStateCount() == 1 ? 1 : 0) != 0);
            AdminProtos.OpenRegionResponse.RegionOpeningState ors = responseOpen.getOpeningState(0);
            Assert.assertTrue((String)("request " + i + " failed"), (ors.equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED) || ors.equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.ALREADY_OPENED) ? 1 : 0) != 0);
        }
        TestRegionServerNoMaster.checkRegionIsOpened(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test
    public void testOpenClosingRegion() throws Exception {
        Assert.assertTrue((boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
        try {
            ServerName sn = TestRegionServerNoMaster.getRS().getServerName();
            MetaTableAccessor.updateRegionLocation(TestRegionServerNoMaster.getRS().getConnection(), hri, sn, TestRegionServerNoMaster.getRS().getRegion(regionName).getOpenSeqNum(), -1L);
            TestRegionServerNoMaster.getRS().regionsInTransitionInRS.put(hri.getEncodedNameAsBytes(), Boolean.FALSE);
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest(sn, hri, 0, null, null);
            TestRegionServerNoMaster.getRS().rpcServices.openRegion(null, orr);
            Assert.fail((String)"The closing region should not be opened");
        }
        catch (ServiceException se) {
            Assert.assertTrue((String)"The region should be already in transition", (boolean)(se.getCause() instanceof RegionAlreadyInTransitionException));
        }
        finally {
            TestRegionServerNoMaster.getRS().regionsInTransitionInRS.remove(hri.getEncodedNameAsBytes());
        }
    }

    @Test(timeout=60000L)
    public void testMultipleCloseFromMaster() throws Exception {
        ZKAssign.createNodeClosing(HTU.getZooKeeperWatcher(), hri, TestRegionServerNoMaster.getRS().getServerName());
        for (int i = 0; i < 10; ++i) {
            AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest(TestRegionServerNoMaster.getRS().getServerName(), regionName, 0, null, true);
            try {
                AdminProtos.CloseRegionResponse responseClose = TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
                Assert.assertEquals((String)"The first request should succeeds", (long)0L, (long)i);
                Assert.assertTrue((String)("request " + i + " failed"), (responseClose.getClosed() || responseClose.hasClosed() ? 1 : 0) != 0);
                continue;
            }
            catch (ServiceException se) {
                Assert.assertTrue((String)"The next queries should throw an exception.", (i > 0 ? 1 : 0) != 0);
            }
        }
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        Assert.assertTrue((boolean)ZKAssign.deleteClosedNode(HTU.getZooKeeperWatcher(), hri.getEncodedName(), TestRegionServerNoMaster.getRS().getServerName()));
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testCancelOpeningWithoutZK() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        ZKAssign.createNodeOffline(HTU.getZooKeeperWatcher(), hri, TestRegionServerNoMaster.getRS().getServerName());
        TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest(TestRegionServerNoMaster.getRS().getServerName(), regionName, false);
        try {
            TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
            Assert.assertTrue((boolean)false);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.FALSE, TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
        HTableDescriptor htd = TestRegionServerNoMaster.getRS().tableDescriptors.get(hri.getTable());
        ZkCoordinatedStateManager csm = new ZkCoordinatedStateManager();
        ((BaseCoordinatedStateManager)csm).initialize(TestRegionServerNoMaster.getRS());
        csm.start();
        ZkOpenRegionCoordination.ZkOpenRegionDetails zkCrd = new ZkOpenRegionCoordination.ZkOpenRegionDetails();
        zkCrd.setServerName(TestRegionServerNoMaster.getRS().getServerName());
        zkCrd.setVersionOfOfflineNode(0);
        TestRegionServerNoMaster.getRS().service.submit(new OpenRegionHandler(TestRegionServerNoMaster.getRS(), TestRegionServerNoMaster.getRS(), hri, htd, -1L, ((BaseCoordinatedStateManager)csm).getOpenRegionCoordination(), zkCrd));
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        Assert.assertTrue((boolean)ZKAssign.deleteNode(TestRegionServerNoMaster.getRS().getZooKeeper(), hri.getEncodedName(), EventType.RS_ZK_REGION_FAILED_OPEN, 1));
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    @Test(timeout=60000L)
    public void testCancelOpeningWithZK() throws Exception {
        this.closeRegionNoZK();
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
        ZKAssign.createNodeClosing(HTU.getZooKeeperWatcher(), hri, TestRegionServerNoMaster.getRS().getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest(TestRegionServerNoMaster.getRS().getServerName(), regionName, false);
        try {
            TestRegionServerNoMaster.getRS().rpcServices.closeRegion(null, crr);
            Assert.assertTrue((boolean)false);
        }
        catch (ServiceException expected) {
            Assert.assertTrue((boolean)(expected.getCause() instanceof RegionAlreadyInTransitionException));
        }
        Assert.assertTrue((boolean)ZKAssign.deleteNode(TestRegionServerNoMaster.getRS().getZooKeeper(), hri.getEncodedName(), EventType.M_ZK_REGION_CLOSING, 0));
        Assert.assertEquals((Object)Boolean.FALSE, TestRegionServerNoMaster.getRS().getRegionsInTransitionInRS().get(hri.getEncodedNameAsBytes()));
        HTableDescriptor htd = TestRegionServerNoMaster.getRS().tableDescriptors.get(hri.getTable());
        ZkCoordinatedStateManager csm = new ZkCoordinatedStateManager();
        ((BaseCoordinatedStateManager)csm).initialize(TestRegionServerNoMaster.getRS());
        csm.start();
        ZkOpenRegionCoordination.ZkOpenRegionDetails zkCrd = new ZkOpenRegionCoordination.ZkOpenRegionDetails();
        zkCrd.setServerName(TestRegionServerNoMaster.getRS().getServerName());
        zkCrd.setVersionOfOfflineNode(0);
        TestRegionServerNoMaster.getRS().service.submit(new OpenRegionHandler(TestRegionServerNoMaster.getRS(), TestRegionServerNoMaster.getRS(), hri, htd, -1L, ((BaseCoordinatedStateManager)csm).getOpenRegionCoordination(), zkCrd));
        TestRegionServerNoMaster.checkRegionIsClosed(HTU, TestRegionServerNoMaster.getRS(), hri);
        Assert.assertEquals((long)-1L, (long)ZKAssign.getVersion(HTU.getZooKeeperWatcher(), hri));
        TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenCloseRegionRPCIntendedForPreviousServer() throws Exception {
        Assert.assertTrue((boolean)TestRegionServerNoMaster.getRS().getRegion(regionName).isAvailable());
        ServerName sn = TestRegionServerNoMaster.getRS().getServerName();
        ServerName earlierServerName = ServerName.valueOf(sn.getHostname(), sn.getPort(), 1L);
        try {
            AdminProtos.CloseRegionRequest request = RequestConverter.buildCloseRegionRequest(earlierServerName, regionName, true);
            TestRegionServerNoMaster.getRS().getRSRpcServices().closeRegion(null, request);
            Assert.fail((String)"The closeRegion should have been rejected");
        }
        catch (ServiceException se) {
            Assert.assertTrue((boolean)(se.getCause() instanceof IOException));
            Assert.assertTrue((boolean)se.getCause().getMessage().contains("This RPC was intended for a different server"));
        }
        this.closeRegionNoZK();
        try {
            AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest(earlierServerName, hri, 0, null, null);
            TestRegionServerNoMaster.getRS().getRSRpcServices().openRegion(null, orr);
            Assert.fail((String)"The openRegion should have been rejected");
        }
        catch (ServiceException se) {
            Assert.assertTrue((boolean)(se.getCause() instanceof IOException));
            Assert.assertTrue((boolean)se.getCause().getMessage().contains("This RPC was intended for a different server"));
        }
        finally {
            TestRegionServerNoMaster.openRegion(HTU, TestRegionServerNoMaster.getRS(), hri);
        }
    }

    static {
        row = "ee".getBytes();
        HTU = new HBaseTestingUtility();
    }
}

