/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionServerAbort {
    private static final byte[] FAMILY_BYTES = Bytes.toBytes("f");
    private static final Log LOG = LogFactory.getLog(TestRegionServerAbort.class);
    private HBaseTestingUtility testUtil;
    private Configuration conf;
    private MiniDFSCluster dfsCluster;
    private MiniHBaseCluster cluster;

    @Before
    public void setup() throws Exception {
        this.testUtil = new HBaseTestingUtility();
        this.conf = this.testUtil.getConfiguration();
        this.conf.set("hbase.coprocessor.regionserver.classes", StopBlockingRegionObserver.class.getName());
        this.conf.set("hbase.coprocessor.region.classes", StopBlockingRegionObserver.class.getName());
        this.conf.set("dfs.blocksize", Long.toString(102400L));
        this.conf.set("dfs.client.read.prefetch.size", Long.toString(102400L));
        this.testUtil.startMiniZKCluster();
        this.dfsCluster = this.testUtil.startMiniDFSCluster(2);
        this.cluster = this.testUtil.startMiniHBaseCluster(1, 2);
    }

    @After
    public void tearDown() throws Exception {
        for (JVMClusterUtil.RegionServerThread t : this.cluster.getRegionServerThreads()) {
            HRegionServer rs = t.getRegionServer();
            RegionServerCoprocessorHost cpHost = rs.getRegionServerCoprocessorHost();
            StopBlockingRegionObserver cp = (StopBlockingRegionObserver)cpHost.findCoprocessor(StopBlockingRegionObserver.class.getName());
            cp.setStopAllowed(true);
        }
        this.testUtil.shutdownMiniCluster();
    }

    @Test
    public void testAbortFromRPC() throws Exception {
        TableName tableName = TableName.valueOf("testAbortFromRPC");
        HTable table = this.testUtil.createTable(tableName, FAMILY_BYTES);
        this.testUtil.loadTable((Table)table, FAMILY_BYTES);
        LOG.info((Object)"Wrote data");
        this.cluster.flushcache(tableName);
        LOG.info((Object)"Flushed table");
        Put put = new Put(new byte[]{0, 0, 0, 0});
        put.addColumn(FAMILY_BYTES, Bytes.toBytes("c"), new byte[0]);
        put.setAttribute("DO_ABORT", new byte[]{1});
        table.put(put);
        HRegion firstRegion = this.cluster.findRegionsForTable(tableName).get(0);
        Assert.assertNotNull((Object)firstRegion);
        Assert.assertNotNull((Object)firstRegion.getRegionServerServices());
        LOG.info((Object)("isAborted = " + firstRegion.getRegionServerServices().isAborted()));
        Assert.assertTrue((boolean)firstRegion.getRegionServerServices().isAborted());
        LOG.info((Object)("isStopped = " + firstRegion.getRegionServerServices().isStopped()));
        Assert.assertTrue((boolean)firstRegion.getRegionServerServices().isStopped());
    }

    @Test
    public void testStopOverrideFromCoprocessor() throws Exception {
        HBaseAdmin admin = this.testUtil.getHBaseAdmin();
        HRegionServer regionserver = this.cluster.getRegionServer(0);
        admin.stopRegionServer(regionserver.getServerName().getHostAndPort());
        Assert.assertFalse((boolean)this.cluster.getRegionServer(0).isAborted());
        Assert.assertFalse((boolean)this.cluster.getRegionServer(0).isStopped());
    }

    public static class StopBlockingRegionObserver
    extends BaseRegionObserver
    implements RegionServerObserver {
        public static final String DO_ABORT = "DO_ABORT";
        private boolean stopAllowed;

        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            if (put.getAttribute(DO_ABORT) != null) {
                HRegionServer rs = (HRegionServer)c.getEnvironment().getRegionServerServices();
                LOG.info((Object)("Triggering abort for regionserver " + rs.getServerName()));
                rs.abort("Aborting for test");
            }
        }

        @Override
        public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
            if (!this.stopAllowed) {
                throw new IOException("Stop not allowed");
            }
        }

        @Override
        public void preMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        }

        @Override
        public void postMerge(ObserverContext<RegionServerCoprocessorEnvironment> c, Region regionA, Region regionB, Region mergedRegion) throws IOException {
        }

        @Override
        public void preMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, List<Mutation> metaEntries) throws IOException {
        }

        @Override
        public void postMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, Region mergedRegion) throws IOException {
        }

        @Override
        public void preRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        }

        @Override
        public void postRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        }

        @Override
        public void preRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        }

        @Override
        public void postRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        }

        @Override
        public ReplicationEndpoint postCreateReplicationEndPoint(ObserverContext<RegionServerCoprocessorEnvironment> ctx, ReplicationEndpoint endpoint) {
            return null;
        }

        @Override
        public void preReplicateLogEntries(ObserverContext<RegionServerCoprocessorEnvironment> ctx, List<AdminProtos.WALEntry> entries, CellScanner cells) throws IOException {
        }

        @Override
        public void postReplicateLogEntries(ObserverContext<RegionServerCoprocessorEnvironment> ctx, List<AdminProtos.WALEntry> entries, CellScanner cells) throws IOException {
        }

        public void setStopAllowed(boolean allowed) {
            this.stopAllowed = allowed;
        }

        public boolean isStopAllowed() {
            return this.stopAllowed;
        }
    }
}

