/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class})
public class TestMultiLogThreshold {
    private static RSRpcServices SERVICES;
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration CONF;
    private static final byte[] TEST_FAM;
    private static RSRpcServices.LogDelegate LD;
    private static HRegionServer RS;
    private static int THRESHOLD;

    @BeforeClass
    public static void setup() throws Exception {
        TableName tableName = TableName.valueOf("tableName");
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        CONF = TEST_UTIL.getConfiguration();
        THRESHOLD = CONF.getInt("hbase.rpc.rows.warning.threshold", 5000);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.createTable(tableName, TEST_FAM);
        RS = TEST_UTIL.getRSForFirstRegionInTable(tableName);
    }

    @Before
    public void setupTest() throws Exception {
        LD = (RSRpcServices.LogDelegate)Mockito.mock(RSRpcServices.LogDelegate.class);
        SERVICES = new RSRpcServices(RS, LD);
    }

    private void sendMultiRequest(int rows, ActionType actionType) throws ServiceException {
        RpcController rpcc = (RpcController)Mockito.mock(RpcController.class);
        ClientProtos.MultiRequest.Builder builder = ClientProtos.MultiRequest.newBuilder();
        int numRAs = 1;
        int numAs = 1;
        switch (actionType) {
            case REGION_ACTIONS: {
                numRAs = rows;
                break;
            }
            case ACTIONS: {
                numAs = rows;
            }
        }
        for (int i = 0; i < numRAs; ++i) {
            ClientProtos.RegionAction.Builder rab = ClientProtos.RegionAction.newBuilder();
            rab.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, new String("someStuff" + i).getBytes()));
            for (int j = 0; j < numAs; ++j) {
                ClientProtos.Action.Builder ab = ClientProtos.Action.newBuilder();
                rab.addAction(ab.build());
            }
            builder.addRegionAction(rab.build());
        }
        try {
            SERVICES.multi(rpcc, builder.build());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiLogThresholdRegionActions() throws ServiceException, IOException {
        this.sendMultiRequest(THRESHOLD + 1, ActionType.REGION_ACTIONS);
        ((RSRpcServices.LogDelegate)Mockito.verify((Object)LD, (VerificationMode)Mockito.times((int)1))).logBatchWarning(Mockito.anyString(), Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void testMultiNoLogThresholdRegionActions() throws ServiceException, IOException {
        this.sendMultiRequest(THRESHOLD, ActionType.REGION_ACTIONS);
        ((RSRpcServices.LogDelegate)Mockito.verify((Object)LD, (VerificationMode)Mockito.never())).logBatchWarning(Mockito.anyString(), Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void testMultiLogThresholdActions() throws ServiceException, IOException {
        this.sendMultiRequest(THRESHOLD + 1, ActionType.ACTIONS);
        ((RSRpcServices.LogDelegate)Mockito.verify((Object)LD, (VerificationMode)Mockito.times((int)1))).logBatchWarning(Mockito.anyString(), Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void testMultiNoLogThresholdAction() throws ServiceException, IOException {
        this.sendMultiRequest(THRESHOLD, ActionType.ACTIONS);
        ((RSRpcServices.LogDelegate)Mockito.verify((Object)LD, (VerificationMode)Mockito.never())).logBatchWarning(Mockito.anyString(), Mockito.anyInt(), Mockito.anyInt());
    }

    static {
        TEST_FAM = Bytes.toBytes("fam");
    }

    private static enum ActionType {
        REGION_ACTIONS,
        ACTIONS;

    }
}

