/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableLatencies;
import org.apache.hadoop.hbase.regionserver.MetricsTableLatenciesImpl;
import org.apache.hadoop.hbase.regionserver.RegionServerTableMetrics;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMetricsTableLatencies {
    public static MetricsAssertHelper HELPER = CompatibilityFactory.getInstance(MetricsAssertHelper.class);

    @Test
    public void testTableWrapperAggregateMetrics() throws IOException {
        TableName tn1 = TableName.valueOf("table1");
        TableName tn2 = TableName.valueOf("table2");
        MetricsTableLatencies latencies = CompatibilitySingletonFactory.getInstance(MetricsTableLatencies.class);
        Assert.assertTrue((String)("'latencies' is actually " + latencies.getClass()), (boolean)(latencies instanceof MetricsTableLatenciesImpl));
        MetricsTableLatenciesImpl latenciesImpl = (MetricsTableLatenciesImpl)latencies;
        RegionServerTableMetrics tableMetrics = new RegionServerTableMetrics();
        tableMetrics.updateGet(tn1, 500L);
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName(tn1, "getTime_999th_percentile"), 500L, (BaseSource)latenciesImpl);
        tableMetrics.updatePut(tn1, 50L);
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName(tn1, "putTime_99th_percentile"), 50L, (BaseSource)latenciesImpl);
        tableMetrics.updateGet(tn2, 300L);
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName(tn2, "getTime_999th_percentile"), 300L, (BaseSource)latenciesImpl);
        tableMetrics.updatePut(tn2, 75L);
        HELPER.assertGauge(MetricsTableLatenciesImpl.qualifyMetricsName(tn2, "putTime_99th_percentile"), 75L, (BaseSource)latenciesImpl);
    }
}

