/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import drill.shaded.hbase.guava.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MockStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCompactionPolicy {
    private static final Log LOG = LogFactory.getLog(TestCompactionPolicy.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected Configuration conf;
    protected HStore store;
    private static final String DIR = TEST_UTIL.getDataTestDir(TestCompactionPolicy.class.getSimpleName()).toString();
    protected static Path TEST_FILE;
    protected static final int minFiles = 3;
    protected static final int maxFiles = 5;
    protected static final long minSize = 10L;
    protected static final long maxSize = 2100L;
    private FSHLog hlog;
    private HRegion region;

    @Before
    public void setUp() throws Exception {
        this.config();
        this.initialize();
    }

    protected void config() {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setLong("hbase.hregion.majorcompaction", 0L);
        this.conf.setInt("hbase.hstore.compaction.min", 3);
        this.conf.setInt("hbase.hstore.compaction.max", 5);
        this.conf.setLong("hbase.hstore.compaction.min.size", 10L);
        this.conf.setLong("hbase.hstore.compaction.max.size", 2100L);
        this.conf.setFloat("hbase.hstore.compaction.ratio", 1.0f);
    }

    protected void initialize() throws IOException {
        Path basedir = new Path(DIR);
        String logName = "logs";
        Path logdir = new Path(DIR, logName);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes("family"));
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.delete(logdir, true);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(Bytes.toBytes("table")));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        this.hlog = new FSHLog(fs, basedir, logName, this.conf);
        this.region = HRegion.createHRegion(info, basedir, this.conf, htd, this.hlog);
        this.region.close();
        Path tableDir = FSUtils.getTableDir(basedir, htd.getTableName());
        this.region = new HRegion(tableDir, this.hlog, fs, this.conf, info, htd, null);
        this.store = new HStore(this.region, hcd, this.conf);
        TEST_FILE = this.region.getRegionFileSystem().createTempName();
        fs.createNewFile(TEST_FILE);
    }

    @After
    public void tearDown() throws IOException {
        IOException ex = null;
        try {
            this.region.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"Caught Exception", (Throwable)e);
            ex = e;
        }
        try {
            this.hlog.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"Caught Exception", (Throwable)e);
            ex = e;
        }
        if (ex != null) {
            throw ex;
        }
    }

    ArrayList<Long> toArrayList(long ... numbers) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long i : numbers) {
            result.add(i);
        }
        return result;
    }

    List<StoreFile> sfCreate(long ... sizes) throws IOException {
        ArrayList<Long> ageInDisk = new ArrayList<Long>();
        for (int i = 0; i < sizes.length; ++i) {
            ageInDisk.add(0L);
        }
        return this.sfCreate(this.toArrayList(sizes), ageInDisk);
    }

    List<StoreFile> sfCreate(ArrayList<Long> sizes, ArrayList<Long> ageInDisk) throws IOException {
        return this.sfCreate(false, sizes, ageInDisk);
    }

    List<StoreFile> sfCreate(boolean isReference, long ... sizes) throws IOException {
        ArrayList<Long> ageInDisk = new ArrayList<Long>(sizes.length);
        for (int i = 0; i < sizes.length; ++i) {
            ageInDisk.add(0L);
        }
        return this.sfCreate(isReference, this.toArrayList(sizes), ageInDisk);
    }

    List<StoreFile> sfCreate(boolean isReference, ArrayList<Long> sizes, ArrayList<Long> ageInDisk) throws IOException {
        ArrayList<StoreFile> ret = Lists.newArrayList();
        for (int i = 0; i < sizes.size(); ++i) {
            ret.add(new MockStoreFile(TEST_UTIL, TEST_FILE, sizes.get(i), ageInDisk.get(i), isReference, i));
        }
        return ret;
    }

    long[] getSizes(List<StoreFile> sfList) {
        long[] aNums = new long[sfList.size()];
        for (int i = 0; i < sfList.size(); ++i) {
            aNums[i] = sfList.get(i).getReader().length();
        }
        return aNums;
    }

    void compactEquals(List<StoreFile> candidates, long ... expected) throws IOException {
        this.compactEquals(candidates, false, false, expected);
    }

    void compactEquals(List<StoreFile> candidates, boolean forcemajor, long ... expected) throws IOException {
        this.compactEquals(candidates, forcemajor, false, expected);
    }

    void compactEquals(List<StoreFile> candidates, boolean forcemajor, boolean isOffPeak, long ... expected) throws IOException {
        this.store.forceMajor = forcemajor;
        CompactionRequest result = ((RatioBasedCompactionPolicy)this.store.storeEngine.getCompactionPolicy()).selectCompaction(candidates, new ArrayList<StoreFile>(), false, isOffPeak, forcemajor);
        ArrayList<StoreFile> actual = new ArrayList<StoreFile>(result.getFiles());
        if (isOffPeak && !forcemajor) {
            Assert.assertTrue((boolean)result.isOffPeak());
        }
        Assert.assertEquals((Object)Arrays.toString(expected), (Object)Arrays.toString(this.getSizes(actual)));
        this.store.forceMajor = false;
    }
}

