/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestCleanupMetaWAL {
    private static final Logger LOG = LoggerFactory.getLogger(TestCleanupMetaWAL.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void before() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void after() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testCleanupMetaWAL() throws Exception {
        TEST_UTIL.createTable(TableName.valueOf("test"), "cf");
        HRegionServer serverWithMeta = TEST_UTIL.getMiniHBaseCluster().getRegionServer(TEST_UTIL.getMiniHBaseCluster().getServerWithMeta());
        TEST_UTIL.getHBaseAdmin().move(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), null);
        TEST_UTIL.getMiniHBaseCluster().killRegionServer(serverWithMeta.getServerName());
        boolean scpFinished = false;
        for (int count = 0; count < 25 && !scpFinished; ++count) {
            List<ProcedureInfo> procs = TEST_UTIL.getMiniHBaseCluster().getMaster().listProcedures();
            for (ProcedureInfo pi : procs) {
                if (!pi.getProcName().startsWith("ServerCrashProcedure") || pi.getProcState() != ProcedureProtos.ProcedureState.FINISHED) continue;
                LOG.info("SCP is finished: " + pi.getProcName());
                scpFinished = true;
                break;
            }
            Thread.sleep(1000L);
        }
        MasterFileSystem fs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path walPath = new Path(fs.getWALRootDir(), "WALs");
        for (FileStatus status : FSUtils.listStatus(fs.getFileSystem(), walPath)) {
            if (!status.getPath().toString().contains("-splitting")) continue;
            Assert.fail((String)("Should not have splitting wal dir here:" + status));
        }
    }
}

