/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestCleanupCompactedFileAfterFailover {
    private static final Logger LOG = LoggerFactory.getLogger(TestCleanupCompactedFileAfterFailover.class);
    private static HBaseTestingUtility TEST_UTIL;
    private static Admin admin;
    private static Table table;
    private static TableName TABLE_NAME;
    private static byte[] ROW;
    private static byte[] FAMILY;
    private static byte[] QUALIFIER;
    private static byte[] VALUE;
    private static final int RS_NUMBER = 5;

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.getConfiguration().setInt("hbase.client.scanner.timeout.period", 1200000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compaction.min", 100);
        TEST_UTIL.getConfiguration().set("dfs.blocksize", "64000");
        TEST_UTIL.getConfiguration().set("dfs.namenode.fs-limits.min-block-size", "1024");
        TEST_UTIL.getConfiguration().set("hbase.master.hfilecleaner.ttl", "0");
        TEST_UTIL.startMiniCluster(5);
        admin = TEST_UTIL.getHBaseAdmin();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAME);
        htd.addFamily(new HColumnDescriptor(FAMILY));
        admin.createTable(htd);
        TEST_UTIL.waitTableAvailable(TABLE_NAME, 30000L);
        table = TEST_UTIL.getConnection().getTable(TABLE_NAME);
    }

    @After
    public void after() throws Exception {
        admin.disableTable(TABLE_NAME);
        admin.deleteTable(TABLE_NAME);
    }

    @Test
    public void testCleanupAfterFailoverWithCompactOnce() throws Exception {
        this.testCleanupAfterFailover(1);
    }

    @Test
    public void testCleanupAfterFailoverWithCompactTwice() throws Exception {
        this.testCleanupAfterFailover(2);
    }

    @Test
    public void testCleanupAfterFailoverWithCompactThreeTimes() throws Exception {
        this.testCleanupAfterFailover(3);
    }

    private void testCleanupAfterFailover(int compactNum) throws Exception {
        HRegionServer rsServedTable = null;
        ArrayList<Region> regions = new ArrayList<Region>();
        for (JVMClusterUtil.RegionServerThread rsThread : TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads()) {
            HRegionServer rs = rsThread.getRegionServer();
            if (!rs.getOnlineTables().contains(TABLE_NAME)) continue;
            regions.addAll(rs.getOnlineRegions(TABLE_NAME));
            rsServedTable = rs;
        }
        Assert.assertNotNull(rsServedTable);
        Assert.assertEquals((String)"Table should only have one region", (long)1L, (long)regions.size());
        HRegion region = (HRegion)regions.get(0);
        HStore store = (HStore)region.getStore(FAMILY);
        this.writeDataAndFlush(3, region);
        Assert.assertEquals((long)3L, (long)store.getStorefilesCount());
        store.getScanner(new Scan(), null, Long.MAX_VALUE);
        region.compact(true);
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        Assert.assertEquals((long)3L, (long)store.getStoreEngine().getStoreFileManager().getCompactedfiles().size());
        for (int i = 1; i < compactNum; ++i) {
            region.compact(true);
            Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
            store.closeAndArchiveCompactedFiles();
            Assert.assertEquals((long)3L, (long)store.getStoreEngine().getStoreFileManager().getCompactedfiles().size());
        }
        int walNum = rsServedTable.getWALs().size();
        rsServedTable.walRoller.requestRollAll();
        region.flush(true);
        Assert.assertEquals((String)"The old WAL should be archived", (long)walNum, (long)rsServedTable.getWALs().size());
        rsServedTable.kill();
        Thread.sleep(3000L);
        TEST_UTIL.waitTableAvailable(TABLE_NAME, 30000L);
        regions.clear();
        for (JVMClusterUtil.RegionServerThread rsThread : TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads()) {
            HRegionServer rs = rsThread.getRegionServer();
            if (rs == rsServedTable || !rs.getOnlineTables().contains(TABLE_NAME)) continue;
            regions.addAll(rs.getOnlineRegions(TABLE_NAME));
        }
        Assert.assertEquals((String)"Table should only have one region", (long)1L, (long)regions.size());
        region = (HRegion)regions.get(0);
        store = (HStore)region.getStore(FAMILY);
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
    }

    private void writeDataAndFlush(int fileNum, HRegion region) throws Exception {
        for (int i = 0; i < fileNum; ++i) {
            for (int j = 0; j < 100; ++j) {
                table.put(new Put(this.concat(ROW, j)).addColumn(FAMILY, QUALIFIER, this.concat(VALUE, j)));
            }
            region.flush(true);
        }
    }

    private byte[] concat(byte[] base, int index) {
        return Bytes.toBytes(Bytes.toString(base) + "-" + index);
    }

    static {
        TABLE_NAME = TableName.valueOf("TestCleanupCompactedFileAfterFailover");
        ROW = Bytes.toBytes("row");
        FAMILY = Bytes.toBytes("cf");
        QUALIFIER = Bytes.toBytes("cq");
        VALUE = Bytes.toBytes("value");
    }
}

