/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Iterator;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.CellSkipListSet;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellSkipListSet
extends TestCase {
    private final CellSkipListSet csls = new CellSkipListSet(KeyValue.COMPARATOR);

    protected void setUp() throws Exception {
        super.setUp();
        this.csls.clear();
    }

    public void testAdd() throws Exception {
        byte[] bytes = Bytes.toBytes(this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        this.csls.add(kv);
        TestCellSkipListSet.assertTrue((boolean)this.csls.contains(kv));
        TestCellSkipListSet.assertEquals((int)1, (int)this.csls.sizeForTests());
        Cell first = this.csls.first();
        TestCellSkipListSet.assertTrue((boolean)kv.equals(first));
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals(kv.getValue(), first.getValue()));
        byte[] overwriteValue = Bytes.toBytes("overwrite");
        KeyValue overwrite = new KeyValue(bytes, bytes, bytes, overwriteValue);
        this.csls.add(overwrite);
        TestCellSkipListSet.assertEquals((int)1, (int)this.csls.sizeForTests());
        first = this.csls.first();
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals(overwrite.getValue(), first.getValue()));
        TestCellSkipListSet.assertFalse((boolean)Bytes.equals(overwrite.getValue(), kv.getValue()));
    }

    public void testIterator() throws Exception {
        byte[] bytes = Bytes.toBytes(this.getName());
        byte[] value1 = Bytes.toBytes("1");
        byte[] value2 = Bytes.toBytes("2");
        int total = 3;
        for (int i = 0; i < 3; ++i) {
            this.csls.add(new KeyValue(bytes, bytes, Bytes.toBytes("" + i), value1));
        }
        int count = 0;
        for (Cell kv : this.csls) {
            TestCellSkipListSet.assertEquals((String)("" + count), (String)Bytes.toString(kv.getQualifier()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals(kv.getValue(), value1));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
        for (int i = 0; i < 3; ++i) {
            this.csls.add(new KeyValue(bytes, bytes, Bytes.toBytes("" + i), value2));
        }
        count = 0;
        for (Cell kv : this.csls) {
            TestCellSkipListSet.assertEquals((String)("" + count), (String)Bytes.toString(kv.getQualifier()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals(kv.getValue(), value2));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
    }

    public void testDescendingIterator() throws Exception {
        Cell kv;
        byte[] bytes = Bytes.toBytes(this.getName());
        byte[] value1 = Bytes.toBytes("1");
        byte[] value2 = Bytes.toBytes("2");
        int total = 3;
        for (int i = 0; i < 3; ++i) {
            this.csls.add(new KeyValue(bytes, bytes, Bytes.toBytes("" + i), value1));
        }
        int count = 0;
        Iterator<Cell> i = this.csls.descendingIterator();
        while (i.hasNext()) {
            kv = i.next();
            TestCellSkipListSet.assertEquals((String)("" + (3 - (count + 1))), (String)Bytes.toString(kv.getQualifier()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals(kv.getValue(), value1));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.csls.add(new KeyValue(bytes, bytes, Bytes.toBytes("" + i2), value2));
        }
        count = 0;
        Iterator<Cell> i3 = this.csls.descendingIterator();
        while (i3.hasNext()) {
            kv = i3.next();
            TestCellSkipListSet.assertEquals((String)("" + (3 - (count + 1))), (String)Bytes.toString(kv.getQualifier()));
            TestCellSkipListSet.assertTrue((boolean)Bytes.equals(kv.getValue(), value2));
            ++count;
        }
        TestCellSkipListSet.assertEquals((int)3, (int)count);
    }

    public void testHeadTail() throws Exception {
        byte[] bytes = Bytes.toBytes(this.getName());
        byte[] value1 = Bytes.toBytes("1");
        byte[] value2 = Bytes.toBytes("2");
        int total = 3;
        KeyValue splitter = null;
        for (int i = 0; i < 3; ++i) {
            KeyValue kv = new KeyValue(bytes, bytes, Bytes.toBytes("" + i), value1);
            if (i == 1) {
                splitter = kv;
            }
            this.csls.add(kv);
        }
        SortedSet<Cell> tail = this.csls.tailSet(splitter);
        TestCellSkipListSet.assertEquals((int)2, (int)tail.size());
        SortedSet<Cell> head = this.csls.headSet(splitter);
        TestCellSkipListSet.assertEquals((int)1, (int)head.size());
        for (int i = 0; i < 3; ++i) {
            this.csls.add(new KeyValue(bytes, bytes, Bytes.toBytes("" + i), value2));
        }
        tail = this.csls.tailSet(splitter);
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals(tail.first().getValue(), value2));
        head = this.csls.headSet(splitter);
        TestCellSkipListSet.assertTrue((boolean)Bytes.equals(head.first().getValue(), value2));
    }
}

