/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.EncodedDataBlock;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public class DataBlockEncodingTool {
    private static final Log LOG = LogFactory.getLog(DataBlockEncodingTool.class);
    private static final boolean includesMemstoreTS = true;
    private static final int DEFAULT_BENCHMARK_N_TIMES = 12;
    private static final int DEFAULT_BENCHMARK_N_OMIT = 2;
    private static final String OPT_HFILE_NAME = "f";
    private static final String OPT_KV_LIMIT = "n";
    private static final String OPT_MEASURE_THROUGHPUT = "b";
    private static final String OPT_OMIT_CORRECTNESS_TEST = "c";
    private static final String OPT_ENCODING_ALGORITHM = "a";
    private static final String OPT_BENCHMARK_N_TIMES = "t";
    private static final String OPT_BENCHMARK_N_OMIT = "omit";
    private static final Compression.Algorithm DEFAULT_COMPRESSION = Compression.Algorithm.GZ;
    private static final DecimalFormat DELIMITED_DECIMAL_FORMAT = new DecimalFormat();
    private static final String PCT_FORMAT = "%.2f %%";
    private static final String INT_FORMAT = "%d";
    private static int benchmarkNTimes;
    private static int benchmarkNOmit;
    private List<EncodedDataBlock> codecs = new ArrayList<EncodedDataBlock>();
    private long totalPrefixLength = 0L;
    private long totalKeyLength = 0L;
    private long totalValueLength = 0L;
    private long totalKeyRedundancyLength = 0L;
    private long totalCFLength = 0L;
    private long totalTagsLength = 0L;
    private byte[] rawKVs;
    private boolean useHBaseChecksum = false;
    private final String compressionAlgorithmName;
    private final Compression.Algorithm compressionAlgorithm;
    private final Compressor compressor;
    private final Decompressor decompressor;
    private static final double BYTES_IN_MB = 1048576.0;
    private static final double NS_IN_SEC = 1.0E9;
    private static final double MB_SEC_COEF = 953.67431640625;

    public DataBlockEncodingTool(String compressionAlgorithmName) {
        this.compressionAlgorithmName = compressionAlgorithmName;
        this.compressionAlgorithm = Compression.getCompressionAlgorithmByName(compressionAlgorithmName);
        this.compressor = this.compressionAlgorithm.getCompressor();
        this.decompressor = this.compressionAlgorithm.getDecompressor();
    }

    public void checkStatistics(KeyValueScanner scanner, int kvLimit) throws IOException {
        KeyValue currentKV;
        scanner.seek(KeyValue.LOWESTKEY);
        byte[] previousKey = null;
        DataBlockEncoding[] encodings = DataBlockEncoding.values();
        ByteArrayOutputStream uncompressedOutputStream = new ByteArrayOutputStream();
        int j = 0;
        while ((currentKV = KeyValueUtil.ensureKeyValue(scanner.next())) != null && j < kvLimit) {
            ++j;
            byte[] currentKey = currentKV.getKey();
            if (previousKey != null) {
                for (int i = 0; i < previousKey.length && i < currentKey.length && previousKey[i] == currentKey[i]; ++i) {
                    ++this.totalKeyRedundancyLength;
                }
            }
            uncompressedOutputStream.write(currentKV.getBuffer(), currentKV.getOffset(), currentKV.getLength());
            previousKey = currentKey;
            int kLen = currentKV.getKeyLength();
            int vLen = currentKV.getValueLength();
            byte cfLen = currentKV.getFamilyLength(currentKV.getFamilyOffset());
            int restLen = currentKV.getLength() - kLen - vLen;
            int tagsLen = currentKV.getTagsLength();
            this.totalKeyLength += (long)kLen;
            this.totalValueLength += (long)vLen;
            this.totalPrefixLength += (long)restLen;
            this.totalCFLength += (long)cfLen;
            this.totalTagsLength += (long)tagsLen;
        }
        this.rawKVs = uncompressedOutputStream.toByteArray();
        boolean useTag = this.totalTagsLength > 0L;
        for (DataBlockEncoding encoding : encodings) {
            if (encoding == DataBlockEncoding.NONE) continue;
            DataBlockEncoder d = encoding.getEncoder();
            HFileContext meta = new HFileContextBuilder().withCompression(Compression.Algorithm.NONE).withIncludesMvcc(true).withIncludesTags(useTag).build();
            this.codecs.add(new EncodedDataBlock(d, encoding, this.rawKVs, meta));
        }
    }

    public boolean verifyCodecs(KeyValueScanner scanner, int kvLimit) throws IOException {
        KeyValue currentKv;
        scanner.seek(KeyValue.LOWESTKEY);
        ArrayList<Iterator<Cell>> codecIterators = new ArrayList<Iterator<Cell>>();
        for (EncodedDataBlock codec : this.codecs) {
            codecIterators.add(codec.getIterator(HFileBlock.headerSize(this.useHBaseChecksum)));
        }
        int j = 0;
        while ((currentKv = KeyValueUtil.ensureKeyValue(scanner.next())) != null && j < kvLimit) {
            ++j;
            for (Iterator iterator : codecIterators) {
                Cell c = (Cell)iterator.next();
                KeyValue codecKv = KeyValueUtil.ensureKeyValue(c);
                if (codecKv != null && 0 == Bytes.compareTo(codecKv.getBuffer(), codecKv.getOffset(), codecKv.getLength(), currentKv.getBuffer(), currentKv.getOffset(), currentKv.getLength())) continue;
                if (codecKv == null) {
                    LOG.error((Object)("There is a bug in codec " + iterator + " it returned null KeyValue,"));
                } else {
                    int prefix;
                    int limitLength = 8 + Math.min(codecKv.getLength(), currentKv.getLength());
                    for (prefix = 0; prefix < limitLength && codecKv.getBuffer()[prefix + codecKv.getOffset()] == currentKv.getBuffer()[prefix + currentKv.getOffset()]; ++prefix) {
                    }
                    LOG.error((Object)("There is bug in codec " + iterator.toString() + "\n on element " + j + "\n codecKv.getKeyLength() " + codecKv.getKeyLength() + "\n codecKv.getValueLength() " + codecKv.getValueLength() + "\n codecKv.getLength() " + codecKv.getLength() + "\n currentKv.getKeyLength() " + currentKv.getKeyLength() + "\n currentKv.getValueLength() " + currentKv.getValueLength() + "\n codecKv.getLength() " + currentKv.getLength() + "\n currentKV rowLength " + currentKv.getRowLength() + " familyName " + currentKv.getFamilyLength() + " qualifier " + currentKv.getQualifierLength() + "\n prefix " + prefix + "\n codecKv   '" + Bytes.toStringBinary(codecKv.getBuffer(), codecKv.getOffset(), prefix) + "' diff '" + Bytes.toStringBinary(codecKv.getBuffer(), codecKv.getOffset() + prefix, codecKv.getLength() - prefix) + "'\n currentKv '" + Bytes.toStringBinary(currentKv.getBuffer(), currentKv.getOffset(), prefix) + "' diff '" + Bytes.toStringBinary(currentKv.getBuffer(), currentKv.getOffset() + prefix, currentKv.getLength() - prefix) + "'"));
                }
                return false;
            }
        }
        LOG.info((Object)"Verification was successful!");
        return true;
    }

    public void benchmarkCodecs() throws IOException {
        LOG.info((Object)"Starting a throughput benchmark for data block encoding codecs");
        int prevTotalSize = -1;
        for (EncodedDataBlock codec : this.codecs) {
            prevTotalSize = this.benchmarkEncoder(prevTotalSize, codec);
        }
        this.benchmarkDefaultCompression(prevTotalSize, this.rawKVs);
    }

    private int benchmarkEncoder(int previousTotalSize, EncodedDataBlock codec) {
        long finishTime;
        long startTime;
        int prevTotalSize = previousTotalSize;
        int totalSize = 0;
        ArrayList<Long> durations = new ArrayList<Long>();
        for (int itTime = 0; itTime < benchmarkNTimes; ++itTime) {
            totalSize = 0;
            Iterator<Cell> it = codec.getIterator(HFileBlock.headerSize(this.useHBaseChecksum));
            startTime = System.nanoTime();
            while (it.hasNext()) {
                totalSize += KeyValueUtil.ensureKeyValue(it.next()).getLength();
            }
            finishTime = System.nanoTime();
            if (itTime >= benchmarkNOmit) {
                durations.add(finishTime - startTime);
            }
            if (prevTotalSize != -1 && prevTotalSize != totalSize) {
                throw new IllegalStateException(String.format("Algorithm '%s' decoded data to different size", codec.toString()));
            }
            prevTotalSize = totalSize;
        }
        ArrayList<Long> encodingDurations = new ArrayList<Long>();
        for (int itTime = 0; itTime < benchmarkNTimes; ++itTime) {
            startTime = System.nanoTime();
            codec.encodeData();
            finishTime = System.nanoTime();
            if (itTime < benchmarkNOmit) continue;
            encodingDurations.add(finishTime - startTime);
        }
        System.out.println(codec.toString() + ":");
        DataBlockEncodingTool.printBenchmarkResult(totalSize, encodingDurations, Manipulation.ENCODING);
        DataBlockEncodingTool.printBenchmarkResult(totalSize, durations, Manipulation.DECODING);
        System.out.println();
        return prevTotalSize;
    }

    private void benchmarkDefaultCompression(int totalSize, byte[] rawBuffer) throws IOException {
        this.benchmarkAlgorithm(this.compressionAlgorithm, this.compressionAlgorithmName.toUpperCase(Locale.ROOT), rawBuffer, 0, totalSize);
    }

    public void benchmarkAlgorithm(Compression.Algorithm algorithm, String name, byte[] buffer, int offset, int length) throws IOException {
        System.out.println(name + ":");
        ArrayList<Long> compressDurations = new ArrayList<Long>();
        ByteArrayOutputStream compressedStream = new ByteArrayOutputStream();
        CompressionOutputStream compressingStream = algorithm.createPlainCompressionStream(compressedStream, this.compressor);
        try {
            for (int itTime = 0; itTime < benchmarkNTimes; ++itTime) {
                long startTime = System.nanoTime();
                compressingStream.resetState();
                compressedStream.reset();
                compressingStream.write(buffer, offset, length);
                compressingStream.flush();
                compressedStream.toByteArray();
                long finishTime = System.nanoTime();
                if (itTime < benchmarkNOmit) continue;
                compressDurations.add(finishTime - startTime);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Benchmark, or encoding algorithm '%s' cause some stream problems", name), e);
        }
        compressingStream.close();
        DataBlockEncodingTool.printBenchmarkResult(length, compressDurations, Manipulation.COMPRESSION);
        byte[] compBuffer = compressedStream.toByteArray();
        ArrayList<Long> durations = new ArrayList<Long>();
        for (int itTime = 0; itTime < benchmarkNTimes; ++itTime) {
            long startTime = System.nanoTime();
            byte[] newBuf = new byte[length + 1];
            try {
                KeyValue kv;
                int nextChunk;
                ByteArrayInputStream downStream = new ByteArrayInputStream(compBuffer, 0, compBuffer.length);
                InputStream decompressedStream = algorithm.createDecompressionStream(downStream, this.decompressor, 0);
                int destOffset = 0;
                while ((nextChunk = decompressedStream.available()) > 0) {
                    destOffset += decompressedStream.read(newBuf, destOffset, nextChunk);
                }
                decompressedStream.close();
                for (int pos = 0; pos < length; pos += kv.getLength()) {
                    kv = new KeyValue(newBuf, pos);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Decoding path in '%s' algorithm cause exception ", name), e);
            }
            long finishTime = System.nanoTime();
            if (0 != Bytes.compareTo(buffer, 0, length, newBuf, 0, length)) {
                for (int prefix = 0; prefix < buffer.length && prefix < newBuf.length && buffer[prefix] == newBuf[prefix]; ++prefix) {
                }
                throw new RuntimeException(String.format("Algorithm '%s' is corrupting the data", name));
            }
            if (itTime < benchmarkNOmit) continue;
            durations.add(finishTime - startTime);
        }
        DataBlockEncodingTool.printBenchmarkResult(length, durations, Manipulation.DECOMPRESSION);
        System.out.println();
    }

    private static void printBenchmarkResult(int totalSize, List<Long> durationsInNanoSec, Manipulation manipulation) {
        int n = durationsInNanoSec.size();
        long meanTime = 0L;
        for (long time : durationsInNanoSec) {
            meanTime += time;
        }
        double meanMBPerSec = (double)totalSize * 953.67431640625 / (double)(meanTime /= (long)n);
        double mbPerSecSTD = 0.0;
        if (n > 0) {
            for (long time : durationsInNanoSec) {
                double mbPerSec = (double)totalSize * 953.67431640625 / (double)time;
                double dev = mbPerSec - meanMBPerSec;
                mbPerSecSTD += dev * dev;
            }
            mbPerSecSTD = Math.sqrt(mbPerSecSTD / (double)n);
        }
        DataBlockEncodingTool.outputTuple((Object)((Object)manipulation) + " performance", "%6.2f MB/s (+/- %.2f MB/s)", meanMBPerSec, mbPerSecSTD);
    }

    private static void outputTuple(String caption, String format, Object ... values) {
        if (format.startsWith(INT_FORMAT)) {
            format = "%s" + format.substring(INT_FORMAT.length());
            values[0] = DELIMITED_DECIMAL_FORMAT.format(values[0]);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("  ");
        sb.append(caption);
        sb.append(":");
        String v = String.format(format, values);
        int padding = 60 - sb.length() - v.length();
        for (int i = 0; i < padding; ++i) {
            sb.append(' ');
        }
        sb.append(v);
        System.out.println(sb);
    }

    public void displayStatistics() throws IOException {
        String comprAlgo = this.compressionAlgorithmName.toUpperCase(Locale.ROOT);
        long rawBytes = this.totalKeyLength + this.totalPrefixLength + this.totalValueLength;
        System.out.println("Raw data size:");
        DataBlockEncodingTool.outputTuple("Raw bytes", INT_FORMAT, rawBytes);
        this.outputTuplePct("Key bytes", this.totalKeyLength);
        this.outputTuplePct("Value bytes", this.totalValueLength);
        this.outputTuplePct("KV infrastructure", this.totalPrefixLength);
        this.outputTuplePct("CF overhead", this.totalCFLength);
        this.outputTuplePct("Total key redundancy", this.totalKeyRedundancyLength);
        int compressedSize = EncodedDataBlock.getCompressedSize(this.compressionAlgorithm, this.compressor, this.rawKVs, 0, this.rawKVs.length);
        DataBlockEncodingTool.outputTuple(comprAlgo + " only size", INT_FORMAT, compressedSize);
        this.outputSavings(comprAlgo + " only", compressedSize, rawBytes);
        System.out.println();
        for (EncodedDataBlock codec : this.codecs) {
            System.out.println(codec.toString());
            long encodedBytes = codec.getSize();
            DataBlockEncodingTool.outputTuple("Encoded bytes", INT_FORMAT, encodedBytes);
            this.outputSavings("Key encoding", encodedBytes - this.totalValueLength, rawBytes - this.totalValueLength);
            this.outputSavings("Total encoding", encodedBytes, rawBytes);
            int encodedCompressedSize = codec.getEncodedCompressedSize(this.compressionAlgorithm, this.compressor);
            DataBlockEncodingTool.outputTuple("Encoding + " + comprAlgo + " size", INT_FORMAT, encodedCompressedSize);
            this.outputSavings("Encoding + " + comprAlgo, encodedCompressedSize, rawBytes);
            this.outputSavings("Encoding with " + comprAlgo, encodedCompressedSize, compressedSize);
            System.out.println();
        }
    }

    private void outputTuplePct(String caption, long size) {
        DataBlockEncodingTool.outputTuple(caption, "%d (%.2f %%)", size, (double)size * 100.0 / (double)this.rawKVs.length);
    }

    private void outputSavings(String caption, long part, long whole) {
        double pct = 100.0 * (1.0 - 1.0 * (double)part / (double)whole);
        double times = (double)whole * 1.0 / (double)part;
        DataBlockEncodingTool.outputTuple(caption + " savings", "%.2f %% (%.2f x)", pct, times);
    }

    public static void testCodecs(Configuration conf, int kvLimit, String hfilePath, String compressionName, boolean doBenchmark, boolean doVerify) throws IOException {
        Path path = new Path(hfilePath);
        CacheConfig cacheConf = new CacheConfig(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        StoreFile hsf = new StoreFile(fs, path, conf, cacheConf, BloomType.NONE);
        StoreFile.Reader reader = hsf.createReader();
        reader.loadFileInfo();
        StoreFileScanner scanner = reader.getStoreFileScanner(true, true, false, 0L, 0L, false);
        DataBlockEncodingTool comp = new DataBlockEncodingTool(compressionName);
        int majorVersion = reader.getHFileVersion();
        comp.useHBaseChecksum = majorVersion > 2 || majorVersion == 2 && reader.getHFileMinorVersion() >= 1;
        comp.checkStatistics(scanner, kvLimit);
        if (doVerify) {
            comp.verifyCodecs(scanner, kvLimit);
        }
        if (doBenchmark) {
            comp.benchmarkCodecs();
        }
        comp.displayStatistics();
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
    }

    private static void printUsage(Options options) {
        System.err.println("Usage:");
        System.err.println(String.format("./hbase %s <options>", DataBlockEncodingTool.class.getName()));
        System.err.println("Options:");
        for (Object it : options.getOptions()) {
            Option opt = (Option)it;
            if (opt.hasArg()) {
                System.err.println(String.format("-%s %s: %s", opt.getOpt(), opt.getArgName(), opt.getDescription()));
                continue;
            }
            System.err.println(String.format("-%s: %s", opt.getOpt(), opt.getDescription()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        boolean doVerify;
        Options options = new Options();
        options.addOption(OPT_HFILE_NAME, true, "HFile to analyse (REQUIRED)");
        options.getOption(OPT_HFILE_NAME).setArgName("FILENAME");
        options.addOption(OPT_KV_LIMIT, true, "Maximum number of KeyValues to process. A benchmark stops running after iterating over this many KV pairs.");
        options.getOption(OPT_KV_LIMIT).setArgName("NUMBER");
        options.addOption(OPT_MEASURE_THROUGHPUT, false, "Measure read throughput");
        options.addOption(OPT_OMIT_CORRECTNESS_TEST, false, "Omit corectness tests.");
        options.addOption(OPT_ENCODING_ALGORITHM, true, "What kind of compression algorithm use for comparison.");
        options.addOption(OPT_BENCHMARK_N_TIMES, true, "Number of times to run each benchmark. Default value: 12");
        options.addOption(OPT_BENCHMARK_N_OMIT, true, "Number of first runs of every benchmark to exclude from statistics (2 by default, so that only the last 10 times are included in statistics.)");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Could not parse arguments!");
            System.exit(-1);
            return;
        }
        int kvLimit = Integer.MAX_VALUE;
        if (cmd.hasOption(OPT_KV_LIMIT)) {
            kvLimit = Integer.parseInt(cmd.getOptionValue(OPT_KV_LIMIT));
        }
        if (!cmd.hasOption(OPT_HFILE_NAME)) {
            LOG.error((Object)"Please specify HFile name using the f option");
            DataBlockEncodingTool.printUsage(options);
            System.exit(-1);
        }
        String pathName = cmd.getOptionValue(OPT_HFILE_NAME);
        String compressionName = DEFAULT_COMPRESSION.getName();
        if (cmd.hasOption(OPT_ENCODING_ALGORITHM)) {
            compressionName = cmd.getOptionValue(OPT_ENCODING_ALGORITHM).toLowerCase(Locale.ROOT);
        }
        boolean doBenchmark = cmd.hasOption(OPT_MEASURE_THROUGHPUT);
        boolean bl = doVerify = !cmd.hasOption(OPT_OMIT_CORRECTNESS_TEST);
        if (cmd.hasOption(OPT_BENCHMARK_N_TIMES)) {
            benchmarkNTimes = Integer.valueOf(cmd.getOptionValue(OPT_BENCHMARK_N_TIMES));
        }
        if (cmd.hasOption(OPT_BENCHMARK_N_OMIT)) {
            benchmarkNOmit = Integer.valueOf(cmd.getOptionValue(OPT_BENCHMARK_N_OMIT));
        }
        if (benchmarkNTimes < benchmarkNOmit) {
            LOG.error((Object)("The number of times to run each benchmark (" + benchmarkNTimes + ") must be greater than the number of benchmark runs to exclude from statistics (" + benchmarkNOmit + ")"));
            System.exit(1);
        }
        LOG.info((Object)("Running benchmark " + benchmarkNTimes + " times. Excluding the first " + benchmarkNOmit + " times from statistics."));
        Configuration conf = HBaseConfiguration.create();
        try {
            DataBlockEncodingTool.testCodecs(conf, kvLimit, pathName, compressionName, doBenchmark, doVerify);
        }
        finally {
            new CacheConfig(conf).getBlockCache().shutdown();
        }
    }

    static {
        DELIMITED_DECIMAL_FORMAT.setGroupingSize(3);
        benchmarkNTimes = 12;
        benchmarkNOmit = 2;
    }

    private static enum Manipulation {
        ENCODING,
        DECODING,
        COMPRESSION,
        DECOMPRESSION;


        public String toString() {
            String s = super.toString();
            StringBuilder sb = new StringBuilder();
            sb.append(s.charAt(0));
            sb.append(s.substring(1).toLowerCase(Locale.ROOT));
            return sb.toString();
        }
    }
}

