/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestQuotaAdmin {
    private static final Log LOG = LogFactory.getLog(TestQuotaAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 2000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testThrottleType() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser(userName, ThrottleType.READ_NUMBER, 6L, TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser(userName, ThrottleType.WRITE_NUMBER, 12L, TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.bypassGlobals(userName, true));
        try (QuotaRetriever scanner = QuotaRetriever.open(TEST_UTIL.getConfiguration());){
            int countThrottle = 0;
            int countGlobalBypass = 0;
            block13: for (QuotaSettings settings : scanner) {
                switch (settings.getQuotaType()) {
                    case THROTTLE: {
                        ThrottleSettings throttle = (ThrottleSettings)settings;
                        if (throttle.getSoftLimit() == 6L) {
                            Assert.assertEquals((Object)((Object)ThrottleType.READ_NUMBER), (Object)((Object)throttle.getThrottleType()));
                        } else if (throttle.getSoftLimit() == 12L) {
                            Assert.assertEquals((Object)((Object)ThrottleType.WRITE_NUMBER), (Object)((Object)throttle.getThrottleType()));
                        } else {
                            Assert.fail((String)"should not come here, because don't set quota with this limit");
                        }
                        Assert.assertEquals((Object)userName, (Object)throttle.getUserName());
                        Assert.assertEquals(null, (Object)throttle.getTableName());
                        Assert.assertEquals(null, (Object)throttle.getNamespace());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttle.getTimeUnit()));
                        ++countThrottle;
                        continue block13;
                    }
                    case GLOBAL_BYPASS: {
                        ++countGlobalBypass;
                        continue block13;
                    }
                }
                Assert.fail((String)("unexpected settings type: " + (Object)((Object)settings.getQuotaType())));
            }
            Assert.assertEquals((long)2L, (long)countThrottle);
            Assert.assertEquals((long)1L, (long)countGlobalBypass);
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleUser(userName));
        this.assertNumResults(1, null);
        admin.setQuota(QuotaSettingsFactory.bypassGlobals(userName, false));
        this.assertNumResults(0, null);
    }

    @Test
    public void testSimpleScan() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser(userName, ThrottleType.REQUEST_NUMBER, 6L, TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.bypassGlobals(userName, true));
        try (QuotaRetriever scanner = QuotaRetriever.open(TEST_UTIL.getConfiguration());){
            int countThrottle = 0;
            int countGlobalBypass = 0;
            block13: for (QuotaSettings settings : scanner) {
                LOG.debug((Object)settings);
                switch (settings.getQuotaType()) {
                    case THROTTLE: {
                        ThrottleSettings throttle = (ThrottleSettings)settings;
                        Assert.assertEquals((Object)userName, (Object)throttle.getUserName());
                        Assert.assertEquals(null, (Object)throttle.getTableName());
                        Assert.assertEquals(null, (Object)throttle.getNamespace());
                        Assert.assertEquals((long)6L, (long)throttle.getSoftLimit());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttle.getTimeUnit()));
                        ++countThrottle;
                        continue block13;
                    }
                    case GLOBAL_BYPASS: {
                        ++countGlobalBypass;
                        continue block13;
                    }
                }
                Assert.fail((String)("unexpected settings type: " + (Object)((Object)settings.getQuotaType())));
            }
            Assert.assertEquals((long)1L, (long)countThrottle);
            Assert.assertEquals((long)1L, (long)countGlobalBypass);
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleUser(userName));
        this.assertNumResults(1, null);
        admin.setQuota(QuotaSettingsFactory.bypassGlobals(userName, false));
        this.assertNumResults(0, null);
    }

    @Test
    public void testQuotaRetrieverFilter() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        TableName[] tables = new TableName[]{TableName.valueOf("T0"), TableName.valueOf("T01"), TableName.valueOf("NS0:T2")};
        String[] namespaces = new String[]{"NS0", "NS01", "NS2"};
        String[] users = new String[]{"User0", "User01", "User2"};
        for (String string : users) {
            admin.setQuota(QuotaSettingsFactory.throttleUser(string, ThrottleType.REQUEST_NUMBER, 1L, TimeUnit.MINUTES));
            for (TableName tableName : tables) {
                admin.setQuota(QuotaSettingsFactory.throttleUser(string, tableName, ThrottleType.REQUEST_NUMBER, 2L, TimeUnit.MINUTES));
            }
            for (String string2 : namespaces) {
                admin.setQuota(QuotaSettingsFactory.throttleUser(string, string2, ThrottleType.REQUEST_NUMBER, 3L, TimeUnit.MINUTES));
            }
        }
        this.assertNumResults(21, null);
        for (TableName tableName : tables) {
            admin.setQuota(QuotaSettingsFactory.throttleTable(tableName, ThrottleType.REQUEST_NUMBER, 4L, TimeUnit.MINUTES));
        }
        this.assertNumResults(24, null);
        for (String string : namespaces) {
            admin.setQuota(QuotaSettingsFactory.throttleNamespace(string, ThrottleType.REQUEST_NUMBER, 5L, TimeUnit.MINUTES));
        }
        this.assertNumResults(27, null);
        this.assertNumResults(7, new QuotaFilter().setUserFilter("User0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User"));
        this.assertNumResults(21, new QuotaFilter().setUserFilter("User.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("NS.*"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setTableFilter("T"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS"));
        this.assertNumResults(9, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS.*"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0").setNamespaceFilter("NS0"));
        this.assertNumResults(1, new QuotaFilter().setTableFilter("T0"));
        this.assertNumResults(0, new QuotaFilter().setTableFilter("T"));
        this.assertNumResults(2, new QuotaFilter().setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setTableFilter(".*T.*"));
        this.assertNumResults(1, new QuotaFilter().setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setNamespaceFilter("NS"));
        this.assertNumResults(3, new QuotaFilter().setNamespaceFilter("NS.*"));
        for (String string : users) {
            admin.setQuota(QuotaSettingsFactory.unthrottleUser(string));
            for (TableName tableName : tables) {
                admin.setQuota(QuotaSettingsFactory.unthrottleUser(string, tableName));
            }
            for (String string3 : namespaces) {
                admin.setQuota(QuotaSettingsFactory.unthrottleUser(string, string3));
            }
        }
        this.assertNumResults(6, null);
        for (TableName tableName : tables) {
            admin.setQuota(QuotaSettingsFactory.unthrottleTable(tableName));
        }
        this.assertNumResults(3, null);
        for (String string : namespaces) {
            admin.setQuota(QuotaSettingsFactory.unthrottleNamespace(string));
        }
        this.assertNumResults(0, null);
    }

    private void assertNumResults(int expected, QuotaFilter filter) throws Exception {
        Assert.assertEquals((long)expected, (long)this.countResults(filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countResults(QuotaFilter filter) throws Exception {
        try (QuotaRetriever scanner = QuotaRetriever.open(TEST_UTIL.getConfiguration(), filter);){
            int count = 0;
            for (QuotaSettings settings : scanner) {
                LOG.debug((Object)settings);
                ++count;
            }
            int n = count;
            return n;
        }
    }
}

