/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import drill.shaded.hbase.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AverageIntervalRateLimiter
extends RateLimiter {
    private long nextRefillTime = -1L;

    @Override
    public long refill(long limit) {
        long now = EnvironmentEdgeManager.currentTime();
        if (this.nextRefillTime == -1L) {
            this.nextRefillTime = EnvironmentEdgeManager.currentTime();
            return limit;
        }
        long timeInterval = now - this.nextRefillTime;
        long delta = 0L;
        long timeUnitInMillis = super.getTimeUnitInMillis();
        if (timeInterval >= timeUnitInMillis) {
            delta = limit;
        } else if (timeInterval > 0L) {
            double r = (double)timeInterval / (double)timeUnitInMillis * (double)limit;
            delta = (long)r;
        }
        if (delta > 0L) {
            this.nextRefillTime = now;
        }
        return delta;
    }

    @Override
    public long getWaitInterval(long limit, long available, long amount) {
        if (this.nextRefillTime == -1L) {
            return 0L;
        }
        double r = (double)(amount - available) * (double)super.getTimeUnitInMillis() / (double)limit;
        return (long)r;
    }

    @Override
    @VisibleForTesting
    public void setNextRefillTime(long nextRefillTime) {
        this.nextRefillTime = nextRefillTime;
    }

    @Override
    @VisibleForTesting
    public long getNextRefillTime() {
        return this.nextRefillTime;
    }
}

