/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.protobuf.ReplicationProtbufUtil;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestReplicationProtobuf {
    @Test
    public void testGetCellScanner() throws IOException {
        ArrayList<KeyValue> a = new ArrayList<KeyValue>();
        KeyValue akv = new KeyValue(Bytes.toBytes("a"), -1L);
        a.add(akv);
        a.add(new KeyValue(Bytes.toBytes("aa"), -1L));
        a.add(new KeyValue(Bytes.toBytes("aaa"), -1L));
        ArrayList b = new ArrayList();
        KeyValue bkv = new KeyValue(Bytes.toBytes("b"), -1L);
        a.add(bkv);
        ArrayList<KeyValue> c = new ArrayList<KeyValue>();
        KeyValue ckv = new KeyValue(Bytes.toBytes("c"), -1L);
        c.add(ckv);
        ArrayList<List<? extends Cell>> all = new ArrayList<List<? extends Cell>>();
        all.add(a);
        all.add(b);
        all.add(c);
        CellScanner scanner = ReplicationProtbufUtil.getCellScanner(all, 0);
        this.testAdvancetHasSameRow(scanner, akv);
        scanner.advance();
        scanner.advance();
        this.testAdvancetHasSameRow(scanner, bkv);
        this.testAdvancetHasSameRow(scanner, ckv);
        Assert.assertFalse((boolean)scanner.advance());
    }

    private void testAdvancetHasSameRow(CellScanner scanner, KeyValue kv) throws IOException {
        scanner.advance();
        Assert.assertTrue((boolean)Bytes.equals(scanner.current().getRowArray(), scanner.current().getRowOffset(), scanner.current().getRowLength(), kv.getRowArray(), kv.getRowOffset(), kv.getRowLength()));
    }
}

