/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSnapshotManager {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
    ProcedureCoordinator coordinator = (ProcedureCoordinator)Mockito.mock(ProcedureCoordinator.class);
    ExecutorService pool = (ExecutorService)Mockito.mock(ExecutorService.class);
    MasterFileSystem mfs = (MasterFileSystem)Mockito.mock(MasterFileSystem.class);
    FileSystem fs;

    public TestSnapshotManager() {
        try {
            this.fs = UTIL.getTestFileSystem();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't get test filesystem", e);
        }
    }

    private SnapshotManager getNewManager() throws IOException, KeeperException {
        return this.getNewManager(UTIL.getConfiguration());
    }

    private SnapshotManager getNewManager(Configuration conf) throws IOException, KeeperException {
        return this.getNewManager(conf, 1);
    }

    private SnapshotManager getNewManager(Configuration conf, int intervalSeconds) throws IOException, KeeperException {
        Mockito.reset((Object[])new MasterServices[]{this.services});
        Mockito.when((Object)this.services.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)this.services.getMasterFileSystem()).thenReturn((Object)this.mfs);
        Mockito.when((Object)this.mfs.getFileSystem()).thenReturn((Object)this.fs);
        Mockito.when((Object)this.mfs.getRootDir()).thenReturn((Object)UTIL.getDataTestDir());
        return new SnapshotManager(this.services, this.coordinator, this.pool, intervalSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanFinishedHandler() throws Exception {
        TableName tableName = TableName.valueOf("testCleanFinishedHandler");
        Configuration conf = UTIL.getConfiguration();
        try {
            conf.setLong("hbase.snapshot.sentinels.cleanup.timeoutMillis", 5000L);
            SnapshotManager manager = this.getNewManager(conf, 1);
            TakeSnapshotHandler handler = (TakeSnapshotHandler)Mockito.mock(TakeSnapshotHandler.class);
            Assert.assertFalse((String)"Manager is in process when there is no current handler", (boolean)manager.isTakingSnapshot(tableName));
            manager.setSnapshotHandlerForTesting(tableName, handler);
            Mockito.when((Object)handler.isFinished()).thenReturn((Object)false);
            Assert.assertTrue((boolean)manager.isTakingAnySnapshot());
            Assert.assertTrue((String)"Manager isn't in process when handler is running", (boolean)manager.isTakingSnapshot(tableName));
            Mockito.when((Object)handler.isFinished()).thenReturn((Object)true);
            Assert.assertFalse((String)"Manager is process when handler isn't running", (boolean)manager.isTakingSnapshot(tableName));
            Assert.assertTrue((boolean)manager.isTakingAnySnapshot());
            Thread.sleep(6000L);
            Assert.assertFalse((boolean)manager.isTakingAnySnapshot());
        }
        finally {
            conf.unset("hbase.snapshot.sentinels.cleanup.timeoutMillis");
        }
    }

    @Test
    public void testInProcess() throws KeeperException, IOException {
        TableName tableName = TableName.valueOf("testTable");
        SnapshotManager manager = this.getNewManager();
        TakeSnapshotHandler handler = (TakeSnapshotHandler)Mockito.mock(TakeSnapshotHandler.class);
        Assert.assertFalse((String)"Manager is in process when there is no current handler", (boolean)manager.isTakingSnapshot(tableName));
        manager.setSnapshotHandlerForTesting(tableName, handler);
        Mockito.when((Object)handler.isFinished()).thenReturn((Object)false);
        Assert.assertTrue((String)"Manager isn't in process when handler is running", (boolean)manager.isTakingSnapshot(tableName));
        Mockito.when((Object)handler.isFinished()).thenReturn((Object)true);
        Assert.assertFalse((String)"Manager is process when handler isn't running", (boolean)manager.isTakingSnapshot(tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotSupportConfiguration() throws Exception {
        Configuration conf = new Configuration();
        SnapshotManager manager = this.getNewManager(conf);
        Assert.assertFalse((String)"Snapshot should be disabled with no configuration", (boolean)this.isSnapshotSupported(manager));
        conf = new Configuration();
        conf.setBoolean("hbase.snapshot.enabled", true);
        manager = this.getNewManager(conf);
        Assert.assertTrue((String)"Snapshot should be enabled", (boolean)this.isSnapshotSupported(manager));
        conf = new Configuration();
        conf.setBoolean("hbase.snapshot.enabled", false);
        manager = this.getNewManager(conf);
        Assert.assertFalse((String)"Snapshot should be disabled", (boolean)this.isSnapshotSupported(manager));
        conf = new Configuration();
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{SnapshotHFileCleaner.class.getName(), HFileLinkCleaner.class.getName()});
        conf.setBoolean("hbase.snapshot.enabled", false);
        manager = this.getNewManager(conf);
        Assert.assertFalse((String)"Snapshot should be disabled", (boolean)this.isSnapshotSupported(manager));
        conf = new Configuration();
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{SnapshotHFileCleaner.class.getName(), HFileLinkCleaner.class.getName()});
        manager = this.getNewManager(conf);
        Assert.assertTrue((String)"Snapshot should be enabled, because cleaners are present", (boolean)this.isSnapshotSupported(manager));
        Path rootDir = UTIL.getDataTestDir();
        Path testSnapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir("testSnapshotSupportConfiguration", rootDir);
        this.fs.mkdirs(testSnapshotDir);
        try {
            conf = new Configuration();
            conf.setBoolean("hbase.snapshot.enabled", false);
            manager = this.getNewManager(conf);
            Assert.fail((String)"Master should not start when snapshot is disabled, but snapshots are present");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        finally {
            this.fs.delete(testSnapshotDir, true);
        }
    }

    private boolean isSnapshotSupported(SnapshotManager manager) {
        try {
            manager.checkSnapshotSupport();
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }
}

