/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestProcedureAdmin {
    private static final Log LOG = LogFactory.getLog(TestProcedureAdmin.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestProcedureAdmin.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)procExec.isRunning());
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertTrue((String)"expected executor to be running", (boolean)this.getMasterProcedureExecutor().isRunning());
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info((Object)("Tear down, remove table=" + htd.getTableName()));
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=60000L)
    public void testAbortProcedureSuccess() throws Exception {
        TableName tableName = TableName.valueOf("testAbortProcedureSuccess");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure(new DisableTableProcedure(procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        boolean abortResult = procExec.abort(procId, true);
        Assert.assertTrue((boolean)abortResult);
        MasterProcedureTestingUtility.testRestartWithAbort(procExec, procId);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        MasterProcedureTestingUtility.validateTableIsEnabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    @Test(timeout=60000L)
    public void testAbortProcedureFailure() throws Exception {
        TableName tableName = TableName.valueOf("testAbortProcedureFailure");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure(new DeleteTableProcedure(procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        boolean abortResult = procExec.abort(procId, true);
        Assert.assertFalse((boolean)abortResult);
        MasterProcedureTestingUtility.testRestartWithAbort(procExec, procId);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f");
    }

    @Test(timeout=60000L)
    public void testAbortProcedureInterruptedNotAllowed() throws Exception {
        TableName tableName = TableName.valueOf("testAbortProcedureInterruptedNotAllowed");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure(new DisableTableProcedure(procExec.getEnvironment(), tableName, true));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        boolean abortResult = procExec.abort(procId, false);
        Assert.assertFalse((boolean)abortResult);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        ProcedureTestingUtility.restart(procExec);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableIsDisabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    @Test(timeout=60000L)
    public void testAbortNonExistProcedure() throws Exception {
        long procId;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        Random randomGenerator = new Random();
        while (procExec.getResult(procId = randomGenerator.nextLong()) != null) {
        }
        boolean abortResult = procExec.abort(procId, true);
        Assert.assertFalse((boolean)abortResult);
    }

    @Test(timeout=60000L)
    public void testListProcedure() throws Exception {
        TableName tableName = TableName.valueOf("testListProcedure");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure(new DisableTableProcedure(procExec.getEnvironment(), tableName, false));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        List<ProcedureInfo> listProcedures = procExec.listProcedures();
        Assert.assertTrue((listProcedures.size() >= 1 ? 1 : 0) != 0);
        boolean found = false;
        for (ProcedureInfo procInfo : listProcedures) {
            if (procInfo.getProcId() == procId) {
                Assert.assertTrue((procInfo.getProcState() == ProcedureProtos.ProcedureState.RUNNABLE ? 1 : 0) != 0);
                found = true;
                continue;
            }
            Assert.assertTrue((procInfo.getProcState() == ProcedureProtos.ProcedureState.FINISHED ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)found);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        ProcedureTestingUtility.restart(procExec);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        listProcedures = procExec.listProcedures();
        for (ProcedureInfo procInfo : listProcedures) {
            Assert.assertTrue((procInfo.getProcState() == ProcedureProtos.ProcedureState.FINISHED ? 1 : 0) != 0);
        }
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }
}

