/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.procedure.TestCreateTableProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterProcedureEvents {
    private static final Log LOG = LogFactory.getLog(TestCreateTableProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 8);
        conf.setBoolean("hbase.procedure.store.wal.use.hsync", false);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestMasterProcedureEvents.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void testMasterInitializedEvent() throws Exception {
        TableName tableName = TableName.valueOf("testMasterInitializedEvent");
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        ProcedureExecutor<MasterProcedureEnv> procExec = master.getMasterProcedureExecutor();
        MasterProcedureScheduler procSched = procExec.getEnvironment().getProcedureQueue();
        HRegionInfo hri = new HRegionInfo(tableName);
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor("f");
        htd.addFamily(hcd);
        while (!master.isInitialized()) {
            Thread.sleep(250L);
        }
        master.setInitialized(false);
        CreateTableProcedure proc = new CreateTableProcedure(procExec.getEnvironment(), htd, new HRegionInfo[]{hri});
        long pollCalls = procSched.getPollCalls();
        long nullPollCalls = procSched.getNullPollCalls();
        long procId = procExec.submitProcedure(proc);
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(100L);
            Assert.assertEquals((long)(pollCalls + 1L), (long)procSched.getPollCalls());
            Assert.assertEquals((long)nullPollCalls, (long)procSched.getNullPollCalls());
        }
        master.setInitialized(true);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Assert.assertEquals((long)(pollCalls + 2L), (long)procSched.getPollCalls());
        Assert.assertEquals((long)nullPollCalls, (long)procSched.getNullPollCalls());
    }

    @Test
    public void testServerCrashProcedureEvent() throws Exception {
        TableName tableName = TableName.valueOf("testServerCrashProcedureEventTb");
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        ProcedureExecutor<MasterProcedureEnv> procExec = master.getMasterProcedureExecutor();
        MasterProcedureScheduler procSched = procExec.getEnvironment().getProcedureQueue();
        while (!master.isServerCrashProcessingEnabled() || !master.isInitialized() || master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(25L);
        }
        UTIL.createTable(tableName, HBaseTestingUtility.COLUMNS[0]);
        try (Table t = UTIL.getConnection().getTable(tableName);){
            UTIL.loadTable(t, HBaseTestingUtility.COLUMNS[0]);
        }
        master.setServerCrashProcessingEnabled(false);
        long pollCalls = procSched.getPollCalls();
        long nullPollCalls = procSched.getNullPollCalls();
        HRegionServer hrs = this.getServerWithRegions();
        boolean carryingMeta = master.getAssignmentManager().isCarryingMeta(hrs.getServerName()) == AssignmentManager.ServerHostRegion.HOSTING_REGION;
        UTIL.getHBaseCluster().killRegionServer(hrs.getServerName());
        hrs.join();
        while (!master.getServerManager().isServerDead(hrs.getServerName())) {
            Thread.sleep(10L);
        }
        master.getServerManager().moveFromOnlineToDeadServers(hrs.getServerName());
        long procId = procExec.submitProcedure(new ServerCrashProcedure(procExec.getEnvironment(), hrs.getServerName(), true, carryingMeta));
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(100L);
            Assert.assertEquals((long)(pollCalls + 1L), (long)procSched.getPollCalls());
            Assert.assertEquals((long)nullPollCalls, (long)procSched.getNullPollCalls());
        }
        master.setServerCrashProcessingEnabled(true);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        LOG.debug((Object)("server crash processing poll calls: " + procSched.getPollCalls()));
        Assert.assertTrue((procSched.getPollCalls() >= pollCalls + 2L ? 1 : 0) != 0);
        Assert.assertEquals((long)nullPollCalls, (long)procSched.getNullPollCalls());
        UTIL.deleteTable(tableName);
    }

    private HRegionServer getServerWithRegions() {
        for (int i = 0; i < 3; ++i) {
            HRegionServer hrs = UTIL.getHBaseCluster().getRegionServer(i);
            if (hrs.getNumberOfOnlineRegions() <= 0) continue;
            return hrs;
        }
        return null;
    }
}

