/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSimpleRegionNormalizerOnCluster {
    private static final Log LOG = LogFactory.getLog(TestSimpleRegionNormalizerOnCluster.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILYNAME = Bytes.toBytes("fam");
    private static Admin admin;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        TEST_UTIL.startMiniCluster(1);
        admin = TEST_UTIL.getHBaseAdmin();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testRegionNormalizationSplitOnCluster() throws Exception {
        int cnt;
        TableName TABLENAME = TableName.valueOf("testRegionNormalizationSplitOnCluster");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try (HTable ht = TEST_UTIL.createMultiRegionTable(TABLENAME, FAMILYNAME, 5);){
            List<HRegion> generatedRegions = TEST_UTIL.getHBaseCluster().getRegions(TABLENAME);
            Collections.sort(generatedRegions, new Comparator<HRegion>(){

                @Override
                public int compare(HRegion o1, HRegion o2) {
                    return o1.getRegionInfo().compareTo(o2.getRegionInfo());
                }
            });
            HRegion region = generatedRegions.get(0);
            this.generateTestData(region, 1);
            region.flush(true);
            region = generatedRegions.get(1);
            this.generateTestData(region, 1);
            region.flush(true);
            region = generatedRegions.get(2);
            this.generateTestData(region, 2);
            region.flush(true);
            region = generatedRegions.get(3);
            this.generateTestData(region, 2);
            region.flush(true);
            region = generatedRegions.get(4);
            this.generateTestData(region, 5);
            region.flush(true);
        }
        HTableDescriptor htd = admin.getTableDescriptor(TABLENAME);
        htd.setNormalizationEnabled(true);
        admin.modifyTable(TABLENAME, htd);
        admin.flush(TABLENAME);
        System.out.println(admin.getTableDescriptor(TABLENAME));
        Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount(TEST_UTIL.getConnection(), TABLENAME));
        Thread.sleep(5000L);
        m.normalizeRegions();
        do {
            List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(TABLENAME);
            cnt = 0;
            for (HRegion region : regions) {
                String regionName = region.getRegionInfo().getRegionNameAsString();
                if (!regionName.startsWith("testRegionNormalizationSplitOnCluster,zzzzz")) continue;
                ++cnt;
            }
        } while (cnt < 2);
        admin.disableTable(TABLENAME);
        admin.deleteTable(TABLENAME);
    }

    @Test(timeout=60000L)
    public void testRegionNormalizationMergeOnCluster() throws Exception {
        TableName TABLENAME = TableName.valueOf("testRegionNormalizationMergeOnCluster");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try (HTable ht = TEST_UTIL.createMultiRegionTable(TABLENAME, FAMILYNAME, 5);){
            List<HRegion> generatedRegions = TEST_UTIL.getHBaseCluster().getRegions(TABLENAME);
            Collections.sort(generatedRegions, new Comparator<HRegion>(){

                @Override
                public int compare(HRegion o1, HRegion o2) {
                    return o1.getRegionInfo().compareTo(o2.getRegionInfo());
                }
            });
            HRegion region = generatedRegions.get(0);
            this.generateTestData(region, 1);
            region.flush(true);
            region = generatedRegions.get(1);
            this.generateTestData(region, 1);
            region.flush(true);
            region = generatedRegions.get(2);
            this.generateTestData(region, 3);
            region.flush(true);
            region = generatedRegions.get(3);
            this.generateTestData(region, 3);
            region.flush(true);
            region = generatedRegions.get(4);
            this.generateTestData(region, 5);
            region.flush(true);
        }
        HTableDescriptor htd = admin.getTableDescriptor(TABLENAME);
        htd.setNormalizationEnabled(true);
        admin.modifyTable(TABLENAME, htd);
        admin.flush(TABLENAME);
        Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount(TEST_UTIL.getConnection(), TABLENAME));
        Thread.sleep(5000L);
        m.normalizeRegions();
        while (MetaTableAccessor.getRegionCount(TEST_UTIL.getConnection(), TABLENAME) > 4) {
            LOG.info((Object)"Waiting for normalization merge to complete");
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)4L, (long)MetaTableAccessor.getRegionCount(TEST_UTIL.getConnection(), TABLENAME));
        admin.disableTable(TABLENAME);
        admin.deleteTable(TABLENAME);
    }

    private void generateTestData(Region region, int numRows) throws IOException {
        LoadTestKVGenerator dataGenerator = new LoadTestKVGenerator(0x100000, 0x100000);
        for (int i = 0; i < numRows; ++i) {
            byte[] key = Bytes.add(region.getRegionInfo().getStartKey(), Bytes.toBytes(i));
            for (int j = 0; j < 1; ++j) {
                Put put = new Put(key);
                byte[] col = Bytes.toBytes(String.valueOf(j));
                byte[] value = dataGenerator.generateRandomSizeValue(key, col);
                put.add(FAMILYNAME, col, value);
                region.put(put);
            }
        }
    }
}

